/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.upgrade.plugins;

import java.security.AccessControlException;
import java.util.ArrayList;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.commons.upgrade.UpgradeProductPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class UpgradeUsersFolderPlugin
extends UpgradeProductPlugin {
    private static final String USER_ALIAS = "usersPath";
    private RepositoryService repoService_;
    private static final Log LOG = ExoLogger.getLogger((String)UpgradeUsersFolderPlugin.class.getName());
    private NodeHierarchyCreator nodeHCreator_;
    private OrganizationService orgService_;

    public UpgradeUsersFolderPlugin(OrganizationService orgService, NodeHierarchyCreator nodeHCreator, RepositoryService repoService, InitParams initParams) {
        super(initParams);
        this.repoService_ = repoService;
        this.nodeHCreator_ = nodeHCreator;
        this.orgService_ = orgService;
    }

    public void processUpgrade(String oldVersion, String newVersion) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Starting upgrade permisson for Users folder");
        }
        this.upgradePermissionForUserFolder();
        try {
            this.upgradePermissionForChildren();
        }
        catch (Exception e) {
            LOG.error((Object)"Upgrade FAILED! Unexpected problem happens", (Throwable)e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Finished upgrade permission for Users Folder");
        }
    }

    public boolean shouldProceedToUpgrade(String previousVersion, String newVersion) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradePermissionForUserFolder() {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        String superUser = ((UserACL)WCMCoreUtils.getService(UserACL.class)).getSuperUser();
        try {
            String defaultWSName = this.repoService_.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
            Node usersFolder = (Node)sessionProvider.getSession(defaultWSName, this.repoService_.getCurrentRepository()).getItem(this.nodeHCreator_.getJcrPath(USER_ALIAS));
            ArrayList<String> persList = new ArrayList<String>(4);
            persList.add("read");
            persList.add("add_node");
            persList.add("set_property");
            persList.add("remove");
            ((ExtendedNode)usersFolder).setPermission(superUser, persList.toArray(new String[persList.size()]));
            sessionProvider.getSession(defaultWSName, this.repoService_.getCurrentRepository()).save();
        }
        catch (PathNotFoundException e) {
            LOG.error((Object)"Upgrade FAILED! Users folder can not be found", (Throwable)e);
        }
        catch (LoginException e) {
            LOG.error((Object)"Upgrade failed! Cannot login into system", (Throwable)e);
        }
        catch (NoSuchWorkspaceException e) {
            LOG.error((Object)"Upgrade FAILED! The default workspace cannot be found", (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.error((Object)"Upgrade FAILED! Unexpected problem happens", (Throwable)e);
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradePermissionForChildren() throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        String defaultWSName = this.repoService_.getCurrentRepository().getConfiguration().getDefaultWorkspaceName();
        try {
            Session session = sessionProvider.getSession(this.repoService_.getCurrentRepository().getConfiguration().getDefaultWorkspaceName(), this.repoService_.getCurrentRepository());
            String usersNodePath = this.nodeHCreator_.getJcrPath(USER_ALIAS);
            int count = 0;
            NodeIterator nodeIter = session.getWorkspace().getQueryManager().createQuery("SELECT * FROM nt:unstructured WHERE jcr:path like '" + usersNodePath + "/%'" + " AND (exo:name='Public' OR exo:name='Private') ORDER BY exo:dateCreated", "sql").execute().getNodes();
            while (nodeIter.hasNext()) {
                String userNodeName;
                Node appNode = nodeIter.nextNode();
                Node userNode = appNode.getParent();
                String userNodePath = userNode.getPath();
                if (!userNodePath.equals(this.nodeHCreator_.getUserNode(sessionProvider, userNodeName = userNode.getName()).getPath())) continue;
                NodeImpl nodeImpl = (NodeImpl)appNode;
                try {
                    nodeImpl.removePermission(userNodeName, "remove");
                }
                catch (AccessControlException ace) {
                    continue;
                }
                userNode.save();
                if (++count % 200 != 0 || !LOG.isInfoEnabled()) continue;
                StringBuilder infor = new StringBuilder(((Object)((Object)this)).getClass().getSimpleName()).append(": ").append(count / 2).append(" users done!");
                LOG.info((Object)infor.toString());
            }
        }
        catch (Exception e) {
            sessionProvider.getSession(defaultWSName, this.repoService_.getCurrentRepository()).refresh(false);
            LOG.error((Object)"MIGRATION DIDN'T SUCCESSED", (Throwable)e);
        }
        finally {
            if (sessionProvider != null) {
                sessionProvider.close();
            }
        }
    }
}

