/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.jabber.JDOMXMessageHandler;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageHandler;
import com.echomine.jabber.JabberMessageReceiver;
import com.echomine.jabber.JabberSession;
import com.echomine.jabber.MessageRequestQueue;
import com.echomine.jabber.MsgSessionInit;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

public class JabberContentHandler
extends DefaultHandler {
    private JabberSession session;
    private JabberMessageReceiver receiver;
    private JabberMessageHandler msgHandler;
    private MessageRequestQueue queue;
    private boolean delegated;
    private String msgQName;

    public JabberContentHandler(JabberSession session, JabberMessageReceiver receiver, MessageRequestQueue queue) {
        this.queue = queue;
        this.receiver = receiver;
        this.session = session;
        this.msgHandler = new JDOMXMessageHandler(session.getMessageParser());
    }

    public void startDocument() {
        this.delegated = false;
        this.msgQName = null;
    }

    public void endDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attr) {
        if (qName.equals("stream:stream")) {
            String id = attr.getValue("id");
            String from = attr.getValue("from");
            if (id == null || from == null) {
                this.session.disconnect();
                return;
            }
            MsgSessionInit initmsg = new MsgSessionInit(from, id);
            JabberMessage sentMsg = this.queue.getMessageForReply(initmsg.getMessageID());
            if (sentMsg != null) {
                sentMsg.replyReceived(this.session, initmsg);
            }
            this.receiver.receive(this.session, initmsg);
            return;
        }
        if (!this.delegated) {
            this.delegated = true;
            this.msgQName = qName;
            this.msgHandler.startMessage();
        }
        if (this.delegated) {
            this.msgHandler.startElement(namespaceURI, localName, qName, attr);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (qName.equals("stream:stream")) {
            this.session.disconnect();
            return;
        }
        if (this.delegated) {
            this.msgHandler.endElement(namespaceURI, localName, qName);
        }
        if (qName.equals(this.msgQName)) {
            this.msgHandler.endMessage();
            JabberMessage msg = this.msgHandler.getMessage();
            JabberMessage sentMsg = this.queue.getMessageForReply(msg.getMessageID());
            if (sentMsg != null) {
                msg = sentMsg.replyReceived(this.session, msg);
            }
            this.receiver.receive(this.session, msg);
            this.delegated = false;
            this.msgQName = null;
        }
    }

    public void characters(char[] ch, int start, int length) {
        if (this.delegated) {
            this.msgHandler.characters(ch, start, length);
        }
    }
}

