/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.AttributeSet;
import org.exolab.castor.xml.Namespaces;
import org.exolab.castor.xml.XMLException;
import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SchemaNames;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.ComponentReader;
import org.exolab.castor.xml.schema.reader.ElementUnmarshaller;
import org.exolab.castor.xml.schema.reader.ModelGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.WildcardUnmarshaller;

public class GroupUnmarshaller
extends ComponentReader {
    private static final int ALL = 1;
    private static final int CHOICE = 2;
    private static final int MODEL_GROUP = 3;
    private static final int SEQUENCE = 4;
    private static final String MAX_OCCURS_WILDCARD = "unbounded";
    private ComponentReader unmarshaller;
    private int depth = 0;
    private Group _group = null;
    private Schema _schema = null;
    private String _element = "sequence";
    private boolean foundAll = false;
    private boolean foundElement = false;
    private boolean foundGroup = false;
    private boolean foundModelGroup = false;
    private boolean foundAnnotation = false;

    public GroupUnmarshaller(Schema schema, String element, AttributeSet atts, Resolver resolver) {
        this.setResolver(resolver);
        this._schema = schema;
        this._group = new Group();
        String attValue = null;
        if ("sequence".equals(element)) {
            this._group.setOrder(Order.seq);
        } else if ("choice".equals(element)) {
            this._group.setOrder(Order.choice);
        } else if ("all".equals(element)) {
            this.foundAll = true;
            this._group.setOrder(Order.all);
        } else {
            String err = "Invalid group element name: '" + element + "'";
            throw new IllegalArgumentException(err);
        }
        this._element = element;
        attValue = atts.getValue("name");
        if (attValue != null) {
            this._group.setName(attValue);
        }
        if ((attValue = atts.getValue("maxOccurs")) != null) {
            if (MAX_OCCURS_WILDCARD.equals(attValue)) {
                this._group.setMaxOccurs(-1);
            } else {
                this._group.setMaxOccurs(ComponentReader.toInt(attValue));
            }
        }
        if ((attValue = atts.getValue("minOccurs")) != null) {
            this._group.setMinOccurs(ComponentReader.toInt(attValue));
        }
        if (this._group.getOrder() == Order.all) {
            if (this._group.getMaxOccurs() != 1) {
                String err = "Wrong maxOccurs value for a <all>:" + this._group.getMaxOccurs();
                err = err + "\n1 is the only possible value.";
                throw new IllegalArgumentException(err);
            }
            if (this._group.getMinOccurs() > 1) {
                String err = "Wrong minOccurs value for a <all>:" + this._group.getMinOccurs();
                err = err + "\n0 or 1 are the only possible values.";
                throw new IllegalArgumentException(err);
            }
        }
        this._group.setId(atts.getValue("id"));
    }

    public String elementName() {
        return this._element;
    }

    public Group getGroup() {
        return this._group;
    }

    public Object getObject() {
        return this.getGroup();
    }

    public void startElement(String name, String namespace, AttributeSet atts, Namespaces nsDecls) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(name, namespace, atts, nsDecls);
            ++this.depth;
            return;
        }
        if ("annotation".equals(name)) {
            if (this.foundElement || this.foundGroup || this.foundModelGroup) {
                this.error("An annotation may only appear as the first child of an element definition.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) 'annotation' is allowed as a child of element definitions.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(atts);
        } else if ("element".equals(name)) {
            this.foundElement = true;
            this.unmarshaller = new ElementUnmarshaller(this._schema, atts, this.getResolver());
        } else if (name.equals("group")) {
            this.foundModelGroup = true;
            this.unmarshaller = new ModelGroupUnmarshaller(this._schema, atts, this.getResolver());
        } else if (SchemaNames.isGroupName(name) && name != "group") {
            this.foundGroup = true;
            if ("all".equals(name)) {
                this.foundAll = true;
            }
            this.unmarshaller = new GroupUnmarshaller(this._schema, name, atts, this.getResolver());
        } else if ("any".equals(name)) {
            if (this.foundAll) {
                this.error("<any> can not appear as a child of a <all> element");
            }
            this.unmarshaller = new WildcardUnmarshaller(this._group, this._schema, name, atts, this.getResolver());
        } else {
            StringBuffer err = new StringBuffer("illegal element <");
            err.append(name);
            err.append("> found in <group>.");
            throw new SchemaException(err.toString());
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }

    public void endElement(String name, String namespace) throws XMLException {
        Group group;
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(name, namespace);
            --this.depth;
            return;
        }
        if (this.unmarshaller != null && !name.equals(this.unmarshaller.elementName())) {
            String err = "missing end element for ";
            err = err + this.unmarshaller.elementName();
            throw new SchemaException(err);
        }
        this.unmarshaller.finish();
        if ("any".equals(name)) {
            Wildcard wildcard = ((WildcardUnmarshaller)this.unmarshaller).getWildcard();
            try {
                this._group.addWildcard(wildcard);
            }
            catch (SchemaException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }
        if ("annotation".equals(name)) {
            Annotation ann = (Annotation)this.unmarshaller.getObject();
            this._group.addAnnotation(ann);
        } else if ("element".equals(name)) {
            ElementDecl element = (ElementDecl)this.unmarshaller.getObject();
            this._group.addElementDecl(element);
        } else if (name.equals("group")) {
            group = (ModelGroup)this.unmarshaller.getObject();
            this._group.addGroup((ModelGroup)group);
        } else if (SchemaNames.isGroupName(name) && name != "group") {
            group = ((GroupUnmarshaller)this.unmarshaller).getGroup();
            this._group.addGroup(group);
        }
        this.unmarshaller = null;
    }

    public void characters(char[] ch, int start, int length) throws XMLException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(ch, start, length);
        }
    }
}

