/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Command;
import tcl.lang.Extension;
import tcl.lang.Interp;
import tcl.lang.TclClassLoader;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;

class JavaLoadCmd
implements Command {
    private static final String[] validOpts = new String[]{"-classpath"};

    JavaLoadCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        Class clazz;
        String string;
        TclObject tclObject;
        Extension extension = null;
        boolean bl = false;
        if (tclObjectArray.length != 2 && tclObjectArray.length != 4) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "?-classpath arg? packageName");
        }
        if (tclObjectArray.length == 4) {
            TclIndex.get(interp, tclObjectArray[1], validOpts, "switch", 0);
            tclObject = tclObjectArray[2];
            string = tclObjectArray[3].toString();
        } else {
            tclObject = null;
            string = tclObjectArray[1].toString();
        }
        String string2 = "load \"" + string + "\" failed: ";
        if (string.endsWith(".class")) {
            string = string.substring(0, string.lastIndexOf(".class"));
        }
        TclClassLoader tclClassLoader = new TclClassLoader(interp, tclObject);
        try {
            try {
                bl = false;
                clazz = tclClassLoader.loadClass(string, true);
                bl = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new TclException(interp, "package \"" + string + "\" not found");
            }
            catch (ClassFormatError classFormatError) {
                throw new TclException(interp, string2 + "use the fully qualified package name");
            }
            catch (SecurityException securityException) {
                throw new TclException(interp, string2 + securityException);
            }
            Object var14_10 = null;
            if (!bl) {
                tclClassLoader.removeCache(string);
            }
        }
        catch (Throwable throwable) {
            Object var14_11 = null;
            if (!bl) {
                tclClassLoader.removeCache(string);
            }
            throw throwable;
        }
        try {
            try {
                bl = false;
                extension = (Extension)clazz.newInstance();
                extension.init(interp);
                bl = true;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new TclException(interp, string2 + "class or initializer is not accessible");
            }
            catch (InstantiationException instantiationException) {
                throw new TclException(interp, string2 + "object instantiation failure");
            }
            catch (ClassCastException classCastException) {
                throw new TclException(interp, string2 + "not a subclass of tcl.lang.Extension");
            }
            catch (Exception exception) {
                throw new TclException(interp, string2 + "can't find class \"" + exception.getMessage() + "\"");
            }
            Object var16_20 = null;
            if (!bl) {
                tclClassLoader.removeCache(string);
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            if (!bl) {
                tclClassLoader.removeCache(string);
            }
            throw throwable;
        }
    }
}

