/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.util;

import org.exolab.castor.types.AnyNode;
import org.exolab.castor.util.Stack;
import org.exolab.castor.xml.EventProducer;
import org.exolab.castor.xml.Namespaces;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class AnyNode2SAX
implements EventProducer {
    private AnyNode _node;
    private DocumentHandler _handler;
    private Stack _elements = new Stack();
    private Namespaces _context;
    private static final String XMLNS_PREFIX = "xmlns";

    public AnyNode2SAX() {
    }

    public AnyNode2SAX(AnyNode node) {
        this();
        this._node = node;
        this._context = new Namespaces();
    }

    public AnyNode2SAX(AnyNode node, Namespaces context) {
        this();
        this._node = node;
        this._context = context == null ? new Namespaces() : context;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("AnyNode2SAX#setDocumentHandler 'null' value for handler");
        }
        this._handler = handler;
    }

    public static void fireEvents(AnyNode node, DocumentHandler handler) throws SAXException {
        AnyNode2SAX.fireEvents(node, handler, null);
    }

    public static void fireEvents(AnyNode node, DocumentHandler handler, Namespaces context) throws SAXException {
        AnyNode2SAX eventProducer = new AnyNode2SAX(node, context);
        eventProducer.setDocumentHandler(handler);
        eventProducer.start();
    }

    public void start() throws SAXException {
        if (this._node == null || this._handler == null) {
            return;
        }
        this.processAnyNode(this._node, this._handler);
    }

    private void processAnyNode(AnyNode node, DocumentHandler handler) throws SAXException {
        String value;
        if (node == null || handler == null) {
            throw new IllegalArgumentException();
        }
        if (this._elements.search(node) >= 0) {
            return;
        }
        this._elements.push(node);
        if (node.getNodeType() == 1) {
            AnyNode siblingNode = node.getNextSibling();
            String name = node.getLocalName();
            AttributeListImpl atts = new AttributeListImpl();
            AnyNode tempNode = node.getFirstAttribute();
            String xmlName = null;
            String value2 = null;
            while (tempNode != null) {
                xmlName = tempNode.getLocalName();
                value2 = tempNode.getStringValue();
                atts.addAttribute(xmlName, null, value2);
                tempNode = tempNode.getNextSibling();
            }
            this._context = this._context.createNamespaces();
            String nsPrefix = node.getNamespacePrefix();
            String nsURI = node.getNamespaceURI();
            tempNode = node.getFirstNamespace();
            String prefix = null;
            while (tempNode != null) {
                prefix = tempNode.getNamespacePrefix();
                value2 = tempNode.getNamespaceURI();
                if (value2 != null && value2.length() > 0) {
                    this._context.addNamespace(prefix, value2);
                }
                tempNode = tempNode.getNextSibling();
            }
            String qName = null;
            if (nsURI != null && nsURI.length() > 0) {
                String tempPrefix = this._context.getNamespacePrefix(nsURI);
                if (tempPrefix != null) {
                    nsPrefix = tempPrefix;
                } else {
                    this._context.addNamespace(nsPrefix, nsURI);
                }
            }
            if (nsPrefix != null) {
                int len = nsPrefix.length();
                if (len > 0) {
                    StringBuffer sb = new StringBuffer(len + name.length() + 1);
                    sb.append(nsPrefix);
                    sb.append(':');
                    sb.append(name);
                    qName = sb.toString();
                } else {
                    qName = name;
                }
            } else {
                qName = name;
            }
            try {
                this._context.declareAsAttributes(atts, true);
                handler.startElement(qName, atts);
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
            tempNode = node.getFirstChild();
            while (tempNode != null) {
                this.processAnyNode(tempNode, handler);
                tempNode = tempNode.getNextSibling();
            }
            try {
                handler.endElement(qName);
                this._context = this._context.getParent();
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
        }
        if (node.getNodeType() == 6 && (value = node.getStringValue()) != null && value.length() > 0) {
            char[] chars = value.toCharArray();
            try {
                handler.characters(chars, 0, chars.length);
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
        }
    }

    private void processTextNode(AnyNode node, DocumentHandler handler) throws SAXException {
        if (node.getNodeType() != 6) {
            String err = "This node can not be handle by processTextNode.";
            throw new IllegalArgumentException(err);
        }
        String value = node.getStringValue();
        if (value != null && value.length() > 0) {
            char[] chars = value.toCharArray();
            try {
                handler.characters(chars, 0, chars.length);
            }
            catch (SAXException sx) {
                throw new SAXException(sx);
            }
        }
    }
}

