/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net;

import com.echomine.net.ConnectionThrottler;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class ConnectionModel {
    long startTime;
    long endTime;
    long bytesTransferred;
    int port;
    InetAddress host;
    ConnectionThrottler throttler;

    public ConnectionModel(int port) {
        this.host = null;
        this.port = port;
    }

    public ConnectionModel(InetAddress host, int port) {
        this(host, port, null);
    }

    public ConnectionModel(String hostname, int port) throws UnknownHostException {
        this(hostname, port, null);
    }

    public ConnectionModel(InetAddress host, int port, ConnectionThrottler throttler) {
        this.host = host;
        this.port = port;
        this.throttler = throttler;
    }

    public ConnectionModel(String hostname, int port, ConnectionThrottler throttler) throws UnknownHostException {
        this.host = InetAddress.getByName(hostname);
        this.port = port;
        this.throttler = throttler;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getHost() {
        return this.host;
    }

    public String getHostName() {
        if (this.host == null) {
            return null;
        }
        return this.host.getHostName();
    }

    public String getHostAddress() {
        if (this.host == null) {
            return null;
        }
        return this.host.getHostAddress();
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(InetAddress host) {
        this.host = host;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ConnectionModel)) {
            return false;
        }
        ConnectionModel model = (ConnectionModel)obj;
        if (this.host == null && model.getHost() == null && this.port == model.getPort()) {
            return true;
        }
        return this.host != null && this.host.equals(((ConnectionModel)obj).getHost()) && this.port == ((ConnectionModel)obj).getPort();
    }

    public void setThrottler(ConnectionThrottler throttler) {
        this.throttler = throttler;
    }

    public ConnectionThrottler getThrottler() {
        return this.throttler;
    }

    public String toString() {
        return this.host.getHostAddress() + ":" + this.port;
    }

    public void incrementBytesTransferred(long increment) {
        this.bytesTransferred += increment;
    }

    public float getTransferKBPS() {
        if (this.endTime > 0L) {
            return 0.0f;
        }
        float kbps = this.getTransferBPS() / 1024L;
        return kbps;
    }

    public long getTransferBPS() {
        if (this.endTime > 0L) {
            return 0;
        }
        return (long)((float)this.bytesTransferred / (float)((System.currentTimeMillis() - this.startTime) / 1000L));
    }

    public long getTimeOnlineMillis() {
        if (this.startTime <= 0L) {
            return 0;
        }
        if (this.endTime > 0L) {
            return this.endTime - this.startTime;
        }
        return System.currentTimeMillis() - this.startTime;
    }

    public String getTimeOnlineString() {
        long timeOnline = this.getTimeOnlineMillis() / 1000L;
        if (timeOnline <= 0L) {
            return "00:00:00";
        }
        int hour = (int)(timeOnline / 3600L);
        int min = (int)((timeOnline %= 3600L) / 60L);
        int sec = (int)(timeOnline % 60L);
        StringBuffer buffer = new StringBuffer(9);
        buffer.append(hour < 10 ? "0" : "").append(hour).append(":");
        buffer.append(min < 10 ? "0" : "").append(min).append(":");
        buffer.append(sec < 10 ? "0" : "").append(sec);
        return buffer.toString();
    }

    public void reset() {
        this.bytesTransferred = 0L;
        this.startTime = 0L;
        this.endTime = 0L;
    }

    public void setStartTime(long startTime) {
        this.reset();
        this.startTime = startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }
}

