/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net;

import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionFailedException;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.HandshakeFailedException;
import com.echomine.net.HandshakeableSocketHandler;
import com.echomine.net.TimeableConnection;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.net.Socket;

public class HandshakeableSocketConnector
extends TimeableConnection {
    private HandshakeableSocketHandler socketHandler;

    public HandshakeableSocketConnector() {
    }

    public HandshakeableSocketConnector(HandshakeableSocketHandler socketHandler) {
        this.socketHandler = socketHandler;
    }

    public void connect(ConnectionModel connectionModel) throws ConnectionFailedException {
        this.connect(this.socketHandler, connectionModel);
    }

    public void connect(HandshakeableSocketHandler socketHandler, ConnectionModel connectionModel) throws ConnectionFailedException {
        try {
            ConnectionEvent event = new ConnectionEvent(connectionModel, 4);
            ConnectionEvent vetoEvent = new ConnectionEvent(connectionModel, 5);
            socketHandler.start();
            this.fireConnectionStarting(event, vetoEvent);
            Socket socket = new Socket(connectionModel.getHost(), connectionModel.getPort());
            try {
                try {
                    event = new ConnectionEvent(connectionModel, 1);
                    socketHandler.handshake(socket);
                    this.fireConnectionEstablished(event);
                    socketHandler.handle(socket);
                    event = new ConnectionEvent(connectionModel, 2);
                    this.fireConnectionClosed(event);
                }
                catch (HandshakeFailedException ex) {
                    event = new ConnectionEvent(connectionModel, 3, "Error during handshaking: " + ex.getMessage());
                    this.fireConnectionClosed(event);
                    throw new ConnectionFailedException("Error during handshaking");
                }
                catch (IOException ex) {
                    event = new ConnectionEvent(connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                    this.fireConnectionClosed(event);
                    throw new ConnectionFailedException("Error while handling connection");
                }
                Object var10_11 = null;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                IOUtil.closeSocket(socket);
                throw throwable;
            }
            IOUtil.closeSocket(socket);
        }
        catch (ConnectionVetoException ex) {
        }
        catch (IOException ex) {
            ConnectionEvent event = new ConnectionEvent(connectionModel, 3, "Error..." + ex.getMessage());
            this.fireConnectionClosed(event);
            throw new ConnectionFailedException("Cannot Connect to remote host");
        }
    }

    public void aconnect(ConnectionModel connectionModel) {
        this.aconnect(this.socketHandler, connectionModel);
    }

    public void aconnect(HandshakeableSocketHandler socketHandler, ConnectionModel connectionModel) {
        Thread thread = new Thread(new _1(this, socketHandler, connectionModel));
        thread.start();
    }

    public HandshakeableSocketHandler getSocketHandler() {
        return this.socketHandler;
    }

    public void setSocketHandler(HandshakeableSocketHandler socketHandler) {
        this.socketHandler = socketHandler;
    }

    class _1
    implements Runnable {
        private final HandshakeableSocketConnector this$HandshakeableSocketConnector;
        final ConnectionModel val$connectionModel;
        final HandshakeableSocketHandler val$socketHandler;

        public void run() {
            try {
                ConnectionEvent event = new ConnectionEvent(this.val$connectionModel, 4);
                ConnectionEvent vetoEvent = new ConnectionEvent(this.val$connectionModel, 5);
                this.val$socketHandler.start();
                this.this$HandshakeableSocketConnector.fireConnectionStarting(event, vetoEvent);
                Socket socket = new Socket(this.val$connectionModel.getHost(), this.val$connectionModel.getPort());
                try {
                    try {
                        event = new ConnectionEvent(this.val$connectionModel, 1);
                        this.val$socketHandler.handshake(socket);
                        this.this$HandshakeableSocketConnector.fireConnectionEstablished(event);
                        this.val$socketHandler.handle(socket);
                        event = new ConnectionEvent(this.val$connectionModel, 2);
                        this.this$HandshakeableSocketConnector.fireConnectionClosed(event);
                    }
                    catch (HandshakeFailedException ex) {
                        event = new ConnectionEvent(this.val$connectionModel, 3, "Error during handshaking: " + ex.getMessage());
                        this.this$HandshakeableSocketConnector.fireConnectionClosed(event);
                    }
                    catch (IOException ex) {
                        event = new ConnectionEvent(this.val$connectionModel, 3, "Error while handling connection: " + ex.getMessage());
                        this.this$HandshakeableSocketConnector.fireConnectionClosed(event);
                    }
                    Object var8_9 = null;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    IOUtil.closeSocket(socket);
                    throw throwable;
                }
                IOUtil.closeSocket(socket);
            }
            catch (IOException ex) {
                ConnectionEvent event = new ConnectionEvent(this.val$connectionModel, 3, "Error connecting to host: " + ex.getMessage());
                this.this$HandshakeableSocketConnector.fireConnectionClosed(event);
            }
            catch (ConnectionVetoException connectionVetoException) {
                // empty catch block
            }
        }

        _1(HandshakeableSocketConnector enclosing$instance, HandshakeableSocketHandler val$socketHandler, ConnectionModel val$connectionModel) {
            this.this$HandshakeableSocketConnector = enclosing$instance;
            this.val$socketHandler = val$socketHandler;
            this.val$connectionModel = val$connectionModel;
        }
    }
}

