/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import com.sun.tools.doclets.standard.HtmlStandardWriter;
import com.sun.tools.doclets.standard.SerialFieldSubWriter;
import com.sun.tools.doclets.standard.SerialMethodSubWriter;
import com.sun.tools.doclets.standard.SubWriterHolderWriter;
import java.io.IOException;
import java.util.Arrays;

public class SerializedFormWriter
extends SubWriterHolderWriter {
    ConfigurationStandard configuration;
    private static final String SERIAL_VERSION_UID_HEADER = "serialVersionUID:";

    protected void tableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
        this.p();
    }

    protected void tableHeader() {
        this.tableIndexSummary();
        this.trBgcolorStyle("#CCCCFF", "TableSubHeadingColor");
    }

    protected void printSerialMemberInfo(ClassDoc classDoc) {
        String string = classDoc.isPublic() || classDoc.isProtected() ? this.getQualifiedClassLink(classDoc) : classDoc.qualifiedName();
        this.anchor(classDoc.qualifiedName());
        String string2 = classDoc.superclass() != null ? this.getClassLink(classDoc.superclass()) : null;
        this.printClassName(string2 == null ? this.getText("doclet.Class_0_implements_serializable", string) : this.getText("doclet.Class_0_extends_implements_serializable", string, string2));
        this.printSerialUID(classDoc);
        this.printSerialMembers(classDoc);
        this.p();
    }

    protected void printSerialMembers(ClassDoc classDoc) {
        new SerialMethodSubWriter(this, classDoc, this.configuration).printMembers();
        new SerialFieldSubWriter(this, classDoc).printMembers();
    }

    protected void printSerialUID(ClassDoc classDoc) {
        FieldDoc[] fieldDocArray = classDoc.fields(false);
        int n = 0;
        while (n < fieldDocArray.length) {
            if (fieldDocArray[n].name().equals("serialVersionUID") && fieldDocArray[n].constantValueExpression() != null) {
                this.bold("serialVersionUID:&nbsp;");
                this.println(fieldDocArray[n].constantValueExpression());
                this.p();
                return;
            }
            ++n;
        }
    }

    protected boolean serialClassFoundToDocument(ClassDoc[] classDocArray) {
        int n = 0;
        while (n < classDocArray.length) {
            if (HtmlStandardWriter.serialClassInclude(classDocArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected void generateContents(RootDoc rootDoc) {
        PackageDoc[] packageDocArray = rootDoc.specifiedPackages();
        Object[] objectArray = rootDoc.specifiedClasses();
        boolean bl = true;
        int n = 0;
        while (n < packageDocArray.length) {
            if (HtmlStandardWriter.serialInclude(packageDocArray[n])) {
                Object[] objectArray2 = packageDocArray[n].allClasses(false);
                boolean bl2 = true;
                if (this.serialClassFoundToDocument((ClassDoc[])objectArray2)) {
                    Arrays.sort(objectArray2);
                    int n2 = 0;
                    while (n2 < objectArray2.length) {
                        Object object = objectArray2[n2];
                        if (object.isClass() && object.isSerializable() && HtmlStandardWriter.serialClassInclude((ClassDoc)object)) {
                            if (bl2) {
                                this.hr(4, "noshade");
                                this.printPackageName(packageDocArray[n].name());
                                bl2 = false;
                            }
                            bl = false;
                            this.printSerialMemberInfo((ClassDoc)object);
                        }
                        ++n2;
                    }
                }
            }
            ++n;
        }
        if (objectArray.length > 0) {
            Arrays.sort(objectArray);
            int n3 = 0;
            while (n3 < objectArray.length) {
                Object object = objectArray[n3];
                if (object.isClass() && object.isSerializable()) {
                    if (!bl) {
                        this.hr(4, "noshade");
                    }
                    bl = false;
                    this.printSerialMemberInfo((ClassDoc)object);
                }
                ++n3;
            }
        }
    }

    public void generateSerializedFormFile(RootDoc rootDoc) {
        this.printHtmlHeader(this.getText("doclet.Serialized_Form"));
        this.navLinks(true);
        this.hr();
        this.center();
        this.h1();
        this.printText("doclet.Serialized_Form");
        this.h1End();
        this.centerEnd();
        this.generateContents(rootDoc);
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    public static void generate(ConfigurationStandard configurationStandard) {
        String string = "serialized-form.html";
        try {
            SerializedFormWriter serializedFormWriter = new SerializedFormWriter(configurationStandard, string);
            serializedFormWriter.generateSerializedFormFile(configurationStandard.root);
            serializedFormWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void printClassName(String string) {
        this.tableHeader();
        this.tdColspan(2);
        this.font("+2");
        this.bold(string);
        this.tableFooter();
    }

    protected void printPackageName(String string) {
        this.tableHeader();
        this.tdAlign("center");
        this.font("+2");
        this.boldText("doclet.Package");
        this.print(' ');
        this.bold(string);
        this.tableFooter();
    }

    public SerializedFormWriter(ConfigurationStandard configurationStandard, String string) throws IOException {
        super(configurationStandard, string);
        this.configuration = configurationStandard;
    }
}

