/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.Agent;
import com.echomine.jabber.JabberCode;
import com.echomine.jabber.JabberIQMessage;
import com.echomine.jabber.JabberMessage;
import com.echomine.jabber.JabberMessageParser;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class AgentsIQMessage
extends JabberIQMessage {
    private ArrayList agents = new ArrayList();

    public AgentsIQMessage() {
        super("get");
        this.getDOM().addContent(new Element("query", JabberCode.XMLNS_IQ_AGENTS));
    }

    public List getAgentList() {
        return this.agents;
    }

    public JabberMessage parse(JabberMessageParser parser, Element msgTree) throws ParseException {
        this.agents.clear();
        super.parse(parser, msgTree);
        Element query = msgTree.getChild("query", JabberCode.XMLNS_IQ_AGENTS);
        if (query == null) {
            throw new ParseException("No agent message exists");
        }
        List agentElems = query.getChildren("agent", JabberCode.XMLNS_IQ_AGENTS);
        int size = agentElems.size();
        int i = 0;
        while (i < size) {
            Element agentElem = (Element)agentElems.get(i);
            String agentJID = agentElem.getAttributeValue("jid");
            Agent agent = new Agent(agentJID);
            agent.parse(agentElem);
            this.agents.add(agent);
            ++i;
        }
        return this;
    }

    public int getMessageType() {
        return 20;
    }
}

