/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.xmlrpc;

import com.echomine.xmlrpc.SerializerFactory;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class Call {
    private String methodName;
    private Namespace ns;
    private ArrayList params = new ArrayList();

    public Call() {
    }

    public Call(String methodName) {
        this(methodName, null);
    }

    public Call(String methodName, Namespace ns) {
        this.methodName = methodName;
        this.ns = ns;
    }

    public void setNamespace(Namespace ns) {
        this.ns = ns;
    }

    public Namespace getNamespace() {
        return this.ns;
    }

    public void setMethodName(String name) {
        this.methodName = name;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void addParameter(Object param) {
        this.params.add(param);
    }

    public void addParameters(Object[] param) {
        int i = 0;
        while (i < param.length) {
            this.params.add(param[i]);
            ++i;
        }
    }

    public Object getParameter(int idx) {
        return this.params.get(idx);
    }

    public Object[] getParameters() {
        return this.params.toArray();
    }

    public Element getDOM() {
        Element root = new Element("methodCall", this.ns);
        Element method = new Element("methodName", this.ns);
        method.setText(this.methodName);
        root.addContent(method);
        if (this.params.size() == 0) {
            return root;
        }
        Element paramsElem = new Element("params", this.ns);
        root.addContent(paramsElem);
        int length = this.params.size();
        int i = 0;
        while (i < length) {
            Object obj = this.params.get(i);
            Element valueData = SerializerFactory.serialize(obj, this.ns);
            if (valueData != null) {
                Element param = new Element("param", this.ns);
                Element paramValue = new Element("value", this.ns);
                paramValue.addContent(valueData);
                param.addContent(paramValue);
                paramsElem.addContent(param);
            }
            ++i;
        }
        return root;
    }

    public void parse(Element elem) {
        this.params.clear();
        this.methodName = null;
        this.ns = elem.getNamespace();
        this.methodName = elem.getChildText("methodName", this.ns);
        List paramList = elem.getChild("params", this.ns).getChildren();
        int len = paramList.size();
        int i = 0;
        while (i < len) {
            Element data = (Element)paramList.get(i);
            Element value = (Element)data.getChild("value", this.ns).getChildren().get(0);
            Object paramVal = SerializerFactory.deserialize(value);
            this.params.add(paramVal);
            ++i;
        }
    }

    public String toString() {
        Element dom = this.getDOM();
        XMLOutputter xos = new XMLOutputter();
        return xos.outputString(dom);
    }

    public static void main(String[] args) {
        Call call = new Call("getHelloWorldString");
        call.addParameter("Testing 1 2 3");
        ArrayList<String> list = new ArrayList<String>();
        list.add("index 0");
        list.add("index 1");
        list.add("index 2");
        call.addParameter(list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faultCode", new Integer(1));
        map.put("faultString", "too few < parameters.");
        call.addParameter(map);
        call.addParameter(new Boolean(true));
        call.addParameter(new Double(2.342984288E9));
        call.addParameter(new Date());
        call.addParameter("a base64 string".getBytes());
        String callStr = call.toString();
        System.out.println("Call: \n" + callStr);
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(callStr));
            Call inCall = new Call();
            inCall.parse(doc.getRootElement());
            System.out.println("Parsed Call:");
            System.out.println("Method Name: " + inCall.getMethodName());
            System.out.println("Parameters: ");
            Object[] objs = inCall.getParameters();
            int i = 0;
            while (i < objs.length) {
                System.out.println("Param " + i + ": " + objs[i]);
                ++i;
            }
        }
        catch (JDOMException ex) {
            ex.printStackTrace();
        }
    }
}

