/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.ParseException;
import com.echomine.jabber.JabberCode;
import java.util.ArrayList;
import java.util.List;
import org.apache.oro.text.perl.Perl5Util;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.XMLOutputter;

public class JIDType {
    private String category;
    private String subtype;
    private String jid;
    private String name;
    private ArrayList children;
    private ArrayList nsList;

    public JIDType(String type) {
        Perl5Util regex = new Perl5Util();
        if (regex.match("m#(\\S+)/(\\S+)#", type)) {
            this.category = regex.group(1);
            this.subtype = regex.group(2);
        }
    }

    public JIDType(String category, String subtype) {
        this.category = category;
        this.subtype = subtype;
    }

    public String getJIDType() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.category).append("/");
        if (this.subtype != null) {
            buf.append(this.subtype);
        }
        return buf.toString();
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getSubtype() {
        return this.subtype;
    }

    public void setSubtype(String subtype) {
        this.subtype = subtype;
    }

    public String getJID() {
        return this.jid;
    }

    public void setJID(String jid) {
        this.jid = jid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void addChild(JIDType child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    public void addNS(Namespace ns) {
        if (this.nsList == null) {
            this.nsList = new ArrayList();
        }
        this.nsList.add(ns);
    }

    public List getChildren() {
        return this.children;
    }

    public List getNSList() {
        return this.nsList;
    }

    public void parse(Element browse) throws ParseException {
        if (this.children == null) {
            this.children = new ArrayList();
        } else {
            this.children.clear();
        }
        if (this.nsList == null) {
            this.children = new ArrayList();
        } else {
            this.nsList.clear();
        }
        this.name = null;
        this.jid = null;
        this.setName(browse.getAttributeValue("name"));
        this.setJID(browse.getAttributeValue("jid"));
        List bchildren = browse.getChildren();
        int size = bchildren.size();
        int i = 0;
        while (i < size) {
            Element child = (Element)bchildren.get(i);
            if (child.getName().equals("ns")) {
                this.addNS(Namespace.getNamespace((String)child.getText()));
            } else {
                JIDType subChild = new JIDType(child.getName(), child.getAttributeValue("type"));
                subChild.parse(child);
                this.addChild(subChild);
            }
            ++i;
        }
    }

    public Element getDOM() throws ParseException {
        int size;
        if (this.category == null || this.jid == null) {
            throw new ParseException("JIDType category must be set");
        }
        Element browse = new Element(this.category, JabberCode.XMLNS_IQ_BROWSE);
        if (this.jid != null) {
            browse.setAttribute("jid", this.jid.toString());
        }
        if (this.subtype != null) {
            browse.setAttribute("type", this.subtype);
        }
        if (this.name != null) {
            browse.setAttribute("name", this.name);
        }
        if (this.nsList != null) {
            size = this.nsList.size();
            int i = 0;
            while (i < size) {
                Namespace ns = (Namespace)this.nsList.get(i);
                Element elem = new Element("ns", JabberCode.XMLNS_IQ_BROWSE);
                elem.setText(ns.getURI());
                browse.addContent(elem);
                ++i;
            }
        }
        if (this.children != null) {
            size = this.children.size();
            int i = 0;
            while (i < size) {
                JIDType jidtype = (JIDType)this.children.get(i);
                browse.addContent(jidtype.getDOM());
                ++i;
            }
        }
        return browse;
    }

    public String toString() {
        XMLOutputter os = new XMLOutputter();
        String temp = "";
        try {
            temp = os.outputString(this.getDOM());
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return temp;
    }
}

