/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.util.junit;

import com.echomine.util.IOUtil;
import com.echomine.util.junit.StringStream;
import java.io.IOException;
import junit.framework.TestCase;

public class IOUtilTest
extends TestCase {
    public IOUtilTest(String name) {
        super(name);
    }

    public void testReadToCRLF() throws IOException {
        byte[] buf = new byte[1024];
        int bread = 0;
        StringStream sis = new StringStream("This string with CRLF should parse normally\r\n");
        bread = IOUtil.readToCRLF(sis, buf, 0, 1024);
        IOUtilTest.assertTrue((boolean)sis.equals(buf, 0, bread));
        sis = new StringStream("This string with LFLF should parse normally\n\n");
        bread = IOUtil.readToCRLF(sis, buf, 0, 1024);
        IOUtilTest.assertTrue((boolean)sis.equals(buf, 0, bread));
        try {
            sis.setString("This string with simulated 0x00 should throw\u0000 an exception\n\n");
            bread = IOUtil.readToCRLF(sis, buf, 0, 1024);
            IOUtilTest.fail((String)"The string should have caused an exception");
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public void testReadToLF() throws IOException {
        byte[] buf = new byte[1024];
        int bread = 0;
        StringStream sis = new StringStream("This string with LF should parse normally\n");
        bread = IOUtil.readToLF(sis, buf, 0, 1024);
        IOUtilTest.assertTrue((boolean)sis.equals(buf, 0, bread));
        try {
            sis.setString("This string with simulated 0x00 should throw\u0000 an exception\n");
            bread = IOUtil.readToLF(sis, buf, 0, 1024);
            IOUtilTest.fail((String)"The string should have caused an exception");
        }
        catch (IOException ex) {
            // empty catch block
        }
    }
}

