/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.Channel;
import tcl.lang.Command;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclIndex;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;

class FconfigureCmd
implements Command {
    private static final String[] validCmds = new String[]{"-blocking", "-buffering", "-buffersize", "-eofchar", "-translation"};
    static final int OPT_BLOCKING = 0;
    static final int OPT_BUFFERING = 1;
    static final int OPT_BUFFERSIZE = 2;
    static final int OPT_EOFCHAR = 3;
    static final int OPT_TRANSLATION = 4;

    FconfigureCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        if (tclObjectArray.length < 2 || tclObjectArray.length % 2 == 1 && tclObjectArray.length != 3) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "channelId ?optionName? ?value? ?optionName value?...");
        }
        Channel channel = TclIO.getChannel(interp, tclObjectArray[1].toString());
        if (channel == null) {
            throw new TclException(interp, "can not find channel named \"" + tclObjectArray[1].toString() + "\"");
        }
        if (tclObjectArray.length == 2) {
            // empty if block
        }
        if (tclObjectArray.length == 3) {
            n = TclIndex.get(interp, tclObjectArray[2], validCmds, "option", 0);
            switch (n) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
            }
        }
        n = 3;
        while (n < tclObjectArray.length) {
            int n2 = TclIndex.get(interp, tclObjectArray[n - 1], validCmds, "option", 0);
            switch (n2) {
                case 0: {
                    break;
                }
                case 1: {
                    String string = tclObjectArray[n].toString();
                    if (string.equals("full") || string.equals("line") || string.equals("none")) break;
                    throw new TclException(interp, "bad value for -buffering: must be one of full, line, or none");
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    String string = tclObjectArray[n].toString();
                    if (string.equals("auto") || string.equals("binary") || string.equals("cr") || string.equals("crlf") || string.equals("lf")) break;
                    throw new TclException(interp, "bad value for -translation: must be one of auto, binary, cr, lf, crlf, or platform");
                }
                default: {
                    throw new TclRuntimeError("Fconfigure.cmdProc() error: incorrect index returned from TclIndex.get()");
                }
            }
            n += 2;
        }
        throw new TclException(interp, "fconfigure command not implemented yet");
    }
}

