/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import tcl.lang.Channel;
import tcl.lang.FileUtil;
import tcl.lang.Interp;
import tcl.lang.TclException;
import tcl.lang.TclIO;
import tcl.lang.TclPosixException;
import tcl.lang.TclRuntimeError;

class FileChannel
extends Channel {
    private RandomAccessFile file = null;
    private BufferedReader reader = null;
    private static final int BUF_SIZE = 1024;
    private boolean eofCond = false;

    FileChannel() {
    }

    String open(Interp interp, String string, int n) throws IOException, TclException {
        this.mode = n;
        File file = FileUtil.getNewFileObj(interp, string);
        if ((n & 0x10) != 0 && !file.exists()) {
            this.file = new RandomAccessFile(file, "rw");
            this.file.close();
        }
        if ((n & 4) != 0) {
            this.checkFileExists(interp, file);
            this.checkReadWritePerm(interp, file, 0);
            if (file.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + string + "\": illegal operation on a directory");
            }
            this.file = new RandomAccessFile(file, "rw");
        } else if ((n & 1) != 0) {
            this.checkFileExists(interp, file);
            this.checkReadWritePerm(interp, file, -1);
            if (file.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + string + "\": illegal operation on a directory");
            }
            this.file = new RandomAccessFile(file, "r");
        } else if ((n & 2) != 0) {
            this.checkFileExists(interp, file);
            this.checkReadWritePerm(interp, file, 1);
            if (file.isDirectory()) {
                throw new TclException(interp, "couldn't open \"" + string + "\": illegal operation on a directory");
            }
            if (!file.canRead()) {
                throw new TclException(interp, "Java IO limitation: Cannot open a file that has only write permissions set.");
            }
            this.file = new RandomAccessFile(file, "rw");
        } else {
            throw new TclRuntimeError("FileChannel.java: invalid mode value");
        }
        if ((n & 8) != 0) {
            this.file.seek(this.file.length());
        }
        String string2 = "file" + this.getNextFileNum(interp);
        this.setChanName(string2);
        return string2;
    }

    String read(Interp interp, int n, int n2) throws IOException, TclException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.read: null file object");
        }
        if ((this.mode & 2) != 0) {
            throw new TclException(interp, "channel" + this.getChanName() + "\"wasn't opened for reading");
        }
        if (this.reader == null) {
            this.reader = new BufferedReader(new FileReader(this.file.getFD()));
        }
        this.eofCond = false;
        switch (n) {
            case 1: {
                int n3;
                char[] cArray = new char[1024];
                StringBuffer stringBuffer = new StringBuffer((int)this.file.length());
                while ((n3 = this.reader.read(cArray, 0, 1024)) != -1) {
                    stringBuffer.append(cArray, 0, n3);
                }
                this.eofCond = true;
                return stringBuffer.toString();
            }
            case 2: {
                String string = this.reader.readLine();
                if (string == null) {
                    this.eofCond = true;
                    return "";
                }
                return string;
            }
            case 3: {
                char[] cArray = new char[n2];
                int n4 = this.reader.read(cArray, 0, n2);
                if (n4 == -1) {
                    this.eofCond = true;
                    return "";
                }
                return new String(cArray, 0, n4);
            }
        }
        throw new TclRuntimeError("FileChannel.read(): Incorrect read mode.");
    }

    void write(Interp interp, String string) throws IOException, TclException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.write(): null file object");
        }
        if ((this.mode & 1) != 0) {
            throw new TclException(interp, "channel \"" + this.getChanName() + "\" wasn't opened for writing");
        }
        this.file.writeBytes(string);
    }

    void close() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.close(): null file object");
        }
        this.file.close();
    }

    void flush(Interp interp) throws IOException, TclException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.flush(): null file object");
        }
    }

    void seek(long l, int n) throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.seek(): null file object");
        }
        switch (n) {
            case 1: {
                this.file.seek(l);
                break;
            }
            case 2: {
                this.file.seek(this.file.getFilePointer() + l);
                break;
            }
            case 3: {
                this.file.seek(this.file.length() + l);
            }
        }
    }

    long tell() throws IOException {
        if (this.file == null) {
            throw new TclRuntimeError("FileChannel.tell(): null file object");
        }
        return this.file.getFilePointer();
    }

    boolean eof() {
        return this.eofCond;
    }

    private void checkFileExists(Interp interp, File file) throws TclException {
        if (!file.exists()) {
            throw new TclPosixException(interp, 2, true, "couldn't open \"" + file.getName() + "\"");
        }
    }

    private void checkReadWritePerm(Interp interp, File file, int n) throws TclException {
        boolean bl = false;
        if (n <= 0 && !file.canRead()) {
            bl = true;
        }
        if (n >= 0 && !file.canWrite()) {
            bl = true;
        }
        if (bl) {
            throw new TclPosixException(interp, 13, true, "couldn't open \"" + file.getName() + "\"");
        }
    }

    private int getNextFileNum(Interp interp) {
        Hashtable hashtable = TclIO.getInterpChanTable(interp);
        int n = 0;
        while (hashtable.get("file" + n) != null) {
            ++n;
        }
        return n;
    }
}

