/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import com.sun.tools.doclets.standard.ConstantFieldSubWriter;
import com.sun.tools.doclets.standard.SubWriterHolderWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ConstantsSummaryWriter
extends SubWriterHolderWriter {
    ConfigurationStandard configuration;
    private Set classDocsWithConstFields;
    private Set printedPackageHeaders;
    private String UNNAMED_PACKAGE_ANCHOR = "unnamed_package";
    private String UNNAMED_PACKAGE_HEADING = "Unnamed Package";

    private void tableFooter() {
        this.fontEnd();
        this.tdEnd();
        this.trEnd();
        this.tableEnd();
        this.p();
    }

    protected void printConstantMemberInfo(ClassDoc classDoc) {
        String string = classDoc.isPublic() || classDoc.isProtected() ? this.getClassLink(classDoc) : classDoc.qualifiedName();
        String string2 = classDoc.containingPackage().name();
        if (string2.length() > 0) {
            this.printClassName(string2 + "." + string);
        } else {
            this.printClassName(string);
        }
        this.printConstantMembers(classDoc);
        this.tableFooter();
        this.p();
    }

    protected void printConstantMembers(ClassDoc classDoc) {
        new ConstantFieldSubWriter(this, classDoc).printMembersSummary();
    }

    private boolean hasConstantField(ClassDoc classDoc) {
        FieldDoc[] fieldDocArray = classDoc.fields();
        int n = 0;
        while (n < fieldDocArray.length) {
            if (fieldDocArray[n].constantValueExpression() != null) {
                this.classDocsWithConstFields.add(classDoc);
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean hasConstantField(PackageDoc packageDoc) {
        ClassDoc[] classDocArray = packageDoc.name().length() > 0 ? packageDoc.allClasses() : this.configuration.classDocCatalog.allClasses("");
        boolean bl = false;
        int n = 0;
        while (n < classDocArray.length) {
            if (classDocArray[n].isIncluded() && this.hasConstantField(classDocArray[n])) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public void generateConstantsFile(RootDoc rootDoc) {
        this.printHtmlHeader(this.getText("doclet.Constants_Summary"));
        this.navLinks(true);
        this.hr();
        this.center();
        this.h1();
        this.printText("doclet.Constants_Summary");
        this.h1End();
        this.centerEnd();
        this.hr(4, "noshade");
        this.generateIndex(rootDoc);
        this.generateContents(rootDoc);
        this.hr();
        this.navLinks(false);
        this.printBottom();
        this.printBodyHtmlEnd();
    }

    protected void generateContents(RootDoc rootDoc) {
        PackageDoc[] packageDocArray = this.configuration.packages;
        this.printedPackageHeaders = new HashSet();
        boolean bl = true;
        int n = 0;
        while (n < packageDocArray.length) {
            Object[] objectArray = packageDocArray[n].name().length() > 0 ? packageDocArray[n].allClasses() : this.configuration.classDocCatalog.allClasses("");
            boolean bl2 = true;
            Arrays.sort(objectArray);
            int n2 = 0;
            while (n2 < objectArray.length) {
                Object object = objectArray[n2];
                if (this.classDocsWithConstFields.contains(object) && object.isIncluded()) {
                    if (bl2) {
                        this.printPackageName(packageDocArray[n].name());
                        bl2 = false;
                    }
                    bl = false;
                    this.printConstantMemberInfo((ClassDoc)object);
                }
                ++n2;
            }
            ++n;
        }
    }

    protected void generateIndex(RootDoc rootDoc) {
        PackageDoc[] packageDocArray = this.configuration.packages;
        this.printedPackageHeaders = new HashSet();
        this.bold(this.getText("doclet.Contents"));
        this.ul();
        int n = 0;
        while (n < packageDocArray.length) {
            String string = packageDocArray[n].name();
            if (this.hasConstantField(packageDocArray[n]) && !this.hasPrintedPackage(string)) {
                this.li();
                if (string.length() == 0) {
                    this.printHyperLink("#" + this.UNNAMED_PACKAGE_ANCHOR, this.UNNAMED_PACKAGE_HEADING);
                } else {
                    string = this.parsePackageName(string);
                    this.printHyperLink("#" + string, string + ".*");
                    this.printedPackageHeaders.add(string);
                }
                this.print("\n");
            }
            ++n;
        }
        this.ulEnd();
        this.print("\n");
    }

    public static void generate(ConfigurationStandard configurationStandard) {
        String string = "constant-values.html";
        try {
            ConstantsSummaryWriter constantsSummaryWriter = new ConstantsSummaryWriter(configurationStandard, string);
            constantsSummaryWriter.generateConstantsFile(configurationStandard.root);
            constantsSummaryWriter.close();
        }
        catch (IOException iOException) {
            configurationStandard.standardmessage.error("doclet.exception_encountered", iOException.toString(), string);
            throw new DocletAbortException();
        }
    }

    protected void printClassName(String string) {
        this.table(0, 3, 0);
        this.trBgcolorStyle("#EEEEFF", "TableSubHeadingColor");
        this.tdColspan(3);
        this.bold(string);
        this.tdEnd();
        this.trEnd();
    }

    protected void printPackageName(String string) {
        if (string.length() == 0) {
            this.anchor(this.UNNAMED_PACKAGE_ANCHOR);
            string = this.UNNAMED_PACKAGE_HEADING;
        } else {
            if (this.hasPrintedPackage(string)) {
                return;
            }
            string = this.parsePackageName(string);
            this.anchor(string);
        }
        this.table(1, "100%", 3, 0);
        this.trBgcolorStyle("#CCCCFF", "TableHeadingColor");
        this.tdAlign("left");
        this.font("+2");
        this.printedPackageHeaders.add(string);
        this.bold(string + ".*");
        this.tableFooter();
    }

    protected boolean hasPrintedPackage(String string) {
        String[] stringArray = this.printedPackageHeaders.toArray(new String[0]);
        int n = 0;
        while (n < stringArray.length) {
            if (string.startsWith(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public ConstantsSummaryWriter(ConfigurationStandard configurationStandard, String string) throws IOException {
        super(configurationStandard, string);
        this.configuration = configurationStandard;
        this.classDocsWithConstFields = new HashSet();
    }

    private String parsePackageName(String string) {
        int n = -1;
        int n2 = 0;
        while (n2 < 2) {
            n = string.indexOf(".", n + 1);
            ++n2;
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        return string;
    }
}

