/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.jdi;

import com.sun.tools.jdi.ReferenceTypeImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

class SDE {
    private static final int INIT_SIZE_FILE = 3;
    private static final int INIT_SIZE_LINE = 100;
    private static final int INIT_SIZE_STRATUM = 3;
    static final String BASE_STRATUM_NAME = "Java";
    static final String NullString = null;
    private FileTableRecord[] fileTable = null;
    private LineTableRecord[] lineTable = null;
    private StratumTableRecord[] stratumTable = null;
    private int fileIndex = 0;
    private int lineIndex = 0;
    private int stratumIndex = 0;
    private int currentFileId = 0;
    private int defaultStratumIndex = -1;
    private int baseStratumIndex = -2;
    private int sdePos = 0;
    final String sourceDebugExtension;
    String jplsFilename = null;
    String defaultStratumId = null;
    boolean isValid = false;

    char sdePeek() {
        if (this.sdePos >= this.sourceDebugExtension.length()) {
            this.syntax();
        }
        return this.sourceDebugExtension.charAt(this.sdePos);
    }

    char sdeRead() {
        if (this.sdePos >= this.sourceDebugExtension.length()) {
            this.syntax();
        }
        return this.sourceDebugExtension.charAt(this.sdePos++);
    }

    private int defaultStratumTableIndex() {
        if (this.defaultStratumIndex == -1 && this.defaultStratumId != null) {
            this.defaultStratumIndex = this.stratumTableIndex(this.defaultStratumId);
        }
        return this.defaultStratumIndex;
    }

    int readNumber() {
        char c;
        int n = 0;
        this.ignoreWhite();
        while ((c = this.sdePeek()) >= '0' && c <= '9') {
            this.sdeAdvance();
            n = n * 10 + c - 48;
        }
        this.ignoreWhite();
        return n;
    }

    SDE() {
        this.sourceDebugExtension = null;
        this.createProxyForAbsentSDE();
    }

    void assureFileTableSize() {
        int n;
        int n2 = n = this.fileTable == null ? 0 : this.fileTable.length;
        if (this.fileIndex >= n) {
            int n3;
            int n4 = n == 0 ? 3 : n * 2;
            FileTableRecord[] fileTableRecordArray = new FileTableRecord[n4];
            for (n3 = 0; n3 < n; ++n3) {
                fileTableRecordArray[n3] = this.fileTable[n3];
            }
            while (n3 < n4) {
                fileTableRecordArray[n3] = new FileTableRecord();
                ++n3;
            }
            this.fileTable = fileTableRecordArray;
        }
    }

    void assureLineTableSize() {
        int n;
        int n2 = n = this.lineTable == null ? 0 : this.lineTable.length;
        if (this.lineIndex >= n) {
            int n3;
            int n4 = n == 0 ? 100 : n * 2;
            LineTableRecord[] lineTableRecordArray = new LineTableRecord[n4];
            for (n3 = 0; n3 < n; ++n3) {
                lineTableRecordArray[n3] = this.lineTable[n3];
            }
            while (n3 < n4) {
                lineTableRecordArray[n3] = new LineTableRecord();
                ++n3;
            }
            this.lineTable = lineTableRecordArray;
        }
    }

    void assureStratumTableSize() {
        int n;
        int n2 = n = this.stratumTable == null ? 0 : this.stratumTable.length;
        if (this.stratumIndex >= n) {
            int n3;
            int n4 = n == 0 ? 3 : n * 2;
            StratumTableRecord[] stratumTableRecordArray = new StratumTableRecord[n4];
            for (n3 = 0; n3 < n; ++n3) {
                stratumTableRecordArray[n3] = this.stratumTable[n3];
            }
            while (n3 < n4) {
                stratumTableRecordArray[n3] = new StratumTableRecord();
                ++n3;
            }
            this.stratumTable = stratumTableRecordArray;
        }
    }

    void createJavaStratum() {
        this.baseStratumIndex = this.stratumIndex;
        this.storeStratum(BASE_STRATUM_NAME);
        this.storeFile(1, this.jplsFilename, NullString);
        this.storeLine(1, 65536, 1, 1, 65536, 1);
        this.storeStratum("Aux");
    }

    void createProxyForAbsentSDE() {
        this.jplsFilename = null;
        this.defaultStratumId = BASE_STRATUM_NAME;
        this.defaultStratumIndex = this.stratumIndex;
        this.createJavaStratum();
        this.storeStratum("*terminator*");
    }

    void decode() {
        if (this.sourceDebugExtension.length() < 4 || this.sdeRead() != 'S' || this.sdeRead() != 'M' || this.sdeRead() != 'A' || this.sdeRead() != 'P') {
            return;
        }
        this.ignoreLine();
        this.jplsFilename = this.readLine();
        this.defaultStratumId = this.readLine();
        this.createJavaStratum();
        block6: while (true) {
            if (this.sdeRead() != '*') {
                this.syntax();
            }
            switch (this.sdeRead()) {
                case 'S': {
                    this.stratumSection();
                    continue block6;
                }
                case 'F': {
                    this.fileSection();
                    continue block6;
                }
                case 'L': {
                    this.lineSection();
                    continue block6;
                }
                case 'E': {
                    this.storeStratum("*terminator*");
                    this.isValid = true;
                    return;
                }
            }
            this.ignoreSection();
        }
    }

    void fileLine() {
        boolean bl = false;
        String string = null;
        if (this.sdePeek() == '+') {
            this.sdeAdvance();
            bl = true;
        }
        int n = this.readNumber();
        String string2 = this.readLine();
        if (bl) {
            string = this.readLine();
        }
        this.storeFile(n, string2, string);
    }

    void fileSection() {
        this.ignoreLine();
        while (this.sdePeek() != '*') {
            this.fileLine();
        }
    }

    void ignoreLine() {
        char c;
        while ((c = this.sdeRead()) != '\n' && c != '\r') {
        }
        if (c == '\r' && this.sdePeek() == '\n') {
            this.sdeAdvance();
        }
        this.ignoreWhite();
    }

    void ignoreSection() {
        this.ignoreLine();
        while (this.sdePeek() != '*') {
            this.ignoreLine();
        }
    }

    void ignoreWhite() {
        char c;
        while ((c = this.sdePeek()) == ' ' || c == '\t') {
            this.sdeAdvance();
        }
    }

    void lineLine() {
        int n = 1;
        int n2 = 1;
        int n3 = this.readNumber();
        if (this.sdePeek() == '#') {
            this.sdeAdvance();
            this.currentFileId = this.readNumber();
        }
        if (this.sdePeek() == ',') {
            this.sdeAdvance();
            n = this.readNumber();
        }
        if (this.sdeRead() != ':') {
            this.syntax();
        }
        int n4 = this.readNumber();
        if (this.sdePeek() == ',') {
            this.sdeAdvance();
            n2 = this.readNumber();
        }
        this.ignoreLine();
        this.storeLine(n4, n4 + n * n2 - 1, n2, n3, n3 + n - 1, this.currentFileId);
    }

    void lineSection() {
        this.ignoreLine();
        while (this.sdePeek() != '*') {
            this.lineLine();
        }
    }

    void sdeAdvance() {
        ++this.sdePos;
    }

    void stratumSection() {
        this.storeStratum(this.readLine());
    }

    void syntax() {
        throw new InternalError("bad SourceDebugExtension syntax - position " + this.sdePos);
    }

    boolean isValid() {
        return this.isValid;
    }

    private int fileTableIndex(int n, int n2) {
        int n3 = this.stratumTable[n].fileIndex;
        int n4 = this.stratumTable[n + 1].fileIndex;
        for (int i = n3; i < n4; ++i) {
            if (this.fileTable[i].fileId != n2) continue;
            return i;
        }
        return -1;
    }

    private int stiFileTableIndex(int n, int n2) {
        return this.fileTableIndex(n, this.lineTable[n2].fileId);
    }

    private int stiLineTableIndex(int n, int n2) {
        int n3 = this.stratumTable[n].lineIndex;
        int n4 = this.stratumTable[n + 1].lineIndex;
        for (int i = n3; i < n4; ++i) {
            if (n2 < this.lineTable[i].jplsStart || n2 > this.lineTable[i].jplsEnd) continue;
            return i;
        }
        return -1;
    }

    private int stiLineNumber(int n, int n2, int n3) {
        return this.lineTable[n2].njplsStart + (n3 - this.lineTable[n2].jplsStart) / this.lineTable[n2].jplsLineInc;
    }

    void storeLine(int n, int n2, int n3, int n4, int n5, int n6) {
        this.assureLineTableSize();
        this.lineTable[this.lineIndex].jplsStart = n;
        this.lineTable[this.lineIndex].jplsEnd = n2;
        this.lineTable[this.lineIndex].jplsLineInc = n3;
        this.lineTable[this.lineIndex].njplsStart = n4;
        this.lineTable[this.lineIndex].njplsEnd = n5;
        this.lineTable[this.lineIndex].fileId = n6;
        ++this.lineIndex;
    }

    String readLine() {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        this.ignoreWhite();
        while ((c = this.sdeRead()) != '\n' && c != '\r') {
            stringBuffer.append(c);
        }
        if (c == '\r' && this.sdePeek() == '\n') {
            this.sdeRead();
        }
        this.ignoreWhite();
        return stringBuffer.toString();
    }

    int stratumTableIndex(String string) {
        if (string == null) {
            return this.defaultStratumTableIndex();
        }
        for (int i = 0; i < this.stratumIndex - 1; ++i) {
            if (!this.stratumTable[i].id.equals(string)) continue;
            return i;
        }
        return this.defaultStratumTableIndex();
    }

    SDE(String string) {
        this.sourceDebugExtension = string;
        this.decode();
    }

    void storeStratum(String string) {
        if (this.stratumIndex > 0 && this.stratumTable[this.stratumIndex - 1].fileIndex == this.fileIndex && this.stratumTable[this.stratumIndex - 1].lineIndex == this.lineIndex) {
            --this.stratumIndex;
        }
        this.assureStratumTableSize();
        this.stratumTable[this.stratumIndex].id = string;
        this.stratumTable[this.stratumIndex].fileIndex = this.fileIndex;
        this.stratumTable[this.stratumIndex].lineIndex = this.lineIndex;
        ++this.stratumIndex;
        this.currentFileId = 0;
    }

    void syntax(String string) {
        throw new InternalError("bad SourceDebugExtension syntax: " + string);
    }

    List availableStrata() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.stratumIndex - 1; ++i) {
            StratumTableRecord stratumTableRecord = this.stratumTable[i];
            arrayList.add(stratumTableRecord.id);
        }
        return arrayList;
    }

    Stratum stratum(String string) {
        int n = this.stratumTableIndex(string);
        return new Stratum(n);
    }

    void storeFile(int n, String string, String string2) {
        this.assureFileTableSize();
        this.fileTable[this.fileIndex].fileId = n;
        this.fileTable[this.fileIndex].sourceName = string;
        this.fileTable[this.fileIndex].sourcePath = string2;
        ++this.fileIndex;
    }

    private class FileTableRecord {
        int fileId;
        String sourceName;
        String sourcePath;
        boolean isConverted = false;

        private FileTableRecord() {
        }

        String getSourcePath(ReferenceTypeImpl referenceTypeImpl) {
            if (!this.isConverted) {
                if (this.sourcePath == null) {
                    this.sourcePath = referenceTypeImpl.baseSourceDir() + this.sourceName;
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    for (int i = 0; i < this.sourcePath.length(); ++i) {
                        char c = this.sourcePath.charAt(i);
                        if (c == '/') {
                            stringBuffer.append(File.separatorChar);
                            continue;
                        }
                        stringBuffer.append(c);
                    }
                    this.sourcePath = stringBuffer.toString();
                }
                this.isConverted = true;
            }
            return this.sourcePath;
        }
    }

    class LineStratum {
        private final int sti;
        private final int lti;
        private final ReferenceTypeImpl refType;
        private final int jplsLine;
        private String sourceName = null;
        private String sourcePath = null;

        int lineNumber() {
            return SDE.this.stiLineNumber(this.sti, this.lti, this.jplsLine);
        }

        void getSourceInfo() {
            if (this.sourceName != null) {
                return;
            }
            int n = SDE.this.stiFileTableIndex(this.sti, this.lti);
            if (n == -1) {
                throw new InternalError("Bad SourceDebugExtension, no matching source id " + ((SDE)SDE.this).lineTable[this.lti].fileId + " jplsLine: " + this.jplsLine);
            }
            FileTableRecord fileTableRecord = SDE.this.fileTable[n];
            this.sourceName = fileTableRecord.sourceName;
            this.sourcePath = fileTableRecord.getSourcePath(this.refType);
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof LineStratum) {
                LineStratum lineStratum = (LineStratum)object;
                return this.lti == lineStratum.lti && this.sti == lineStratum.sti && this.lineNumber() == lineStratum.lineNumber() && this.refType.equals(lineStratum.refType);
            }
            return false;
        }

        String sourceName() {
            this.getSourceInfo();
            return this.sourceName;
        }

        String sourcePath() {
            this.getSourceInfo();
            return this.sourcePath;
        }

        private LineStratum(int n, int n2, ReferenceTypeImpl referenceTypeImpl, int n3) {
            this.sti = n;
            this.lti = n2;
            this.refType = referenceTypeImpl;
            this.jplsLine = n3;
        }
    }

    private class LineTableRecord {
        int jplsStart;
        int jplsEnd;
        int jplsLineInc;
        int njplsStart;
        int njplsEnd;
        int fileId;

        private LineTableRecord() {
        }
    }

    class Stratum {
        private final int sti;

        boolean isJava() {
            return this.sti == SDE.this.baseStratumIndex;
        }

        private Stratum(int n) {
            this.sti = n;
        }

        String id() {
            return ((SDE)SDE.this).stratumTable[this.sti].id;
        }

        LineStratum lineStratum(ReferenceTypeImpl referenceTypeImpl, int n) {
            int n2 = SDE.this.stiLineTableIndex(this.sti, n);
            if (n2 < 0) {
                return null;
            }
            return new LineStratum(this.sti, n2, referenceTypeImpl, n);
        }

        List sourceNames(ReferenceTypeImpl referenceTypeImpl) {
            int n = ((SDE)SDE.this).stratumTable[this.sti].fileIndex;
            int n2 = ((SDE)SDE.this).stratumTable[this.sti + 1].fileIndex;
            ArrayList<String> arrayList = new ArrayList<String>(n2 - n);
            for (int i = n; i < n2; ++i) {
                arrayList.add(((SDE)SDE.this).fileTable[i].sourceName);
            }
            return arrayList;
        }

        List sourcePaths(ReferenceTypeImpl referenceTypeImpl) {
            int n = ((SDE)SDE.this).stratumTable[this.sti].fileIndex;
            int n2 = ((SDE)SDE.this).stratumTable[this.sti + 1].fileIndex;
            ArrayList<String> arrayList = new ArrayList<String>(n2 - n);
            for (int i = n; i < n2; ++i) {
                arrayList.add(SDE.this.fileTable[i].getSourcePath(referenceTypeImpl));
            }
            return arrayList;
        }
    }

    private class StratumTableRecord {
        String id;
        int fileIndex;
        int lineIndex;

        private StratumTableRecord() {
        }
    }
}

