/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.IDLNames;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.Type;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Identifier;

public class SpecialInterfaceType
extends InterfaceType {
    public String getTypeDescription() {
        return "Special interface";
    }

    private boolean initialize(sun.tools.java.Type type, ContextStack contextStack) {
        boolean bl;
        int n = 0;
        Identifier identifier = null;
        String string = null;
        String[] stringArray = null;
        boolean bl2 = bl = contextStack.size() > 0 && contextStack.getContext().isConstant();
        if (type.isType(10)) {
            identifier = type.getClassName();
            if (identifier.equals(idRemote)) {
                n = 524288;
                string = "Remote";
                stringArray = IDL_JAVA_RMI_MODULE;
            } else if (identifier == idJavaIoSerializable) {
                n = 1024;
                string = "Serializable";
                stringArray = IDL_JAVA_IO_MODULE;
            } else if (identifier == idJavaIoExternalizable) {
                n = 1024;
                string = "Externalizable";
                stringArray = IDL_JAVA_IO_MODULE;
            } else if (identifier == idIDLEntity) {
                n = 1024;
                string = "IDLEntity";
                stringArray = IDL_ORG_OMG_CORBA_PORTABLE_MODULE;
            } else {
                n = 2048;
                if (identifier == idCorbaObject) {
                    string = IDLNames.getTypeName(n, bl);
                    stringArray = null;
                } else {
                    try {
                        string = IDLNames.getClassOrInterfaceName(identifier, this.env);
                        stringArray = IDLNames.getModuleNames(identifier, this.isBoxed(), this.env);
                    }
                    catch (Exception exception) {
                        SpecialInterfaceType.failedConstraint(7, false, contextStack, identifier.toString(), exception.getMessage());
                        throw new CompilerError("");
                    }
                }
            }
        }
        if (n == 0) {
            return false;
        }
        this.setTypeCode(n | 0x20000000 | 0x8000000 | 0x2000000);
        if (string == null) {
            throw new CompilerError("Not a special type");
        }
        this.setNames(identifier, stringArray, string);
        return this.initialize(null, null, null, contextStack, false);
    }

    private SpecialInterfaceType(ContextStack contextStack, int n, ClassDefinition classDefinition) {
        super(contextStack, n | 0x20000000 | 0x8000000 | 0x2000000, classDefinition);
        this.setNames(classDefinition.getName(), null, null);
    }

    private static boolean isSpecial(sun.tools.java.Type type, ClassDefinition classDefinition, ContextStack contextStack) {
        if (type.isType(10)) {
            Identifier identifier = type.getClassName();
            if (identifier.equals(idRemote)) {
                return true;
            }
            if (identifier == idJavaIoSerializable) {
                return true;
            }
            if (identifier == idJavaIoExternalizable) {
                return true;
            }
            if (identifier == idCorbaObject) {
                return true;
            }
            if (identifier == idIDLEntity) {
                return true;
            }
            BatchEnvironment batchEnvironment = contextStack.getEnv();
            try {
                if (batchEnvironment.defCorbaObject.implementedBy(batchEnvironment, classDefinition.getClassDeclaration())) {
                    return true;
                }
            }
            catch (ClassNotFound classNotFound) {
                SpecialInterfaceType.classNotFound(contextStack, classNotFound);
            }
        }
        return false;
    }

    public static SpecialInterfaceType forSpecial(ClassDefinition classDefinition, ContextStack contextStack) {
        if (contextStack.anyErrors()) {
            return null;
        }
        sun.tools.java.Type type = classDefinition.getType();
        Type type2 = SpecialInterfaceType.getType(type, contextStack);
        if (type2 != null) {
            if (!(type2 instanceof SpecialInterfaceType)) {
                return null;
            }
            return (SpecialInterfaceType)type2;
        }
        if (SpecialInterfaceType.isSpecial(type, classDefinition, contextStack)) {
            SpecialInterfaceType specialInterfaceType = new SpecialInterfaceType(contextStack, 0, classDefinition);
            SpecialInterfaceType.putType(type, (Type)specialInterfaceType, contextStack);
            contextStack.push(specialInterfaceType);
            if (specialInterfaceType.initialize(type, contextStack)) {
                contextStack.pop(true);
                return specialInterfaceType;
            }
            SpecialInterfaceType.removeType(type, contextStack);
            contextStack.pop(false);
            return null;
        }
        return null;
    }
}

