/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.handlers;

import java.lang.reflect.Array;
import java.util.StringTokenizer;
import org.exolab.castor.mapping.FieldHandler;
import org.exolab.castor.mapping.ValidityException;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLFieldHandler;

public class CollectionFieldHandler
extends XMLFieldHandler {
    private FieldHandler _handler = null;
    private TypeValidator _validator = null;

    public CollectionFieldHandler(FieldHandler fieldHandler) {
        if (fieldHandler == null) {
            String err = "The FieldHandler argument passed to the constructor of CollectionFieldHandler must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._handler = fieldHandler;
    }

    public CollectionFieldHandler(FieldHandler fieldHandler, TypeValidator validator) {
        if (fieldHandler == null) {
            String err = "The FieldHandler argument passed to the constructor of CollectionFieldHandler must not be null.";
            throw new IllegalArgumentException(err);
        }
        this._handler = fieldHandler;
        this._validator = validator;
    }

    public void setValue(Object target, Object value) throws IllegalStateException {
        if (value == null) {
            return;
        }
        if (value instanceof String) {
            StringTokenizer temp = new StringTokenizer((String)value, " ");
            int size = temp.countTokens();
            int i = 0;
            while (i < size) {
                String tempValue = temp.nextToken();
                try {
                    if (this._validator != null) {
                        this._validator.validate(tempValue, null);
                    }
                }
                catch (ValidationException e) {
                    throw new IllegalStateException(e.getMessage());
                }
                this._handler.setValue(target, tempValue);
                ++i;
            }
        } else {
            this._handler.setValue(target, value);
        }
    }

    public Object getValue(Object target) throws IllegalStateException {
        Object temp = this._handler.getValue(target);
        if (temp == null) {
            return temp;
        }
        String result = null;
        if (temp.getClass().isArray()) {
            int size = Array.getLength(temp);
            if (size != 0) {
                result = "";
                int i = 0;
                while (i < size) {
                    if (i > 0) {
                        result = result + ' ';
                    }
                    Object obj = Array.get(temp, i++);
                    result = result + obj.toString();
                }
            }
        } else {
            result = temp.toString();
        }
        return result;
    }

    public void resetValue(Object target) throws IllegalStateException {
        this._handler.resetValue(target);
    }

    public void checkValidity(Object object) throws ValidityException, IllegalStateException {
    }

    public Object newInstance(Object parent) throws IllegalStateException {
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof XMLFieldHandler)) {
            return false;
        }
        return this._handler.getClass().isInstance(obj);
    }
}

