/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net.junit;

import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionListener;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.SocketConnector;
import com.echomine.net.SocketHandler;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import junit.framework.TestCase;

public class SocketConnectorTest
extends TestCase {
    ConnectionModel model;
    SocketConnector connector;
    SocketHandler handler;
    MyAcceptorThread thr = new MyAcceptorThread(this);

    public SocketConnectorTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.model = new ConnectionModel("127.0.0.1", 7000);
        this.handler = new _1(this);
        this.connector = new SocketConnector(this.handler);
        this.thr.open();
    }

    protected void tearDown() throws Exception {
        this.thr.close();
    }

    public void testSocketConnectorNormalAsync() throws Exception {
        this.thr.start();
        this.connector.aconnect(this.model);
        Thread.currentThread();
        Thread.sleep(500L);
        SocketConnectorTest.assertEquals((Object)"Success", (Object)this.thr.str);
    }

    public void testSocketAcceptorNormalSync() throws Exception {
        this.thr.start();
        Thread.currentThread();
        Thread.sleep(500L);
        this.connector.connect(this.model);
        SocketConnectorTest.assertEquals((Object)"Success", (Object)this.thr.str);
    }

    public void testConnectorConnectionListener() throws Exception {
        ConnectorConnectionListener l = new ConnectorConnectionListener(this);
        this.thr.start();
        Thread.currentThread();
        Thread.sleep(500L);
        this.connector.addConnectionListener(l);
        this.connector.connect(this.model);
        SocketConnectorTest.assertTrue((l.starting ? 1 : 0) != 0);
        SocketConnectorTest.assertTrue((l.established ? 1 : 0) != 0);
        SocketConnectorTest.assertTrue((l.closed ? 1 : 0) != 0);
    }

    public void testConnectorVetoedConnectionListener() throws Exception {
        VetoedConnectionListener l = new VetoedConnectionListener(this);
        this.thr.start();
        Thread.currentThread();
        Thread.sleep(500L);
        this.connector.addConnectionListener(l);
        this.connector.connect(this.model);
        SocketConnectorTest.assertTrue((l.starting ? 1 : 0) != 0);
        SocketConnectorTest.assertTrue((!l.established ? 1 : 0) != 0);
        SocketConnectorTest.assertTrue((l.closed ? 1 : 0) != 0);
    }

    class MyAcceptorThread
    extends Thread {
        private final SocketConnectorTest this$SocketConnectorTest;
        String str;
        ServerSocket ssocket;

        public MyAcceptorThread(SocketConnectorTest enclosing$instance) {
            this.this$SocketConnectorTest = enclosing$instance;
            this.str = "";
        }

        public void open() throws IOException {
            this.ssocket = new ServerSocket(7000);
        }

        public void run() {
            Socket socket = null;
            try {
                try {
                    socket = this.ssocket.accept();
                    byte[] data = new byte[10];
                    int bread = socket.getInputStream().read(data);
                    this.str = new String(data, 0, bread);
                }
                catch (Exception ex) {
                }
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                IOUtil.closeSocket(socket);
                throw throwable;
            }
            IOUtil.closeSocket(socket);
        }

        public void close() {
            IOUtil.closeSocket(this.ssocket);
        }
    }

    class _1
    implements SocketHandler {
        private final SocketConnectorTest this$SocketConnectorTest;

        public void handle(Socket socket) throws IOException {
            socket.getOutputStream().write("Success".getBytes());
            socket.getOutputStream().flush();
        }

        public void shutdown() {
        }

        public void start() {
        }

        _1(SocketConnectorTest enclosing$instance) {
            this.this$SocketConnectorTest = enclosing$instance;
        }
    }

    class ConnectorConnectionListener
    implements ConnectionListener {
        private final SocketConnectorTest this$SocketConnectorTest;
        boolean starting;
        boolean established;
        boolean closed;

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            this.starting = true;
        }

        public void connectionEstablished(ConnectionEvent e) {
            this.established = true;
        }

        public void connectionClosed(ConnectionEvent e) {
            this.closed = true;
        }

        ConnectorConnectionListener(SocketConnectorTest enclosing$instance) {
            this.this$SocketConnectorTest = enclosing$instance;
            this.starting = false;
            this.established = false;
            this.closed = false;
        }
    }

    class VetoedConnectionListener
    extends ConnectorConnectionListener {
        private final SocketConnectorTest this$SocketConnectorTest;

        public void connectionStarting(ConnectionEvent e) throws ConnectionVetoException {
            super.connectionStarting(e);
            throw new ConnectionVetoException("Vetoed");
        }

        VetoedConnectionListener(SocketConnectorTest enclosing$instance) {
            super(enclosing$instance);
            this.this$SocketConnectorTest = enclosing$instance;
        }
    }
}

