/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import java.util.Vector;
import tcl.lang.AssocData;
import tcl.lang.Command;
import tcl.lang.IdleHandler;
import tcl.lang.Interp;
import tcl.lang.Notifier;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclIndex;
import tcl.lang.TclInteger;
import tcl.lang.TclList;
import tcl.lang.TclNumArgsException;
import tcl.lang.TclObject;
import tcl.lang.TclString;
import tcl.lang.TimerHandler;
import tcl.lang.Util;

class AfterCmd
implements Command {
    AfterAssocData assocData = null;
    private static final String[] validOpts = new String[]{"cancel", "idle", "info"};
    static final int OPT_CANCEL = 0;
    static final int OPT_IDLE = 1;
    static final int OPT_INFO = 2;

    AfterCmd() {
    }

    public void cmdProc(Interp interp, TclObject[] tclObjectArray) throws TclException {
        int n;
        Object object;
        Notifier notifier = interp.getNotifier();
        if (this.assocData == null) {
            this.assocData = (AfterAssocData)interp.getAssocData("tclAfter");
            if (this.assocData == null) {
                this.assocData = new AfterAssocData();
                interp.setAssocData("tclAfter", this.assocData);
            }
        }
        if (tclObjectArray.length < 2) {
            throw new TclNumArgsException(interp, 1, tclObjectArray, "option ?arg arg ...?");
        }
        boolean bl = false;
        int n2 = 0;
        if (tclObjectArray[1].getInternalRep() instanceof TclInteger) {
            n2 = TclInteger.get(interp, tclObjectArray[1]);
            bl = true;
        } else {
            object = tclObjectArray[1].toString();
            if (((String)object).length() > 0 && Character.isDigit(((String)object).charAt(0))) {
                n2 = TclInteger.get(interp, tclObjectArray[1]);
                bl = true;
            }
        }
        if (bl) {
            if (n2 < 0) {
                n2 = 0;
            }
            if (tclObjectArray.length == 2) {
                long l = System.currentTimeMillis() + (long)n2;
                while (true) {
                    try {
                        Thread.sleep(n2);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        long l2 = System.currentTimeMillis();
                        if (l2 >= l) {
                            return;
                        }
                        n2 = (int)(l - l2);
                        continue;
                    }
                    break;
                }
            }
            object = this.getCmdObject(tclObjectArray);
            ((TclObject)object).preserve();
            ++this.assocData.lastAfterId;
            TimerInfo timerInfo = new TimerInfo(notifier, n2);
            timerInfo.interp = interp;
            timerInfo.command = object;
            timerInfo.id = this.assocData.lastAfterId;
            this.assocData.handlers.addElement(timerInfo);
            interp.setResult("after#" + timerInfo.id);
            return;
        }
        try {
            n = TclIndex.get(interp, tclObjectArray[1], validOpts, "option", 0);
        }
        catch (TclException tclException) {
            throw new TclException(interp, "bad argument \"" + tclObjectArray[1] + "\": must be cancel, idle, info, or a number");
        }
        switch (n) {
            case 0: {
                if (tclObjectArray.length < 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "id|command");
                }
                TclObject tclObject = this.getCmdObject(tclObjectArray);
                tclObject.preserve();
                Object object2 = null;
                int n3 = 0;
                while (n3 < this.assocData.handlers.size()) {
                    TclObject tclObject2;
                    Object e = this.assocData.handlers.elementAt(n3);
                    if (e instanceof TimerInfo) {
                        tclObject2 = ((TimerInfo)e).command;
                        if (tclObject2 == tclObject || tclObject2.toString().equals(tclObject.toString())) {
                            object2 = e;
                            break;
                        }
                    } else {
                        tclObject2 = ((IdleInfo)e).command;
                        if (tclObject2 == tclObject || tclObject2.toString().equals(tclObject.toString())) {
                            object2 = e;
                            break;
                        }
                    }
                    ++n3;
                }
                if (object2 == null) {
                    object2 = this.getAfterEvent(tclObject.toString());
                }
                tclObject.release();
                if (object2 == null) break;
                if (object2 instanceof TimerInfo) {
                    ((TimerInfo)object2).cancel();
                    ((TimerInfo)object2).command.release();
                } else {
                    ((IdleInfo)object2).cancel();
                    ((IdleInfo)object2).command.release();
                }
                this.assocData.handlers.removeElement(object2);
                break;
            }
            case 1: {
                if (tclObjectArray.length < 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "script script ...");
                }
                TclObject tclObject = this.getCmdObject(tclObjectArray);
                tclObject.preserve();
                ++this.assocData.lastAfterId;
                IdleInfo idleInfo = new IdleInfo(notifier);
                idleInfo.interp = interp;
                idleInfo.command = tclObject;
                idleInfo.id = this.assocData.lastAfterId;
                this.assocData.handlers.addElement(idleInfo);
                interp.setResult("after#" + idleInfo.id);
                break;
            }
            case 2: {
                if (tclObjectArray.length == 2) {
                    TclObject tclObject = TclList.newInstance();
                    int n4 = 0;
                    while (n4 < this.assocData.handlers.size()) {
                        Object e = this.assocData.handlers.elementAt(n4);
                        int n5 = e instanceof TimerInfo ? ((TimerInfo)e).id : ((IdleInfo)e).id;
                        TclList.append(interp, tclObject, TclString.newInstance("after#" + n5));
                        ++n4;
                    }
                    interp.setResult(tclObject);
                    return;
                }
                if (tclObjectArray.length != 3) {
                    throw new TclNumArgsException(interp, 2, tclObjectArray, "?id?");
                }
                Object object3 = this.getAfterEvent(tclObjectArray[2].toString());
                if (object3 == null) {
                    throw new TclException(interp, "event \"" + tclObjectArray[2] + "\" doesn't exist");
                }
                TclObject tclObject = TclList.newInstance();
                TclList.append(interp, tclObject, object3 instanceof TimerInfo ? ((TimerInfo)object3).command : ((IdleInfo)object3).command);
                TclList.append(interp, tclObject, TclString.newInstance(object3 instanceof TimerInfo ? "timer" : "idle"));
                interp.setResult(tclObject);
            }
        }
    }

    private TclObject getCmdObject(TclObject[] tclObjectArray) {
        if (tclObjectArray.length == 3) {
            return tclObjectArray[2];
        }
        TclObject tclObject = TclString.newInstance(Util.concat(2, tclObjectArray.length - 1, tclObjectArray));
        return tclObject;
    }

    private Object getAfterEvent(String string) {
        if (!string.startsWith("after#")) {
            return null;
        }
        StrtoulResult strtoulResult = Util.strtoul(string, 6, 10);
        if (strtoulResult.errno != 0) {
            return null;
        }
        int n = 0;
        while (n < this.assocData.handlers.size()) {
            Object e = this.assocData.handlers.elementAt(n);
            if (e instanceof TimerInfo ? (long)((TimerInfo)e).id == strtoulResult.value : (long)((IdleInfo)e).id == strtoulResult.value) {
                return e;
            }
            ++n;
        }
        return null;
    }

    class IdleInfo
    extends IdleHandler {
        Interp interp;
        TclObject command;
        int id;

        IdleInfo(Notifier notifier) {
            super(notifier);
        }

        public void processIdleEvent() {
            try {
                try {
                    AfterCmd.this.assocData.handlers.removeElement(this);
                    this.interp.eval(this.command, 1);
                }
                catch (TclException tclException) {
                    this.interp.addErrorInfo("\n    (\"after\" script)");
                    this.interp.backgroundError();
                    Object var3_2 = null;
                    this.command.release();
                    this.command = null;
                }
                Object var3_1 = null;
                this.command.release();
                this.command = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.command.release();
                this.command = null;
                throw throwable;
            }
        }
    }

    class TimerInfo
    extends TimerHandler {
        Interp interp;
        TclObject command;
        int id;

        TimerInfo(Notifier notifier, int n) {
            super(notifier, n);
        }

        public void processTimerEvent() {
            try {
                try {
                    AfterCmd.this.assocData.handlers.removeElement(this);
                    this.interp.eval(this.command, 1);
                }
                catch (TclException tclException) {
                    this.interp.addErrorInfo("\n    (\"after\" script)");
                    this.interp.backgroundError();
                    Object var3_2 = null;
                    this.command.release();
                    this.command = null;
                }
                Object var3_1 = null;
                this.command.release();
                this.command = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.command.release();
                this.command = null;
                throw throwable;
            }
        }
    }

    class AfterAssocData
    implements AssocData {
        Vector handlers = new Vector();
        int lastAfterId = 0;

        AfterAssocData() {
        }

        public void disposeAssocData(Interp interp) {
            int n = AfterCmd.this.assocData.handlers.size() - 1;
            while (n >= 0) {
                Object e = AfterCmd.this.assocData.handlers.elementAt(n);
                AfterCmd.this.assocData.handlers.removeElementAt(n);
                if (e instanceof TimerInfo) {
                    ((TimerInfo)e).cancel();
                    ((TimerInfo)e).command.release();
                } else {
                    ((IdleInfo)e).cancel();
                    ((IdleInfo)e).command.release();
                }
                --n;
            }
            AfterCmd.this.assocData = null;
        }
    }
}

