/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder;

import org.exolab.castor.builder.CollectionInfo;
import org.exolab.castor.builder.CollectionInfoJ2;
import org.exolab.castor.builder.CollectionInfoODMG30;
import org.exolab.castor.builder.FieldInfo;
import org.exolab.castor.builder.IdentityInfo;
import org.exolab.castor.builder.types.XSType;

public class FieldInfoFactory {
    private static final String VECTOR = "vector";
    private static final String ARRAY_LIST = "arraylist";
    private static final String ODMG = "odmg";
    private String _default;

    public FieldInfoFactory() {
        this(VECTOR);
    }

    public FieldInfoFactory(String collectionName) {
        if (!(collectionName.equals(VECTOR) || collectionName.equals(ARRAY_LIST) || collectionName.equals(ODMG))) {
            throw new IllegalArgumentException(collectionName + " is currently not a supported Java collection.");
        }
        this._default = collectionName;
    }

    public IdentityInfo createIdentity(String name) {
        return new IdentityInfo(name);
    }

    public CollectionInfo createCollection(XSType contentType, String name, String elementName) {
        return this.createCollection(contentType, name, elementName, this._default);
    }

    public CollectionInfo createCollection(XSType contentType, String name, String elementName, String collectionName) {
        String temp = collectionName;
        if (temp == null || temp.length() > 0) {
            temp = this._default;
        }
        if (temp.equals(VECTOR)) {
            return new CollectionInfo(contentType, name, elementName);
        }
        if (temp.equals(ARRAY_LIST)) {
            return new CollectionInfoJ2(contentType, name, elementName);
        }
        if (temp.equals(ODMG)) {
            return new CollectionInfoODMG30(contentType, name, elementName);
        }
        return null;
    }

    public FieldInfo createFieldInfo(XSType type, String name) {
        return new FieldInfo(type, name);
    }
}

