/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.exolab.castor.jdo.ClassNotPersistenceCapableException;
import org.exolab.castor.jdo.Database;
import org.exolab.castor.jdo.DatabaseNotFoundException;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.OQLQuery;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.ObjectNotPersistentException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.Query;
import org.exolab.castor.jdo.QueryException;
import org.exolab.castor.jdo.TransactionAbortedException;
import org.exolab.castor.jdo.TransactionNotInProgressException;
import org.exolab.castor.jdo.engine.DatabaseRegistry;
import org.exolab.castor.jdo.engine.OQLQueryImpl;
import org.exolab.castor.jdo.engine.TransactionContextImpl;
import org.exolab.castor.jdo.engine.TxDatabaseMap;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.PersistenceInfo;
import org.exolab.castor.persist.PersistenceInfoGroup;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.Complex;
import org.exolab.castor.persist.spi.InstanceFactory;
import org.exolab.castor.persist.spi.LogInterceptor;
import org.exolab.castor.util.Messages;

public class DatabaseImpl
implements Database,
Synchronization {
    protected PersistenceInfoGroup _scope;
    protected TransactionContext _ctx;
    private int _lockTimeout;
    private LogInterceptor _logInterceptor;
    private CallbackInterceptor _callback;
    private InstanceFactory _instanceFactory;
    private String _dbName;
    private Transaction _transaction;
    private boolean _autoStore;
    private ClassLoader _classLoader;
    private TxDatabaseMap _txMap;

    public DatabaseImpl(String dbName, int lockTimeout, LogInterceptor logInterceptor, CallbackInterceptor callback, InstanceFactory instanceFactory, Transaction transaction, ClassLoader classLoader, boolean autoStore) throws DatabaseNotFoundException {
        this._autoStore = autoStore;
        DatabaseRegistry dbs = DatabaseRegistry.getDatabaseRegistry(dbName);
        if (dbs == null) {
            throw new DatabaseNotFoundException(Messages.format("jdo.dbNoMapping", dbName));
        }
        LockEngine[] pe = new LockEngine[]{DatabaseRegistry.getLockEngine(dbs)};
        this._scope = new PersistenceInfoGroup(pe);
        this._logInterceptor = logInterceptor;
        this._callback = callback;
        this._instanceFactory = instanceFactory;
        this._dbName = dbName;
        this._lockTimeout = lockTimeout;
        this._transaction = transaction;
        if (this._transaction != null) {
            this._ctx = new TransactionContextImpl((Database)this, true);
            this._ctx.setLockTimeout(this._lockTimeout);
            this._ctx.setAutoStore(this._autoStore);
            this._ctx.setCallback(this._callback);
            this._ctx.setInstanceFactory(this._instanceFactory);
        }
        this._classLoader = classLoader;
    }

    LockEngine getLockEngine() {
        return this._scope.getLockEngine();
    }

    public PersistenceInfoGroup getScope() {
        return this._scope;
    }

    public void setAutoStore(boolean autoStore) {
        this._autoStore = autoStore;
    }

    public boolean isAutoStore() {
        if (this._ctx != null) {
            return this._ctx.isAutoStore();
        }
        return this._autoStore;
    }

    public ClassLoader getClassLoader() {
        return this._classLoader;
    }

    public String getDatabaseName() {
        return this._dbName;
    }

    public synchronized void close() throws PersistenceException {
        try {
            if (this._transaction == null) {
                if (this._ctx != null && this._ctx.isOpen()) {
                    try {
                        this._ctx.rollback();
                    }
                    catch (Exception except) {
                        // empty catch block
                    }
                    try {
                        this._ctx.close();
                    }
                    catch (Exception except) {
                        // empty catch block
                    }
                    throw new PersistenceException(Messages.message("jdo.dbClosedTxRolledback"));
                }
            } else if (this._ctx != null && this._ctx.isOpen()) {
                try {
                    this._ctx.close();
                }
                catch (Exception e) {
                    throw new PersistenceException(e.getMessage());
                }
            }
            Object var3_4 = null;
            this._scope = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this._scope = null;
            throw throwable;
        }
    }

    public boolean isClosed() {
        return this._scope == null;
    }

    public Object load(Class type, Object identity, Object object) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(type);
        if (info == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", type.getName()));
        }
        return tx.load(info.engine, info.molder, identity, object, null);
    }

    public Object load(Class type, Complex identity) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(type, (Object)identity, null);
    }

    public Object load(Class type, Object identity) throws ObjectNotFoundException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        return this.load(type, identity, null);
    }

    public Object load(Class type, Complex identity, short accessMode) throws TransactionNotInProgressException, ObjectNotFoundException, LockNotGrantedException, PersistenceException {
        return this.load(type, (Object)identity, accessMode);
    }

    public Object load(Class type, Object identity, short accessMode) throws ObjectNotFoundException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        AccessMode mode;
        switch (accessMode) {
            case 0: {
                mode = AccessMode.ReadOnly;
                break;
            }
            case 1: {
                mode = AccessMode.Shared;
                break;
            }
            case 2: {
                mode = AccessMode.Exclusive;
                break;
            }
            case 3: {
                mode = AccessMode.DbLocked;
                break;
            }
            default: {
                throw new IllegalArgumentException("Value for 'accessMode' is invalid");
            }
        }
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(type);
        if (info == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", type.getName()));
        }
        return tx.load(info.engine, info.molder, identity, null, mode);
    }

    public void create(Object object) throws ClassNotPersistenceCapableException, DuplicateIdentityException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        if (info == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", object.getClass().getName()));
        }
        tx.create(info.engine, info.molder, object, null);
    }

    public void update(Object object) throws ClassNotPersistenceCapableException, ObjectModifiedException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        if (info == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", object.getClass().getName()));
        }
        tx.update(info.engine, info.molder, object, null);
    }

    public synchronized void makePersistent(Object object) throws ClassNotPersistenceCapableException, DuplicateIdentityException, TransactionNotInProgressException, PersistenceException {
        this.create(object);
    }

    public void remove(Object object) throws ObjectNotPersistentException, LockNotGrantedException, TransactionNotInProgressException, PersistenceException {
        TransactionContext tx = this.getTransaction();
        PersistenceInfo info = this._scope.getPersistenceInfo(object.getClass());
        if (info == null) {
            throw new ClassNotPersistenceCapableException(Messages.format("persist.classNotPersistenceCapable", object.getClass().getName()));
        }
        tx.delete(object);
    }

    public synchronized void deletePersistent(Object object) throws ObjectNotPersistentException, LockNotGrantedException, PersistenceException {
        this.remove(object);
    }

    public boolean isPersistent(Object object) {
        if (this._scope == null) {
            throw new IllegalStateException(Messages.message("jdo.dbClosed"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            return this._ctx.isPersistent(object);
        }
        return false;
    }

    public Object getIdentity(Object object) {
        if (this._scope == null) {
            throw new IllegalStateException(Messages.message("jdo.dbClosed"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            return this._ctx.getIdentity(object);
        }
        return null;
    }

    public void lock(Object object) throws LockNotGrantedException, ObjectNotPersistentException, TransactionNotInProgressException, PersistenceException {
        if (this._ctx == null || !this._ctx.isOpen()) {
            throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
        }
        this._ctx.writeLock(object, this._lockTimeout);
    }

    public OQLQuery getOQLQuery() {
        return new OQLQueryImpl(this);
    }

    public OQLQuery getOQLQuery(String oql) throws QueryException {
        OQLQueryImpl oqlImpl = new OQLQueryImpl(this);
        oqlImpl.create(oql);
        return oqlImpl;
    }

    public Query getQuery() {
        return new OQLQueryImpl(this);
    }

    protected void finalize() throws Throwable {
        if (this._scope != null) {
            this.close();
        }
    }

    protected TransactionContext getTransaction() throws TransactionNotInProgressException {
        if (this._scope == null) {
            throw new TransactionNotInProgressException(Messages.message("jdo.dbClosed"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            return this._ctx;
        }
        throw new TransactionNotInProgressException(Messages.message("jdo.dbTxNotInProgress"));
    }

    public void begin() throws PersistenceException {
        if (this._transaction != null) {
            throw new IllegalStateException(Messages.message("jdo.txInJ2EE"));
        }
        if (this._ctx != null && this._ctx.isOpen()) {
            throw new PersistenceException(Messages.message("jdo.txInProgress"));
        }
        this._ctx = new TransactionContextImpl((Database)this, false);
        this._ctx.setLockTimeout(this._lockTimeout);
        this._ctx.setAutoStore(this._autoStore);
        this._ctx.setCallback(this._callback);
        this._ctx.setInstanceFactory(this._instanceFactory);
    }

    /*
     * Loose catch block
     */
    public void commit() throws TransactionNotInProgressException, TransactionAbortedException {
        block10: {
            if (this._transaction != null) {
                throw new IllegalStateException(Messages.message("jdo.txInJ2EE"));
            }
            if (this._ctx == null || !this._ctx.isOpen()) {
                throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
            }
            if (this._ctx.getStatus() == 1) {
                throw new TransactionAbortedException(Messages.message("jdo.txAborted"));
            }
            this._ctx.prepare();
            this._ctx.commit();
            Object var3_1 = null;
            try {
                this._ctx.close();
                break block10;
            }
            catch (Exception ex) {
                // empty catch block
            }
            {
                break block10;
                catch (TransactionAbortedException except) {
                    this._ctx.rollback();
                    throw except;
                }
            }
            catch (Throwable throwable) {
                Object var3_2 = null;
                try {
                    this._ctx.close();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this._ctx = null;
                throw throwable;
            }
        }
        this._ctx = null;
    }

    public void rollback() throws TransactionNotInProgressException {
        if (this._transaction != null) {
            throw new IllegalStateException(Messages.message("jdo.txInJ2EE"));
        }
        if (this._ctx == null || !this._ctx.isOpen()) {
            throw new TransactionNotInProgressException(Messages.message("jdo.txNotInProgress"));
        }
        this._ctx.rollback();
        this._ctx = null;
    }

    public void beforeCompletion() {
        if (this._transaction == null || this._ctx == null || !this._ctx.isOpen()) {
            throw new IllegalStateException(Messages.message("jdo.txNotInProgress"));
        }
        if (this._ctx.getStatus() == 1) {
            block9: {
                try {
                    this._transaction.setRollbackOnly();
                }
                catch (SystemException except) {
                    if (this._logInterceptor == null) break block9;
                    this._logInterceptor.exception((Exception)((Object)except));
                }
            }
            return;
        }
        try {
            this._ctx.prepare();
        }
        catch (TransactionAbortedException except) {
            block10: {
                if (this._logInterceptor != null) {
                    this._logInterceptor.exception(except);
                }
                try {
                    this._transaction.setRollbackOnly();
                }
                catch (SystemException except2) {
                    if (this._logInterceptor == null) break block10;
                    this._logInterceptor.exception((Exception)((Object)except2));
                }
            }
            this._ctx.rollback();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void afterCompletion(int status) {
        block14: {
            block13: {
                block12: {
                    try {
                        if (this._transaction == null) throw new IllegalStateException(Messages.message("jdo.txNotInProgress"));
                        if (this._ctx == null) {
                            throw new IllegalStateException(Messages.message("jdo.txNotInProgress"));
                        }
                        if (this._ctx.getStatus() == 4) {
                            Object var4_2 = null;
                            if (this._txMap == null) return;
                            if (this._transaction == null) return;
                            this._txMap.remove(this._transaction);
                            break block12;
                        }
                        if (this._ctx.getStatus() != 2 && status != 4) {
                            throw new IllegalStateException("Unexpected state: afterCompletion called at status " + this._ctx.getStatus());
                        }
                        switch (status) {
                            case 3: {
                                try {
                                    this._ctx.commit();
                                }
                                catch (TransactionAbortedException except) {
                                    if (this._logInterceptor != null) {
                                        this._logInterceptor.exception(except);
                                    }
                                    this._ctx.rollback();
                                }
                                this._ctx = null;
                                break block13;
                            }
                            case 4: {
                                this._ctx.rollback();
                                this._ctx = null;
                                break block14;
                            }
                            default: {
                                this._ctx.rollback();
                                this._ctx = null;
                                throw new IllegalStateException("Unexpected state: afterCompletion called with status " + status);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (this._txMap == null) throw throwable;
                        if (this._transaction == null) throw throwable;
                        this._txMap.remove(this._transaction);
                        this._txMap = null;
                        throw throwable;
                    }
                }
                this._txMap = null;
                return;
            }
            Object var4_3 = null;
            if (this._txMap == null) return;
            if (this._transaction == null) return;
            this._txMap.remove(this._transaction);
            this._txMap = null;
            return;
        }
        Object var4_4 = null;
        if (this._txMap == null) return;
        if (this._transaction == null) return;
        this._txMap.remove(this._transaction);
        this._txMap = null;
    }

    void setTxMap(TxDatabaseMap txMap) {
        this._txMap = txMap;
    }

    public boolean isActive() {
        return this._ctx != null && this._ctx.isOpen();
    }

    public void checkpoint() throws TransactionNotInProgressException, TransactionAbortedException {
    }

    public String toString() {
        return super.toString() + ":" + this._dbName;
    }

    public Object getConnection() throws PersistenceException {
        return this._ctx.getConnection(this._scope.getLockEngine());
    }
}

