/*
 * Decompiled with CFR 0.152.
 */
package tcl.lang;

import tcl.lang.BackSlashResult;
import tcl.lang.FindElemResult;
import tcl.lang.FormatCmd;
import tcl.lang.Interp;
import tcl.lang.PrecTraceProc;
import tcl.lang.RegexMatcher;
import tcl.lang.StrtodResult;
import tcl.lang.StrtoulResult;
import tcl.lang.TclException;
import tcl.lang.TclObject;
import tcl.lang.TclRuntimeError;
import tcl.lang.TclString;
import tcl.lang.VarTrace;

public class Util {
    static final int TCL_DONT_USE_BRACES = 1;
    static final int USE_BRACES = 2;
    static final int BRACES_UNMATCHED = 4;
    static final String intTooBigCode = "ARITH IOVERFLOW {integer value too large to represent}";
    static final String fpTooBigCode = "ARITH OVERFLOW {floating-point value too large to represent}";
    static char[] cvtIn = new char[]{'\u0000', '\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t', 'd', 'd', 'd', 'd', 'd', 'd', 'd', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#', 'd', 'd', 'd', 'd', 'd', 'd', '\n', '\u000b', '\f', '\r', '\u000e', '\u000f', '\u0010', '\u0011', '\u0012', '\u0013', '\u0014', '\u0015', '\u0016', '\u0017', '\u0018', '\u0019', '\u001a', '\u001b', '\u001c', '\u001d', '\u001e', '\u001f', ' ', '!', '\"', '#'};
    static final int maxExponent = 511;
    static final double[] powersOf10 = new double[]{10.0, 100.0, 10000.0, 1.0E8, 1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
    static RegexMatcher regexMatcher = Util.checkRegexPackage();
    static boolean broken_isLetterOrDigit = Util.checkIsLetterOrDigit();
    static final int DEFAULT_PRECISION = 12;
    static int precision = 12;

    private Util() {
    }

    static StrtoulResult strtoul(String string, int n, int n2) {
        int n3;
        long l = 0L;
        boolean bl = false;
        int n4 = string.length();
        int n5 = n;
        while (n5 < n4 && Character.isWhitespace(string.charAt(n5))) {
            ++n5;
        }
        if (n5 >= n4) {
            return new StrtoulResult(0L, 0, -1);
        }
        if (n2 == 0) {
            char c = string.charAt(n5);
            if (c == '0') {
                if (n5 < n4 - 1 && (c = string.charAt(++n5)) == 'x') {
                    ++n5;
                    n2 = 16;
                }
                if (n2 == 0) {
                    bl = true;
                    n2 = 8;
                }
            } else {
                n2 = 10;
            }
        } else if (n2 == 16 && n5 < n4 - 2 && string.charAt(n5) == '0' && string.charAt(n5 + 1) == 'x') {
            n5 += 2;
        }
        long l2 = 0x100000000L / (long)n2;
        boolean bl2 = false;
        while (n5 < n4 && (n3 = string.charAt(n5) - 48) >= 0 && n3 <= 74 && (n3 = cvtIn[n3]) < n2) {
            if (l > l2) {
                bl2 = true;
            }
            l = l * (long)n2 + (long)n3;
            bl = true;
            ++n5;
        }
        if (!bl) {
            return new StrtoulResult(0L, 0, -1);
        }
        if (bl2) {
            return new StrtoulResult(0L, n5, -2);
        }
        return new StrtoulResult(l, n5, 0);
    }

    static int getInt(Interp interp, String string) throws TclException {
        boolean bl;
        int n = string.length();
        int n2 = 0;
        while (n2 < n && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        if (n2 >= n) {
            throw new TclException(interp, "expected integer but got \"" + string + "\"");
        }
        char c = string.charAt(n2);
        if (c == '-') {
            bl = true;
            ++n2;
        } else {
            if (c == '+') {
                ++n2;
            }
            bl = false;
        }
        StrtoulResult strtoulResult = Util.strtoul(string, n2, 0);
        if (strtoulResult.errno < 0) {
            if (strtoulResult.errno == -2) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance(intTooBigCode));
                }
                throw new TclException(interp, "integer value too large to represent");
            }
            throw new TclException(interp, "expected integer but got \"" + string + "\"");
        }
        if (strtoulResult.index < n) {
            n2 = strtoulResult.index;
            while (n2 < n) {
                if (!Character.isWhitespace(string.charAt(n2))) {
                    throw new TclException(interp, "expected integer but got \"" + string + "\"");
                }
                ++n2;
            }
        }
        if (bl) {
            return (int)(-strtoulResult.value);
        }
        return (int)strtoulResult.value;
    }

    static StrtodResult strtod(String string, int n) {
        boolean bl = false;
        int n2 = string.length();
        int n3 = n;
        while (n3 < n2 && Character.isWhitespace(string.charAt(n3))) {
            ++n3;
        }
        if (n3 >= n2) {
            return new StrtodResult(0.0, 0, -3);
        }
        char c = string.charAt(n3);
        if (c == '-') {
            bl = true;
            ++n3;
        } else {
            if (c == '+') {
                ++n3;
            }
            bl = false;
        }
        int n4 = -1;
        int n5 = 0;
        while (true) {
            if (!Character.isDigit(c = Util.CharAt(string, n3, n2))) {
                if (c != '.' || n4 >= 0) break;
                n4 = n5;
            }
            ++n3;
            ++n5;
        }
        if (Util.CharAt(string, n3, n2) == 'E' || Util.CharAt(string, n3, n2) == 'e') {
            if (Util.CharAt(string, ++n3, n2) == '-') {
                ++n3;
            } else if (Util.CharAt(string, n3, n2) == '+') {
                ++n3;
            }
            while (Character.isDigit(Util.CharAt(string, n3, n2))) {
                ++n3;
            }
        }
        string = string.substring(n, n3);
        double d = 0.0;
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            return new StrtodResult(0.0, 0, -3);
        }
        if (d == Double.NEGATIVE_INFINITY || d == Double.POSITIVE_INFINITY) {
            return new StrtodResult(0.0, n3, -4);
        }
        if (d == Double.NaN) {
            return new StrtodResult(0.0, 0, -3);
        }
        return new StrtodResult(d, n3, 0);
    }

    static final char CharAt(String string, int n, int n2) {
        if (n >= 0 && n < n2) {
            return string.charAt(n);
        }
        return '\u0000';
    }

    static double getDouble(Interp interp, String string) throws TclException {
        boolean bl;
        int n = string.length();
        int n2 = 0;
        while (n2 < n && Character.isWhitespace(string.charAt(n2))) {
            ++n2;
        }
        if (n2 >= n) {
            throw new TclException(interp, "expected floating-point number but got \"" + string + "\"");
        }
        char c = string.charAt(n2);
        if (c == '-') {
            bl = true;
            ++n2;
        } else {
            if (c == '+') {
                ++n2;
            }
            bl = false;
        }
        StrtodResult strtodResult = Util.strtod(string, n2);
        if (strtodResult.errno != 0) {
            if (strtodResult.errno == -4) {
                if (interp != null) {
                    interp.setErrorCode(TclString.newInstance(fpTooBigCode));
                }
                throw new TclException(interp, "floating-point value too large to represent");
            }
            throw new TclException(interp, "expected floating-point number but got \"" + string + "\"");
        }
        if (strtodResult.index < n) {
            n2 = strtodResult.index;
            while (n2 < n) {
                if (!Character.isWhitespace(string.charAt(n2))) {
                    throw new TclException(interp, "expected floating-point number but got \"" + string + "\"");
                }
                ++n2;
            }
        }
        if (bl) {
            return -strtodResult.value;
        }
        return strtodResult.value;
    }

    static String concat(int n, int n2, TclObject[] tclObjectArray) {
        if (n > tclObjectArray.length) {
            return "";
        }
        if (n2 <= tclObjectArray.length) {
            n2 = tclObjectArray.length - 1;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = n;
        while (n3 <= n2) {
            String string = Util.TrimLeft(tclObjectArray[n3].toString());
            if ((string = Util.TrimRight(string)).length() != 0) {
                stringBuffer.append(string);
                if (n3 < n2) {
                    stringBuffer.append(" ");
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static final boolean stringMatch(String string, String string2) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = string2.toCharArray();
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        while (true) {
            if (bl) {
                ++n3;
                ++n4;
                bl = false;
            }
            if (n3 == n2) {
                return n4 == n;
            }
            if (n4 == n && cArray2[n3] != '*') {
                return false;
            }
            if (cArray2[n3] == '*') {
                if (++n3 == n2) {
                    return true;
                }
                while (true) {
                    if (Util.stringMatch(string.substring(n4), string2.substring(n3))) {
                        return true;
                    }
                    if (n4 == n) {
                        return false;
                    }
                    ++n4;
                }
            }
            if (cArray2[n3] == '?') {
                bl = true;
                continue;
            }
            if (cArray2[n3] == '[') {
                ++n3;
                while (true) {
                    if (n3 == n2 || cArray2[n3] == ']') {
                        return false;
                    }
                    if (n4 == n) {
                        return false;
                    }
                    char c = cArray2[n3];
                    char c2 = cArray[n4];
                    if (n3 + 1 != n2 && cArray2[n3 + 1] == '-') {
                        if ((n3 += 2) == n2) {
                            return false;
                        }
                        char c3 = cArray2[n3];
                        if (c <= c2 && c3 >= c2 || c >= c2 && c3 <= c2) {
                            break;
                        }
                    } else if (c == c2) break;
                    ++n3;
                }
                ++n3;
                while (n3 != n2 && cArray2[n3] != ']') {
                    ++n3;
                }
                if (n3 == n2) {
                    return false;
                }
                bl = true;
                continue;
            }
            if (cArray2[n3] == '\\' && ++n3 == n2) {
                return false;
            }
            if (n4 == n || cArray2[n3] != cArray[n4]) {
                return false;
            }
            bl = true;
        }
    }

    static final RegexMatcher checkRegexPackage() {
        try {
            Class<?> clazz = Class.forName("tcl.regex.OroRegexMatcher");
            return (RegexMatcher)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static final boolean regExpMatch(Interp interp, String string, TclObject tclObject) throws TclException {
        if (regexMatcher != null) {
            return regexMatcher.match(interp, string, tclObject.toString());
        }
        return false;
    }

    static final void appendElement(Interp interp, StringBuffer stringBuffer, String string) throws TclException {
        if (stringBuffer.length() > 0) {
            stringBuffer.append(' ');
        }
        int n = Util.scanElement(interp, string);
        stringBuffer.append(Util.convertElement(string, n));
    }

    static final FindElemResult findElement(Interp interp, String string, int n, int n2) throws TclException {
        int n3 = 0;
        boolean bl = false;
        while (n < n2 && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n >= n2) {
            return null;
        }
        char c = string.charAt(n);
        if (c == '{') {
            n3 = 1;
            ++n;
        } else if (c == '\"') {
            bl = true;
            ++n;
        }
        StringBuffer stringBuffer = new StringBuffer();
        block8: while (true) {
            if (n >= n2) {
                if (n3 != 0) {
                    throw new TclException(interp, "unmatched open brace in list");
                }
                if (bl) {
                    throw new TclException(interp, "unmatched open quote in list");
                }
                return new FindElemResult(n, stringBuffer.toString());
            }
            c = string.charAt(n);
            switch (c) {
                case '{': {
                    if (n3 != 0) {
                        ++n3;
                    }
                    stringBuffer.append(c);
                    ++n;
                    continue block8;
                }
                case '}': {
                    if (n3 == 1) {
                        if (n == n2 - 1 || Character.isWhitespace(string.charAt(n + 1))) {
                            return new FindElemResult(n + 1, stringBuffer.toString());
                        }
                        int n4 = n + 1;
                        while (n4 < n2) {
                            if (Character.isWhitespace(string.charAt(n4))) break;
                            ++n4;
                        }
                        throw new TclException(interp, "list element in braces followed by \"" + string.substring(n + 1, n4) + "\" instead of space");
                    }
                    if (n3 != 0) {
                        --n3;
                    }
                    stringBuffer.append(c);
                    ++n;
                    continue block8;
                }
                case '\\': {
                    if (n3 > 0) {
                        stringBuffer.append(c);
                        ++n;
                        continue block8;
                    }
                    BackSlashResult backSlashResult = Interp.backslash(string, n, n2);
                    stringBuffer.append(backSlashResult.c);
                    n = backSlashResult.nextIndex;
                    continue block8;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (n3 == 0 && !bl) {
                        return new FindElemResult(n + 1, stringBuffer.toString());
                    }
                    stringBuffer.append(c);
                    ++n;
                    continue block8;
                }
                case '\"': {
                    if (bl) {
                        if (n == n2 - 1 || Character.isWhitespace(string.charAt(n + 1))) {
                            return new FindElemResult(n + 1, stringBuffer.toString());
                        }
                        int n5 = n + 1;
                        while (n5 < n2) {
                            if (Character.isWhitespace(string.charAt(n5))) break;
                            ++n5;
                        }
                        throw new TclException(interp, "list element in quotes followed by \"" + string.substring(n + 1, n5) + "\" instead of space");
                    }
                    stringBuffer.append(c);
                    ++n;
                    continue block8;
                }
            }
            stringBuffer.append(c);
            ++n;
        }
    }

    static int scanElement(Interp interp, String string) throws TclException {
        char c;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = string.length();
        if (n4 == 0) {
            string = String.valueOf('\u0000');
        }
        if ((c = string.charAt(n3)) == '{' || c == '\"' || c == '\u0000') {
            n2 |= 2;
        }
        while (n3 < n4) {
            c = string.charAt(n3);
            switch (c) {
                case '{': {
                    ++n;
                    break;
                }
                case '}': {
                    if (--n >= 0) break;
                    n2 |= 5;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '$': 
                case ';': 
                case '[': {
                    n2 |= 2;
                    break;
                }
                case '\\': {
                    if (n3 >= n4 - 1 || string.charAt(n3 + 1) == '\n') {
                        n2 = 5;
                        break;
                    }
                    BackSlashResult backSlashResult = Interp.backslash(string, n3, n4);
                    n3 = backSlashResult.nextIndex - 1;
                    n2 |= 2;
                }
            }
            ++n3;
        }
        if (n != 0) {
            n2 = 5;
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    static String convertElement(String var0, int var1_1) {
        block14: {
            block13: {
                var2_2 = 0;
                var4_3 = var0.length();
                if (var0 == null || var0.length() == 0 || var0.charAt(0) == '\u0000') {
                    return "{}";
                }
                var5_4 = new StringBuffer();
                if ((var1_1 & 2) == 0 || (var1_1 & 1) != 0) break block13;
                var5_4.append('{');
                var2_2 = 0;
                while (var2_2 < var4_3) {
                    var5_4.append(var0.charAt(var2_2));
                    ++var2_2;
                }
                var5_4.append('}');
                break block14;
            }
            var3_5 = var0.charAt(0);
            if (var3_5 == '{') {
                var5_4.append('\\');
                var5_4.append('{');
                ++var2_2;
                var1_1 |= 4;
            }
            while (var2_2 < var4_3) {
                var3_5 = var0.charAt(var2_2);
                switch (var3_5) {
                    case ' ': 
                    case '\"': 
                    case '$': 
                    case ';': 
                    case '[': 
                    case '\\': 
                    case ']': {
                        var5_4.append('\\');
                        ** GOTO lbl69
                    }
                    case '{': 
                    case '}': {
                        if ((var1_1 & 4) == 0) ** GOTO lbl69
                        var5_4.append('\\');
                        ** GOTO lbl69
                    }
                    case '\f': {
                        var5_4.append('\\');
                        var5_4.append('f');
                        break;
                    }
                    case '\n': {
                        var5_4.append('\\');
                        var5_4.append('n');
                        break;
                    }
                    case '\r': {
                        var5_4.append('\\');
                        var5_4.append('r');
                        break;
                    }
                    case '\t': {
                        var5_4.append('\\');
                        var5_4.append('t');
                        break;
                    }
                    case '\u000b': {
                        var5_4.append('\\');
                        var5_4.append('v');
                        break;
                    }
lbl69:
                    // 4 sources

                    default: {
                        var5_4.append(var3_5);
                    }
                }
                ++var2_2;
            }
        }
        return var5_4.toString();
    }

    static String TrimLeft(String string, String string2) {
        int n = string.length();
        int n2 = string2.length();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            char c = string.charAt(n3);
            bl = true;
            int n4 = 0;
            while (n4 < n2) {
                if (c == string2.charAt(n4)) {
                    bl = false;
                    break;
                }
                ++n4;
            }
            if (bl) break;
            ++n3;
        }
        return string.substring(n3, n);
    }

    static String TrimLeft(String string) {
        return Util.TrimLeft(string, " \n\t\r");
    }

    static String TrimRight(String string, String string2) {
        int n = string.length() - 1;
        char[] cArray = string.toCharArray();
        while (n >= 0) {
            char c = cArray[n];
            if (string2.indexOf(c) == -1) break;
            --n;
        }
        return string.substring(0, n + 1);
    }

    static String TrimRight(String string) {
        return Util.TrimRight(string, " \n\t\r");
    }

    static boolean getBoolean(Interp interp, String string) throws TclException {
        String string2 = string.toLowerCase();
        if (string2.length() > 0) {
            if ("yes".startsWith(string2)) {
                return true;
            }
            if ("no".startsWith(string2)) {
                return false;
            }
            if ("true".startsWith(string2)) {
                return true;
            }
            if ("false".startsWith(string2)) {
                return false;
            }
            if ("on".startsWith(string2) && string2.length() > 1) {
                return true;
            }
            if ("off".startsWith(string2) && string2.length() > 1) {
                return false;
            }
            if (string2.equals("0")) {
                return false;
            }
            if (string2.equals("1")) {
                return true;
            }
        }
        throw new TclException(interp, "expected boolean value but got \"" + string + "\"");
    }

    static final boolean checkIsLetterOrDigit() {
        try {
            Character.isLetterOrDigit('c');
            return false;
        }
        catch (Exception exception) {
            return true;
        }
    }

    static final boolean isLetterOrDigit(char c) {
        if (!broken_isLetterOrDigit) {
            return Character.isLetterOrDigit(c);
        }
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9';
    }

    static final int getActualPlatform() {
        if (Util.isWindows()) {
            return 1;
        }
        if (Util.isMac()) {
            return 2;
        }
        return 0;
    }

    static final boolean isUnix() {
        return !Util.isMac() && !Util.isWindows();
    }

    static final boolean isMac() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().startsWith("mac");
    }

    static final boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.toLowerCase().startsWith("win");
    }

    static void setupPrecisionTrace(Interp interp) {
        try {
            interp.traceVar("tcl_precision", (VarTrace)new PrecTraceProc(), 113);
        }
        catch (TclException tclException) {
            throw new TclRuntimeError("unexpected TclException: " + tclException);
        }
    }

    static String printDouble(double d) {
        String string = FormatCmd.toString(d, precision, 10);
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '.' || Character.isLetter(string.charAt(n2))) {
                return string;
            }
            ++n2;
        }
        return string.concat(".0");
    }

    static String tryGetSystemProperty(String string, String string2) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            return string2;
        }
    }
}

