/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.jabber;

import com.echomine.common.SendMessageFailedException;
import com.echomine.jabber.JabberConnection;
import com.echomine.jabber.JabberContext;
import com.echomine.jabber.RosterIQMessage;
import com.echomine.jabber.RosterItem;

public class JabberRosterService {
    private JabberConnection connection;
    private JabberContext context;

    public JabberRosterService(JabberConnection connection, JabberContext context) {
        this.connection = connection;
        this.context = context;
    }

    public void requestRosterList(boolean wait) throws SendMessageFailedException {
        RosterIQMessage msg = new RosterIQMessage("get");
        msg.setSynchronized(wait);
        this.connection.send(msg);
    }

    public void addToRoster(String jid, String name, String group, boolean wait) throws SendMessageFailedException {
        RosterItem item = new RosterItem(jid, name);
        item.addGroup(group);
        this.addToRoster(item, wait);
    }

    public void addToRoster(RosterItem item, boolean wait) throws SendMessageFailedException {
        RosterIQMessage msg = new RosterIQMessage("set");
        msg.setSynchronized(wait);
        msg.addRosterItem(item);
        this.connection.send(msg);
    }

    public void removeFromRoster(String jid, boolean wait) throws SendMessageFailedException {
        RosterItem item = new RosterItem(jid, null);
        item.setRemove(true);
        this.removeFromRoster(item, wait);
    }

    public void removeFromRoster(RosterItem item, boolean wait) throws SendMessageFailedException {
        RosterIQMessage msg = new RosterIQMessage("set");
        msg.setSynchronized(wait);
        item.setRemove(true);
        msg.addRosterItem(item);
        this.connection.send(msg);
    }
}

