/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net;

import com.echomine.net.ConnectionModel;
import java.util.EventObject;

public class ConnectionEvent
extends EventObject {
    public static final int CONNECTION_OPENED = 1;
    public static final int CONNECTION_CLOSED = 2;
    public static final int CONNECTION_ERRORED = 3;
    public static final int CONNECTION_STARTING = 4;
    public static final int CONNECTION_VETOED = 5;
    public static final int CONNECTION_REJECTED = 6;
    private String errormsg;
    private int status;

    public ConnectionEvent(ConnectionModel source, int status) {
        super(source);
        this.status = status;
    }

    public ConnectionEvent(ConnectionModel source, int status, String errormsg) {
        this(source, status);
        this.errormsg = errormsg;
    }

    public boolean isError() {
        return this.status == 3;
    }

    public boolean isVetoed() {
        return this.status == 5;
    }

    public boolean isRejected() {
        return this.status == 6;
    }

    public String getErrorMessage() {
        if (this.errormsg == null) {
            return "";
        }
        return this.errormsg;
    }

    public ConnectionModel getConnectionModel() {
        return (ConnectionModel)this.getSource();
    }

    public int getStatus() {
        return this.status;
    }

    public int getPort() {
        return ((ConnectionModel)this.getSource()).getPort();
    }

    public String getHostName() {
        return ((ConnectionModel)this.getSource()).getHostName();
    }
}

