/*
 * Decompiled with CFR 0.152.
 */
package com.echomine.net;

import com.echomine.net.ConnectionEvent;
import com.echomine.net.ConnectionModel;
import com.echomine.net.ConnectionVetoException;
import com.echomine.net.SocketHandler;
import com.echomine.net.TimeableConnection;
import com.echomine.util.IOUtil;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;

public class SocketAcceptor
extends TimeableConnection {
    protected ServerSocket socket;
    private ConnectionModel connectionModel;

    public SocketAcceptor() {
    }

    public SocketAcceptor(ConnectionModel model) throws IOException {
        this(model, 20);
    }

    public SocketAcceptor(ConnectionModel model, int backlog) throws IOException {
        this.connectionModel = model;
        this.open(backlog);
    }

    public void open(int backlog) throws IOException {
        this.socket = this.connectionModel.getHost() == null ? new ServerSocket(this.connectionModel.getPort(), backlog) : new ServerSocket(this.connectionModel.getPort(), backlog, this.connectionModel.getHost());
    }

    public void accept(SocketHandler socketHandler) {
        Socket s = null;
        try {
            s = this.socket.accept();
            ConnectionModel model = new ConnectionModel(s.getInetAddress(), s.getPort());
            ConnectionEvent e = new ConnectionEvent(this.connectionModel, 4);
            ConnectionEvent vetoEvent = new ConnectionEvent(this.connectionModel, 5);
            try {
                try {
                    socketHandler.start();
                    this.fireConnectionStarting(e, vetoEvent);
                    e = new ConnectionEvent(this.connectionModel, 1);
                    this.fireConnectionEstablished(e);
                    socketHandler.handle(s);
                    e = new ConnectionEvent(this.connectionModel, 2);
                    this.fireConnectionClosed(e);
                }
                catch (IOException ex) {
                    e = new ConnectionEvent(this.connectionModel, 3, "Error during handling: " + ex.getMessage());
                    this.fireConnectionClosed(e);
                }
                catch (ConnectionVetoException ex) {
                }
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                IOUtil.closeSocket(s);
                throw throwable;
            }
            IOUtil.closeSocket(s);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void aaccept(SocketHandler socketHandler) {
        Thread thread = new Thread(new _1(this, socketHandler));
        thread.start();
    }

    public void close() {
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public ConnectionModel getConnectionModel() {
        return this.connectionModel;
    }

    public void setConnectionModel(ConnectionModel connectionModel) throws IOException {
        this.setConnectionModel(connectionModel, 20);
    }

    public void setConnectionModel(ConnectionModel connectionModel, int backlog) throws IOException {
        this.connectionModel = connectionModel;
        this.close();
        this.open(backlog);
    }

    static ConnectionModel access$11(SocketAcceptor obj$) {
        return obj$.connectionModel;
    }

    class _1
    implements Runnable {
        private final SocketAcceptor this$SocketAcceptor;
        final SocketHandler val$socketHandler;

        public void run() {
            Socket s = null;
            try {
                s = this.this$SocketAcceptor.socket.accept();
                ConnectionModel model = new ConnectionModel(s.getInetAddress(), s.getPort());
                ConnectionEvent e = new ConnectionEvent(SocketAcceptor.access$11(this.this$SocketAcceptor), 4);
                ConnectionEvent vetoEvent = new ConnectionEvent(SocketAcceptor.access$11(this.this$SocketAcceptor), 5);
                try {
                    try {
                        this.val$socketHandler.start();
                        this.this$SocketAcceptor.fireConnectionStarting(e, vetoEvent);
                        e = new ConnectionEvent(SocketAcceptor.access$11(this.this$SocketAcceptor), 1);
                        this.this$SocketAcceptor.fireConnectionEstablished(e);
                        this.val$socketHandler.handle(s);
                        e = new ConnectionEvent(SocketAcceptor.access$11(this.this$SocketAcceptor), 2);
                        this.this$SocketAcceptor.fireConnectionClosed(e);
                    }
                    catch (IOException ex) {
                        e = new ConnectionEvent(SocketAcceptor.access$11(this.this$SocketAcceptor), 3, "Error during handling: " + ex.getMessage());
                        this.this$SocketAcceptor.fireConnectionClosed(e);
                    }
                    catch (ConnectionVetoException ex) {
                    }
                    Object var9_8 = null;
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    IOUtil.closeSocket(s);
                    throw throwable;
                }
                IOUtil.closeSocket(s);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        _1(SocketAcceptor enclosing$instance, SocketHandler val$socketHandler) {
            this.this$SocketAcceptor = enclosing$instance;
            this.val$socketHandler = val$socketHandler;
        }
    }
}

