/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.ItemDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.Constants;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.ExtendedItemDefinition;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class ItemDefinitionImpl
implements ExtendedItemDefinition {
    private static final Log LOG = ExoLogger.getLogger(ItemDefinitionImpl.class);
    protected final NodeTypeDataManager nodeTypeDataManager;
    protected final LocationFactory locationFactory;
    protected final ExtendedNodeTypeManager nodeTypeManager;
    protected final ValueFactory valueFactory;
    private final ItemDefinitionData itemDefinitionData;

    public ItemDefinitionImpl(ItemDefinitionData itemDefinitionData, NodeTypeDataManager nodeTypeDataManager, ExtendedNodeTypeManager nodeTypeManager, LocationFactory locationFactory, ValueFactory valueFactory) {
        this.itemDefinitionData = itemDefinitionData;
        this.nodeTypeDataManager = nodeTypeDataManager;
        this.nodeTypeManager = nodeTypeManager;
        this.locationFactory = locationFactory;
        this.valueFactory = valueFactory;
    }

    public NodeType getDeclaringNodeType() {
        return new NodeTypeImpl(this.nodeTypeDataManager.getNodeType(this.itemDefinitionData.getDeclaringNodeType()), this.nodeTypeDataManager, this.nodeTypeManager, this.locationFactory, this.valueFactory);
    }

    public String getName() {
        String result = "";
        try {
            result = this.locationFactory.createJCRName(this.itemDefinitionData.getName()).getAsString();
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public InternalQName getQName() {
        return this.itemDefinitionData.getName();
    }

    public InternalQName getDeclaringNodeTypeQName() {
        return this.itemDefinitionData.getDeclaringNodeType();
    }

    public int getOnParentVersion() {
        return this.itemDefinitionData.getOnParentVersion();
    }

    public boolean isAutoCreated() {
        return this.itemDefinitionData.isAutoCreated();
    }

    public boolean isMandatory() {
        return this.itemDefinitionData.isMandatory();
    }

    public boolean isProtected() {
        return this.itemDefinitionData.isProtected();
    }

    public boolean isResidualSet() {
        return this.getName().equals(Constants.JCR_ANY_NAME.getName());
    }
}

