/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.nodetype;

import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.services.jcr.core.nodetype.ExtendedNodeTypeManager;
import org.exoplatform.services.jcr.core.nodetype.NodeDefinitionData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeData;
import org.exoplatform.services.jcr.core.nodetype.NodeTypeDataManager;
import org.exoplatform.services.jcr.datamodel.InternalQName;
import org.exoplatform.services.jcr.impl.core.LocationFactory;
import org.exoplatform.services.jcr.impl.core.nodetype.ExtendedNodeDefinition;
import org.exoplatform.services.jcr.impl.core.nodetype.ItemDefinitionImpl;
import org.exoplatform.services.jcr.impl.core.nodetype.NodeTypeImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class NodeDefinitionImpl
extends ItemDefinitionImpl
implements ExtendedNodeDefinition {
    private static final Log LOG = ExoLogger.getLogger(NodeDefinitionImpl.class);
    private final NodeDefinitionData nodeDefinitionData;

    public NodeDefinitionImpl(NodeDefinitionData nodeDefinitionData, NodeTypeDataManager nodeTypeDataManager, ExtendedNodeTypeManager nodeTypeManager, LocationFactory locationFactory, ValueFactory valueFactory) {
        super(nodeDefinitionData, nodeTypeDataManager, nodeTypeManager, locationFactory, valueFactory);
        this.nodeDefinitionData = nodeDefinitionData;
    }

    public boolean allowsSameNameSiblings() {
        return this.nodeDefinitionData.isAllowsSameNameSiblings();
    }

    public NodeType getDefaultPrimaryType() {
        if (this.nodeDefinitionData.getDefaultPrimaryType() == null) {
            return null;
        }
        return new NodeTypeImpl(this.nodeTypeDataManager.getNodeType(this.nodeDefinitionData.getDefaultPrimaryType()), this.nodeTypeDataManager, this.nodeTypeManager, this.locationFactory, this.valueFactory);
    }

    public String getDefaultPrimaryTypeName() {
        String result = null;
        if (this.nodeDefinitionData.getDefaultPrimaryType() != null) {
            try {
                result = this.locationFactory.createJCRName(this.nodeDefinitionData.getDefaultPrimaryType()).getAsString();
            }
            catch (RepositoryException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public InternalQName getDefaultPrimaryTypeQName() {
        return this.nodeDefinitionData.getDefaultPrimaryType();
    }

    public String[] getRequiredPrimaryTypeNames() {
        InternalQName[] requiredPrimaryTypes = this.nodeDefinitionData.getRequiredPrimaryTypes();
        String[] result = new String[requiredPrimaryTypes.length];
        try {
            for (int i = 0; i < requiredPrimaryTypes.length; ++i) {
                result[i] = this.locationFactory.createJCRName(requiredPrimaryTypes[i]).getAsString();
            }
        }
        catch (RepositoryException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public InternalQName[] getRequiredPrimaryTypeQNames() {
        return this.nodeDefinitionData.getRequiredPrimaryTypes();
    }

    public NodeType[] getRequiredPrimaryTypes() {
        InternalQName[] requiredPrimaryTypes = this.nodeDefinitionData.getRequiredPrimaryTypes();
        NodeType[] result = new NodeType[requiredPrimaryTypes.length];
        for (int i = 0; i < requiredPrimaryTypes.length; ++i) {
            NodeTypeData ntData = this.nodeTypeDataManager.getNodeType(requiredPrimaryTypes[i]);
            if (ntData == null) {
                LOG.error((Object)("NODE TYPE NOT FOUND " + requiredPrimaryTypes[i].getAsString()));
                continue;
            }
            result[i] = new NodeTypeImpl(ntData, this.nodeTypeDataManager, this.nodeTypeManager, this.locationFactory, this.valueFactory);
        }
        return result;
    }
}

