/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.taxonomy.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Workspace;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyAlreadyExistsException;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyNodeAlreadyExistsException;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyPlugin;
import org.exoplatform.services.cms.taxonomy.impl.TaxonomyTreeDefaultUserPermission;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaxonomyServiceImpl
implements TaxonomyService,
Startable {
    private SessionProviderService providerService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    private RepositoryService repositoryService_;
    private final String TAXONOMY_LINK = "exo:taxonomyLink";
    private final String EXOSYMLINK_LINK = "exo:symlink";
    private LinkManager linkManager_;
    private final String SQL_QUERY = "Select * from exo:taxonomyLink where jcr:path like '$0/%' and exo:uuid = '$1' order by exo:dateCreated DESC";
    List<TaxonomyPlugin> plugins_ = new ArrayList<TaxonomyPlugin>();
    private DMSConfiguration dmsConfiguration_;
    private Map<String, String[]> taxonomyTreeDefaultUserPermissions_;
    private static final Log LOG = ExoLogger.getLogger(TaxonomyServiceImpl.class);

    public TaxonomyServiceImpl(InitParams initParams, SessionProviderService providerService, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repoService, LinkManager linkManager, DMSConfiguration dmsConfiguration) throws Exception {
        this.providerService_ = providerService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repoService;
        this.linkManager_ = linkManager;
        this.dmsConfiguration_ = dmsConfiguration;
        ObjectParameter objectParam = initParams.getObjectParam("defaultPermission.configuration");
        if (objectParam != null) {
            this.taxonomyTreeDefaultUserPermissions_ = this.getPermissions(((TaxonomyTreeDefaultUserPermission)objectParam.getObject()).getPermissions());
        }
    }

    @Override
    public void init(String repository) throws Exception {
        for (TaxonomyPlugin plugin : this.plugins_) {
            plugin.init(repository);
        }
    }

    @Override
    public void addTaxonomyPlugin(ComponentPlugin plugin) {
        if (plugin instanceof TaxonomyPlugin) {
            this.plugins_.add((TaxonomyPlugin)plugin);
        }
    }

    @Override
    public List<Node> getAllTaxonomyTrees(String repository) throws RepositoryException {
        return this.getAllTaxonomyTrees(repository, false);
    }

    @Override
    public List<Node> getAllTaxonomyTrees(String repository, boolean system) throws RepositoryException {
        ArrayList<Node> listNode = new ArrayList<Node>();
        try {
            Node taxonomyDef = this.getRootTaxonomyDef(repository);
            NodeIterator nodeIter = taxonomyDef.getNodes();
            while (nodeIter.hasNext()) {
                Node node = (Node)nodeIter.next();
                if (!node.isNodeType("exo:symlink")) continue;
                try {
                    Node target = this.linkManager_.getTarget(node, system);
                    if (target == null) continue;
                    listNode.add(target);
                }
                catch (ItemNotFoundException ex) {}
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        return listNode;
    }

    @Override
    public Node getTaxonomyTree(String repository, String taxonomyName) throws RepositoryException {
        return this.getTaxonomyTree(repository, taxonomyName, false);
    }

    @Override
    public Node getTaxonomyTree(String repository, String taxonomyName, boolean system) throws RepositoryException {
        try {
            Node taxonomyDef = this.getRootTaxonomyDef(repository);
            Node taxonomyTree = taxonomyDef.getNode(taxonomyName);
            if (taxonomyTree.isNodeType("exo:symlink")) {
                return this.linkManager_.getTarget(taxonomyTree, system);
            }
        }
        catch (RepositoryConfigurationException e1) {
            throw new RepositoryException((Throwable)e1);
        }
        catch (PathNotFoundException e2) {
            return null;
        }
        return null;
    }

    @Override
    public boolean hasTaxonomyTree(String repository, String taxonomyName) throws RepositoryException {
        try {
            Node taxonomyTree = this.getRootTaxonomyDef(repository).getNode(taxonomyName);
            return taxonomyTree.isNodeType("exo:symlink");
        }
        catch (RepositoryConfigurationException e1) {
            throw new RepositoryException((Throwable)e1);
        }
        catch (PathNotFoundException pathNotFoundException) {
            return false;
        }
    }

    @Override
    public void addTaxonomyTree(Node taxonomyTree) throws RepositoryException, TaxonomyAlreadyExistsException {
        if (this.hasTaxonomyTree(((ManageableRepository)taxonomyTree.getSession().getRepository()).getConfiguration().getName(), taxonomyTree.getName())) {
            throw new TaxonomyAlreadyExistsException();
        }
        try {
            Node taxonomyDef = this.getRootTaxonomyDef(((ManageableRepository)taxonomyTree.getSession().getRepository()).getConfiguration().getName());
            this.linkManager_.createLink(taxonomyDef, "exo:symlink", taxonomyTree, taxonomyTree.getName());
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void updateTaxonomyTree(String taxonomyName, Node taxonomyTree) throws RepositoryException {
        String repository = ((ManageableRepository)taxonomyTree.getSession().getRepository()).getConfiguration().getName();
        try {
            if (this.hasTaxonomyTree(repository, taxonomyName)) {
                Node taxonomyTreeLink = this.getRootTaxonomyDef(repository).getNode(taxonomyName);
                this.linkManager_.updateLink(taxonomyTreeLink, taxonomyTree);
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public void removeTaxonomyTree(String taxonomyName) throws RepositoryException {
        Session session = null;
        try {
            String repository = this.repositoryService_.getDefaultRepository().getConfiguration().getName();
            if (this.hasTaxonomyTree(repository, taxonomyName)) {
                Node targetNode = this.getTaxonomyTree(repository, taxonomyName, true);
                session = targetNode.getSession();
                targetNode.remove();
                session.save();
                Node taxonomyDef = this.getRootTaxonomyDef(repository);
                Node taxonomyTree = taxonomyDef.getNode(taxonomyName);
                taxonomyTree.remove();
                taxonomyDef.getSession().save();
            }
        }
        catch (RepositoryConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    @Override
    public void addTaxonomyNode(String repository, String workspace, String parentPath, String taxoNodeName, String creatorUser) throws RepositoryException, TaxonomyNodeAlreadyExistsException {
        Session systemSession = null;
        try {
            ManageableRepository manaRepo = this.repositoryService_.getRepository(repository);
            systemSession = this.getSession(manaRepo, workspace, true);
            Node parentNode = (Node)systemSession.getItem(parentPath);
            if (parentNode.hasNode(taxoNodeName)) {
                throw new TaxonomyNodeAlreadyExistsException();
            }
            ExtendedNode node = (ExtendedNode)parentNode.addNode(taxoNodeName, "exo:taxonomy");
            if (node.canAddMixin("exo:privilegeable") && node.hasProperty("exo:owner")) {
                String owner = node.getProperty("exo:owner").getString();
                node.addMixin("exo:privilegeable");
                node.setPermission(owner, PermissionType.ALL);
                if (creatorUser != null) {
                    node.setPermission(creatorUser, PermissionType.ALL);
                }
                for (Map.Entry<String, String[]> entry : this.taxonomyTreeDefaultUserPermissions_.entrySet()) {
                    node.setPermission(entry.getKey(), entry.getValue());
                }
            }
            systemSession.save();
        }
        catch (RepositoryConfigurationException e1) {
            throw new RepositoryException((Throwable)e1);
        }
        catch (PathNotFoundException e2) {
            throw new RepositoryException((Throwable)e2);
        }
        finally {
            if (systemSession != null) {
                systemSession.logout();
            }
        }
    }

    @Override
    public void removeTaxonomyNode(String repository, String workspace, String absPath) throws RepositoryException {
        Session systemSession = null;
        try {
            ManageableRepository manaRepo = this.repositoryService_.getRepository(repository);
            systemSession = this.getSession(manaRepo, workspace, true);
            Node taxonomyNode = (Node)systemSession.getItem(absPath);
            taxonomyNode.remove();
            systemSession.save();
        }
        catch (RepositoryConfigurationException e1) {
            throw new RepositoryException((Throwable)e1);
        }
        catch (PathNotFoundException e2) {
            throw new RepositoryException((Throwable)e2);
        }
        finally {
            if (systemSession != null) {
                systemSession.logout();
            }
        }
    }

    @Override
    public List<Node> getCategories(Node node, String taxonomyName) throws RepositoryException {
        return this.getCategories(node, taxonomyName, false);
    }

    @Override
    public List<Node> getCategories(Node node, String taxonomyName, boolean system) throws RepositoryException {
        ArrayList<Node> listCate = new ArrayList<Node>();
        Session session = null;
        try {
            String repository;
            Node rootNodeTaxonomy;
            if (node.isNodeType("mix:referenceable") && (rootNodeTaxonomy = this.getTaxonomyTree(repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName(), taxonomyName, system)) != null) {
                String sql = null;
                sql = StringUtils.replace((String)"Select * from exo:taxonomyLink where jcr:path like '$0/%' and exo:uuid = '$1' order by exo:dateCreated DESC", (String)"$0", (String)rootNodeTaxonomy.getPath());
                sql = StringUtils.replace((String)sql, (String)"$1", (String)node.getUUID());
                session = this.repositoryService_.getRepository(repository).login(rootNodeTaxonomy.getSession().getWorkspace().getName());
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(sql, "sql");
                QueryResult result = query.execute();
                NodeIterator iterate = result.getNodes();
                while (iterate.hasNext()) {
                    Node parentCate = iterate.nextNode().getParent();
                    listCate.add(parentCate);
                }
            }
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
        return listCate;
    }

    @Override
    public List<Node> getAllCategories(Node node) throws RepositoryException {
        return this.getAllCategories(node, false);
    }

    @Override
    public List<Node> getAllCategories(Node node, boolean system) throws RepositoryException {
        ArrayList<Node> listCategories = new ArrayList<Node>();
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        List<Node> allTrees = this.getAllTaxonomyTrees(repository, system);
        for (Node tree : allTrees) {
            List<Node> categories = this.getCategories(node, tree.getName(), system);
            for (Node category : categories) {
                listCategories.add(category);
            }
        }
        return listCategories;
    }

    @Override
    public void addCategory(Node node, String taxonomyName, String categoryPath) throws RepositoryException {
        this.addCategories(node, taxonomyName, new String[]{categoryPath});
    }

    @Override
    public void addCategory(Node node, String taxonomyName, String categoryPath, boolean system) throws RepositoryException {
        this.addCategories(node, taxonomyName, new String[]{categoryPath}, system);
    }

    @Override
    public void addCategories(Node node, String taxonomyName, String[] categoryPaths) throws RepositoryException {
        this.addCategories(node, taxonomyName, categoryPaths, false);
    }

    @Override
    public void addCategories(Node node, String taxonomyName, String[] categoryPaths, boolean system) throws RepositoryException {
        String category = "";
        try {
            String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
            Node rootNodeTaxonomy = this.getTaxonomyTree(repository, taxonomyName, system);
            for (String categoryPath : categoryPaths) {
                category = rootNodeTaxonomy.getPath().equals("/") ? categoryPath : (!categoryPath.startsWith("/") ? rootNodeTaxonomy.getPath() + "/" + categoryPath : rootNodeTaxonomy.getPath() + categoryPath);
                Node categoryNode = categoryPath.startsWith(rootNodeTaxonomy.getPath()) ? (Node)rootNodeTaxonomy.getSession().getItem(categoryPath) : (Node)rootNodeTaxonomy.getSession().getItem(category);
                this.linkManager_.createLink(categoryNode, "exo:taxonomyLink", node, node.getName());
            }
        }
        catch (PathNotFoundException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public boolean hasCategories(Node node, String taxonomyName) throws RepositoryException {
        return this.hasCategories(node, taxonomyName, false);
    }

    @Override
    public boolean hasCategories(Node node, String taxonomyName, boolean system) throws RepositoryException {
        List<Node> listCate = this.getCategories(node, taxonomyName, system);
        return listCate != null && listCate.size() > 0;
    }

    @Override
    public void moveTaxonomyNode(String repository, String workspace, String srcPath, String destPath, String type) throws RepositoryException {
        block8: {
            Session systemSession = null;
            try {
                ManageableRepository manaRepo = this.repositoryService_.getRepository(repository);
                systemSession = this.getSession(manaRepo, workspace, true);
                if ("cut".equals(type)) {
                    systemSession.move(srcPath, destPath);
                    systemSession.save();
                    break block8;
                }
                if ("copy".equals(type)) {
                    Workspace wspace = systemSession.getWorkspace();
                    wspace.copy(srcPath, destPath);
                    systemSession.save();
                    break block8;
                }
                throw new UnsupportedRepositoryOperationException();
            }
            catch (RepositoryConfigurationException e1) {
                throw new RepositoryException((Throwable)e1);
            }
            finally {
                if (systemSession != null) {
                    systemSession.logout();
                }
            }
        }
    }

    @Override
    public void removeCategory(Node node, String taxonomyName, String categoryPath) throws RepositoryException {
        this.removeCategory(node, taxonomyName, categoryPath, false);
    }

    @Override
    public void removeCategory(Node node, String taxonomyName, String categoryPath, boolean system) throws RepositoryException {
        try {
            String category = "";
            String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
            Node rootNodeTaxonomy = this.getTaxonomyTree(repository, taxonomyName, system);
            category = rootNodeTaxonomy.getPath().equals("/") ? categoryPath : (!categoryPath.startsWith("/") ? rootNodeTaxonomy.getPath() + "/" + categoryPath : rootNodeTaxonomy.getPath() + categoryPath);
            Node categoryNode = (Node)rootNodeTaxonomy.getSession().getItem(category);
            Node nodeTaxonomyLink = categoryNode.getNode(node.getName());
            nodeTaxonomyLink.remove();
            categoryNode.save();
            node.getSession().save();
        }
        catch (PathNotFoundException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public Map<String, String[]> getTaxonomyTreeDefaultUserPermission() {
        return this.taxonomyTreeDefaultUserPermissions_;
    }

    public Map<String, String[]> getPermissions(List<TaxonomyTreeDefaultUserPermission.Permission> permissions) {
        HashMap<String, String[]> permissionsMap = new HashMap<String, String[]>();
        for (TaxonomyTreeDefaultUserPermission.Permission permission : permissions) {
            StringBuilder strPer = new StringBuilder();
            if ("true".equals(permission.getRead())) {
                strPer.append("read");
            }
            if ("true".equals(permission.getAddNode())) {
                strPer.append(",").append("add_node");
            }
            if ("true".equals(permission.getSetProperty())) {
                strPer.append(",").append("set_property");
            }
            if ("true".equals(permission.getRemove())) {
                strPer.append(",").append("remove");
            }
            permissionsMap.put(permission.getIdentity(), strPer.toString().split(","));
        }
        return permissionsMap;
    }

    private Node getRootTaxonomyDef(String repository) throws RepositoryException, RepositoryConfigurationException {
        ManageableRepository manaRepository = this.repositoryService_.getRepository(repository);
        DMSRepositoryConfiguration dmsRepoConfig = this.dmsConfiguration_.getConfig(repository);
        Session systemSession = this.getSession(manaRepository, dmsRepoConfig.getSystemWorkspace(), true);
        String taxonomiesTreeDef = this.nodeHierarchyCreator_.getJcrPath("exoTaxoTreesDefinitionPath");
        Node taxonomyRootDef = (Node)systemSession.getItem(taxonomiesTreeDef);
        systemSession.logout();
        return taxonomyRootDef;
    }

    private Session getSession(ManageableRepository manageRepository, String workspaceName, boolean system) throws RepositoryException {
        if (system) {
            return this.providerService_.getSystemSessionProvider(null).getSession(workspaceName, manageRepository);
        }
        return this.providerService_.getSessionProvider(null).getSession(workspaceName, manageRepository);
    }

    public void start() {
        try {
            for (TaxonomyPlugin plugin : this.plugins_) {
                plugin.init();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
        }
    }

    public void stop() {
    }
}

