/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.deployment.plugins;

import java.io.InputStream;
import java.util.Iterator;
import javax.jcr.Session;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.deployment.DeploymentDescriptor;
import org.exoplatform.services.deployment.DeploymentPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class XMLDeploymentPlugin
extends DeploymentPlugin {
    private InitParams initParams;
    private ConfigurationManager configurationManager;
    private RepositoryService repositoryService;
    private Log log = ExoLogger.getLogger(((Object)((Object)this)).getClass());

    public XMLDeploymentPlugin(InitParams initParams, ConfigurationManager configurationManager, RepositoryService repositoryService) {
        this.initParams = initParams;
        this.configurationManager = configurationManager;
        this.repositoryService = repositoryService;
    }

    public void deploy(SessionProvider sessionProvider) throws Exception {
        Iterator iterator = this.initParams.getObjectParamIterator();
        while (iterator.hasNext()) {
            ObjectParameter objectParameter = (ObjectParameter)iterator.next();
            DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)objectParameter.getObject();
            String sourcePath = deploymentDescriptor.getSourcePath();
            InputStream inputStream = this.configurationManager.getInputStream(sourcePath);
            ManageableRepository repository = this.repositoryService.getRepository(deploymentDescriptor.getTarget().getRepository());
            Session session = sessionProvider.getSession(deploymentDescriptor.getTarget().getWorkspace(), repository);
            session.importXML(deploymentDescriptor.getTarget().getNodePath(), inputStream, 0);
            session.save();
            session.logout();
            if (!this.log.isInfoEnabled()) continue;
            this.log.info((Object)(deploymentDescriptor.getSourcePath() + " is deployed succesfully into " + deploymentDescriptor.getTarget().getNodePath()));
        }
    }
}

