/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.util.Iterator;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.pom.data.PortalData;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIGrid;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="app:/groovy/portal/webui/portal/UIChangePortal.gtmpl", events={@EventConfig(listeners={UIMaskWorkspace.CloseActionListener.class})}), @ComponentConfig(id="PortalSelector", type=UIGrid.class, template="app:/groovy/portal/webui/portal/UIPortalSelector.gtmpl")})
public class UIPortalSelector
extends UIContainer {
    public static String[] BEAN_FEILD = new String[]{"creator", "name", "skin"};
    public static String[] SELECT_ACTIONS = new String[]{"SelectPortal"};

    public UIPortalSelector() throws Exception {
        this.setName("UIChangePortal");
        UIGrid uiGrid = (UIGrid)this.addChild(UIGrid.class, "PortalSelector", null);
        uiGrid.configure("name", BEAN_FEILD, SELECT_ACTIONS);
        uiGrid.getUIPageIterator().setId("ChangePortalPageInterator");
        this.addChild((UIComponent)uiGrid.getUIPageIterator());
        uiGrid.getUIPageIterator().setRendered(false);
        DataStorage dataService = (DataStorage)this.getApplicationComponent(DataStorage.class);
        Query query = new Query(null, null, null, null, PortalData.class);
        LazyPageList<PortalData> pageList = dataService.find(query);
        pageList.setPageSize(10);
        pageList = this.extractPermissedPortal(pageList);
        uiGrid.getUIPageIterator().setPageList(pageList);
    }

    private LazyPageList<PortalData> extractPermissedPortal(LazyPageList<PortalData> pageList) throws Exception {
        UserACL userACL = (UserACL)this.getApplicationComponent(UserACL.class);
        Iterator itr = pageList.getAll().iterator();
        while (itr.hasNext()) {
            PortalData pConfig = (PortalData)itr.next();
            if (userACL.hasPermission(new PortalConfig(pConfig))) continue;
            itr.remove();
        }
        return pageList;
    }
}

