/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Header;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Buffer;
import org.jgroups.util.Headers;
import org.jgroups.util.Marshaller;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
implements Externalizable,
Streamable {
    protected Address dest_addr = null;
    protected Address src_addr = null;
    private byte[] buf = null;
    protected transient int offset = 0;
    protected transient int length = 0;
    protected Headers headers;
    protected static final Log log = LogFactory.getLog(Message.class);
    private static final long serialVersionUID = 7966206671974139740L;
    static final byte DEST_SET = 1;
    static final byte SRC_SET = 2;
    static final byte BUF_SET = 4;
    static final byte IPADDR_DEST = 16;
    static final byte IPADDR_SRC = 32;
    static final byte SRC_HOST_NULL = 64;
    public static final byte OOB = 1;
    public static final byte LOW_PRIO = 2;
    public static final byte HIGH_PRIO = 4;
    private byte flags = 0;
    static final Set<Class> nonStreamableHeaders = new HashSet<Class>();

    public Message(Address dest) {
        this.setDest(dest);
        this.headers = Message.createHeaders(3);
    }

    public Message(Address dest, Address src, byte[] buf) {
        this(dest);
        this.setSrc(src);
        this.setBuffer(buf);
    }

    public Message(Address dest, Address src, byte[] buf, int offset, int length) {
        this(dest);
        this.setSrc(src);
        this.setBuffer(buf, offset, length);
    }

    public Message(Address dest, Address src, Serializable obj) {
        this(dest);
        this.setSrc(src);
        this.setObject(obj);
    }

    public Message() {
        this.headers = Message.createHeaders(3);
    }

    public Message(boolean create_headers) {
        if (create_headers) {
            this.headers = Message.createHeaders(3);
        }
    }

    public Address getDest() {
        return this.dest_addr;
    }

    public void setDest(Address new_dest) {
        this.dest_addr = new_dest;
    }

    public Address getSrc() {
        return this.src_addr;
    }

    public void setSrc(Address new_src) {
        this.src_addr = new_src;
    }

    public byte[] getRawBuffer() {
        return this.buf;
    }

    public final byte[] getBuffer() {
        if (this.buf == null) {
            return null;
        }
        if (this.offset == 0 && this.length == this.buf.length) {
            return this.buf;
        }
        byte[] retval = new byte[this.length];
        System.arraycopy(this.buf, this.offset, retval, 0, this.length);
        return retval;
    }

    public final void setBuffer(byte[] b) {
        this.buf = b;
        if (this.buf != null) {
            this.offset = 0;
            this.length = this.buf.length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
    }

    public final void setBuffer(byte[] b, int offset, int length) {
        this.buf = b;
        if (this.buf != null) {
            if (offset < 0 || offset > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset);
            }
            if (offset + length > this.buf.length) {
                throw new ArrayIndexOutOfBoundsException(offset + length);
            }
            this.offset = offset;
            this.length = length;
        } else {
            this.length = 0;
            this.offset = 0;
        }
    }

    public final void setBuffer(Buffer buf) {
        if (buf != null) {
            this.buf = buf.getBuf();
            this.offset = buf.getOffset();
            this.length = buf.getLength();
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public Map<String, Header> getHeaders() {
        return this.headers.getHeaders();
    }

    public String printHeaders() {
        return this.headers.printHeaders();
    }

    public int getNumHeaders() {
        return this.headers.size();
    }

    public final void setObject(Serializable obj) {
        if (obj == null) {
            return;
        }
        try {
            byte[] tmp = Util.objectToByteBuffer(obj);
            this.setBuffer(tmp);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public final Object getObject() {
        try {
            return Util.objectFromByteBuffer(this.buf, this.offset, this.length);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void setFlag(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        this.flags = (byte)(this.flags | flag);
    }

    public void clearFlag(byte flag) {
        if (flag > 127 || flag < 0) {
            throw new IllegalArgumentException("flag has to be >= 0 and <= 127");
        }
        this.flags = (byte)(this.flags & ~flag);
    }

    public boolean isFlagSet(byte flag) {
        return (this.flags & flag) == flag;
    }

    public byte getFlags() {
        return this.flags;
    }

    public void putHeader(String key, Header hdr) {
        this.headers.putHeader(key, hdr);
    }

    public Header putHeaderIfAbsent(String key, Header hdr) {
        return this.headers.putHeaderIfAbsent(key, hdr);
    }

    public Header removeHeader(String key) {
        return this.getHeader(key);
    }

    public Header getHeader(String key) {
        return this.headers.getHeader(key);
    }

    public Message copy() {
        return this.copy(true);
    }

    public Message copy(boolean copy_buffer) {
        Message retval = new Message(false);
        retval.dest_addr = this.dest_addr;
        retval.src_addr = this.src_addr;
        retval.flags = this.flags;
        if (copy_buffer && this.buf != null) {
            retval.setBuffer(this.buf, this.offset, this.length);
        }
        retval.headers = Message.createHeaders(this.headers);
        return retval;
    }

    protected Object clone() throws CloneNotSupportedException {
        return this.copy();
    }

    public Message makeReply() {
        return new Message(this.src_addr);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(64);
        ret.append("[dst: ");
        if (this.dest_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.dest_addr);
        }
        ret.append(", src: ");
        if (this.src_addr == null) {
            ret.append("<null>");
        } else {
            ret.append(this.src_addr);
        }
        int size = this.getNumHeaders();
        if (size > 0) {
            ret.append(" (").append(size).append(" headers)");
        }
        ret.append(", size=");
        if (this.buf != null && this.length > 0) {
            ret.append(this.length);
        } else {
            ret.append('0');
        }
        ret.append(" bytes");
        if (this.flags > 0) {
            ret.append(", flags=").append(this.flagsToString());
        }
        ret.append(']');
        return ret.toString();
    }

    public String toStringAsObject() {
        if (this.buf == null) {
            return null;
        }
        try {
            Object obj = this.getObject();
            return obj != null ? obj.toString() : "";
        }
        catch (Exception e) {
            return "";
        }
    }

    public long size() {
        long retval = 2 + this.length + (this.buf != null ? 4 : 0);
        if (this.src_addr != null) {
            retval += (long)this.src_addr.size();
        }
        retval += 2L;
        return retval += (long)this.headers.marshalledSize();
    }

    public String printObjectHeaders() {
        return this.headers.printObjectHeaders();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.dest_addr != null) {
            out.writeBoolean(true);
            Marshaller.write(this.dest_addr, out);
        } else {
            out.writeBoolean(false);
        }
        if (this.src_addr != null) {
            out.writeBoolean(true);
            Marshaller.write(this.src_addr, out);
        } else {
            out.writeBoolean(false);
        }
        out.write(this.flags);
        if (this.buf == null) {
            out.writeInt(0);
        } else {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        int len = this.headers.size();
        out.writeInt(len);
        Object[] data = this.headers.getRawData();
        for (int i = 0; i < data.length; i += 2) {
            if (data[i] == null) continue;
            out.writeUTF((String)data[i]);
            Externalizable hdr = (Externalizable)data[i + 1];
            Marshaller.write(hdr, out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean srcAddressExist;
        boolean destAddressExist = in.readBoolean();
        if (destAddressExist) {
            this.dest_addr = (Address)Marshaller.read(in);
        }
        if (srcAddressExist = in.readBoolean()) {
            this.src_addr = (Address)Marshaller.read(in);
        }
        this.flags = in.readByte();
        int i = in.readInt();
        if (i != 0) {
            this.buf = new byte[i];
            in.readFully(this.buf);
            this.offset = 0;
            this.length = this.buf.length;
        }
        int len = in.readInt();
        while (len-- > 0) {
            String key = in.readUTF();
            Header value = (Header)Marshaller.read(in);
            this.headers.putHeader(key, value);
        }
    }

    @Override
    public void writeTo(DataOutputStream out) throws IOException {
        int leading = 0;
        if (this.src_addr != null) {
            leading = (byte)(leading + 2);
            if (this.src_addr instanceof IpAddress) {
                leading = (byte)(leading + 32);
                if (((IpAddress)this.src_addr).getIpAddress() == null) {
                    leading = (byte)(leading + 64);
                }
            }
        }
        if (this.buf != null) {
            leading = (byte)(leading + 4);
        }
        out.write(leading);
        out.write(this.flags);
        if (this.src_addr != null) {
            if (this.src_addr instanceof IpAddress) {
                this.src_addr.writeTo(out);
            } else {
                Util.writeAddress(this.src_addr, out);
            }
        }
        if (this.buf != null) {
            out.writeInt(this.length);
            out.write(this.buf, this.offset, this.length);
        }
        int size = this.headers.size();
        out.writeShort(size);
        Object[] data = this.headers.getRawData();
        for (int i = 0; i < data.length; i += 2) {
            if (data[i] == null) continue;
            out.writeUTF((String)data[i]);
            Message.writeHeader((Header)data[i + 1], out);
        }
    }

    @Override
    public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
        int len;
        byte leading = in.readByte();
        this.flags = in.readByte();
        if ((leading & 2) == 2) {
            if ((leading & 0x20) == 32) {
                this.src_addr = new IpAddress();
                this.src_addr.readFrom(in);
            } else {
                this.src_addr = Util.readAddress(in);
            }
        }
        if ((leading & 4) == 4) {
            len = in.readInt();
            this.buf = new byte[len];
            in.read(this.buf, 0, len);
            this.length = len;
        }
        len = in.readShort();
        this.headers = Message.createHeaders(len);
        Object[] data = this.headers.getRawData();
        int index = 0;
        for (int i = 0; i < len; ++i) {
            String hdr_name = in.readUTF();
            data[index++] = hdr_name;
            Header hdr = Message.readHeader(in);
            data[index++] = hdr;
        }
    }

    private String flagsToString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        if (this.isFlagSet((byte)1)) {
            first = false;
            sb.append("OOB");
        }
        if (this.isFlagSet((byte)2)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("LOW_PRIO");
        }
        if (this.isFlagSet((byte)4)) {
            if (!first) {
                sb.append("|");
            } else {
                first = false;
            }
            sb.append("HIGH_PRIO");
        }
        return sb.toString();
    }

    private static void writeHeader(Header value, DataOutputStream out) throws IOException {
        ObjectOutputStream oos = null;
        int size = value.size();
        try {
            short magic_number = ClassConfigurator.getInstance(false).getMagicNumber(value.getClass());
            out.writeShort(magic_number);
            if (magic_number == -1) {
                String classname = value.getClass().getName();
                out.writeUTF(classname);
                if (log.isWarnEnabled()) {
                    log.warn((Object)("magic number for " + classname + " not found, make sure you add your header to " + "jg-magic-map.xml, or register it programmatically with the ClassConfigurator"));
                }
            }
            out.writeShort(size);
            if (value instanceof Streamable) {
                ((Streamable)((Object)value)).writeTo(out);
            } else {
                oos = new ObjectOutputStream(out);
                value.writeExternal(oos);
                if (!nonStreamableHeaders.contains(value.getClass())) {
                    nonStreamableHeaders.add(value.getClass());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("encountered non-Streamable header: " + value.getClass()));
                    }
                }
            }
        }
        catch (ChannelException e) {
            IOException io_ex = new IOException("failed writing header");
            io_ex.initCause(e);
            throw io_ex;
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    private static Header readHeader(DataInputStream in) throws IOException {
        Header hdr;
        ObjectInputStream ois = null;
        try {
            Class clazz;
            short magic_number = in.readShort();
            if (magic_number != -1) {
                clazz = ClassConfigurator.getInstance(false).get(magic_number);
                if (clazz == null) {
                    throw new IllegalArgumentException("magic number " + magic_number + " is not available in magic map");
                }
            } else {
                String classname = in.readUTF();
                clazz = ClassConfigurator.getInstance(false).get(classname);
            }
            in.readShort();
            hdr = (Header)clazz.newInstance();
            if (hdr instanceof Streamable) {
                ((Streamable)((Object)hdr)).readFrom(in);
            } else {
                ois = new ObjectInputStream(in);
                hdr.readExternal(ois);
            }
        }
        catch (Exception ex) {
            IOException io_ex = new IOException("failed reading header");
            io_ex.initCause(ex);
            throw io_ex;
        }
        return hdr;
    }

    private static Headers createHeaders(int size) {
        return size > 0 ? new Headers(size) : new Headers(3);
    }

    private static Headers createHeaders(Headers m) {
        return new Headers(m);
    }
}

