/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.stack;

import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.Message;
import org.jgroups.stack.Interval;
import org.jgroups.stack.Retransmitter;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.TimeScheduler;

public class AckSenderWindow
implements Retransmitter.RetransmitCommand {
    RetransmitCommand retransmit_command = null;
    final ConcurrentMap<Long, Message> msgs = new ConcurrentHashMap<Long, Message>();
    Interval interval = new StaticInterval(400L, 800L, 1200L, 1600L);
    final Retransmitter retransmitter;
    static final Log log = LogFactory.getLog(AckSenderWindow.class);
    long lowest = 1L;

    public AckSenderWindow(RetransmitCommand com) {
        this.retransmit_command = com;
        this.retransmitter = new Retransmitter(null, this, null);
        this.retransmitter.setRetransmitTimeouts(this.interval);
    }

    public AckSenderWindow(RetransmitCommand com, Interval interval, TimeScheduler sched) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter = new Retransmitter(null, this, sched);
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public AckSenderWindow(RetransmitCommand com, Interval interval, TimeScheduler sched, Address sender) {
        this.retransmit_command = com;
        this.interval = interval;
        this.retransmitter = new Retransmitter(sender, this, sched);
        this.retransmitter.setRetransmitTimeouts(interval);
    }

    public synchronized long getLowest() {
        return this.lowest;
    }

    public void reset() {
        this.msgs.clear();
        this.retransmitter.reset();
        this.lowest = 1L;
    }

    public void add(long seqno, Message msg) {
        this.msgs.putIfAbsent(seqno, msg);
        this.retransmitter.add(seqno, seqno);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ack(long seqno) {
        AckSenderWindow ackSenderWindow = this;
        synchronized (ackSenderWindow) {
            if (seqno < this.lowest) {
                return;
            }
            long prev_lowest = this.lowest;
            this.lowest = Math.max(this.lowest, seqno + 1L);
        }
        for (long i = prev_lowest; i <= seqno; ++i) {
            this.msgs.remove(i);
            this.retransmitter.remove(i);
        }
    }

    public synchronized Message getLowestMessage() {
        return (Message)this.msgs.get(this.lowest);
    }

    public int size() {
        return this.msgs.size();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append(this.retransmitter.size()).append(" to retransmit): ");
        TreeSet keys = new TreeSet(this.msgs.keySet());
        if (!keys.isEmpty()) {
            sb.append(keys.first()).append(" - ").append(keys.last());
        } else {
            sb.append("[]");
        }
        return sb.toString();
    }

    public String printDetails() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.msgs.size()).append(" msgs (").append(this.retransmitter.size()).append(" to retransmit): ").append(new TreeSet(this.msgs.keySet()));
        return sb.toString();
    }

    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        if (this.retransmit_command != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)new StringBuilder("retransmitting messages ").append(first_seqno).append(" - ").append(last_seqno).append(" from ").append(sender));
            }
            for (long i = first_seqno; i <= last_seqno; ++i) {
                Message msg = (Message)this.msgs.get(i);
                if (msg == null) continue;
                this.retransmit_command.retransmit(i, msg);
            }
        }
    }

    public static interface RetransmitCommand {
        public void retransmit(long var1, Message var3);
    }
}

