/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.webdav.util;

import java.io.IOException;
import java.io.InputStream;

public class RangedInputStream
extends InputStream {
    private InputStream nativeInputStream;
    private long endRange;
    private long position = 0L;

    public RangedInputStream(InputStream nativeInputStream, long startRange, long endRange) throws IOException {
        this.nativeInputStream = nativeInputStream;
        this.endRange = endRange;
        byte[] buff = new byte[4096];
        while (this.position < startRange - 1L) {
            long readed;
            long needToRead = buff.length;
            if (needToRead > startRange - this.position) {
                needToRead = startRange - this.position;
            }
            if ((readed = (long)nativeInputStream.read(buff, 0, (int)needToRead)) < 0L) break;
            this.position += readed;
        }
    }

    public int read() throws IOException {
        if (this.position > this.endRange) {
            return -1;
        }
        int curReaded = this.nativeInputStream.read();
        if (curReaded >= 0) {
            ++this.position;
        }
        return curReaded;
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int size) throws IOException {
        long needsToRead = size;
        if (needsToRead > this.endRange - this.position + 1L) {
            needsToRead = this.endRange - this.position + 1L;
        }
        if (needsToRead == 0L) {
            return -1;
        }
        int curReaded = this.nativeInputStream.read(buffer, offset, (int)needsToRead);
        this.position += (long)curReaded;
        return curReaded;
    }

    public long skip(long skipVal) throws IOException {
        return this.nativeInputStream.skip(skipVal);
    }

    public int available() throws IOException {
        return this.nativeInputStream.available();
    }

    public void close() throws IOException {
        this.nativeInputStream.close();
    }

    public synchronized void mark(int markVal) {
        this.nativeInputStream.mark(markVal);
    }

    public synchronized void reset() throws IOException {
        this.nativeInputStream.reset();
    }

    public boolean markSupported() {
        return this.nativeInputStream.markSupported();
    }
}

