/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.link.LinkManager;
import org.exoplatform.services.cms.taxonomy.TaxonomyService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.NotInPublicationLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationPlugin;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.wcm.core.WCMService;
import org.exoplatform.services.wcm.publication.MessageDigester;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WCMComposerImpl
implements WCMComposer,
Startable {
    private RepositoryService repositoryService;
    private LinkManager linkManager;
    private PublicationService publicationService;
    private TaxonomyService taxonomyService;
    private TemplateService templateService;
    private WCMService wcmService;
    private ExoCache<String, Object> cache;
    private boolean isCached = true;
    private static Log log = ExoLogger.getLogger(WCMComposerImpl.class);
    private String templatesFilter;

    public WCMComposerImpl(InitParams params) throws Exception {
        ValueParam useCache;
        if (params != null && (useCache = params.getValueParam("useCache")) != null) {
            this.isCached = Boolean.parseBoolean(useCache.getValue());
        }
        this.repositoryService = (RepositoryService)WCMCoreUtils.getService(RepositoryService.class);
        this.linkManager = (LinkManager)WCMCoreUtils.getService(LinkManager.class);
        this.publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
        this.templateService = (TemplateService)WCMCoreUtils.getService(TemplateService.class);
        this.wcmService = (WCMService)WCMCoreUtils.getService(WCMService.class);
        this.cache = ((CacheService)WCMCoreUtils.getService(CacheService.class)).getCacheInstance("wcm.composer");
    }

    @Override
    public Node getContent(String repository, String workspace, String nodeIdentifier, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        String hash;
        Node cachedNode;
        String mode = filters.get("filter-mode");
        String version = filters.get("filter-version");
        String remoteUser = null;
        try {
            remoteUser = Util.getPortalRequestContext().getRemoteUser();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (repository == null && workspace == null) {
            String[] params = nodeIdentifier.split("/");
            repository = params[0];
            workspace = params[1];
            try {
                this.repositoryService.getRepository(repository);
                nodeIdentifier = nodeIdentifier.substring(repository.length() + workspace.length() + 1);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (nodeIdentifier.lastIndexOf("/") == 0) {
                nodeIdentifier = nodeIdentifier.substring(1);
            }
        }
        if ("Live".equals(mode) && this.isCached && (cachedNode = (Node)this.cache.get((Serializable)((Object)(hash = this.getHash(nodeIdentifier, version, remoteUser))))) != null) {
            return cachedNode;
        }
        Node node = null;
        try {
            node = this.wcmService.getReferencedContent(sessionProvider, repository, workspace, nodeIdentifier);
        }
        catch (RepositoryException e) {
            node = this.getNodeByCategory(nodeIdentifier);
        }
        if (version == null || !"base".equals(version)) {
            node = this.getViewableContent(node, filters);
        }
        if ("Live".equals(mode) && this.isCached) {
            String hash2 = this.getHash(nodeIdentifier, version, remoteUser);
            this.cache.remove((Serializable)((Object)hash2));
            this.cache.put((Serializable)((Object)hash2), (Object)node);
        }
        return node;
    }

    @Override
    public List<Node> getContents(String repository, String workspace, String path, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        String hash;
        List cachedNodes;
        String mode = filters.get("filter-mode");
        String version = filters.get("filter-version");
        String remoteUser = null;
        try {
            remoteUser = Util.getPortalRequestContext().getRemoteUser();
        }
        catch (Exception e) {
            // empty catch block
        }
        if ("Live".equals(mode) && this.isCached && (cachedNodes = (List)this.cache.get((Serializable)((Object)(hash = this.getHash(path, version, remoteUser))))) != null) {
            return cachedNodes;
        }
        NodeIterator nodeIterator = this.getViewableContents(repository, workspace, path, filters, sessionProvider);
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node node = null;
        Node viewNode = null;
        while (nodeIterator.hasNext()) {
            node = nodeIterator.nextNode();
            viewNode = this.getViewableContent(node, filters);
            if (viewNode == null) continue;
            nodes.add(viewNode);
        }
        if ("Live".equals(mode) && this.isCached) {
            String hash2 = this.getHash(path, version, remoteUser);
            this.cache.remove((Serializable)((Object)hash2));
            this.cache.put((Serializable)((Object)hash2), nodes);
        }
        return nodes;
    }

    private NodeIterator getViewableContents(String repository, String workspace, String path, HashMap<String, String> filters, SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService.getRepository(repository);
        Session session = sessionProvider.getSession(workspace, manageableRepository);
        QueryManager manager = session.getWorkspace().getQueryManager();
        String orderFilter = this.getOrderSQLFilter(filters);
        String recursive = filters.get("filter-recursive");
        String primaryType = filters.get("filter-primary-type");
        if (primaryType == null) {
            primaryType = "nt:base";
            Node currentFolder = session.getRootNode().getNode(path.substring(1));
            if (currentFolder.isNodeType("exo:taxonomy")) {
                primaryType = "exo:taxonomyLink";
            }
        }
        StringBuffer statement = new StringBuffer();
        statement.append("SELECT * FROM " + primaryType + " WHERE (jcr:path LIKE '" + path + "/%'");
        if (recursive == null) {
            statement.append(" AND NOT jcr:path LIKE '" + path + "/%/%')");
        }
        statement.append(" AND " + this.getTemplatesSQLFilter(repository));
        statement.append(orderFilter);
        Query query = manager.createQuery(statement.toString(), "sql");
        return query.execute().getNodes();
    }

    private Node getViewableContent(Node node, HashMap<String, String> filters) throws Exception {
        if (node.isNodeType("exo:taxonomyLink")) {
            try {
                node = this.linkManager.getTarget(node);
                return node;
            }
            catch (AccessDeniedException ade) {
                return null;
            }
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        String mode = filters.get("filter-mode");
        context.put("filter-mode", mode);
        String lifecyleName = null;
        try {
            lifecyleName = this.publicationService.getNodeLifecycleName(node);
        }
        catch (NotInPublicationLifecycleException e) {
            // empty catch block
        }
        if (lifecyleName == null) {
            return node;
        }
        PublicationPlugin publicationPlugin = this.publicationService.getPublicationPlugins().get(lifecyleName);
        Node viewNode = publicationPlugin.getNodeView(node, context);
        return viewNode;
    }

    @Override
    public boolean updateContent(String repository, String workspace, String path, HashMap<String, String> filters) throws Exception {
        if (this.isCached) {
            String oid;
            String remoteUser;
            String part;
            block10: {
                if (log.isInfoEnabled()) {
                    log.info((Object)("updateContent : " + path));
                }
                part = path.substring(0, path.lastIndexOf("/"));
                remoteUser = null;
                try {
                    remoteUser = Util.getPortalRequestContext().getRemoteUser();
                }
                catch (Exception e) {
                    // empty catch block
                }
                oid = null;
                SessionProvider sessionProvider = SessionProvider.createSystemProvider();
                try {
                    repository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
                    Node node = this.wcmService.getReferencedContent(sessionProvider, repository, workspace, path);
                    if (node != null) {
                        oid = node.getUUID();
                    }
                }
                catch (RepositoryException e) {
                    if (!log.isInfoEnabled()) break block10;
                    log.info((Object)("Can't find UUID for path : " + workspace + ":" + path));
                }
            }
            String hash = this.getHash(path, null);
            this.cache.remove((Serializable)((Object)hash));
            hash = this.getHash(path, "base");
            this.cache.remove((Serializable)((Object)hash));
            hash = this.getHash(part, null);
            this.cache.remove((Serializable)((Object)hash));
            if (oid != null) {
                hash = this.getHash(oid, null);
                this.cache.remove((Serializable)((Object)hash));
            }
            if (remoteUser != null) {
                hash = this.getHash(path, null, remoteUser);
                this.cache.remove((Serializable)((Object)hash));
                hash = this.getHash(path, "base", remoteUser);
                this.cache.remove((Serializable)((Object)hash));
                hash = this.getHash(part, null, remoteUser);
                this.cache.remove((Serializable)((Object)hash));
                if (oid != null) {
                    hash = this.getHash(oid, null, remoteUser);
                    this.cache.remove((Serializable)((Object)hash));
                }
            }
        }
        return true;
    }

    @Override
    public boolean updateContents(String repository, String workspace, String path, HashMap<String, String> filters) throws Exception {
        if (this.isCached) {
            String remoteUser = null;
            try {
                remoteUser = Util.getPortalRequestContext().getRemoteUser();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("updateContents : " + path));
            }
            String hash = this.getHash(path, null);
            this.cache.remove((Serializable)((Object)hash));
            hash = this.getHash(path, "base");
            this.cache.remove((Serializable)((Object)hash));
            if (remoteUser != null) {
                hash = this.getHash(path, null, remoteUser);
                this.cache.remove((Serializable)((Object)hash));
                hash = this.getHash(path, "base", remoteUser);
                this.cache.remove((Serializable)((Object)hash));
            }
        }
        return true;
    }

    @Override
    public List<String> getAllowedStates(String mode) {
        ArrayList<String> states = new ArrayList<String>();
        if ("Live".equals(mode)) {
            states.add("published");
        } else if ("Edit".equals(mode)) {
            states.add("published");
            states.add("draft");
            states.add("pending");
            states.add("staged");
            states.add("approved");
        }
        return states;
    }

    @Override
    public void cleanTemplates() throws Exception {
        this.templatesFilter = null;
        this.getTemplatesSQLFilter("repository");
        if (log.isInfoEnabled()) {
            log.info((Object)"WCMComposer templates have been cleaned !");
        }
    }

    public void start() {
    }

    public void stop() {
    }

    private String getOrderSQLFilter(HashMap<String, String> filters) {
        String orderQuery = " ORDER BY ";
        String orderBy = filters.get("filter-order-by");
        String orderType = filters.get("filter-order-type");
        if (orderType == null) {
            orderType = "DESC";
        }
        if (orderBy == null) {
            orderBy = "exo:title";
        }
        orderQuery = orderQuery + orderBy + " " + orderType;
        return orderQuery;
    }

    private String getTemplatesSQLFilter(String repository) {
        if (this.templatesFilter != null) {
            return this.templatesFilter;
        }
        try {
            List documentTypes = this.templateService.getDocumentTemplates(repository);
            StringBuffer documentTypeClause = new StringBuffer("(");
            for (int i = 0; i < documentTypes.size(); ++i) {
                String documentType = (String)documentTypes.get(i);
                documentTypeClause.append("jcr:primaryType = '" + documentType + "'");
                if (i == documentTypes.size() - 1) continue;
                documentTypeClause.append(" OR ");
            }
            this.templatesFilter = documentTypeClause.toString();
            this.templatesFilter = this.templatesFilter + " OR jcr:primaryType = 'exo:taxonomyLink')";
            return this.templatesFilter;
        }
        catch (Exception e) {
            log.error((Object)"Error when perform getTemlatesSQLFilter: ", (Throwable)e);
            return null;
        }
    }

    private Node getNodeByCategory(String parameters) throws Exception {
        try {
            String repository = this.repositoryService.getCurrentRepository().getConfiguration().getName();
            if (this.taxonomyService == null) {
                this.taxonomyService = (TaxonomyService)WCMCoreUtils.getService(TaxonomyService.class);
            }
            Node taxonomyTree = this.taxonomyService.getTaxonomyTree(repository, parameters.split("/")[0]);
            Node symlink = taxonomyTree.getNode(parameters.substring(parameters.indexOf("/") + 1));
            return this.linkManager.getTarget(symlink);
        }
        catch (Exception e) {
            return null;
        }
    }

    private String getHash(String path, String version, String remoteUser) throws Exception {
        String key = path;
        if (version != null) {
            key = key + "::" + version;
        }
        if (remoteUser != null) {
            key = key + ";;" + remoteUser;
        }
        return MessageDigester.getHash(key);
    }

    private String getHash(String path, String version) throws Exception {
        return this.getHash(path, version, null);
    }
}

