/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.page;

import org.exoplatform.container.ExoContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.page.UIDesktopPage;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.portal.UIPortalComponent;
import org.exoplatform.portal.webui.util.PortalDataMapper;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;

@ComponentConfig(template="system:/groovy/portal/webui/page/UIPageBody.gtmpl")
public class UIPageBody
extends UIComponentDecorator {
    private UIPortalComponent maximizedUIComponent;
    private String storageId;

    public UIPageBody(PageBody model) throws Exception {
        this.setId("UIPageBody");
    }

    public String getStorageId() {
        return this.storageId;
    }

    public void setStorageId(String storageId) {
        this.storageId = storageId;
    }

    public UIPageBody() throws Exception {
        this.setId("UIPageBody");
    }

    public void init(PageBody model) throws Exception {
        this.setId("UIPageBody");
    }

    public void setPageBody(PageNode pageNode, UIPortal uiPortal) throws Exception {
        UIPage uiPage;
        PortalRequestContext context = Util.getPortalRequestContext();
        ExoContainer appContainer = context.getApplication().getApplicationServiceContainer();
        UserPortalConfigService userPortalConfigService = (UserPortalConfigService)appContainer.getComponentInstanceOfType(UserPortalConfigService.class);
        Page page = null;
        String pageReference = null;
        if (pageNode != null) {
            pageReference = pageNode.getPageReference();
            try {
                if (pageReference != null) {
                    page = userPortalConfigService.getPage(pageReference, context.getRemoteUser());
                }
            }
            catch (Exception e) {
                UIPortalApplication uiApp = (UIPortalApplication)this.getAncestorOfType(UIPortalApplication.class);
                uiApp.addMessage(new ApplicationMessage(e.getMessage(), new Object[0]));
            }
        }
        uiPortal.setMaximizedUIComponent(null);
        try {
            uiPage = this.getUIPage(pageReference, page, uiPortal, context);
        }
        catch (Exception ex) {
            this.setUIComponent(null);
            return;
        }
        if (uiPage.isShowMaxWindow()) {
            uiPortal.setMaximizedUIComponent((UIComponent)uiPage);
        } else {
            Object maximizedComponent = uiPortal.getMaximizedUIComponent();
            if (maximizedComponent != null && maximizedComponent instanceof UIPage) {
                uiPortal.setMaximizedUIComponent(null);
            }
            if ((maximizedComponent = this.getMaximizedUIComponent()) != null && maximizedComponent instanceof UIPage) {
                this.setMaximizedUIComponent(null);
            }
        }
        this.setUIComponent((UIComponent)uiPage);
    }

    private UIPage getUIPage(String pageReference, Page page, UIPortal uiPortal, WebuiRequestContext context) throws Exception {
        if (page == null) {
            uiPortal.clearUIPage(pageReference);
            throw new Exception("The page with id " + pageReference + " has been removed");
        }
        UIPage uiPage = uiPortal.getUIPage(pageReference);
        if (uiPage != null) {
            return uiPage;
        }
        uiPage = "Desktop".equals(page.getFactoryId()) ? (UIPage)this.createUIComponent(context, UIDesktopPage.class, null, null) : (UIPage)this.createUIComponent(context, UIPage.class, null, null);
        PortalDataMapper.toUIPage(uiPage, page);
        uiPortal.setUIPage(page.getId(), uiPage);
        return uiPage;
    }

    public void renderChildren() throws Exception {
        this.uicomponent_.processRender((WebuiRequestContext)WebuiRequestContext.getCurrentInstance());
    }

    public void processRender(WebuiRequestContext context) throws Exception {
        if (this.maximizedUIComponent != null && Util.getUIPortalApplication().getModeState() % 2 == 0) {
            this.maximizedUIComponent.processRender((WebuiRequestContext)WebuiRequestContext.getCurrentInstance());
            return;
        }
        if (this.uicomponent_ == null) {
            this.setPageBody(Util.getUIPortal().getSelectedNode(), Util.getUIPortal());
        }
        super.processRender(context);
    }

    public UIPortalComponent getMaximizedUIComponent() {
        return this.maximizedUIComponent;
    }

    public void setMaximizedUIComponent(UIPortalComponent uiMaximizedComponent) {
        this.maximizedUIComponent = uiMaximizedComponent;
    }
}

