/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.Hashtable;
import java.util.Vector;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.LiteralStringObject;
import org.icepdf.core.pobjects.Reference;
import org.icepdf.core.pobjects.StringObject;
import org.icepdf.core.util.Library;

public class NameTree
extends Dictionary {
    private Node root;

    public NameTree(Library library, Hashtable hashtable) {
        super(library, hashtable);
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.root = new Node(this.library, this.entries);
        this.inited = true;
    }

    public void dispose() {
        this.root.dispose();
    }

    public Object searchName(String string) {
        return this.root.searchName(string);
    }

    static class Node
    extends Dictionary {
        private static Object NOT_FOUND = new Object();
        private static Object NOT_FOUND_IS_LESSER = new Object();
        private static Object NOT_FOUND_IS_GREATER = new Object();
        private boolean namesAreDecrypted;
        private Vector namesAndValues;
        private Vector kidsReferences;
        private Vector kidsNodes;
        private Object lowerLimit;
        private Object upperLimit;

        Node(Library library, Hashtable hashtable) {
            super(library, hashtable);
            Vector vector;
            Object object = this.library.getObject(this.entries, "Kids");
            if (object != null && object instanceof Vector) {
                this.kidsReferences = vector = (Vector)object;
                int n = this.kidsReferences.size();
                if (n > 0) {
                    this.kidsNodes = new Vector(n);
                    this.kidsNodes.setSize(n);
                }
            }
            this.namesAreDecrypted = false;
            object = this.library.getObject(this.entries, "Names");
            if (object != null && object instanceof Vector) {
                this.namesAndValues = (Vector)object;
            }
            if ((object = this.library.getObject(this.entries, "Limits")) != null && object instanceof Vector && (vector = (Vector)object).size() >= 2) {
                this.lowerLimit = this.decryptIfText(vector.get(0));
                this.upperLimit = this.decryptIfText(vector.get(1));
            }
        }

        private void ensureNamesDecrypted() {
            if (this.namesAreDecrypted) {
                return;
            }
            this.namesAreDecrypted = true;
            for (int i = 0; i < this.namesAndValues.size(); i += 2) {
                Object object = this.namesAndValues.get(i);
                object = this.decryptIfText(object);
                this.namesAndValues.set(i, object);
            }
        }

        private Object decryptIfText(Object object) {
            if (object instanceof StringObject) {
                StringObject stringObject = (StringObject)object;
                String string = stringObject.getDecryptedLiteralString(this.library.securityManager);
                return new LiteralStringObject(string);
            }
            return object;
        }

        Object searchName(String string) {
            Object object = this.search(string);
            if (object == NOT_FOUND || object == NOT_FOUND_IS_LESSER || object == NOT_FOUND_IS_GREATER) {
                object = null;
            }
            return object;
        }

        private Object search(String string) {
            if (this.kidsReferences != null) {
                int n;
                if (this.lowerLimit != null) {
                    n = this.lowerLimit.toString().compareTo(string);
                    if (n > 0) {
                        return NOT_FOUND_IS_LESSER;
                    }
                    if (n == 0) {
                        return this.getNode(0).search(string);
                    }
                }
                if (this.upperLimit != null) {
                    n = this.upperLimit.toString().compareTo(string);
                    if (n < 0) {
                        return NOT_FOUND_IS_GREATER;
                    }
                    if (n == 0) {
                        return this.getNode(this.kidsReferences.size() - 1).search(string);
                    }
                }
                return this.binarySearchKids(0, this.kidsReferences.size() - 1, string);
            }
            if (this.namesAndValues != null) {
                int n;
                int n2 = this.namesAndValues.size();
                if (this.lowerLimit != null) {
                    n = this.lowerLimit.toString().compareTo(string);
                    if (n > 0) {
                        return NOT_FOUND_IS_LESSER;
                    }
                    if (n == 0) {
                        this.ensureNamesDecrypted();
                        if (this.namesAndValues.get(0).toString().equals(string)) {
                            Object object = this.namesAndValues.get(1);
                            if (object instanceof Reference) {
                                object = this.library.getObject((Reference)object);
                            }
                            return object;
                        }
                    }
                }
                if (this.upperLimit != null) {
                    n = this.upperLimit.toString().compareTo(string);
                    if (n < 0) {
                        return NOT_FOUND_IS_GREATER;
                    }
                    if (n == 0) {
                        this.ensureNamesDecrypted();
                        if (this.namesAndValues.get(n2 - 2).toString().equals(string)) {
                            Object object = this.namesAndValues.get(n2 - 1);
                            if (object instanceof Reference) {
                                object = this.library.getObject((Reference)object);
                            }
                            return object;
                        }
                    }
                }
                this.ensureNamesDecrypted();
                Object object = this.binarySearchNames(0, n2 - 1, string);
                if (object == NOT_FOUND || object == NOT_FOUND_IS_LESSER || object == NOT_FOUND_IS_GREATER) {
                    object = null;
                }
                return object;
            }
            return null;
        }

        private Object binarySearchKids(int n, int n2, String string) {
            if (n > n2) {
                return NOT_FOUND;
            }
            int n3 = n + (n2 - n) / 2;
            Object object = this.getNode(n3).search(string);
            if (object == NOT_FOUND_IS_LESSER) {
                return this.binarySearchKids(n, n3 - 1, string);
            }
            if (object == NOT_FOUND_IS_GREATER) {
                return this.binarySearchKids(n3 + 1, n2, string);
            }
            if (object == NOT_FOUND) {
                for (int i = n; i <= n2; ++i) {
                    Object object2;
                    if (i == n3 || (object2 = this.getNode(i).search(string)) == NOT_FOUND || object2 == NOT_FOUND_IS_LESSER || object2 == NOT_FOUND_IS_GREATER) continue;
                    object = object2;
                    break;
                }
            }
            return object;
        }

        private Object binarySearchNames(int n, int n2, String string) {
            if (n > n2) {
                return NOT_FOUND;
            }
            int n3 = n + (n2 - n) / 2;
            int n4 = this.namesAndValues.get(n3 &= 0xFFFFFFFE).toString().compareTo(string);
            if (n4 == 0) {
                Object object = this.namesAndValues.get(n3 + 1);
                if (object instanceof Reference) {
                    object = this.library.getObject((Reference)object);
                }
                return object;
            }
            if (n4 > 0) {
                return this.binarySearchNames(n, n3 - 1, string);
            }
            if (n4 < 0) {
                return this.binarySearchNames(n3 + 2, n2, string);
            }
            return NOT_FOUND;
        }

        private Node getNode(int n) {
            Node node = (Node)this.kidsNodes.get(n);
            if (node == null) {
                Reference reference = (Reference)this.kidsReferences.get(n);
                Hashtable hashtable = (Hashtable)this.library.getObject(reference);
                node = new Node(this.library, hashtable);
                this.kidsNodes.set(n, node);
            }
            return node;
        }

        public void dispose() {
            if (this.namesAndValues != null) {
                this.namesAndValues.clear();
            }
            if (this.kidsReferences != null) {
                this.kidsReferences.clear();
            }
            if (this.kidsNodes != null) {
                this.kidsNodes.clear();
            }
        }
    }
}

