/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts.ofont;

import java.util.Hashtable;

public class Encoding
implements org.icepdf.core.pobjects.fonts.Encoding {
    private char[] enc;
    private static Hashtable h;
    private static char[] se;
    private static char[] mre;
    private static char[] wae;
    private static char[] pde;
    private static char[] sym;
    private static char[] zap;
    public static int[][] symbolAlaises;
    public static int[] registeredAlaises;

    private Encoding(char[] cArray) {
        this.enc = cArray;
    }

    public char get(char c) {
        if (c >= '\u0000' && c < '\u0100') {
            char c2 = this.enc[c];
            return c2;
        }
        return c;
    }

    static Encoding getStandard() {
        return new Encoding(se);
    }

    static Encoding getMacRoman() {
        return new Encoding(mre);
    }

    static Encoding getWinAnsi() {
        return new Encoding(wae);
    }

    public static Encoding getPDFDoc() {
        return new Encoding(pde);
    }

    static Encoding getSymbol() {
        return new Encoding(sym);
    }

    static Encoding getZapfDingBats() {
        return new Encoding(zap);
    }

    static int getUV(String string) {
        Integer n = (Integer)h.get(string);
        if (n != null) {
            return n;
        }
        if (string.startsWith("G")) {
            try {
                String string2 = string.substring(1);
                int n2 = Integer.parseInt(string2);
                return n2;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return -1;
    }

    /*
     * Opcode count of 20955 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        symbolAlaises = new int[][]{{183, 61623, 8226}, {169, 61667, 61651, 63721, 63193}, {174, 61650, 61666, 61614}, {80, 8364}};
        registeredAlaises = new int[]{182};
        h = new Hashtable(1046);
        h.put("A", new Integer(65));
        h.put("AE", new Integer(198));
        h.put("AEacute", new Integer(508));
        h.put("AEsmall", new Integer(63462));
        h.put("Aacute", new Integer(193));
        h.put("Aacutesmall", new Integer(63457));
        h.put("Abreve", new Integer(258));
        h.put("Acircumflex", new Integer(194));
        h.put("Acircumflexsmall", new Integer(63458));
        h.put("Acute", new Integer(63177));
        h.put("Acutesmall", new Integer(63412));
        h.put("Adieresis", new Integer(196));
        h.put("Adieresissmall", new Integer(63460));
        h.put("Agrave", new Integer(192));
        h.put("Agravesmall", new Integer(63456));
        h.put("Alpha", new Integer(913));
        h.put("Alphatonos", new Integer(902));
        h.put("Amacron", new Integer(256));
        h.put("Aogonek", new Integer(260));
        h.put("Aring", new Integer(197));
        h.put("Aringacute", new Integer(506));
        h.put("Aringsmall", new Integer(63461));
        h.put("Asmall", new Integer(63329));
        h.put("Atilde", new Integer(195));
        h.put("Atildesmall", new Integer(63459));
        h.put("B", new Integer(66));
        h.put("Beta", new Integer(914));
        h.put("Brevesmall", new Integer(63220));
        h.put("Bsmall", new Integer(63330));
        h.put("C", new Integer(67));
        h.put("Cacute", new Integer(262));
        h.put("Caron", new Integer(63178));
        h.put("Caronsmall", new Integer(63221));
        h.put("Ccaron", new Integer(268));
        h.put("Ccedilla", new Integer(199));
        h.put("Ccedillasmall", new Integer(63463));
        h.put("Ccircumflex", new Integer(264));
        h.put("Cdotaccent", new Integer(266));
        h.put("Cedillasmall", new Integer(63416));
        h.put("Chi", new Integer(935));
        h.put("Circumflexsmall", new Integer(63222));
        h.put("Csmall", new Integer(63331));
        h.put("D", new Integer(68));
        h.put("Dcaron", new Integer(270));
        h.put("Dcroat", new Integer(272));
        h.put("Delta", new Integer(8710));
        h.put("Delta", new Integer(916));
        h.put("Dieresis", new Integer(63179));
        h.put("DieresisAcute", new Integer(63180));
        h.put("DieresisGrave", new Integer(63181));
        h.put("Dieresissmall", new Integer(63400));
        h.put("Dotaccentsmall", new Integer(63223));
        h.put("Dsmall", new Integer(63332));
        h.put("E", new Integer(69));
        h.put("Eacute", new Integer(201));
        h.put("Eacutesmall", new Integer(63465));
        h.put("Ebreve", new Integer(276));
        h.put("Ecaron", new Integer(282));
        h.put("Ecircumflex", new Integer(202));
        h.put("Ecircumflexsmall", new Integer(63466));
        h.put("Edieresis", new Integer(203));
        h.put("Edieresissmall", new Integer(63467));
        h.put("Edotaccent", new Integer(278));
        h.put("Egrave", new Integer(200));
        h.put("Egravesmall", new Integer(63464));
        h.put("Emacron", new Integer(274));
        h.put("Eng", new Integer(330));
        h.put("Eogonek", new Integer(280));
        h.put("Epsilon", new Integer(917));
        h.put("Epsilontonos", new Integer(904));
        h.put("Esmall", new Integer(63333));
        h.put("Eta", new Integer(919));
        h.put("Etatonos", new Integer(905));
        h.put("Eth", new Integer(208));
        h.put("Ethsmall", new Integer(63472));
        h.put("Euro", new Integer(8364));
        h.put("F", new Integer(70));
        h.put("Fsmall", new Integer(63334));
        h.put("G", new Integer(71));
        h.put("Gamma", new Integer(915));
        h.put("Gbreve", new Integer(286));
        h.put("Gcaron", new Integer(486));
        h.put("Gcircumflex", new Integer(284));
        h.put("Gcommaaccent", new Integer(290));
        h.put("Gdotaccent", new Integer(288));
        h.put("Grave", new Integer(63182));
        h.put("Gravesmall", new Integer(63328));
        h.put("Gsmall", new Integer(63335));
        h.put("H", new Integer(72));
        h.put("H18533", new Integer(9679));
        h.put("H18543", new Integer(9642));
        h.put("H18551", new Integer(9643));
        h.put("H22073", new Integer(9633));
        h.put("Hbar", new Integer(294));
        h.put("Hcircumflex", new Integer(292));
        h.put("Hsmall", new Integer(63336));
        h.put("Hungarumlaut", new Integer(63183));
        h.put("Hungarumlautsmall", new Integer(63224));
        h.put("I", new Integer(73));
        h.put("IJ", new Integer(306));
        h.put("Iacute", new Integer(205));
        h.put("Iacutesmall", new Integer(63469));
        h.put("Ibreve", new Integer(300));
        h.put("Icircumflex", new Integer(206));
        h.put("Icircumflexsmall", new Integer(63470));
        h.put("Idieresis", new Integer(207));
        h.put("Idieresissmall", new Integer(63471));
        h.put("Idotaccent", new Integer(304));
        h.put("Ifraktur", new Integer(8465));
        h.put("Igrave", new Integer(204));
        h.put("Igravesmall", new Integer(63468));
        h.put("Imacron", new Integer(298));
        h.put("Iogonek", new Integer(302));
        h.put("Iota", new Integer(921));
        h.put("Iotadieresis", new Integer(938));
        h.put("Iotatonos", new Integer(906));
        h.put("Ismall", new Integer(63337));
        h.put("Itilde", new Integer(296));
        h.put("J", new Integer(74));
        h.put("Jcircumflex", new Integer(308));
        h.put("Jsmall", new Integer(63338));
        h.put("K", new Integer(75));
        h.put("Kappa", new Integer(922));
        h.put("Kcommaaccent", new Integer(310));
        h.put("Ksmall", new Integer(63339));
        h.put("L", new Integer(76));
        h.put("LL", new Integer(63167));
        h.put("Lacute", new Integer(313));
        h.put("Lambda", new Integer(923));
        h.put("Lcaron", new Integer(317));
        h.put("Lcommaaccent", new Integer(315));
        h.put("Ldot", new Integer(319));
        h.put("Lslash", new Integer(321));
        h.put("Lslashsmall", new Integer(63225));
        h.put("Lsmall", new Integer(63340));
        h.put("M", new Integer(77));
        h.put("Macron", new Integer(63184));
        h.put("Macronsmall", new Integer(63407));
        h.put("Msmall", new Integer(63341));
        h.put("Mu", new Integer(924));
        h.put("N", new Integer(78));
        h.put("Nacute", new Integer(323));
        h.put("Ncaron", new Integer(327));
        h.put("Ncommaaccent", new Integer(325));
        h.put("Nsmall", new Integer(63342));
        h.put("Ntilde", new Integer(209));
        h.put("Ntildesmall", new Integer(63473));
        h.put("Nu", new Integer(925));
        h.put("O", new Integer(79));
        h.put("OE", new Integer(338));
        h.put("OEsmall", new Integer(63226));
        h.put("Oacute", new Integer(211));
        h.put("Oacutesmall", new Integer(63475));
        h.put("Obreve", new Integer(334));
        h.put("Ocircumflex", new Integer(212));
        h.put("Ocircumflexsmall", new Integer(63476));
        h.put("Odieresis", new Integer(214));
        h.put("Odieresissmall", new Integer(63478));
        h.put("Ogoneksmall", new Integer(63227));
        h.put("Ograve", new Integer(210));
        h.put("Ogravesmall", new Integer(63474));
        h.put("Ohorn", new Integer(416));
        h.put("Ohungarumlaut", new Integer(336));
        h.put("Omacron", new Integer(332));
        h.put("Omega", new Integer(8486));
        h.put("Omega", new Integer(937));
        h.put("Omegatonos", new Integer(911));
        h.put("Omicron", new Integer(927));
        h.put("Omicrontonos", new Integer(908));
        h.put("Oslash", new Integer(216));
        h.put("Oslashacute", new Integer(510));
        h.put("Oslashsmall", new Integer(63480));
        h.put("Osmall", new Integer(63343));
        h.put("Otilde", new Integer(213));
        h.put("Otildesmall", new Integer(63477));
        h.put("P", new Integer(80));
        h.put("Phi", new Integer(934));
        h.put("Pi", new Integer(928));
        h.put("Psi", new Integer(936));
        h.put("Psmall", new Integer(63344));
        h.put("Q", new Integer(81));
        h.put("Qsmall", new Integer(63345));
        h.put("R", new Integer(82));
        h.put("Racute", new Integer(340));
        h.put("Rcaron", new Integer(344));
        h.put("Rcommaaccent", new Integer(342));
        h.put("Rfraktur", new Integer(8476));
        h.put("Rho", new Integer(929));
        h.put("Ringsmall", new Integer(63228));
        h.put("Rsmall", new Integer(63346));
        h.put("S", new Integer(83));
        h.put("SF010000", new Integer(9484));
        h.put("SF020000", new Integer(9492));
        h.put("SF030000", new Integer(9488));
        h.put("SF040000", new Integer(9496));
        h.put("SF050000", new Integer(9532));
        h.put("SF060000", new Integer(9516));
        h.put("SF070000", new Integer(9524));
        h.put("SF080000", new Integer(9500));
        h.put("SF090000", new Integer(9508));
        h.put("SF100000", new Integer(9472));
        h.put("SF110000", new Integer(9474));
        h.put("SF190000", new Integer(9569));
        h.put("SF200000", new Integer(9570));
        h.put("SF210000", new Integer(9558));
        h.put("SF220000", new Integer(9557));
        h.put("SF230000", new Integer(9571));
        h.put("SF240000", new Integer(9553));
        h.put("SF250000", new Integer(9559));
        h.put("SF260000", new Integer(9565));
        h.put("SF270000", new Integer(9564));
        h.put("SF280000", new Integer(9563));
        h.put("SF360000", new Integer(9566));
        h.put("SF370000", new Integer(9567));
        h.put("SF380000", new Integer(9562));
        h.put("SF390000", new Integer(9556));
        h.put("SF400000", new Integer(9577));
        h.put("SF410000", new Integer(9574));
        h.put("SF420000", new Integer(9568));
        h.put("SF430000", new Integer(9552));
        h.put("SF440000", new Integer(9580));
        h.put("SF450000", new Integer(9575));
        h.put("SF460000", new Integer(9576));
        h.put("SF470000", new Integer(9572));
        h.put("SF480000", new Integer(9573));
        h.put("SF490000", new Integer(9561));
        h.put("SF500000", new Integer(9560));
        h.put("SF510000", new Integer(9554));
        h.put("SF520000", new Integer(9555));
        h.put("SF530000", new Integer(9579));
        h.put("SF540000", new Integer(9578));
        h.put("Sacute", new Integer(346));
        h.put("Scaron", new Integer(352));
        h.put("Scaronsmall", new Integer(63229));
        h.put("Scedilla", new Integer(350));
        h.put("Scedilla", new Integer(63169));
        h.put("Scircumflex", new Integer(348));
        h.put("Scommaaccent", new Integer(536));
        h.put("Sigma", new Integer(931));
        h.put("Ssmall", new Integer(63347));
        h.put("T", new Integer(84));
        h.put("Tau", new Integer(932));
        h.put("Tbar", new Integer(358));
        h.put("Tcaron", new Integer(356));
        h.put("Tcommaaccent", new Integer(354));
        h.put("Tcommaaccent", new Integer(538));
        h.put("Theta", new Integer(920));
        h.put("Thorn", new Integer(222));
        h.put("Thornsmall", new Integer(63486));
        h.put("Tildesmall", new Integer(63230));
        h.put("Tsmall", new Integer(63348));
        h.put("U", new Integer(85));
        h.put("Uacute", new Integer(218));
        h.put("Uacutesmall", new Integer(63482));
        h.put("Ubreve", new Integer(364));
        h.put("Ucircumflex", new Integer(219));
        h.put("Ucircumflexsmall", new Integer(63483));
        h.put("Udieresis", new Integer(220));
        h.put("Udieresissmall", new Integer(63484));
        h.put("Ugrave", new Integer(217));
        h.put("Ugravesmall", new Integer(63481));
        h.put("Uhorn", new Integer(431));
        h.put("Uhungarumlaut", new Integer(368));
        h.put("Umacron", new Integer(362));
        h.put("Uogonek", new Integer(370));
        h.put("Upsilon", new Integer(933));
        h.put("Upsilon1", new Integer(978));
        h.put("Upsilondieresis", new Integer(939));
        h.put("Upsilontonos", new Integer(910));
        h.put("Uring", new Integer(366));
        h.put("Usmall", new Integer(63349));
        h.put("Utilde", new Integer(360));
        h.put("V", new Integer(86));
        h.put("Vsmall", new Integer(63350));
        h.put("W", new Integer(87));
        h.put("Wacute", new Integer(7810));
        h.put("Wcircumflex", new Integer(372));
        h.put("Wdieresis", new Integer(7812));
        h.put("Wgrave", new Integer(7808));
        h.put("Wsmall", new Integer(63351));
        h.put("X", new Integer(88));
        h.put("Xi", new Integer(926));
        h.put("Xsmall", new Integer(63352));
        h.put("Y", new Integer(89));
        h.put("Yacute", new Integer(221));
        h.put("Yacutesmall", new Integer(63485));
        h.put("Ycircumflex", new Integer(374));
        h.put("Ydieresis", new Integer(376));
        h.put("Ydieresissmall", new Integer(63487));
        h.put("Ygrave", new Integer(7922));
        h.put("Ysmall", new Integer(63353));
        h.put("Z", new Integer(90));
        h.put("Zacute", new Integer(377));
        h.put("Zcaron", new Integer(381));
        h.put("Zcaronsmall", new Integer(63231));
        h.put("Zdotaccent", new Integer(379));
        h.put("Zeta", new Integer(918));
        h.put("Zsmall", new Integer(63354));
        h.put("a", new Integer(97));
        h.put("aacute", new Integer(225));
        h.put("abreve", new Integer(259));
        h.put("acircumflex", new Integer(226));
        h.put("acute", new Integer(180));
        h.put("acutecomb", new Integer(769));
        h.put("adieresis", new Integer(228));
        h.put("ae", new Integer(230));
        h.put("aeacute", new Integer(509));
        h.put("afii00208", new Integer(8213));
        h.put("afii10017", new Integer(1040));
        h.put("afii10018", new Integer(1041));
        h.put("afii10019", new Integer(1042));
        h.put("afii10020", new Integer(1043));
        h.put("afii10021", new Integer(1044));
        h.put("afii10022", new Integer(1045));
        h.put("afii10023", new Integer(1025));
        h.put("afii10024", new Integer(1046));
        h.put("afii10025", new Integer(1047));
        h.put("afii10026", new Integer(1048));
        h.put("afii10027", new Integer(1049));
        h.put("afii10028", new Integer(1050));
        h.put("afii10029", new Integer(1051));
        h.put("afii10030", new Integer(1052));
        h.put("afii10031", new Integer(1053));
        h.put("afii10032", new Integer(1054));
        h.put("afii10033", new Integer(1055));
        h.put("afii10034", new Integer(1056));
        h.put("afii10035", new Integer(1057));
        h.put("afii10036", new Integer(1058));
        h.put("afii10037", new Integer(1059));
        h.put("afii10038", new Integer(1060));
        h.put("afii10039", new Integer(1061));
        h.put("afii10040", new Integer(1062));
        h.put("afii10041", new Integer(1063));
        h.put("afii10042", new Integer(1064));
        h.put("afii10043", new Integer(1065));
        h.put("afii10044", new Integer(1066));
        h.put("afii10045", new Integer(1067));
        h.put("afii10046", new Integer(1068));
        h.put("afii10047", new Integer(1069));
        h.put("afii10048", new Integer(1070));
        h.put("afii10049", new Integer(1071));
        h.put("afii10050", new Integer(1168));
        h.put("afii10051", new Integer(1026));
        h.put("afii10052", new Integer(1027));
        h.put("afii10053", new Integer(1028));
        h.put("afii10054", new Integer(1029));
        h.put("afii10055", new Integer(1030));
        h.put("afii10056", new Integer(1031));
        h.put("afii10057", new Integer(1032));
        h.put("afii10058", new Integer(1033));
        h.put("afii10059", new Integer(1034));
        h.put("afii10060", new Integer(1035));
        h.put("afii10061", new Integer(1036));
        h.put("afii10062", new Integer(1038));
        h.put("afii10063", new Integer(63172));
        h.put("afii10064", new Integer(63173));
        h.put("afii10065", new Integer(1072));
        h.put("afii10066", new Integer(1073));
        h.put("afii10067", new Integer(1074));
        h.put("afii10068", new Integer(1075));
        h.put("afii10069", new Integer(1076));
        h.put("afii10070", new Integer(1077));
        h.put("afii10071", new Integer(1105));
        h.put("afii10072", new Integer(1078));
        h.put("afii10073", new Integer(1079));
        h.put("afii10074", new Integer(1080));
        h.put("afii10075", new Integer(1081));
        h.put("afii10076", new Integer(1082));
        h.put("afii10077", new Integer(1083));
        h.put("afii10078", new Integer(1084));
        h.put("afii10079", new Integer(1085));
        h.put("afii10080", new Integer(1086));
        h.put("afii10081", new Integer(1087));
        h.put("afii10082", new Integer(1088));
        h.put("afii10083", new Integer(1089));
        h.put("afii10084", new Integer(1090));
        h.put("afii10085", new Integer(1091));
        h.put("afii10086", new Integer(1092));
        h.put("afii10087", new Integer(1093));
        h.put("afii10088", new Integer(1094));
        h.put("afii10089", new Integer(1095));
        h.put("afii10090", new Integer(1096));
        h.put("afii10091", new Integer(1097));
        h.put("afii10092", new Integer(1098));
        h.put("afii10093", new Integer(1099));
        h.put("afii10094", new Integer(1100));
        h.put("afii10095", new Integer(1101));
        h.put("afii10096", new Integer(1102));
        h.put("afii10097", new Integer(1103));
        h.put("afii10098", new Integer(1169));
        h.put("afii10099", new Integer(1106));
        h.put("afii10100", new Integer(1107));
        h.put("afii10101", new Integer(1108));
        h.put("afii10102", new Integer(1109));
        h.put("afii10103", new Integer(1110));
        h.put("afii10104", new Integer(1111));
        h.put("afii10105", new Integer(1112));
        h.put("afii10106", new Integer(1113));
        h.put("afii10107", new Integer(1114));
        h.put("afii10108", new Integer(1115));
        h.put("afii10109", new Integer(1116));
        h.put("afii10110", new Integer(1118));
        h.put("afii10145", new Integer(1039));
        h.put("afii10146", new Integer(1122));
        h.put("afii10147", new Integer(1138));
        h.put("afii10148", new Integer(1140));
        h.put("afii10192", new Integer(63174));
        h.put("afii10193", new Integer(1119));
        h.put("afii10194", new Integer(1123));
        h.put("afii10195", new Integer(1139));
        h.put("afii10196", new Integer(1141));
        h.put("afii10831", new Integer(63175));
        h.put("afii10832", new Integer(63176));
        h.put("afii10846", new Integer(1241));
        h.put("afii299", new Integer(8206));
        h.put("afii300", new Integer(8207));
        h.put("afii301", new Integer(8205));
        h.put("afii57381", new Integer(1642));
        h.put("afii57388", new Integer(1548));
        h.put("afii57392", new Integer(1632));
        h.put("afii57393", new Integer(1633));
        h.put("afii57394", new Integer(1634));
        h.put("afii57395", new Integer(1635));
        h.put("afii57396", new Integer(1636));
        h.put("afii57397", new Integer(1637));
        h.put("afii57398", new Integer(1638));
        h.put("afii57399", new Integer(1639));
        h.put("afii57400", new Integer(1640));
        h.put("afii57401", new Integer(1641));
        h.put("afii57403", new Integer(1563));
        h.put("afii57407", new Integer(1567));
        h.put("afii57409", new Integer(1569));
        h.put("afii57410", new Integer(1570));
        h.put("afii57411", new Integer(1571));
        h.put("afii57412", new Integer(1572));
        h.put("afii57413", new Integer(1573));
        h.put("afii57414", new Integer(1574));
        h.put("afii57415", new Integer(1575));
        h.put("afii57416", new Integer(1576));
        h.put("afii57417", new Integer(1577));
        h.put("afii57418", new Integer(1578));
        h.put("afii57419", new Integer(1579));
        h.put("afii57420", new Integer(1580));
        h.put("afii57421", new Integer(1581));
        h.put("afii57422", new Integer(1582));
        h.put("afii57423", new Integer(1583));
        h.put("afii57424", new Integer(1584));
        h.put("afii57425", new Integer(1585));
        h.put("afii57426", new Integer(1586));
        h.put("afii57427", new Integer(1587));
        h.put("afii57428", new Integer(1588));
        h.put("afii57429", new Integer(1589));
        h.put("afii57430", new Integer(1590));
        h.put("afii57431", new Integer(1591));
        h.put("afii57432", new Integer(1592));
        h.put("afii57433", new Integer(1593));
        h.put("afii57434", new Integer(1594));
        h.put("afii57440", new Integer(1600));
        h.put("afii57441", new Integer(1601));
        h.put("afii57442", new Integer(1602));
        h.put("afii57443", new Integer(1603));
        h.put("afii57444", new Integer(1604));
        h.put("afii57445", new Integer(1605));
        h.put("afii57446", new Integer(1606));
        h.put("afii57448", new Integer(1608));
        h.put("afii57449", new Integer(1609));
        h.put("afii57450", new Integer(1610));
        h.put("afii57451", new Integer(1611));
        h.put("afii57452", new Integer(1612));
        h.put("afii57453", new Integer(1613));
        h.put("afii57454", new Integer(1614));
        h.put("afii57455", new Integer(1615));
        h.put("afii57456", new Integer(1616));
        h.put("afii57457", new Integer(1617));
        h.put("afii57458", new Integer(1618));
        h.put("afii57470", new Integer(1607));
        h.put("afii57505", new Integer(1700));
        h.put("afii57506", new Integer(1662));
        h.put("afii57507", new Integer(1670));
        h.put("afii57508", new Integer(1688));
        h.put("afii57509", new Integer(1711));
        h.put("afii57511", new Integer(1657));
        h.put("afii57512", new Integer(1672));
        h.put("afii57513", new Integer(1681));
        h.put("afii57514", new Integer(1722));
        h.put("afii57519", new Integer(1746));
        h.put("afii57534", new Integer(1749));
        h.put("afii57636", new Integer(8362));
        h.put("afii57645", new Integer(1470));
        h.put("afii57658", new Integer(1475));
        h.put("afii57664", new Integer(1488));
        h.put("afii57665", new Integer(1489));
        h.put("afii57666", new Integer(1490));
        h.put("afii57667", new Integer(1491));
        h.put("afii57668", new Integer(1492));
        h.put("afii57669", new Integer(1493));
        h.put("afii57670", new Integer(1494));
        h.put("afii57671", new Integer(1495));
        h.put("afii57672", new Integer(1496));
        h.put("afii57673", new Integer(1497));
        h.put("afii57674", new Integer(1498));
        h.put("afii57675", new Integer(1499));
        h.put("afii57676", new Integer(1500));
        h.put("afii57677", new Integer(1501));
        h.put("afii57678", new Integer(1502));
        h.put("afii57679", new Integer(1503));
        h.put("afii57680", new Integer(1504));
        h.put("afii57681", new Integer(1505));
        h.put("afii57682", new Integer(1506));
        h.put("afii57683", new Integer(1507));
        h.put("afii57684", new Integer(1508));
        h.put("afii57685", new Integer(1509));
        h.put("afii57686", new Integer(1510));
        h.put("afii57687", new Integer(1511));
        h.put("afii57688", new Integer(1512));
        h.put("afii57689", new Integer(1513));
        h.put("afii57690", new Integer(1514));
        h.put("afii57694", new Integer(64298));
        h.put("afii57695", new Integer(64299));
        h.put("afii57700", new Integer(64331));
        h.put("afii57705", new Integer(64287));
        h.put("afii57716", new Integer(1520));
        h.put("afii57717", new Integer(1521));
        h.put("afii57718", new Integer(1522));
        h.put("afii57723", new Integer(64309));
        h.put("afii57793", new Integer(1460));
        h.put("afii57794", new Integer(1461));
        h.put("afii57795", new Integer(1462));
        h.put("afii57796", new Integer(1467));
        h.put("afii57797", new Integer(1464));
        h.put("afii57798", new Integer(1463));
        h.put("afii57799", new Integer(1456));
        h.put("afii57800", new Integer(1458));
        h.put("afii57801", new Integer(1457));
        h.put("afii57802", new Integer(1459));
        h.put("afii57803", new Integer(1474));
        h.put("afii57804", new Integer(1473));
        h.put("afii57806", new Integer(1465));
        h.put("afii57807", new Integer(1468));
        h.put("afii57839", new Integer(1469));
        h.put("afii57841", new Integer(1471));
        h.put("afii57842", new Integer(1472));
        h.put("afii57929", new Integer(700));
        h.put("afii61248", new Integer(8453));
        h.put("afii61289", new Integer(8467));
        h.put("afii61352", new Integer(8470));
        h.put("afii61573", new Integer(8236));
        h.put("afii61574", new Integer(8237));
        h.put("afii61575", new Integer(8238));
        h.put("afii61664", new Integer(8204));
        h.put("afii63167", new Integer(1645));
        h.put("afii64937", new Integer(701));
        h.put("agrave", new Integer(224));
        h.put("aleph", new Integer(8501));
        h.put("alpha", new Integer(945));
        h.put("alphatonos", new Integer(940));
        h.put("amacron", new Integer(257));
        h.put("ampersand", new Integer(38));
        h.put("ampersandsmall", new Integer(63270));
        h.put("angle", new Integer(8736));
        h.put("angleleft", new Integer(9001));
        h.put("angleright", new Integer(9002));
        h.put("anoteleia", new Integer(903));
        h.put("aogonek", new Integer(261));
        h.put("approxequal", new Integer(8776));
        h.put("aring", new Integer(229));
        h.put("aringacute", new Integer(507));
        h.put("arrowboth", new Integer(8596));
        h.put("arrowdblboth", new Integer(8660));
        h.put("arrowdbldown", new Integer(8659));
        h.put("arrowdblleft", new Integer(8656));
        h.put("arrowdblright", new Integer(8658));
        h.put("arrowdblup", new Integer(8657));
        h.put("arrowdown", new Integer(8595));
        h.put("arrowhorizex", new Integer(63719));
        h.put("arrowleft", new Integer(8592));
        h.put("arrowright", new Integer(8594));
        h.put("arrowup", new Integer(8593));
        h.put("arrowupdn", new Integer(8597));
        h.put("arrowupdnbse", new Integer(8616));
        h.put("arrowvertex", new Integer(63718));
        h.put("asciicircum", new Integer(94));
        h.put("asciitilde", new Integer(126));
        h.put("asterisk", new Integer(42));
        h.put("asteriskmath", new Integer(8727));
        h.put("asuperior", new Integer(63209));
        h.put("at", new Integer(64));
        h.put("atilde", new Integer(227));
        h.put("b", new Integer(98));
        h.put("backslash", new Integer(92));
        h.put("bar", new Integer(124));
        h.put("beta", new Integer(946));
        h.put("block", new Integer(9608));
        h.put("braceex", new Integer(63732));
        h.put("braceleft", new Integer(123));
        h.put("braceleftbt", new Integer(63731));
        h.put("braceleftmid", new Integer(63730));
        h.put("bracelefttp", new Integer(63729));
        h.put("braceright", new Integer(125));
        h.put("bracerightbt", new Integer(63742));
        h.put("bracerightmid", new Integer(63741));
        h.put("bracerighttp", new Integer(63740));
        h.put("bracketleft", new Integer(91));
        h.put("bracketleftbt", new Integer(63728));
        h.put("bracketleftex", new Integer(63727));
        h.put("bracketlefttp", new Integer(63726));
        h.put("bracketright", new Integer(93));
        h.put("bracketrightbt", new Integer(63739));
        h.put("bracketrightex", new Integer(63738));
        h.put("bracketrighttp", new Integer(63737));
        h.put("breve", new Integer(728));
        h.put("brokenbar", new Integer(166));
        h.put("bsuperior", new Integer(63210));
        h.put("bullet", new Integer(8226));
        h.put("c", new Integer(99));
        h.put("cacute", new Integer(263));
        h.put("caron", new Integer(711));
        h.put("carriagereturn", new Integer(8629));
        h.put("ccaron", new Integer(269));
        h.put("ccedilla", new Integer(231));
        h.put("ccircumflex", new Integer(265));
        h.put("cdotaccent", new Integer(267));
        h.put("cedilla", new Integer(184));
        h.put("cent", new Integer(162));
        h.put("centinferior", new Integer(63199));
        h.put("centoldstyle", new Integer(63394));
        h.put("centsuperior", new Integer(63200));
        h.put("chi", new Integer(967));
        h.put("circle", new Integer(9675));
        h.put("circlemultiply", new Integer(8855));
        h.put("circleplus", new Integer(8853));
        h.put("circumflex", new Integer(710));
        h.put("club", new Integer(9827));
        h.put("colon", new Integer(58));
        h.put("colonmonetary", new Integer(8353));
        h.put("comma", new Integer(44));
        h.put("commaaccent", new Integer(63171));
        h.put("commainferior", new Integer(63201));
        h.put("commasuperior", new Integer(63202));
        h.put("congruent", new Integer(8773));
        h.put("copyright", new Integer(169));
        h.put("copyrightsans", new Integer(63721));
        h.put("copyrightserif", new Integer(63193));
        h.put("currency", new Integer(164));
        h.put("cyrBreve", new Integer(63185));
        h.put("cyrFlex", new Integer(63186));
        h.put("cyrbreve", new Integer(63188));
        h.put("cyrflex", new Integer(63189));
        h.put("d", new Integer(100));
        h.put("dagger", new Integer(8224));
        h.put("daggerdbl", new Integer(8225));
        h.put("dblGrave", new Integer(63187));
        h.put("dblgrave", new Integer(63190));
        h.put("dcaron", new Integer(271));
        h.put("dcroat", new Integer(273));
        h.put("degree", new Integer(176));
        h.put("delta", new Integer(948));
        h.put("diamond", new Integer(9830));
        h.put("dieresis", new Integer(168));
        h.put("dieresisacute", new Integer(63191));
        h.put("dieresisgrave", new Integer(63192));
        h.put("dieresistonos", new Integer(901));
        h.put("divide", new Integer(247));
        h.put("dkshade", new Integer(9619));
        h.put("dnblock", new Integer(9604));
        h.put("dollar", new Integer(36));
        h.put("dollarinferior", new Integer(63203));
        h.put("dollaroldstyle", new Integer(63268));
        h.put("dollarsuperior", new Integer(63204));
        h.put("dong", new Integer(8363));
        h.put("dotaccent", new Integer(729));
        h.put("dotbelowcomb", new Integer(803));
        h.put("dotlessi", new Integer(305));
        h.put("dotlessj", new Integer(63166));
        h.put("dotmath", new Integer(8901));
        h.put("dsuperior", new Integer(63211));
        h.put("e", new Integer(101));
        h.put("eacute", new Integer(233));
        h.put("ebreve", new Integer(277));
        h.put("ecaron", new Integer(283));
        h.put("ecircumflex", new Integer(234));
        h.put("edieresis", new Integer(235));
        h.put("edotaccent", new Integer(279));
        h.put("egrave", new Integer(232));
        h.put("eight", new Integer(56));
        h.put("eightinferior", new Integer(8328));
        h.put("eightoldstyle", new Integer(63288));
        h.put("eightsuperior", new Integer(8312));
        h.put("element", new Integer(8712));
        h.put("ellipsis", new Integer(8230));
        h.put("emacron", new Integer(275));
        h.put("emdash", new Integer(8212));
        h.put("emptyset", new Integer(8709));
        h.put("endash", new Integer(8211));
        h.put("eng", new Integer(331));
        h.put("eogonek", new Integer(281));
        h.put("epsilon", new Integer(949));
        h.put("epsilontonos", new Integer(941));
        h.put("equal", new Integer(61));
        h.put("equivalence", new Integer(8801));
        h.put("estimated", new Integer(8494));
        h.put("esuperior", new Integer(63212));
        h.put("eta", new Integer(951));
        h.put("etatonos", new Integer(942));
        h.put("eth", new Integer(240));
        h.put("exclam", new Integer(33));
        h.put("exclamdbl", new Integer(8252));
        h.put("exclamdown", new Integer(161));
        h.put("exclamdownsmall", new Integer(63393));
        h.put("exclamsmall", new Integer(63265));
        h.put("existential", new Integer(8707));
        h.put("f", new Integer(102));
        h.put("female", new Integer(9792));
        h.put("ff", new Integer(64256));
        h.put("ffi", new Integer(64259));
        h.put("ffl", new Integer(64260));
        h.put("fi", new Integer(64257));
        h.put("figuredash", new Integer(8210));
        h.put("filledbox", new Integer(9632));
        h.put("filledrect", new Integer(9644));
        h.put("five", new Integer(53));
        h.put("fiveeighths", new Integer(8541));
        h.put("fiveinferior", new Integer(8325));
        h.put("fiveoldstyle", new Integer(63285));
        h.put("fivesuperior", new Integer(8309));
        h.put("fl", new Integer(64258));
        h.put("florin", new Integer(402));
        h.put("four", new Integer(52));
        h.put("fourinferior", new Integer(8324));
        h.put("fouroldstyle", new Integer(63284));
        h.put("foursuperior", new Integer(8308));
        h.put("fraction", new Integer(8260));
        h.put("fraction", new Integer(8725));
        h.put("franc", new Integer(8355));
        h.put("g", new Integer(103));
        h.put("gamma", new Integer(947));
        h.put("gbreve", new Integer(287));
        h.put("gcaron", new Integer(487));
        h.put("gcircumflex", new Integer(285));
        h.put("gcommaaccent", new Integer(291));
        h.put("gdotaccent", new Integer(289));
        h.put("germandbls", new Integer(223));
        h.put("gradient", new Integer(8711));
        h.put("grave", new Integer(96));
        h.put("gravecomb", new Integer(768));
        h.put("greater", new Integer(62));
        h.put("greaterequal", new Integer(8805));
        h.put("guillemotleft", new Integer(171));
        h.put("guillemotright", new Integer(187));
        h.put("guilsinglleft", new Integer(8249));
        h.put("guilsinglright", new Integer(8250));
        h.put("h", new Integer(104));
        h.put("hbar", new Integer(295));
        h.put("hcircumflex", new Integer(293));
        h.put("heart", new Integer(9829));
        h.put("hookabovecomb", new Integer(777));
        h.put("house", new Integer(8962));
        h.put("hungarumlaut", new Integer(733));
        h.put("hyphen", new Integer(45));
        h.put("hypheninferior", new Integer(63205));
        h.put("hyphensuperior", new Integer(63206));
        h.put("i", new Integer(105));
        h.put("iacute", new Integer(237));
        h.put("ibreve", new Integer(301));
        h.put("icircumflex", new Integer(238));
        h.put("idieresis", new Integer(239));
        h.put("igrave", new Integer(236));
        h.put("ij", new Integer(307));
        h.put("imacron", new Integer(299));
        h.put("infinity", new Integer(8734));
        h.put("integral", new Integer(8747));
        h.put("integralbt", new Integer(8993));
        h.put("integralex", new Integer(63733));
        h.put("integraltp", new Integer(8992));
        h.put("intersection", new Integer(8745));
        h.put("invbullet", new Integer(9688));
        h.put("invcircle", new Integer(9689));
        h.put("invsmileface", new Integer(9787));
        h.put("iogonek", new Integer(303));
        h.put("iota", new Integer(953));
        h.put("iotadieresis", new Integer(970));
        h.put("iotadieresistonos", new Integer(912));
        h.put("iotatonos", new Integer(943));
        h.put("isuperior", new Integer(63213));
        h.put("itilde", new Integer(297));
        h.put("j", new Integer(106));
        h.put("jcircumflex", new Integer(309));
        h.put("k", new Integer(107));
        h.put("kappa", new Integer(954));
        h.put("kcommaaccent", new Integer(311));
        h.put("kgreenlandic", new Integer(312));
        h.put("l", new Integer(108));
        h.put("lacute", new Integer(314));
        h.put("lambda", new Integer(955));
        h.put("lcaron", new Integer(318));
        h.put("lcommaaccent", new Integer(316));
        h.put("ldot", new Integer(320));
        h.put("less", new Integer(60));
        h.put("lessequal", new Integer(8804));
        h.put("lfblock", new Integer(9612));
        h.put("lira", new Integer(8356));
        h.put("ll", new Integer(63168));
        h.put("logicaland", new Integer(8743));
        h.put("logicalnot", new Integer(172));
        h.put("logicalor", new Integer(8744));
        h.put("longs", new Integer(383));
        h.put("lozenge", new Integer(9674));
        h.put("lslash", new Integer(322));
        h.put("lsuperior", new Integer(63214));
        h.put("ltshade", new Integer(9617));
        h.put("m", new Integer(109));
        h.put("macron", new Integer(175));
        h.put("male", new Integer(9794));
        h.put("minus", new Integer(8722));
        h.put("minute", new Integer(8242));
        h.put("msuperior", new Integer(63215));
        h.put("mu", new Integer(181));
        h.put("multiply", new Integer(215));
        h.put("musicalnote", new Integer(9834));
        h.put("musicalnotedbl", new Integer(9835));
        h.put("n", new Integer(110));
        h.put("nacute", new Integer(324));
        h.put("napostrophe", new Integer(329));
        h.put("ncaron", new Integer(328));
        h.put("ncommaaccent", new Integer(326));
        h.put("nine", new Integer(57));
        h.put("nineinferior", new Integer(8329));
        h.put("nineoldstyle", new Integer(63289));
        h.put("ninesuperior", new Integer(8313));
        h.put("notelement", new Integer(8713));
        h.put("notequal", new Integer(8800));
        h.put("notsubset", new Integer(8836));
        h.put("nsuperior", new Integer(8319));
        h.put("ntilde", new Integer(241));
        h.put("nu", new Integer(957));
        h.put("numbersign", new Integer(35));
        h.put("o", new Integer(111));
        h.put("oacute", new Integer(243));
        h.put("obreve", new Integer(335));
        h.put("ocircumflex", new Integer(244));
        h.put("odieresis", new Integer(246));
        h.put("oe", new Integer(339));
        h.put("ogonek", new Integer(731));
        h.put("ograve", new Integer(242));
        h.put("ohorn", new Integer(417));
        h.put("ohungarumlaut", new Integer(337));
        h.put("omacron", new Integer(333));
        h.put("omega", new Integer(969));
        h.put("omega1", new Integer(982));
        h.put("omegatonos", new Integer(974));
        h.put("omicron", new Integer(959));
        h.put("omicrontonos", new Integer(972));
        h.put("one", new Integer(49));
        h.put("onedotenleader", new Integer(8228));
        h.put("oneeighth", new Integer(8539));
        h.put("onefitted", new Integer(63196));
        h.put("onehalf", new Integer(189));
        h.put("oneinferior", new Integer(8321));
        h.put("oneoldstyle", new Integer(63281));
        h.put("onequarter", new Integer(188));
        h.put("onesuperior", new Integer(185));
        h.put("onethird", new Integer(8531));
        h.put("openbullet", new Integer(9702));
        h.put("ordfeminine", new Integer(170));
        h.put("ordmasculine", new Integer(186));
        h.put("orthogonal", new Integer(8735));
        h.put("oslash", new Integer(248));
        h.put("oslashacute", new Integer(511));
        h.put("osuperior", new Integer(63216));
        h.put("otilde", new Integer(245));
        h.put("p", new Integer(112));
        h.put("paragraph", new Integer(182));
        h.put("parenleft", new Integer(40));
        h.put("parenleftbt", new Integer(63725));
        h.put("parenleftex", new Integer(63724));
        h.put("parenleftinferior", new Integer(8333));
        h.put("parenleftsuperior", new Integer(8317));
        h.put("parenlefttp", new Integer(63723));
        h.put("parenright", new Integer(41));
        h.put("parenrightbt", new Integer(63736));
        h.put("parenrightex", new Integer(63735));
        h.put("parenrightinferior", new Integer(8334));
        h.put("parenrightsuperior", new Integer(8318));
        h.put("parenrighttp", new Integer(63734));
        h.put("partialdiff", new Integer(8706));
        h.put("percent", new Integer(37));
        h.put("period", new Integer(46));
        h.put("periodcentered", new Integer(183));
        h.put("periodcentered", new Integer(8729));
        h.put("periodinferior", new Integer(63207));
        h.put("periodsuperior", new Integer(63208));
        h.put("perpendicular", new Integer(8869));
        h.put("perthousand", new Integer(8240));
        h.put("peseta", new Integer(8359));
        h.put("phi", new Integer(966));
        h.put("phi1", new Integer(981));
        h.put("pi", new Integer(960));
        h.put("plus", new Integer(43));
        h.put("plusminus", new Integer(177));
        h.put("prescription", new Integer(8478));
        h.put("product", new Integer(8719));
        h.put("propersubset", new Integer(8834));
        h.put("propersuperset", new Integer(8835));
        h.put("proportional", new Integer(8733));
        h.put("psi", new Integer(968));
        h.put("q", new Integer(113));
        h.put("question", new Integer(63));
        h.put("questiondown", new Integer(191));
        h.put("questiondownsmall", new Integer(63423));
        h.put("questionsmall", new Integer(63295));
        h.put("quotedbl", new Integer(34));
        h.put("quotedblbase", new Integer(8222));
        h.put("quotedblleft", new Integer(8220));
        h.put("quotedblright", new Integer(8221));
        h.put("quoteleft", new Integer(8216));
        h.put("quotereversed", new Integer(8219));
        h.put("quoteright", new Integer(8217));
        h.put("quotesinglbase", new Integer(8218));
        h.put("quotesingle", new Integer(39));
        h.put("r", new Integer(114));
        h.put("racute", new Integer(341));
        h.put("radical", new Integer(8730));
        h.put("radicalex", new Integer(63717));
        h.put("rcaron", new Integer(345));
        h.put("rcommaaccent", new Integer(343));
        h.put("reflexsubset", new Integer(8838));
        h.put("reflexsuperset", new Integer(8839));
        h.put("registered", new Integer(174));
        h.put("registersans", new Integer(63720));
        h.put("registerserif", new Integer(63194));
        h.put("revlogicalnot", new Integer(8976));
        h.put("rho", new Integer(961));
        h.put("ring", new Integer(730));
        h.put("rsuperior", new Integer(63217));
        h.put("rtblock", new Integer(9616));
        h.put("rupiah", new Integer(63197));
        h.put("s", new Integer(115));
        h.put("sacute", new Integer(347));
        h.put("scaron", new Integer(353));
        h.put("scedilla", new Integer(351));
        h.put("scedilla", new Integer(63170));
        h.put("scircumflex", new Integer(349));
        h.put("scommaaccent", new Integer(537));
        h.put("second", new Integer(8243));
        h.put("section", new Integer(167));
        h.put("semicolon", new Integer(59));
        h.put("seven", new Integer(55));
        h.put("seveneighths", new Integer(8542));
        h.put("seveninferior", new Integer(8327));
        h.put("sevenoldstyle", new Integer(63287));
        h.put("sevensuperior", new Integer(8311));
        h.put("shade", new Integer(9618));
        h.put("sigma", new Integer(963));
        h.put("sigma1", new Integer(962));
        h.put("similar", new Integer(8764));
        h.put("six", new Integer(54));
        h.put("sixinferior", new Integer(8326));
        h.put("sixoldstyle", new Integer(63286));
        h.put("sixsuperior", new Integer(8310));
        h.put("slash", new Integer(47));
        h.put("smileface", new Integer(9786));
        h.put("space", new Integer(32));
        h.put("spade", new Integer(9824));
        h.put("ssuperior", new Integer(63218));
        h.put("sterling", new Integer(163));
        h.put("suchthat", new Integer(8715));
        h.put("summation", new Integer(8721));
        h.put("sun", new Integer(9788));
        h.put("t", new Integer(116));
        h.put("tau", new Integer(964));
        h.put("tbar", new Integer(359));
        h.put("tcaron", new Integer(357));
        h.put("tcommaaccent", new Integer(355));
        h.put("tcommaaccent", new Integer(539));
        h.put("therefore", new Integer(8756));
        h.put("theta", new Integer(952));
        h.put("theta1", new Integer(977));
        h.put("thorn", new Integer(254));
        h.put("three", new Integer(51));
        h.put("threeeighths", new Integer(8540));
        h.put("threeinferior", new Integer(8323));
        h.put("threeoldstyle", new Integer(63283));
        h.put("threequarters", new Integer(190));
        h.put("threequartersemdash", new Integer(63198));
        h.put("threesuperior", new Integer(179));
        h.put("tilde", new Integer(732));
        h.put("tildecomb", new Integer(771));
        h.put("tonos", new Integer(900));
        h.put("trademark", new Integer(8482));
        h.put("trademarksans", new Integer(63722));
        h.put("trademarkserif", new Integer(63195));
        h.put("triagdn", new Integer(9660));
        h.put("triaglf", new Integer(9668));
        h.put("triagrt", new Integer(9658));
        h.put("triagup", new Integer(9650));
        h.put("tsuperior", new Integer(63219));
        h.put("two", new Integer(50));
        h.put("twodotenleader", new Integer(8229));
        h.put("twoinferior", new Integer(8322));
        h.put("twooldstyle", new Integer(63282));
        h.put("twosuperior", new Integer(178));
        h.put("twothirds", new Integer(8532));
        h.put("u", new Integer(117));
        h.put("uacute", new Integer(250));
        h.put("ubreve", new Integer(365));
        h.put("ucircumflex", new Integer(251));
        h.put("udieresis", new Integer(252));
        h.put("ugrave", new Integer(249));
        h.put("uhorn", new Integer(432));
        h.put("uhungarumlaut", new Integer(369));
        h.put("umacron", new Integer(363));
        h.put("underscore", new Integer(95));
        h.put("underscoredbl", new Integer(8215));
        h.put("union", new Integer(8746));
        h.put("universal", new Integer(8704));
        h.put("uogonek", new Integer(371));
        h.put("upblock", new Integer(9600));
        h.put("upsilon", new Integer(965));
        h.put("upsilondieresis", new Integer(971));
        h.put("upsilondieresistonos", new Integer(944));
        h.put("upsilontonos", new Integer(973));
        h.put("uring", new Integer(367));
        h.put("utilde", new Integer(361));
        h.put("v", new Integer(118));
        h.put("w", new Integer(119));
        h.put("wacute", new Integer(7811));
        h.put("wcircumflex", new Integer(373));
        h.put("wdieresis", new Integer(7813));
        h.put("weierstrass", new Integer(8472));
        h.put("wgrave", new Integer(7809));
        h.put("x", new Integer(120));
        h.put("xi", new Integer(958));
        h.put("y", new Integer(121));
        h.put("yacute", new Integer(253));
        h.put("ycircumflex", new Integer(375));
        h.put("ydieresis", new Integer(255));
        h.put("yen", new Integer(165));
        h.put("ygrave", new Integer(7923));
        h.put("z", new Integer(122));
        h.put("zacute", new Integer(378));
        h.put("zcaron", new Integer(382));
        h.put("zdotaccent", new Integer(380));
        h.put("zero", new Integer(48));
        h.put("zeroinferior", new Integer(8320));
        h.put("zerooldstyle", new Integer(63280));
        h.put("zerosuperior", new Integer(8304));
        h.put("zeta", new Integer(950));
        h.put("a1", new Integer(9985));
        h.put("a2", new Integer(9986));
        h.put("a202", new Integer(9987));
        h.put("a3", new Integer(9988));
        h.put("a4", new Integer(9742));
        h.put("a5", new Integer(9990));
        h.put("a119", new Integer(9991));
        h.put("a118", new Integer(9992));
        h.put("a117", new Integer(9993));
        h.put("a11", new Integer(9755));
        h.put("a12", new Integer(9758));
        h.put("a13", new Integer(9996));
        h.put("a14", new Integer(9997));
        h.put("a15", new Integer(9998));
        h.put("a16", new Integer(9999));
        h.put("a105", new Integer(10000));
        h.put("a17", new Integer(10001));
        h.put("a18", new Integer(10002));
        h.put("a19", new Integer(10003));
        h.put("a20", new Integer(10004));
        h.put("a21", new Integer(10005));
        h.put("a22", new Integer(10006));
        h.put("a23", new Integer(10007));
        h.put("a24", new Integer(10008));
        h.put("a25", new Integer(10009));
        h.put("a26", new Integer(10010));
        h.put("a27", new Integer(10011));
        h.put("a28", new Integer(10012));
        h.put("a6", new Integer(10013));
        h.put("a7", new Integer(10014));
        h.put("a8", new Integer(10015));
        h.put("a9", new Integer(10016));
        h.put("a10", new Integer(10017));
        h.put("a29", new Integer(10018));
        h.put("a30", new Integer(10019));
        h.put("a31", new Integer(10020));
        h.put("a32", new Integer(10021));
        h.put("a33", new Integer(10022));
        h.put("a34", new Integer(10023));
        h.put("a35", new Integer(9733));
        h.put("a36", new Integer(10025));
        h.put("a37", new Integer(10026));
        h.put("a38", new Integer(10027));
        h.put("a39", new Integer(10028));
        h.put("a40", new Integer(10029));
        h.put("a41", new Integer(10030));
        h.put("a42", new Integer(10031));
        h.put("a43", new Integer(10032));
        h.put("a44", new Integer(10033));
        h.put("a45", new Integer(10034));
        h.put("a46", new Integer(10035));
        h.put("a47", new Integer(10036));
        h.put("a48", new Integer(10037));
        h.put("a49", new Integer(10038));
        h.put("a50", new Integer(10039));
        h.put("a51", new Integer(10040));
        h.put("a52", new Integer(10041));
        h.put("a53", new Integer(10042));
        h.put("a54", new Integer(10043));
        h.put("a55", new Integer(10044));
        h.put("a56", new Integer(10045));
        h.put("a57", new Integer(10046));
        h.put("a58", new Integer(10047));
        h.put("a59", new Integer(10048));
        h.put("a60", new Integer(10049));
        h.put("a61", new Integer(10050));
        h.put("a62", new Integer(10051));
        h.put("a63", new Integer(10052));
        h.put("a64", new Integer(10053));
        h.put("a65", new Integer(10054));
        h.put("a66", new Integer(10055));
        h.put("a67", new Integer(10056));
        h.put("a68", new Integer(10057));
        h.put("a69", new Integer(10058));
        h.put("a70", new Integer(10059));
        h.put("a71", new Integer(9679));
        h.put("a72", new Integer(10061));
        h.put("a73", new Integer(9632));
        h.put("a74", new Integer(10063));
        h.put("a203", new Integer(10064));
        h.put("a75", new Integer(10065));
        h.put("a204", new Integer(10066));
        h.put("a76", new Integer(9650));
        h.put("a77", new Integer(9660));
        h.put("a78", new Integer(9670));
        h.put("a79", new Integer(10070));
        h.put("a81", new Integer(9687));
        h.put("a82", new Integer(10072));
        h.put("a83", new Integer(10073));
        h.put("a84", new Integer(10074));
        h.put("a97", new Integer(10075));
        h.put("a98", new Integer(10076));
        h.put("a99", new Integer(10077));
        h.put("a100", new Integer(10078));
        h.put("a89", new Integer(63703));
        h.put("a90", new Integer(63704));
        h.put("a93", new Integer(63705));
        h.put("a94", new Integer(63706));
        h.put("a91", new Integer(63707));
        h.put("a92", new Integer(63708));
        h.put("a205", new Integer(63709));
        h.put("a85", new Integer(63710));
        h.put("a206", new Integer(63711));
        h.put("a86", new Integer(63712));
        h.put("a87", new Integer(63713));
        h.put("a88", new Integer(63714));
        h.put("a95", new Integer(63715));
        h.put("a96", new Integer(63716));
        h.put("a101", new Integer(10081));
        h.put("a102", new Integer(10082));
        h.put("a103", new Integer(10083));
        h.put("a104", new Integer(10084));
        h.put("a106", new Integer(10085));
        h.put("a107", new Integer(10086));
        h.put("a108", new Integer(10087));
        h.put("a112", new Integer(9827));
        h.put("a111", new Integer(9830));
        h.put("a110", new Integer(9829));
        h.put("a109", new Integer(9824));
        h.put("a120", new Integer(9312));
        h.put("a121", new Integer(9313));
        h.put("a122", new Integer(9314));
        h.put("a123", new Integer(9315));
        h.put("a124", new Integer(9316));
        h.put("a125", new Integer(9317));
        h.put("a126", new Integer(9318));
        h.put("a127", new Integer(9319));
        h.put("a128", new Integer(9320));
        h.put("a129", new Integer(9321));
        h.put("a130", new Integer(10102));
        h.put("a131", new Integer(10103));
        h.put("a132", new Integer(10104));
        h.put("a133", new Integer(10105));
        h.put("a134", new Integer(10106));
        h.put("a135", new Integer(10107));
        h.put("a136", new Integer(10108));
        h.put("a137", new Integer(10109));
        h.put("a138", new Integer(10110));
        h.put("a139", new Integer(10111));
        h.put("a140", new Integer(10112));
        h.put("a141", new Integer(10113));
        h.put("a142", new Integer(10114));
        h.put("a143", new Integer(10115));
        h.put("a144", new Integer(10116));
        h.put("a145", new Integer(10117));
        h.put("a146", new Integer(10118));
        h.put("a147", new Integer(10119));
        h.put("a148", new Integer(10120));
        h.put("a149", new Integer(10121));
        h.put("a150", new Integer(10122));
        h.put("a151", new Integer(10123));
        h.put("a152", new Integer(10124));
        h.put("a153", new Integer(10125));
        h.put("a154", new Integer(10126));
        h.put("a155", new Integer(10127));
        h.put("a156", new Integer(10128));
        h.put("a157", new Integer(10129));
        h.put("a158", new Integer(10130));
        h.put("a159", new Integer(10131));
        h.put("a160", new Integer(10132));
        h.put("a161", new Integer(8594));
        h.put("a163", new Integer(8596));
        h.put("a164", new Integer(8597));
        h.put("a196", new Integer(10136));
        h.put("a165", new Integer(10137));
        h.put("a192", new Integer(10138));
        h.put("a166", new Integer(10139));
        h.put("a167", new Integer(10140));
        h.put("a168", new Integer(10141));
        h.put("a169", new Integer(10142));
        h.put("a170", new Integer(10143));
        h.put("a171", new Integer(10144));
        h.put("a172", new Integer(10145));
        h.put("a173", new Integer(10146));
        h.put("a162", new Integer(10147));
        h.put("a174", new Integer(10148));
        h.put("a175", new Integer(10149));
        h.put("a176", new Integer(10150));
        h.put("a177", new Integer(10151));
        h.put("a178", new Integer(10152));
        h.put("a179", new Integer(10153));
        h.put("a193", new Integer(10154));
        h.put("a180", new Integer(10155));
        h.put("a199", new Integer(10156));
        h.put("a181", new Integer(10157));
        h.put("a200", new Integer(10158));
        h.put("a182", new Integer(10159));
        h.put("a201", new Integer(10161));
        h.put("a183", new Integer(10162));
        h.put("a184", new Integer(10163));
        h.put("a197", new Integer(10164));
        h.put("a185", new Integer(10165));
        h.put("a194", new Integer(10166));
        h.put("a198", new Integer(10167));
        h.put("a186", new Integer(10168));
        h.put("a195", new Integer(10169));
        h.put("a187", new Integer(10170));
        h.put("a188", new Integer(10171));
        h.put("a189", new Integer(10172));
        h.put("a190", new Integer(10173));
        h.put("a191", new Integer(10174));
        h.put("apple", new Integer(32));
        se = new char[256];
        mre = new char[256];
        wae = new char[256];
        pde = new char[256];
        sym = new char[256];
        zap = new char[256];
        for (int i = 0; i < 256; ++i) {
            Encoding.se[i] = 63;
            Encoding.mre[i] = 63;
            Encoding.wae[i] = 63;
            if (i > 32) {
                Encoding.wae[i] = (char)((Integer)h.get("bullet")).intValue();
            }
            Encoding.pde[i] = 63;
            Encoding.sym[i] = 63;
            Encoding.zap[i] = 63;
        }
        Encoding.pde[24] = (char)((Integer)h.get("breve")).intValue();
        Encoding.pde[25] = (char)((Integer)h.get("caron")).intValue();
        Encoding.pde[26] = (char)((Integer)h.get("circumflex")).intValue();
        Encoding.pde[27] = (char)((Integer)h.get("dotaccent")).intValue();
        Encoding.pde[28] = (char)((Integer)h.get("hungarumlaut")).intValue();
        Encoding.pde[29] = (char)((Integer)h.get("ogonek")).intValue();
        Encoding.pde[30] = (char)((Integer)h.get("ring")).intValue();
        Encoding.pde[31] = (char)((Integer)h.get("tilde")).intValue();
        Encoding.se[32] = (char)((Integer)h.get("space")).intValue();
        Encoding.mre[32] = (char)((Integer)h.get("space")).intValue();
        Encoding.wae[32] = (char)((Integer)h.get("space")).intValue();
        Encoding.pde[32] = (char)((Integer)h.get("space")).intValue();
        Encoding.se[33] = (char)((Integer)h.get("exclam")).intValue();
        Encoding.mre[33] = (char)((Integer)h.get("exclam")).intValue();
        Encoding.wae[33] = (char)((Integer)h.get("exclam")).intValue();
        Encoding.pde[33] = (char)((Integer)h.get("exclam")).intValue();
        Encoding.se[34] = (char)((Integer)h.get("quotedbl")).intValue();
        Encoding.mre[34] = (char)((Integer)h.get("quotedbl")).intValue();
        Encoding.wae[34] = (char)((Integer)h.get("quotedbl")).intValue();
        Encoding.pde[34] = (char)((Integer)h.get("quotedbl")).intValue();
        Encoding.se[35] = (char)((Integer)h.get("numbersign")).intValue();
        Encoding.mre[35] = (char)((Integer)h.get("numbersign")).intValue();
        Encoding.wae[35] = (char)((Integer)h.get("numbersign")).intValue();
        Encoding.pde[35] = (char)((Integer)h.get("numbersign")).intValue();
        Encoding.se[36] = (char)((Integer)h.get("dollar")).intValue();
        Encoding.mre[36] = (char)((Integer)h.get("dollar")).intValue();
        Encoding.wae[36] = (char)((Integer)h.get("dollar")).intValue();
        Encoding.pde[36] = (char)((Integer)h.get("dollar")).intValue();
        Encoding.se[37] = (char)((Integer)h.get("percent")).intValue();
        Encoding.mre[37] = (char)((Integer)h.get("percent")).intValue();
        Encoding.wae[37] = (char)((Integer)h.get("percent")).intValue();
        Encoding.pde[37] = (char)((Integer)h.get("percent")).intValue();
        Encoding.se[38] = (char)((Integer)h.get("ampersand")).intValue();
        Encoding.mre[38] = (char)((Integer)h.get("ampersand")).intValue();
        Encoding.wae[38] = (char)((Integer)h.get("ampersand")).intValue();
        Encoding.pde[38] = (char)((Integer)h.get("ampersand")).intValue();
        Encoding.se[39] = (char)((Integer)h.get("quoteright")).intValue();
        Encoding.mre[39] = (char)((Integer)h.get("quotesingle")).intValue();
        Encoding.wae[39] = (char)((Integer)h.get("quotesingle")).intValue();
        Encoding.pde[39] = (char)((Integer)h.get("quotesingle")).intValue();
        Encoding.se[40] = (char)((Integer)h.get("parenleft")).intValue();
        Encoding.mre[40] = (char)((Integer)h.get("parenleft")).intValue();
        Encoding.wae[40] = (char)((Integer)h.get("parenleft")).intValue();
        Encoding.pde[40] = (char)((Integer)h.get("parenleft")).intValue();
        Encoding.se[41] = (char)((Integer)h.get("parenright")).intValue();
        Encoding.mre[41] = (char)((Integer)h.get("parenright")).intValue();
        Encoding.wae[41] = (char)((Integer)h.get("parenright")).intValue();
        Encoding.pde[41] = (char)((Integer)h.get("parenright")).intValue();
        Encoding.se[42] = (char)((Integer)h.get("asterisk")).intValue();
        Encoding.mre[42] = (char)((Integer)h.get("asterisk")).intValue();
        Encoding.wae[42] = (char)((Integer)h.get("asterisk")).intValue();
        Encoding.pde[42] = (char)((Integer)h.get("asterisk")).intValue();
        Encoding.se[43] = (char)((Integer)h.get("plus")).intValue();
        Encoding.mre[43] = (char)((Integer)h.get("plus")).intValue();
        Encoding.wae[43] = (char)((Integer)h.get("plus")).intValue();
        Encoding.pde[43] = (char)((Integer)h.get("plus")).intValue();
        Encoding.se[44] = (char)((Integer)h.get("comma")).intValue();
        Encoding.mre[44] = (char)((Integer)h.get("comma")).intValue();
        Encoding.wae[44] = (char)((Integer)h.get("comma")).intValue();
        Encoding.pde[44] = (char)((Integer)h.get("comma")).intValue();
        Encoding.se[45] = (char)((Integer)h.get("hyphen")).intValue();
        Encoding.mre[45] = (char)((Integer)h.get("hyphen")).intValue();
        Encoding.wae[45] = (char)((Integer)h.get("hyphen")).intValue();
        Encoding.pde[45] = (char)((Integer)h.get("hyphen")).intValue();
        Encoding.se[46] = (char)((Integer)h.get("period")).intValue();
        Encoding.mre[46] = (char)((Integer)h.get("period")).intValue();
        Encoding.wae[46] = (char)((Integer)h.get("period")).intValue();
        Encoding.pde[46] = (char)((Integer)h.get("period")).intValue();
        Encoding.se[47] = (char)((Integer)h.get("slash")).intValue();
        Encoding.mre[47] = (char)((Integer)h.get("slash")).intValue();
        Encoding.wae[47] = (char)((Integer)h.get("slash")).intValue();
        Encoding.pde[47] = (char)((Integer)h.get("slash")).intValue();
        Encoding.se[48] = (char)((Integer)h.get("zero")).intValue();
        Encoding.mre[48] = (char)((Integer)h.get("zero")).intValue();
        Encoding.wae[48] = (char)((Integer)h.get("zero")).intValue();
        Encoding.pde[48] = (char)((Integer)h.get("zero")).intValue();
        Encoding.se[49] = (char)((Integer)h.get("one")).intValue();
        Encoding.mre[49] = (char)((Integer)h.get("one")).intValue();
        Encoding.wae[49] = (char)((Integer)h.get("one")).intValue();
        Encoding.pde[49] = (char)((Integer)h.get("one")).intValue();
        Encoding.se[50] = (char)((Integer)h.get("two")).intValue();
        Encoding.mre[50] = (char)((Integer)h.get("two")).intValue();
        Encoding.wae[50] = (char)((Integer)h.get("two")).intValue();
        Encoding.pde[50] = (char)((Integer)h.get("two")).intValue();
        Encoding.se[51] = (char)((Integer)h.get("three")).intValue();
        Encoding.mre[51] = (char)((Integer)h.get("three")).intValue();
        Encoding.wae[51] = (char)((Integer)h.get("three")).intValue();
        Encoding.pde[51] = (char)((Integer)h.get("three")).intValue();
        Encoding.se[52] = (char)((Integer)h.get("four")).intValue();
        Encoding.mre[52] = (char)((Integer)h.get("four")).intValue();
        Encoding.wae[52] = (char)((Integer)h.get("four")).intValue();
        Encoding.pde[52] = (char)((Integer)h.get("four")).intValue();
        Encoding.se[53] = (char)((Integer)h.get("five")).intValue();
        Encoding.mre[53] = (char)((Integer)h.get("five")).intValue();
        Encoding.wae[53] = (char)((Integer)h.get("five")).intValue();
        Encoding.pde[53] = (char)((Integer)h.get("five")).intValue();
        Encoding.se[54] = (char)((Integer)h.get("six")).intValue();
        Encoding.mre[54] = (char)((Integer)h.get("six")).intValue();
        Encoding.wae[54] = (char)((Integer)h.get("six")).intValue();
        Encoding.pde[54] = (char)((Integer)h.get("six")).intValue();
        Encoding.se[55] = (char)((Integer)h.get("seven")).intValue();
        Encoding.mre[55] = (char)((Integer)h.get("seven")).intValue();
        Encoding.wae[55] = (char)((Integer)h.get("seven")).intValue();
        Encoding.pde[55] = (char)((Integer)h.get("seven")).intValue();
        Encoding.se[56] = (char)((Integer)h.get("eight")).intValue();
        Encoding.mre[56] = (char)((Integer)h.get("eight")).intValue();
        Encoding.wae[56] = (char)((Integer)h.get("eight")).intValue();
        Encoding.pde[56] = (char)((Integer)h.get("eight")).intValue();
        Encoding.se[57] = (char)((Integer)h.get("nine")).intValue();
        Encoding.mre[57] = (char)((Integer)h.get("nine")).intValue();
        Encoding.wae[57] = (char)((Integer)h.get("nine")).intValue();
        Encoding.pde[57] = (char)((Integer)h.get("nine")).intValue();
        Encoding.se[58] = (char)((Integer)h.get("colon")).intValue();
        Encoding.mre[58] = (char)((Integer)h.get("colon")).intValue();
        Encoding.wae[58] = (char)((Integer)h.get("colon")).intValue();
        Encoding.pde[58] = (char)((Integer)h.get("colon")).intValue();
        Encoding.se[59] = (char)((Integer)h.get("semicolon")).intValue();
        Encoding.mre[59] = (char)((Integer)h.get("semicolon")).intValue();
        Encoding.wae[59] = (char)((Integer)h.get("semicolon")).intValue();
        Encoding.pde[59] = (char)((Integer)h.get("semicolon")).intValue();
        Encoding.se[60] = (char)((Integer)h.get("less")).intValue();
        Encoding.mre[60] = (char)((Integer)h.get("less")).intValue();
        Encoding.wae[60] = (char)((Integer)h.get("less")).intValue();
        Encoding.pde[60] = (char)((Integer)h.get("less")).intValue();
        Encoding.se[61] = (char)((Integer)h.get("equal")).intValue();
        Encoding.mre[61] = (char)((Integer)h.get("equal")).intValue();
        Encoding.wae[61] = (char)((Integer)h.get("equal")).intValue();
        Encoding.pde[61] = (char)((Integer)h.get("equal")).intValue();
        Encoding.se[62] = (char)((Integer)h.get("greater")).intValue();
        Encoding.mre[62] = (char)((Integer)h.get("greater")).intValue();
        Encoding.wae[62] = (char)((Integer)h.get("greater")).intValue();
        Encoding.pde[62] = (char)((Integer)h.get("greater")).intValue();
        Encoding.se[63] = (char)((Integer)h.get("question")).intValue();
        Encoding.mre[63] = (char)((Integer)h.get("question")).intValue();
        Encoding.wae[63] = (char)((Integer)h.get("question")).intValue();
        Encoding.pde[63] = (char)((Integer)h.get("question")).intValue();
        Encoding.se[64] = (char)((Integer)h.get("at")).intValue();
        Encoding.mre[64] = (char)((Integer)h.get("at")).intValue();
        Encoding.wae[64] = (char)((Integer)h.get("at")).intValue();
        Encoding.pde[64] = (char)((Integer)h.get("at")).intValue();
        Encoding.se[65] = (char)((Integer)h.get("A")).intValue();
        Encoding.mre[65] = (char)((Integer)h.get("A")).intValue();
        Encoding.wae[65] = (char)((Integer)h.get("A")).intValue();
        Encoding.pde[65] = (char)((Integer)h.get("A")).intValue();
        Encoding.se[66] = (char)((Integer)h.get("B")).intValue();
        Encoding.mre[66] = (char)((Integer)h.get("B")).intValue();
        Encoding.wae[66] = (char)((Integer)h.get("B")).intValue();
        Encoding.pde[66] = (char)((Integer)h.get("B")).intValue();
        Encoding.se[67] = (char)((Integer)h.get("C")).intValue();
        Encoding.mre[67] = (char)((Integer)h.get("C")).intValue();
        Encoding.wae[67] = (char)((Integer)h.get("C")).intValue();
        Encoding.pde[67] = (char)((Integer)h.get("C")).intValue();
        Encoding.se[68] = (char)((Integer)h.get("D")).intValue();
        Encoding.mre[68] = (char)((Integer)h.get("D")).intValue();
        Encoding.wae[68] = (char)((Integer)h.get("D")).intValue();
        Encoding.pde[68] = (char)((Integer)h.get("D")).intValue();
        Encoding.se[69] = (char)((Integer)h.get("E")).intValue();
        Encoding.mre[69] = (char)((Integer)h.get("E")).intValue();
        Encoding.wae[69] = (char)((Integer)h.get("E")).intValue();
        Encoding.pde[69] = (char)((Integer)h.get("E")).intValue();
        Encoding.se[70] = (char)((Integer)h.get("F")).intValue();
        Encoding.mre[70] = (char)((Integer)h.get("F")).intValue();
        Encoding.wae[70] = (char)((Integer)h.get("F")).intValue();
        Encoding.pde[70] = (char)((Integer)h.get("F")).intValue();
        Encoding.se[71] = (char)((Integer)h.get("G")).intValue();
        Encoding.mre[71] = (char)((Integer)h.get("G")).intValue();
        Encoding.wae[71] = (char)((Integer)h.get("G")).intValue();
        Encoding.pde[71] = (char)((Integer)h.get("G")).intValue();
        Encoding.se[72] = (char)((Integer)h.get("H")).intValue();
        Encoding.mre[72] = (char)((Integer)h.get("H")).intValue();
        Encoding.wae[72] = (char)((Integer)h.get("H")).intValue();
        Encoding.pde[72] = (char)((Integer)h.get("H")).intValue();
        Encoding.se[73] = (char)((Integer)h.get("I")).intValue();
        Encoding.mre[73] = (char)((Integer)h.get("I")).intValue();
        Encoding.wae[73] = (char)((Integer)h.get("I")).intValue();
        Encoding.pde[73] = (char)((Integer)h.get("I")).intValue();
        Encoding.se[74] = (char)((Integer)h.get("J")).intValue();
        Encoding.mre[74] = (char)((Integer)h.get("J")).intValue();
        Encoding.wae[74] = (char)((Integer)h.get("J")).intValue();
        Encoding.pde[74] = (char)((Integer)h.get("J")).intValue();
        Encoding.se[75] = (char)((Integer)h.get("K")).intValue();
        Encoding.mre[75] = (char)((Integer)h.get("K")).intValue();
        Encoding.wae[75] = (char)((Integer)h.get("K")).intValue();
        Encoding.pde[75] = (char)((Integer)h.get("K")).intValue();
        Encoding.se[76] = (char)((Integer)h.get("L")).intValue();
        Encoding.mre[76] = (char)((Integer)h.get("L")).intValue();
        Encoding.wae[76] = (char)((Integer)h.get("L")).intValue();
        Encoding.pde[76] = (char)((Integer)h.get("L")).intValue();
        Encoding.se[77] = (char)((Integer)h.get("M")).intValue();
        Encoding.mre[77] = (char)((Integer)h.get("M")).intValue();
        Encoding.wae[77] = (char)((Integer)h.get("M")).intValue();
        Encoding.pde[77] = (char)((Integer)h.get("M")).intValue();
        Encoding.se[78] = (char)((Integer)h.get("N")).intValue();
        Encoding.mre[78] = (char)((Integer)h.get("N")).intValue();
        Encoding.wae[78] = (char)((Integer)h.get("N")).intValue();
        Encoding.pde[78] = (char)((Integer)h.get("N")).intValue();
        Encoding.se[79] = (char)((Integer)h.get("O")).intValue();
        Encoding.mre[79] = (char)((Integer)h.get("O")).intValue();
        Encoding.wae[79] = (char)((Integer)h.get("O")).intValue();
        Encoding.pde[79] = (char)((Integer)h.get("O")).intValue();
        Encoding.se[80] = (char)((Integer)h.get("P")).intValue();
        Encoding.mre[80] = (char)((Integer)h.get("P")).intValue();
        Encoding.wae[80] = (char)((Integer)h.get("P")).intValue();
        Encoding.pde[80] = (char)((Integer)h.get("P")).intValue();
        Encoding.se[81] = (char)((Integer)h.get("Q")).intValue();
        Encoding.mre[81] = (char)((Integer)h.get("Q")).intValue();
        Encoding.wae[81] = (char)((Integer)h.get("Q")).intValue();
        Encoding.pde[81] = (char)((Integer)h.get("Q")).intValue();
        Encoding.se[82] = (char)((Integer)h.get("R")).intValue();
        Encoding.mre[82] = (char)((Integer)h.get("R")).intValue();
        Encoding.wae[82] = (char)((Integer)h.get("R")).intValue();
        Encoding.pde[82] = (char)((Integer)h.get("R")).intValue();
        Encoding.se[83] = (char)((Integer)h.get("S")).intValue();
        Encoding.mre[83] = (char)((Integer)h.get("S")).intValue();
        Encoding.wae[83] = (char)((Integer)h.get("S")).intValue();
        Encoding.pde[83] = (char)((Integer)h.get("S")).intValue();
        Encoding.se[84] = (char)((Integer)h.get("T")).intValue();
        Encoding.mre[84] = (char)((Integer)h.get("T")).intValue();
        Encoding.wae[84] = (char)((Integer)h.get("T")).intValue();
        Encoding.pde[84] = (char)((Integer)h.get("T")).intValue();
        Encoding.se[85] = (char)((Integer)h.get("U")).intValue();
        Encoding.mre[85] = (char)((Integer)h.get("U")).intValue();
        Encoding.wae[85] = (char)((Integer)h.get("U")).intValue();
        Encoding.pde[85] = (char)((Integer)h.get("U")).intValue();
        Encoding.se[86] = (char)((Integer)h.get("V")).intValue();
        Encoding.mre[86] = (char)((Integer)h.get("V")).intValue();
        Encoding.wae[86] = (char)((Integer)h.get("V")).intValue();
        Encoding.pde[86] = (char)((Integer)h.get("V")).intValue();
        Encoding.se[87] = (char)((Integer)h.get("W")).intValue();
        Encoding.mre[87] = (char)((Integer)h.get("W")).intValue();
        Encoding.wae[87] = (char)((Integer)h.get("W")).intValue();
        Encoding.pde[87] = (char)((Integer)h.get("W")).intValue();
        Encoding.se[88] = (char)((Integer)h.get("X")).intValue();
        Encoding.mre[88] = (char)((Integer)h.get("X")).intValue();
        Encoding.wae[88] = (char)((Integer)h.get("X")).intValue();
        Encoding.pde[88] = (char)((Integer)h.get("X")).intValue();
        Encoding.se[89] = (char)((Integer)h.get("Y")).intValue();
        Encoding.mre[89] = (char)((Integer)h.get("Y")).intValue();
        Encoding.wae[89] = (char)((Integer)h.get("Y")).intValue();
        Encoding.pde[89] = (char)((Integer)h.get("Y")).intValue();
        Encoding.se[90] = (char)((Integer)h.get("Z")).intValue();
        Encoding.mre[90] = (char)((Integer)h.get("Z")).intValue();
        Encoding.wae[90] = (char)((Integer)h.get("Z")).intValue();
        Encoding.pde[90] = (char)((Integer)h.get("Z")).intValue();
        Encoding.se[91] = (char)((Integer)h.get("bracketleft")).intValue();
        Encoding.mre[91] = (char)((Integer)h.get("bracketleft")).intValue();
        Encoding.wae[91] = (char)((Integer)h.get("bracketleft")).intValue();
        Encoding.pde[91] = (char)((Integer)h.get("bracketleft")).intValue();
        Encoding.se[92] = (char)((Integer)h.get("backslash")).intValue();
        Encoding.mre[92] = (char)((Integer)h.get("backslash")).intValue();
        Encoding.wae[92] = (char)((Integer)h.get("backslash")).intValue();
        Encoding.pde[92] = (char)((Integer)h.get("backslash")).intValue();
        Encoding.se[93] = (char)((Integer)h.get("bracketright")).intValue();
        Encoding.mre[93] = (char)((Integer)h.get("bracketright")).intValue();
        Encoding.wae[93] = (char)((Integer)h.get("bracketright")).intValue();
        Encoding.pde[93] = (char)((Integer)h.get("bracketright")).intValue();
        Encoding.se[94] = (char)((Integer)h.get("asciicircum")).intValue();
        Encoding.mre[94] = (char)((Integer)h.get("asciicircum")).intValue();
        Encoding.wae[94] = (char)((Integer)h.get("asciicircum")).intValue();
        Encoding.pde[94] = (char)((Integer)h.get("asciicircum")).intValue();
        Encoding.se[95] = (char)((Integer)h.get("underscore")).intValue();
        Encoding.mre[95] = (char)((Integer)h.get("underscore")).intValue();
        Encoding.wae[95] = (char)((Integer)h.get("underscore")).intValue();
        Encoding.pde[95] = (char)((Integer)h.get("underscore")).intValue();
        Encoding.se[96] = (char)((Integer)h.get("quoteleft")).intValue();
        Encoding.mre[96] = (char)((Integer)h.get("grave")).intValue();
        Encoding.wae[96] = (char)((Integer)h.get("grave")).intValue();
        Encoding.pde[96] = (char)((Integer)h.get("grave")).intValue();
        Encoding.se[97] = (char)((Integer)h.get("a")).intValue();
        Encoding.mre[97] = (char)((Integer)h.get("a")).intValue();
        Encoding.wae[97] = (char)((Integer)h.get("a")).intValue();
        Encoding.pde[97] = (char)((Integer)h.get("a")).intValue();
        Encoding.se[98] = (char)((Integer)h.get("b")).intValue();
        Encoding.mre[98] = (char)((Integer)h.get("b")).intValue();
        Encoding.wae[98] = (char)((Integer)h.get("b")).intValue();
        Encoding.pde[98] = (char)((Integer)h.get("b")).intValue();
        Encoding.se[99] = (char)((Integer)h.get("c")).intValue();
        Encoding.mre[99] = (char)((Integer)h.get("c")).intValue();
        Encoding.wae[99] = (char)((Integer)h.get("c")).intValue();
        Encoding.pde[99] = (char)((Integer)h.get("c")).intValue();
        Encoding.se[100] = (char)((Integer)h.get("d")).intValue();
        Encoding.mre[100] = (char)((Integer)h.get("d")).intValue();
        Encoding.wae[100] = (char)((Integer)h.get("d")).intValue();
        Encoding.pde[100] = (char)((Integer)h.get("d")).intValue();
        Encoding.se[101] = (char)((Integer)h.get("e")).intValue();
        Encoding.mre[101] = (char)((Integer)h.get("e")).intValue();
        Encoding.wae[101] = (char)((Integer)h.get("e")).intValue();
        Encoding.pde[101] = (char)((Integer)h.get("e")).intValue();
        Encoding.se[102] = (char)((Integer)h.get("f")).intValue();
        Encoding.mre[102] = (char)((Integer)h.get("f")).intValue();
        Encoding.wae[102] = (char)((Integer)h.get("f")).intValue();
        Encoding.pde[102] = (char)((Integer)h.get("f")).intValue();
        Encoding.se[103] = (char)((Integer)h.get("g")).intValue();
        Encoding.mre[103] = (char)((Integer)h.get("g")).intValue();
        Encoding.wae[103] = (char)((Integer)h.get("g")).intValue();
        Encoding.pde[103] = (char)((Integer)h.get("g")).intValue();
        Encoding.se[104] = (char)((Integer)h.get("h")).intValue();
        Encoding.mre[104] = (char)((Integer)h.get("h")).intValue();
        Encoding.wae[104] = (char)((Integer)h.get("h")).intValue();
        Encoding.pde[104] = (char)((Integer)h.get("h")).intValue();
        Encoding.se[105] = (char)((Integer)h.get("i")).intValue();
        Encoding.mre[105] = (char)((Integer)h.get("i")).intValue();
        Encoding.wae[105] = (char)((Integer)h.get("i")).intValue();
        Encoding.pde[105] = (char)((Integer)h.get("i")).intValue();
        Encoding.se[106] = (char)((Integer)h.get("j")).intValue();
        Encoding.mre[106] = (char)((Integer)h.get("j")).intValue();
        Encoding.wae[106] = (char)((Integer)h.get("j")).intValue();
        Encoding.pde[106] = (char)((Integer)h.get("j")).intValue();
        Encoding.se[107] = (char)((Integer)h.get("k")).intValue();
        Encoding.mre[107] = (char)((Integer)h.get("k")).intValue();
        Encoding.wae[107] = (char)((Integer)h.get("k")).intValue();
        Encoding.pde[107] = (char)((Integer)h.get("k")).intValue();
        Encoding.se[108] = (char)((Integer)h.get("l")).intValue();
        Encoding.mre[108] = (char)((Integer)h.get("l")).intValue();
        Encoding.wae[108] = (char)((Integer)h.get("l")).intValue();
        Encoding.pde[108] = (char)((Integer)h.get("l")).intValue();
        Encoding.se[109] = (char)((Integer)h.get("m")).intValue();
        Encoding.mre[109] = (char)((Integer)h.get("m")).intValue();
        Encoding.wae[109] = (char)((Integer)h.get("m")).intValue();
        Encoding.pde[109] = (char)((Integer)h.get("m")).intValue();
        Encoding.se[110] = (char)((Integer)h.get("n")).intValue();
        Encoding.mre[110] = (char)((Integer)h.get("n")).intValue();
        Encoding.wae[110] = (char)((Integer)h.get("n")).intValue();
        Encoding.pde[110] = (char)((Integer)h.get("n")).intValue();
        Encoding.se[111] = (char)((Integer)h.get("o")).intValue();
        Encoding.mre[111] = (char)((Integer)h.get("o")).intValue();
        Encoding.wae[111] = (char)((Integer)h.get("o")).intValue();
        Encoding.pde[111] = (char)((Integer)h.get("o")).intValue();
        Encoding.se[112] = (char)((Integer)h.get("p")).intValue();
        Encoding.mre[112] = (char)((Integer)h.get("p")).intValue();
        Encoding.wae[112] = (char)((Integer)h.get("p")).intValue();
        Encoding.pde[112] = (char)((Integer)h.get("p")).intValue();
        Encoding.se[113] = (char)((Integer)h.get("q")).intValue();
        Encoding.mre[113] = (char)((Integer)h.get("q")).intValue();
        Encoding.wae[113] = (char)((Integer)h.get("q")).intValue();
        Encoding.pde[113] = (char)((Integer)h.get("q")).intValue();
        Encoding.se[114] = (char)((Integer)h.get("r")).intValue();
        Encoding.mre[114] = (char)((Integer)h.get("r")).intValue();
        Encoding.wae[114] = (char)((Integer)h.get("r")).intValue();
        Encoding.pde[114] = (char)((Integer)h.get("r")).intValue();
        Encoding.se[115] = (char)((Integer)h.get("s")).intValue();
        Encoding.mre[115] = (char)((Integer)h.get("s")).intValue();
        Encoding.wae[115] = (char)((Integer)h.get("s")).intValue();
        Encoding.pde[115] = (char)((Integer)h.get("s")).intValue();
        Encoding.se[116] = (char)((Integer)h.get("t")).intValue();
        Encoding.mre[116] = (char)((Integer)h.get("t")).intValue();
        Encoding.wae[116] = (char)((Integer)h.get("t")).intValue();
        Encoding.pde[116] = (char)((Integer)h.get("t")).intValue();
        Encoding.se[117] = (char)((Integer)h.get("u")).intValue();
        Encoding.mre[117] = (char)((Integer)h.get("u")).intValue();
        Encoding.wae[117] = (char)((Integer)h.get("u")).intValue();
        Encoding.pde[117] = (char)((Integer)h.get("u")).intValue();
        Encoding.se[118] = (char)((Integer)h.get("v")).intValue();
        Encoding.mre[118] = (char)((Integer)h.get("v")).intValue();
        Encoding.wae[118] = (char)((Integer)h.get("v")).intValue();
        Encoding.pde[118] = (char)((Integer)h.get("v")).intValue();
        Encoding.se[119] = (char)((Integer)h.get("w")).intValue();
        Encoding.mre[119] = (char)((Integer)h.get("w")).intValue();
        Encoding.wae[119] = (char)((Integer)h.get("w")).intValue();
        Encoding.pde[119] = (char)((Integer)h.get("w")).intValue();
        Encoding.se[120] = (char)((Integer)h.get("x")).intValue();
        Encoding.mre[120] = (char)((Integer)h.get("x")).intValue();
        Encoding.wae[120] = (char)((Integer)h.get("x")).intValue();
        Encoding.pde[120] = (char)((Integer)h.get("x")).intValue();
        Encoding.se[121] = (char)((Integer)h.get("y")).intValue();
        Encoding.mre[121] = (char)((Integer)h.get("y")).intValue();
        Encoding.wae[121] = (char)((Integer)h.get("y")).intValue();
        Encoding.pde[121] = (char)((Integer)h.get("y")).intValue();
        Encoding.se[122] = (char)((Integer)h.get("z")).intValue();
        Encoding.mre[122] = (char)((Integer)h.get("z")).intValue();
        Encoding.wae[122] = (char)((Integer)h.get("z")).intValue();
        Encoding.pde[122] = (char)((Integer)h.get("z")).intValue();
        Encoding.se[123] = (char)((Integer)h.get("braceleft")).intValue();
        Encoding.mre[123] = (char)((Integer)h.get("braceleft")).intValue();
        Encoding.wae[123] = (char)((Integer)h.get("braceleft")).intValue();
        Encoding.pde[123] = (char)((Integer)h.get("braceleft")).intValue();
        Encoding.se[124] = (char)((Integer)h.get("bar")).intValue();
        Encoding.mre[124] = (char)((Integer)h.get("bar")).intValue();
        Encoding.wae[124] = (char)((Integer)h.get("bar")).intValue();
        Encoding.pde[124] = (char)((Integer)h.get("bar")).intValue();
        Encoding.se[125] = (char)((Integer)h.get("braceright")).intValue();
        Encoding.mre[125] = (char)((Integer)h.get("braceright")).intValue();
        Encoding.wae[125] = (char)((Integer)h.get("braceright")).intValue();
        Encoding.pde[125] = (char)((Integer)h.get("braceright")).intValue();
        Encoding.se[126] = (char)((Integer)h.get("asciitilde")).intValue();
        Encoding.mre[126] = (char)((Integer)h.get("asciitilde")).intValue();
        Encoding.wae[126] = (char)((Integer)h.get("asciitilde")).intValue();
        Encoding.pde[126] = (char)((Integer)h.get("asciitilde")).intValue();
        Encoding.wae[127] = (char)((Integer)h.get("bullet")).intValue();
        Encoding.mre[128] = (char)((Integer)h.get("Adieresis")).intValue();
        Encoding.wae[128] = (char)((Integer)h.get("Euro")).intValue();
        Encoding.pde[128] = (char)((Integer)h.get("bullet")).intValue();
        Encoding.mre[129] = (char)((Integer)h.get("Aring")).intValue();
        Encoding.wae[129] = (char)((Integer)h.get("bullet")).intValue();
        Encoding.pde[129] = (char)((Integer)h.get("dagger")).intValue();
        Encoding.mre[130] = (char)((Integer)h.get("Ccedilla")).intValue();
        Encoding.wae[130] = (char)((Integer)h.get("quotesinglbase")).intValue();
        Encoding.pde[130] = (char)((Integer)h.get("daggerdbl")).intValue();
        Encoding.mre[131] = (char)((Integer)h.get("Eacute")).intValue();
        Encoding.wae[131] = (char)((Integer)h.get("florin")).intValue();
        Encoding.pde[131] = (char)((Integer)h.get("ellipsis")).intValue();
        Encoding.mre[132] = (char)((Integer)h.get("Ntilde")).intValue();
        Encoding.wae[132] = (char)((Integer)h.get("quotedblbase")).intValue();
        Encoding.pde[132] = (char)((Integer)h.get("emdash")).intValue();
        Encoding.mre[133] = (char)((Integer)h.get("Odieresis")).intValue();
        Encoding.wae[133] = (char)((Integer)h.get("ellipsis")).intValue();
        Encoding.pde[133] = (char)((Integer)h.get("endash")).intValue();
        Encoding.mre[134] = (char)((Integer)h.get("Udieresis")).intValue();
        Encoding.wae[134] = (char)((Integer)h.get("dagger")).intValue();
        Encoding.pde[134] = (char)((Integer)h.get("florin")).intValue();
        Encoding.mre[135] = (char)((Integer)h.get("aacute")).intValue();
        Encoding.wae[135] = (char)((Integer)h.get("daggerdbl")).intValue();
        Encoding.pde[135] = (char)((Integer)h.get("fraction")).intValue();
        Encoding.mre[136] = (char)((Integer)h.get("agrave")).intValue();
        Encoding.wae[136] = (char)((Integer)h.get("circumflex")).intValue();
        Encoding.pde[136] = (char)((Integer)h.get("guilsinglleft")).intValue();
        Encoding.mre[137] = (char)((Integer)h.get("acircumflex")).intValue();
        Encoding.wae[137] = (char)((Integer)h.get("perthousand")).intValue();
        Encoding.pde[137] = (char)((Integer)h.get("guilsinglright")).intValue();
        Encoding.mre[138] = (char)((Integer)h.get("adieresis")).intValue();
        Encoding.wae[138] = (char)((Integer)h.get("Scaron")).intValue();
        Encoding.pde[138] = (char)((Integer)h.get("minus")).intValue();
        Encoding.mre[139] = (char)((Integer)h.get("atilde")).intValue();
        Encoding.wae[139] = (char)((Integer)h.get("guilsinglleft")).intValue();
        Encoding.pde[139] = (char)((Integer)h.get("perthousand")).intValue();
        Encoding.mre[140] = (char)((Integer)h.get("aring")).intValue();
        Encoding.wae[140] = (char)((Integer)h.get("OE")).intValue();
        Encoding.pde[140] = (char)((Integer)h.get("quotedblbase")).intValue();
        Encoding.mre[141] = (char)((Integer)h.get("ccedilla")).intValue();
        Encoding.wae[141] = (char)((Integer)h.get("bullet")).intValue();
        Encoding.pde[141] = (char)((Integer)h.get("quotedblleft")).intValue();
        Encoding.mre[142] = (char)((Integer)h.get("eacute")).intValue();
        Encoding.wae[142] = (char)((Integer)h.get("Zcaron")).intValue();
        Encoding.pde[142] = (char)((Integer)h.get("quotedblright")).intValue();
        Encoding.mre[143] = (char)((Integer)h.get("egrave")).intValue();
        Encoding.wae[143] = (char)((Integer)h.get("bullet")).intValue();
        Encoding.pde[143] = (char)((Integer)h.get("quoteleft")).intValue();
        Encoding.mre[144] = (char)((Integer)h.get("ecircumflex")).intValue();
        Encoding.wae[144] = (char)((Integer)h.get("bullet")).intValue();
        Encoding.pde[144] = (char)((Integer)h.get("quoteright")).intValue();
        Encoding.mre[145] = (char)((Integer)h.get("edieresis")).intValue();
        Encoding.wae[145] = (char)((Integer)h.get("quoteleft")).intValue();
        Encoding.pde[145] = (char)((Integer)h.get("quotesinglbase")).intValue();
        Encoding.mre[146] = (char)((Integer)h.get("iacute")).intValue();
        Encoding.wae[146] = (char)((Integer)h.get("quoteright")).intValue();
        Encoding.pde[146] = (char)((Integer)h.get("trademark")).intValue();
        Encoding.mre[147] = (char)((Integer)h.get("igrave")).intValue();
        Encoding.wae[147] = (char)((Integer)h.get("quotedblleft")).intValue();
        Encoding.pde[147] = (char)((Integer)h.get("fi")).intValue();
        Encoding.mre[148] = (char)((Integer)h.get("icircumflex")).intValue();
        Encoding.wae[148] = (char)((Integer)h.get("quotedblright")).intValue();
        Encoding.pde[148] = (char)((Integer)h.get("fl")).intValue();
        Encoding.mre[149] = (char)((Integer)h.get("idieresis")).intValue();
        Encoding.wae[149] = (char)((Integer)h.get("bullet")).intValue();
        Encoding.pde[149] = (char)((Integer)h.get("Lslash")).intValue();
        Encoding.mre[150] = (char)((Integer)h.get("ntilde")).intValue();
        Encoding.wae[150] = (char)((Integer)h.get("endash")).intValue();
        Encoding.pde[150] = (char)((Integer)h.get("OE")).intValue();
        Encoding.mre[151] = (char)((Integer)h.get("oacute")).intValue();
        Encoding.wae[151] = (char)((Integer)h.get("emdash")).intValue();
        Encoding.pde[151] = (char)((Integer)h.get("Scaron")).intValue();
        Encoding.mre[152] = (char)((Integer)h.get("ograve")).intValue();
        Encoding.wae[152] = (char)((Integer)h.get("tilde")).intValue();
        Encoding.pde[152] = (char)((Integer)h.get("Ydieresis")).intValue();
        Encoding.mre[153] = (char)((Integer)h.get("ocircumflex")).intValue();
        Encoding.wae[153] = (char)((Integer)h.get("trademark")).intValue();
        Encoding.pde[153] = (char)((Integer)h.get("Zcaron")).intValue();
        Encoding.mre[154] = (char)((Integer)h.get("odieresis")).intValue();
        Encoding.wae[154] = (char)((Integer)h.get("scaron")).intValue();
        Encoding.pde[154] = (char)((Integer)h.get("dotlessi")).intValue();
        Encoding.mre[155] = (char)((Integer)h.get("otilde")).intValue();
        Encoding.wae[155] = (char)((Integer)h.get("guilsinglright")).intValue();
        Encoding.pde[155] = (char)((Integer)h.get("lslash")).intValue();
        Encoding.mre[156] = (char)((Integer)h.get("uacute")).intValue();
        Encoding.wae[156] = (char)((Integer)h.get("oe")).intValue();
        Encoding.pde[156] = (char)((Integer)h.get("oe")).intValue();
        Encoding.mre[157] = (char)((Integer)h.get("ugrave")).intValue();
        Encoding.wae[157] = (char)((Integer)h.get("bullet")).intValue();
        Encoding.pde[157] = (char)((Integer)h.get("scaron")).intValue();
        Encoding.mre[158] = (char)((Integer)h.get("ucircumflex")).intValue();
        Encoding.wae[158] = (char)((Integer)h.get("zcaron")).intValue();
        Encoding.pde[158] = (char)((Integer)h.get("zcaron")).intValue();
        Encoding.mre[159] = (char)((Integer)h.get("udieresis")).intValue();
        Encoding.wae[159] = (char)((Integer)h.get("Ydieresis")).intValue();
        Encoding.mre[160] = (char)((Integer)h.get("dagger")).intValue();
        Encoding.wae[160] = (char)((Integer)h.get("space")).intValue();
        Encoding.pde[160] = (char)((Integer)h.get("Euro")).intValue();
        Encoding.se[161] = (char)((Integer)h.get("exclamdown")).intValue();
        Encoding.mre[161] = (char)((Integer)h.get("degree")).intValue();
        Encoding.wae[161] = (char)((Integer)h.get("exclamdown")).intValue();
        Encoding.pde[161] = (char)((Integer)h.get("exclamdown")).intValue();
        Encoding.se[162] = (char)((Integer)h.get("cent")).intValue();
        Encoding.mre[162] = (char)((Integer)h.get("cent")).intValue();
        Encoding.wae[162] = (char)((Integer)h.get("cent")).intValue();
        Encoding.pde[162] = (char)((Integer)h.get("cent")).intValue();
        Encoding.se[163] = (char)((Integer)h.get("sterling")).intValue();
        Encoding.mre[163] = (char)((Integer)h.get("sterling")).intValue();
        Encoding.wae[163] = (char)((Integer)h.get("sterling")).intValue();
        Encoding.pde[163] = (char)((Integer)h.get("sterling")).intValue();
        Encoding.se[164] = (char)((Integer)h.get("fraction")).intValue();
        Encoding.mre[164] = (char)((Integer)h.get("section")).intValue();
        Encoding.wae[164] = (char)((Integer)h.get("currency")).intValue();
        Encoding.pde[164] = (char)((Integer)h.get("currency")).intValue();
        Encoding.se[165] = (char)((Integer)h.get("yen")).intValue();
        Encoding.mre[165] = (char)((Integer)h.get("bullet")).intValue();
        Encoding.wae[165] = (char)((Integer)h.get("yen")).intValue();
        Encoding.pde[165] = (char)((Integer)h.get("yen")).intValue();
        Encoding.se[166] = (char)((Integer)h.get("florin")).intValue();
        Encoding.mre[166] = (char)((Integer)h.get("paragraph")).intValue();
        Encoding.wae[166] = (char)((Integer)h.get("brokenbar")).intValue();
        Encoding.pde[166] = (char)((Integer)h.get("brokenbar")).intValue();
        Encoding.se[167] = (char)((Integer)h.get("section")).intValue();
        Encoding.mre[167] = (char)((Integer)h.get("germandbls")).intValue();
        Encoding.wae[167] = (char)((Integer)h.get("section")).intValue();
        Encoding.pde[167] = (char)((Integer)h.get("section")).intValue();
        Encoding.se[168] = (char)((Integer)h.get("currency")).intValue();
        Encoding.mre[168] = (char)((Integer)h.get("registered")).intValue();
        Encoding.wae[168] = (char)((Integer)h.get("dieresis")).intValue();
        Encoding.pde[168] = (char)((Integer)h.get("dieresis")).intValue();
        Encoding.se[169] = (char)((Integer)h.get("quotesingle")).intValue();
        Encoding.mre[169] = (char)((Integer)h.get("copyright")).intValue();
        Encoding.wae[169] = (char)((Integer)h.get("copyright")).intValue();
        Encoding.pde[169] = (char)((Integer)h.get("copyright")).intValue();
        Encoding.se[170] = (char)((Integer)h.get("quotedblleft")).intValue();
        Encoding.mre[170] = (char)((Integer)h.get("trademark")).intValue();
        Encoding.wae[170] = (char)((Integer)h.get("ordfeminine")).intValue();
        Encoding.pde[170] = (char)((Integer)h.get("ordfeminine")).intValue();
        Encoding.se[171] = (char)((Integer)h.get("guillemotleft")).intValue();
        Encoding.mre[171] = (char)((Integer)h.get("acute")).intValue();
        Encoding.wae[171] = (char)((Integer)h.get("guillemotleft")).intValue();
        Encoding.pde[171] = (char)((Integer)h.get("guillemotleft")).intValue();
        Encoding.se[172] = (char)((Integer)h.get("guilsinglleft")).intValue();
        Encoding.mre[172] = (char)((Integer)h.get("dieresis")).intValue();
        Encoding.wae[172] = (char)((Integer)h.get("logicalnot")).intValue();
        Encoding.pde[172] = (char)((Integer)h.get("logicalnot")).intValue();
        Encoding.se[173] = (char)((Integer)h.get("guilsinglright")).intValue();
        Encoding.wae[173] = (char)((Integer)h.get("hyphen")).intValue();
        Encoding.se[174] = (char)((Integer)h.get("fi")).intValue();
        Encoding.mre[174] = (char)((Integer)h.get("AE")).intValue();
        Encoding.wae[174] = (char)((Integer)h.get("registered")).intValue();
        Encoding.pde[174] = (char)((Integer)h.get("registered")).intValue();
        Encoding.se[175] = (char)((Integer)h.get("fl")).intValue();
        Encoding.mre[175] = (char)((Integer)h.get("Oslash")).intValue();
        Encoding.wae[175] = (char)((Integer)h.get("macron")).intValue();
        Encoding.pde[175] = (char)((Integer)h.get("macron")).intValue();
        Encoding.wae[176] = (char)((Integer)h.get("degree")).intValue();
        Encoding.pde[176] = (char)((Integer)h.get("degree")).intValue();
        Encoding.se[177] = (char)((Integer)h.get("endash")).intValue();
        Encoding.mre[177] = (char)((Integer)h.get("plusminus")).intValue();
        Encoding.wae[177] = (char)((Integer)h.get("plusminus")).intValue();
        Encoding.pde[177] = (char)((Integer)h.get("plusminus")).intValue();
        Encoding.se[178] = (char)((Integer)h.get("dagger")).intValue();
        Encoding.wae[178] = (char)((Integer)h.get("twosuperior")).intValue();
        Encoding.pde[178] = (char)((Integer)h.get("twosuperior")).intValue();
        Encoding.se[179] = (char)((Integer)h.get("daggerdbl")).intValue();
        Encoding.wae[179] = (char)((Integer)h.get("threesuperior")).intValue();
        Encoding.pde[179] = (char)((Integer)h.get("threesuperior")).intValue();
        Encoding.se[180] = (char)((Integer)h.get("periodcentered")).intValue();
        Encoding.mre[180] = (char)((Integer)h.get("yen")).intValue();
        Encoding.wae[180] = (char)((Integer)h.get("acute")).intValue();
        Encoding.pde[180] = (char)((Integer)h.get("acute")).intValue();
        Encoding.mre[181] = (char)((Integer)h.get("mu")).intValue();
        Encoding.wae[181] = (char)((Integer)h.get("mu")).intValue();
        Encoding.pde[181] = (char)((Integer)h.get("mu")).intValue();
        Encoding.se[182] = (char)((Integer)h.get("paragraph")).intValue();
        Encoding.wae[182] = (char)((Integer)h.get("paragraph")).intValue();
        Encoding.pde[182] = (char)((Integer)h.get("paragraph")).intValue();
        Encoding.se[183] = (char)((Integer)h.get("bullet")).intValue();
        Encoding.wae[183] = (char)((Integer)h.get("periodcentered")).intValue();
        Encoding.pde[183] = (char)((Integer)h.get("periodcentered")).intValue();
        Encoding.se[184] = (char)((Integer)h.get("quotesinglbase")).intValue();
        Encoding.wae[184] = (char)((Integer)h.get("cedilla")).intValue();
        Encoding.pde[184] = (char)((Integer)h.get("cedilla")).intValue();
        Encoding.se[185] = (char)((Integer)h.get("quotedblbase")).intValue();
        Encoding.wae[185] = (char)((Integer)h.get("onesuperior")).intValue();
        Encoding.pde[185] = (char)((Integer)h.get("onesuperior")).intValue();
        Encoding.se[186] = (char)((Integer)h.get("quotedblright")).intValue();
        Encoding.wae[186] = (char)((Integer)h.get("ordmasculine")).intValue();
        Encoding.pde[186] = (char)((Integer)h.get("ordmasculine")).intValue();
        Encoding.se[187] = (char)((Integer)h.get("guillemotright")).intValue();
        Encoding.mre[187] = (char)((Integer)h.get("ordfeminine")).intValue();
        Encoding.wae[187] = (char)((Integer)h.get("guillemotright")).intValue();
        Encoding.pde[187] = (char)((Integer)h.get("guillemotright")).intValue();
        Encoding.se[188] = (char)((Integer)h.get("ellipsis")).intValue();
        Encoding.mre[188] = (char)((Integer)h.get("ordmasculine")).intValue();
        Encoding.wae[188] = (char)((Integer)h.get("onequarter")).intValue();
        Encoding.pde[188] = (char)((Integer)h.get("onequarter")).intValue();
        Encoding.se[189] = (char)((Integer)h.get("perthousand")).intValue();
        Encoding.wae[189] = (char)((Integer)h.get("onehalf")).intValue();
        Encoding.pde[189] = (char)((Integer)h.get("onehalf")).intValue();
        Encoding.mre[190] = (char)((Integer)h.get("ae")).intValue();
        Encoding.wae[190] = (char)((Integer)h.get("threequarters")).intValue();
        Encoding.pde[190] = (char)((Integer)h.get("threequarters")).intValue();
        Encoding.se[191] = (char)((Integer)h.get("questiondown")).intValue();
        Encoding.mre[191] = (char)((Integer)h.get("oslash")).intValue();
        Encoding.wae[191] = (char)((Integer)h.get("questiondown")).intValue();
        Encoding.pde[191] = (char)((Integer)h.get("questiondown")).intValue();
        Encoding.mre[192] = (char)((Integer)h.get("questiondown")).intValue();
        Encoding.wae[192] = (char)((Integer)h.get("Agrave")).intValue();
        Encoding.pde[192] = (char)((Integer)h.get("Agrave")).intValue();
        Encoding.se[193] = (char)((Integer)h.get("grave")).intValue();
        Encoding.mre[193] = (char)((Integer)h.get("exclamdown")).intValue();
        Encoding.wae[193] = (char)((Integer)h.get("Aacute")).intValue();
        Encoding.pde[193] = (char)((Integer)h.get("Aacute")).intValue();
        Encoding.se[194] = (char)((Integer)h.get("acute")).intValue();
        Encoding.mre[194] = (char)((Integer)h.get("logicalnot")).intValue();
        Encoding.wae[194] = (char)((Integer)h.get("Acircumflex")).intValue();
        Encoding.pde[194] = (char)((Integer)h.get("Acircumflex")).intValue();
        Encoding.se[195] = (char)((Integer)h.get("circumflex")).intValue();
        Encoding.wae[195] = (char)((Integer)h.get("Atilde")).intValue();
        Encoding.pde[195] = (char)((Integer)h.get("Atilde")).intValue();
        Encoding.se[196] = (char)((Integer)h.get("tilde")).intValue();
        Encoding.mre[196] = (char)((Integer)h.get("florin")).intValue();
        Encoding.wae[196] = (char)((Integer)h.get("Adieresis")).intValue();
        Encoding.pde[196] = (char)((Integer)h.get("Adieresis")).intValue();
        Encoding.se[197] = (char)((Integer)h.get("macron")).intValue();
        Encoding.wae[197] = (char)((Integer)h.get("Aring")).intValue();
        Encoding.pde[197] = (char)((Integer)h.get("Aring")).intValue();
        Encoding.se[198] = (char)((Integer)h.get("breve")).intValue();
        Encoding.wae[198] = (char)((Integer)h.get("AE")).intValue();
        Encoding.pde[198] = (char)((Integer)h.get("AE")).intValue();
        Encoding.se[199] = (char)((Integer)h.get("dotaccent")).intValue();
        Encoding.mre[199] = (char)((Integer)h.get("guillemotleft")).intValue();
        Encoding.wae[199] = (char)((Integer)h.get("Ccedilla")).intValue();
        Encoding.pde[199] = (char)((Integer)h.get("Ccedilla")).intValue();
        Encoding.se[200] = (char)((Integer)h.get("dieresis")).intValue();
        Encoding.mre[200] = (char)((Integer)h.get("guillemotright")).intValue();
        Encoding.wae[200] = (char)((Integer)h.get("Egrave")).intValue();
        Encoding.pde[200] = (char)((Integer)h.get("Egrave")).intValue();
        Encoding.mre[201] = (char)((Integer)h.get("ellipsis")).intValue();
        Encoding.wae[201] = (char)((Integer)h.get("Eacute")).intValue();
        Encoding.pde[201] = (char)((Integer)h.get("Eacute")).intValue();
        Encoding.se[202] = (char)((Integer)h.get("ring")).intValue();
        Encoding.mre[202] = (char)((Integer)h.get("space")).intValue();
        Encoding.wae[202] = (char)((Integer)h.get("Ecircumflex")).intValue();
        Encoding.pde[202] = (char)((Integer)h.get("Ecircumflex")).intValue();
        Encoding.se[203] = (char)((Integer)h.get("cedilla")).intValue();
        Encoding.mre[203] = (char)((Integer)h.get("Agrave")).intValue();
        Encoding.wae[203] = (char)((Integer)h.get("Edieresis")).intValue();
        Encoding.pde[203] = (char)((Integer)h.get("Edieresis")).intValue();
        Encoding.mre[204] = (char)((Integer)h.get("Atilde")).intValue();
        Encoding.wae[204] = (char)((Integer)h.get("Igrave")).intValue();
        Encoding.pde[204] = (char)((Integer)h.get("Igrave")).intValue();
        Encoding.se[205] = (char)((Integer)h.get("hungarumlaut")).intValue();
        Encoding.mre[205] = (char)((Integer)h.get("Otilde")).intValue();
        Encoding.wae[205] = (char)((Integer)h.get("Iacute")).intValue();
        Encoding.pde[205] = (char)((Integer)h.get("Iacute")).intValue();
        Encoding.se[206] = (char)((Integer)h.get("ogonek")).intValue();
        Encoding.mre[206] = (char)((Integer)h.get("OE")).intValue();
        Encoding.wae[206] = (char)((Integer)h.get("Icircumflex")).intValue();
        Encoding.pde[206] = (char)((Integer)h.get("Icircumflex")).intValue();
        Encoding.se[207] = (char)((Integer)h.get("caron")).intValue();
        Encoding.mre[207] = (char)((Integer)h.get("oe")).intValue();
        Encoding.wae[207] = (char)((Integer)h.get("Idieresis")).intValue();
        Encoding.pde[207] = (char)((Integer)h.get("Idieresis")).intValue();
        Encoding.se[208] = (char)((Integer)h.get("emdash")).intValue();
        Encoding.mre[208] = (char)((Integer)h.get("endash")).intValue();
        Encoding.wae[208] = (char)((Integer)h.get("Eth")).intValue();
        Encoding.pde[208] = (char)((Integer)h.get("Eth")).intValue();
        Encoding.mre[209] = (char)((Integer)h.get("emdash")).intValue();
        Encoding.wae[209] = (char)((Integer)h.get("Ntilde")).intValue();
        Encoding.pde[209] = (char)((Integer)h.get("Ntilde")).intValue();
        Encoding.mre[210] = (char)((Integer)h.get("quotedblleft")).intValue();
        Encoding.wae[210] = (char)((Integer)h.get("Ograve")).intValue();
        Encoding.pde[210] = (char)((Integer)h.get("Ograve")).intValue();
        Encoding.mre[211] = (char)((Integer)h.get("quotedblright")).intValue();
        Encoding.wae[211] = (char)((Integer)h.get("Oacute")).intValue();
        Encoding.pde[211] = (char)((Integer)h.get("Oacute")).intValue();
        Encoding.mre[212] = (char)((Integer)h.get("quoteleft")).intValue();
        Encoding.wae[212] = (char)((Integer)h.get("Ocircumflex")).intValue();
        Encoding.pde[212] = (char)((Integer)h.get("Ocircumflex")).intValue();
        Encoding.mre[213] = (char)((Integer)h.get("quoteright")).intValue();
        Encoding.wae[213] = (char)((Integer)h.get("Otilde")).intValue();
        Encoding.pde[213] = (char)((Integer)h.get("Otilde")).intValue();
        Encoding.mre[214] = (char)((Integer)h.get("divide")).intValue();
        Encoding.wae[214] = (char)((Integer)h.get("Odieresis")).intValue();
        Encoding.pde[214] = (char)((Integer)h.get("Odieresis")).intValue();
        Encoding.wae[215] = (char)((Integer)h.get("multiply")).intValue();
        Encoding.pde[215] = (char)((Integer)h.get("multiply")).intValue();
        Encoding.mre[216] = (char)((Integer)h.get("ydieresis")).intValue();
        Encoding.wae[216] = (char)((Integer)h.get("Oslash")).intValue();
        Encoding.pde[216] = (char)((Integer)h.get("Oslash")).intValue();
        Encoding.mre[217] = (char)((Integer)h.get("Ydieresis")).intValue();
        Encoding.wae[217] = (char)((Integer)h.get("Ugrave")).intValue();
        Encoding.pde[217] = (char)((Integer)h.get("Ugrave")).intValue();
        Encoding.mre[218] = (char)((Integer)h.get("fraction")).intValue();
        Encoding.wae[218] = (char)((Integer)h.get("Uacute")).intValue();
        Encoding.pde[218] = (char)((Integer)h.get("Uacute")).intValue();
        Encoding.mre[219] = (char)((Integer)h.get("currency")).intValue();
        Encoding.wae[219] = (char)((Integer)h.get("Ucircumflex")).intValue();
        Encoding.pde[219] = (char)((Integer)h.get("Ucircumflex")).intValue();
        Encoding.mre[220] = (char)((Integer)h.get("guilsinglleft")).intValue();
        Encoding.wae[220] = (char)((Integer)h.get("Udieresis")).intValue();
        Encoding.pde[220] = (char)((Integer)h.get("Udieresis")).intValue();
        Encoding.mre[221] = (char)((Integer)h.get("guilsinglright")).intValue();
        Encoding.wae[221] = (char)((Integer)h.get("Yacute")).intValue();
        Encoding.pde[221] = (char)((Integer)h.get("Yacute")).intValue();
        Encoding.mre[222] = (char)((Integer)h.get("fi")).intValue();
        Encoding.wae[222] = (char)((Integer)h.get("Thorn")).intValue();
        Encoding.pde[222] = (char)((Integer)h.get("Thorn")).intValue();
        Encoding.mre[223] = (char)((Integer)h.get("fl")).intValue();
        Encoding.wae[223] = (char)((Integer)h.get("germandbls")).intValue();
        Encoding.pde[223] = (char)((Integer)h.get("germandbls")).intValue();
        Encoding.mre[224] = (char)((Integer)h.get("daggerdbl")).intValue();
        Encoding.wae[224] = (char)((Integer)h.get("agrave")).intValue();
        Encoding.pde[224] = (char)((Integer)h.get("agrave")).intValue();
        Encoding.se[225] = (char)((Integer)h.get("AE")).intValue();
        Encoding.mre[225] = (char)((Integer)h.get("periodcentered")).intValue();
        Encoding.wae[225] = (char)((Integer)h.get("aacute")).intValue();
        Encoding.pde[225] = (char)((Integer)h.get("aacute")).intValue();
        Encoding.mre[226] = (char)((Integer)h.get("quotesinglbase")).intValue();
        Encoding.wae[226] = (char)((Integer)h.get("acircumflex")).intValue();
        Encoding.pde[226] = (char)((Integer)h.get("acircumflex")).intValue();
        Encoding.se[227] = (char)((Integer)h.get("ordfeminine")).intValue();
        Encoding.mre[227] = (char)((Integer)h.get("quotedblbase")).intValue();
        Encoding.wae[227] = (char)((Integer)h.get("atilde")).intValue();
        Encoding.pde[227] = (char)((Integer)h.get("atilde")).intValue();
        Encoding.mre[228] = (char)((Integer)h.get("perthousand")).intValue();
        Encoding.wae[228] = (char)((Integer)h.get("adieresis")).intValue();
        Encoding.pde[228] = (char)((Integer)h.get("adieresis")).intValue();
        Encoding.mre[229] = (char)((Integer)h.get("Acircumflex")).intValue();
        Encoding.wae[229] = (char)((Integer)h.get("aring")).intValue();
        Encoding.pde[229] = (char)((Integer)h.get("aring")).intValue();
        Encoding.mre[230] = (char)((Integer)h.get("Ecircumflex")).intValue();
        Encoding.wae[230] = (char)((Integer)h.get("ae")).intValue();
        Encoding.pde[230] = (char)((Integer)h.get("ae")).intValue();
        Encoding.mre[231] = (char)((Integer)h.get("Aacute")).intValue();
        Encoding.wae[231] = (char)((Integer)h.get("ccedilla")).intValue();
        Encoding.pde[231] = (char)((Integer)h.get("ccedilla")).intValue();
        Encoding.se[232] = (char)((Integer)h.get("Lslash")).intValue();
        Encoding.mre[232] = (char)((Integer)h.get("Edieresis")).intValue();
        Encoding.wae[232] = (char)((Integer)h.get("egrave")).intValue();
        Encoding.pde[232] = (char)((Integer)h.get("egrave")).intValue();
        Encoding.se[233] = (char)((Integer)h.get("Oslash")).intValue();
        Encoding.mre[233] = (char)((Integer)h.get("Egrave")).intValue();
        Encoding.wae[233] = (char)((Integer)h.get("eacute")).intValue();
        Encoding.pde[233] = (char)((Integer)h.get("eacute")).intValue();
        Encoding.se[234] = (char)((Integer)h.get("OE")).intValue();
        Encoding.mre[234] = (char)((Integer)h.get("Iacute")).intValue();
        Encoding.wae[234] = (char)((Integer)h.get("ecircumflex")).intValue();
        Encoding.pde[234] = (char)((Integer)h.get("ecircumflex")).intValue();
        Encoding.se[235] = (char)((Integer)h.get("ordmasculine")).intValue();
        Encoding.mre[235] = (char)((Integer)h.get("Icircumflex")).intValue();
        Encoding.wae[235] = (char)((Integer)h.get("edieresis")).intValue();
        Encoding.pde[235] = (char)((Integer)h.get("edieresis")).intValue();
        Encoding.mre[236] = (char)((Integer)h.get("Idieresis")).intValue();
        Encoding.wae[236] = (char)((Integer)h.get("igrave")).intValue();
        Encoding.pde[236] = (char)((Integer)h.get("igrave")).intValue();
        Encoding.mre[237] = (char)((Integer)h.get("Igrave")).intValue();
        Encoding.wae[237] = (char)((Integer)h.get("iacute")).intValue();
        Encoding.pde[237] = (char)((Integer)h.get("iacute")).intValue();
        Encoding.mre[238] = (char)((Integer)h.get("Oacute")).intValue();
        Encoding.wae[238] = (char)((Integer)h.get("icircumflex")).intValue();
        Encoding.pde[238] = (char)((Integer)h.get("icircumflex")).intValue();
        Encoding.mre[239] = (char)((Integer)h.get("Ocircumflex")).intValue();
        Encoding.wae[239] = (char)((Integer)h.get("idieresis")).intValue();
        Encoding.pde[239] = (char)((Integer)h.get("idieresis")).intValue();
        Encoding.wae[240] = (char)((Integer)h.get("eth")).intValue();
        Encoding.pde[240] = (char)((Integer)h.get("eth")).intValue();
        Encoding.se[241] = (char)((Integer)h.get("ae")).intValue();
        Encoding.mre[241] = (char)((Integer)h.get("Ograve")).intValue();
        Encoding.wae[241] = (char)((Integer)h.get("ntilde")).intValue();
        Encoding.pde[241] = (char)((Integer)h.get("ntilde")).intValue();
        Encoding.mre[242] = (char)((Integer)h.get("Uacute")).intValue();
        Encoding.wae[242] = (char)((Integer)h.get("ograve")).intValue();
        Encoding.pde[242] = (char)((Integer)h.get("ograve")).intValue();
        Encoding.mre[243] = (char)((Integer)h.get("Ucircumflex")).intValue();
        Encoding.wae[243] = (char)((Integer)h.get("oacute")).intValue();
        Encoding.pde[243] = (char)((Integer)h.get("oacute")).intValue();
        Encoding.mre[244] = (char)((Integer)h.get("Ugrave")).intValue();
        Encoding.wae[244] = (char)((Integer)h.get("ocircumflex")).intValue();
        Encoding.pde[244] = (char)((Integer)h.get("ocircumflex")).intValue();
        Encoding.se[245] = (char)((Integer)h.get("dotlessi")).intValue();
        Encoding.mre[245] = (char)((Integer)h.get("dotlessi")).intValue();
        Encoding.wae[245] = (char)((Integer)h.get("otilde")).intValue();
        Encoding.pde[245] = (char)((Integer)h.get("otilde")).intValue();
        Encoding.mre[246] = (char)((Integer)h.get("circumflex")).intValue();
        Encoding.wae[246] = (char)((Integer)h.get("odieresis")).intValue();
        Encoding.pde[246] = (char)((Integer)h.get("odieresis")).intValue();
        Encoding.mre[247] = (char)((Integer)h.get("tilde")).intValue();
        Encoding.wae[247] = (char)((Integer)h.get("divide")).intValue();
        Encoding.pde[247] = (char)((Integer)h.get("divide")).intValue();
        Encoding.se[248] = (char)((Integer)h.get("lslash")).intValue();
        Encoding.mre[248] = (char)((Integer)h.get("macron")).intValue();
        Encoding.wae[248] = (char)((Integer)h.get("oslash")).intValue();
        Encoding.pde[248] = (char)((Integer)h.get("oslash")).intValue();
        Encoding.se[249] = (char)((Integer)h.get("oslash")).intValue();
        Encoding.mre[249] = (char)((Integer)h.get("breve")).intValue();
        Encoding.wae[249] = (char)((Integer)h.get("ugrave")).intValue();
        Encoding.pde[249] = (char)((Integer)h.get("ugrave")).intValue();
        Encoding.se[250] = (char)((Integer)h.get("oe")).intValue();
        Encoding.mre[250] = (char)((Integer)h.get("dotaccent")).intValue();
        Encoding.wae[250] = (char)((Integer)h.get("uacute")).intValue();
        Encoding.pde[250] = (char)((Integer)h.get("uacute")).intValue();
        Encoding.se[251] = (char)((Integer)h.get("germandbls")).intValue();
        Encoding.mre[251] = (char)((Integer)h.get("ring")).intValue();
        Encoding.wae[251] = (char)((Integer)h.get("ucircumflex")).intValue();
        Encoding.pde[251] = (char)((Integer)h.get("ucircumflex")).intValue();
        Encoding.mre[252] = (char)((Integer)h.get("cedilla")).intValue();
        Encoding.wae[252] = (char)((Integer)h.get("udieresis")).intValue();
        Encoding.pde[252] = (char)((Integer)h.get("udieresis")).intValue();
        Encoding.mre[253] = (char)((Integer)h.get("hungarumlaut")).intValue();
        Encoding.wae[253] = (char)((Integer)h.get("yacute")).intValue();
        Encoding.pde[253] = (char)((Integer)h.get("yacute")).intValue();
        Encoding.mre[254] = (char)((Integer)h.get("ogonek")).intValue();
        Encoding.wae[254] = (char)((Integer)h.get("thorn")).intValue();
        Encoding.pde[254] = (char)((Integer)h.get("thorn")).intValue();
        Encoding.mre[255] = (char)((Integer)h.get("caron")).intValue();
        Encoding.wae[255] = (char)((Integer)h.get("ydieresis")).intValue();
        Encoding.pde[255] = (char)((Integer)h.get("ydieresis")).intValue();
        Encoding.sym[32] = (char)((Integer)h.get("space")).intValue();
        Encoding.sym[33] = (char)((Integer)h.get("exclam")).intValue();
        Encoding.sym[34] = (char)((Integer)h.get("universal")).intValue();
        Encoding.sym[35] = (char)((Integer)h.get("numbersign")).intValue();
        Encoding.sym[36] = (char)((Integer)h.get("existential")).intValue();
        Encoding.sym[37] = (char)((Integer)h.get("percent")).intValue();
        Encoding.sym[38] = (char)((Integer)h.get("ampersand")).intValue();
        Encoding.sym[39] = (char)((Integer)h.get("suchthat")).intValue();
        Encoding.sym[40] = (char)((Integer)h.get("parenleft")).intValue();
        Encoding.sym[41] = (char)((Integer)h.get("parenright")).intValue();
        Encoding.sym[42] = (char)((Integer)h.get("asteriskmath")).intValue();
        Encoding.sym[43] = (char)((Integer)h.get("plus")).intValue();
        Encoding.sym[44] = (char)((Integer)h.get("comma")).intValue();
        Encoding.sym[45] = (char)((Integer)h.get("minus")).intValue();
        Encoding.sym[46] = (char)((Integer)h.get("period")).intValue();
        Encoding.sym[47] = (char)((Integer)h.get("slash")).intValue();
        Encoding.sym[48] = (char)((Integer)h.get("zero")).intValue();
        Encoding.sym[49] = (char)((Integer)h.get("one")).intValue();
        Encoding.sym[50] = (char)((Integer)h.get("two")).intValue();
        Encoding.sym[51] = (char)((Integer)h.get("three")).intValue();
        Encoding.sym[52] = (char)((Integer)h.get("four")).intValue();
        Encoding.sym[53] = (char)((Integer)h.get("five")).intValue();
        Encoding.sym[54] = (char)((Integer)h.get("six")).intValue();
        Encoding.sym[55] = (char)((Integer)h.get("seven")).intValue();
        Encoding.sym[56] = (char)((Integer)h.get("eight")).intValue();
        Encoding.sym[57] = (char)((Integer)h.get("nine")).intValue();
        Encoding.sym[58] = (char)((Integer)h.get("colon")).intValue();
        Encoding.sym[59] = (char)((Integer)h.get("semicolon")).intValue();
        Encoding.sym[60] = (char)((Integer)h.get("less")).intValue();
        Encoding.sym[61] = (char)((Integer)h.get("equal")).intValue();
        Encoding.sym[62] = (char)((Integer)h.get("greater")).intValue();
        Encoding.sym[63] = (char)((Integer)h.get("question")).intValue();
        Encoding.sym[64] = (char)((Integer)h.get("congruent")).intValue();
        Encoding.sym[65] = (char)((Integer)h.get("Alpha")).intValue();
        Encoding.sym[66] = (char)((Integer)h.get("Beta")).intValue();
        Encoding.sym[67] = (char)((Integer)h.get("Chi")).intValue();
        Encoding.sym[68] = (char)((Integer)h.get("Delta")).intValue();
        Encoding.sym[69] = (char)((Integer)h.get("Epsilon")).intValue();
        Encoding.sym[70] = (char)((Integer)h.get("Phi")).intValue();
        Encoding.sym[71] = (char)((Integer)h.get("Gamma")).intValue();
        Encoding.sym[72] = (char)((Integer)h.get("Eta")).intValue();
        Encoding.sym[73] = (char)((Integer)h.get("Iota")).intValue();
        Encoding.sym[74] = (char)((Integer)h.get("theta1")).intValue();
        Encoding.sym[75] = (char)((Integer)h.get("Kappa")).intValue();
        Encoding.sym[76] = (char)((Integer)h.get("Lambda")).intValue();
        Encoding.sym[77] = (char)((Integer)h.get("Mu")).intValue();
        Encoding.sym[78] = (char)((Integer)h.get("Nu")).intValue();
        Encoding.sym[79] = (char)((Integer)h.get("Omicron")).intValue();
        Encoding.sym[80] = (char)((Integer)h.get("Pi")).intValue();
        Encoding.sym[81] = (char)((Integer)h.get("Theta")).intValue();
        Encoding.sym[82] = (char)((Integer)h.get("Rho")).intValue();
        Encoding.sym[83] = (char)((Integer)h.get("Sigma")).intValue();
        Encoding.sym[84] = (char)((Integer)h.get("Tau")).intValue();
        Encoding.sym[85] = (char)((Integer)h.get("Upsilon")).intValue();
        Encoding.sym[86] = (char)((Integer)h.get("sigma1")).intValue();
        Encoding.sym[87] = (char)((Integer)h.get("Omega")).intValue();
        Encoding.sym[88] = (char)((Integer)h.get("Xi")).intValue();
        Encoding.sym[89] = (char)((Integer)h.get("Psi")).intValue();
        Encoding.sym[90] = (char)((Integer)h.get("Zeta")).intValue();
        Encoding.sym[91] = (char)((Integer)h.get("bracketleft")).intValue();
        Encoding.sym[92] = (char)((Integer)h.get("therefore")).intValue();
        Encoding.sym[93] = (char)((Integer)h.get("bracketright")).intValue();
        Encoding.sym[94] = (char)((Integer)h.get("perpendicular")).intValue();
        Encoding.sym[95] = (char)((Integer)h.get("underscore")).intValue();
        Encoding.sym[96] = (char)((Integer)h.get("radicalex")).intValue();
        Encoding.sym[97] = (char)((Integer)h.get("alpha")).intValue();
        Encoding.sym[98] = (char)((Integer)h.get("beta")).intValue();
        Encoding.sym[99] = (char)((Integer)h.get("chi")).intValue();
        Encoding.sym[100] = (char)((Integer)h.get("delta")).intValue();
        Encoding.sym[101] = (char)((Integer)h.get("epsilon")).intValue();
        Encoding.sym[102] = (char)((Integer)h.get("phi")).intValue();
        Encoding.sym[103] = (char)((Integer)h.get("gamma")).intValue();
        Encoding.sym[104] = (char)((Integer)h.get("eta")).intValue();
        Encoding.sym[105] = (char)((Integer)h.get("iota")).intValue();
        Encoding.sym[106] = (char)((Integer)h.get("phi1")).intValue();
        Encoding.sym[107] = (char)((Integer)h.get("kappa")).intValue();
        Encoding.sym[108] = (char)((Integer)h.get("lambda")).intValue();
        Encoding.sym[109] = (char)((Integer)h.get("mu")).intValue();
        Encoding.sym[110] = (char)((Integer)h.get("nu")).intValue();
        Encoding.sym[111] = (char)((Integer)h.get("omicron")).intValue();
        Encoding.sym[112] = (char)((Integer)h.get("pi")).intValue();
        Encoding.sym[113] = (char)((Integer)h.get("theta")).intValue();
        Encoding.sym[114] = (char)((Integer)h.get("rho")).intValue();
        Encoding.sym[115] = (char)((Integer)h.get("sigma")).intValue();
        Encoding.sym[116] = (char)((Integer)h.get("tau")).intValue();
        Encoding.sym[117] = (char)((Integer)h.get("upsilon")).intValue();
        Encoding.sym[118] = (char)((Integer)h.get("omega1")).intValue();
        Encoding.sym[119] = (char)((Integer)h.get("omega")).intValue();
        Encoding.sym[120] = (char)((Integer)h.get("xi")).intValue();
        Encoding.sym[121] = (char)((Integer)h.get("psi")).intValue();
        Encoding.sym[122] = (char)((Integer)h.get("zeta")).intValue();
        Encoding.sym[123] = (char)((Integer)h.get("braceleft")).intValue();
        Encoding.sym[124] = (char)((Integer)h.get("bar")).intValue();
        Encoding.sym[125] = (char)((Integer)h.get("braceright")).intValue();
        Encoding.sym[126] = (char)((Integer)h.get("similar")).intValue();
        Encoding.sym[160] = (char)((Integer)h.get("Euro")).intValue();
        Encoding.sym[161] = (char)((Integer)h.get("Upsilon1")).intValue();
        Encoding.sym[162] = (char)((Integer)h.get("minute")).intValue();
        Encoding.sym[163] = (char)((Integer)h.get("lessequal")).intValue();
        Encoding.sym[164] = (char)((Integer)h.get("fraction")).intValue();
        Encoding.sym[165] = (char)((Integer)h.get("infinity")).intValue();
        Encoding.sym[166] = (char)((Integer)h.get("florin")).intValue();
        Encoding.sym[167] = (char)((Integer)h.get("club")).intValue();
        Encoding.sym[168] = (char)((Integer)h.get("diamond")).intValue();
        Encoding.sym[169] = (char)((Integer)h.get("heart")).intValue();
        Encoding.sym[170] = (char)((Integer)h.get("spade")).intValue();
        Encoding.sym[171] = (char)((Integer)h.get("arrowboth")).intValue();
        Encoding.sym[172] = (char)((Integer)h.get("arrowleft")).intValue();
        Encoding.sym[173] = (char)((Integer)h.get("arrowup")).intValue();
        Encoding.sym[174] = (char)((Integer)h.get("arrowright")).intValue();
        Encoding.sym[175] = (char)((Integer)h.get("arrowdown")).intValue();
        Encoding.sym[176] = (char)((Integer)h.get("degree")).intValue();
        Encoding.sym[177] = (char)((Integer)h.get("plusminus")).intValue();
        Encoding.sym[178] = (char)((Integer)h.get("second")).intValue();
        Encoding.sym[179] = (char)((Integer)h.get("greaterequal")).intValue();
        Encoding.sym[180] = (char)((Integer)h.get("multiply")).intValue();
        Encoding.sym[181] = (char)((Integer)h.get("proportional")).intValue();
        Encoding.sym[182] = (char)((Integer)h.get("partialdiff")).intValue();
        Encoding.sym[183] = (char)((Integer)h.get("bullet")).intValue();
        Encoding.sym[184] = (char)((Integer)h.get("divide")).intValue();
        Encoding.sym[185] = (char)((Integer)h.get("notequal")).intValue();
        Encoding.sym[186] = (char)((Integer)h.get("equivalence")).intValue();
        Encoding.sym[187] = (char)((Integer)h.get("approxequal")).intValue();
        Encoding.sym[188] = (char)((Integer)h.get("ellipsis")).intValue();
        Encoding.sym[189] = (char)((Integer)h.get("arrowvertex")).intValue();
        Encoding.sym[190] = (char)((Integer)h.get("arrowhorizex")).intValue();
        Encoding.sym[191] = (char)((Integer)h.get("carriagereturn")).intValue();
        Encoding.sym[192] = (char)((Integer)h.get("aleph")).intValue();
        Encoding.sym[193] = (char)((Integer)h.get("Ifraktur")).intValue();
        Encoding.sym[194] = (char)((Integer)h.get("Rfraktur")).intValue();
        Encoding.sym[195] = (char)((Integer)h.get("weierstrass")).intValue();
        Encoding.sym[196] = (char)((Integer)h.get("circlemultiply")).intValue();
        Encoding.sym[197] = (char)((Integer)h.get("circleplus")).intValue();
        Encoding.sym[198] = (char)((Integer)h.get("emptyset")).intValue();
        Encoding.sym[199] = (char)((Integer)h.get("intersection")).intValue();
        Encoding.sym[200] = (char)((Integer)h.get("union")).intValue();
        Encoding.sym[201] = (char)((Integer)h.get("propersuperset")).intValue();
        Encoding.sym[202] = (char)((Integer)h.get("reflexsuperset")).intValue();
        Encoding.sym[203] = (char)((Integer)h.get("notsubset")).intValue();
        Encoding.sym[204] = (char)((Integer)h.get("propersubset")).intValue();
        Encoding.sym[205] = (char)((Integer)h.get("reflexsubset")).intValue();
        Encoding.sym[206] = (char)((Integer)h.get("element")).intValue();
        Encoding.sym[207] = (char)((Integer)h.get("notelement")).intValue();
        Encoding.sym[208] = (char)((Integer)h.get("angle")).intValue();
        Encoding.sym[209] = (char)((Integer)h.get("gradient")).intValue();
        Encoding.sym[210] = (char)((Integer)h.get("registerserif")).intValue();
        Encoding.sym[211] = (char)((Integer)h.get("copyrightserif")).intValue();
        Encoding.sym[212] = (char)((Integer)h.get("trademarkserif")).intValue();
        Encoding.sym[213] = (char)((Integer)h.get("product")).intValue();
        Encoding.sym[214] = (char)((Integer)h.get("radical")).intValue();
        Encoding.sym[215] = (char)((Integer)h.get("dotmath")).intValue();
        Encoding.sym[216] = (char)((Integer)h.get("logicalnot")).intValue();
        Encoding.sym[217] = (char)((Integer)h.get("logicaland")).intValue();
        Encoding.sym[218] = (char)((Integer)h.get("logicalor")).intValue();
        Encoding.sym[219] = (char)((Integer)h.get("arrowdblboth")).intValue();
        Encoding.sym[220] = (char)((Integer)h.get("arrowdblleft")).intValue();
        Encoding.sym[221] = (char)((Integer)h.get("arrowdblup")).intValue();
        Encoding.sym[222] = (char)((Integer)h.get("arrowdblright")).intValue();
        Encoding.sym[223] = (char)((Integer)h.get("arrowdbldown")).intValue();
        Encoding.sym[224] = (char)((Integer)h.get("lozenge")).intValue();
        Encoding.sym[225] = (char)((Integer)h.get("angleleft")).intValue();
        Encoding.sym[226] = (char)((Integer)h.get("registersans")).intValue();
        Encoding.sym[227] = (char)((Integer)h.get("copyrightsans")).intValue();
        Encoding.sym[228] = (char)((Integer)h.get("trademarksans")).intValue();
        Encoding.sym[229] = (char)((Integer)h.get("summation")).intValue();
        Encoding.sym[230] = (char)((Integer)h.get("parenlefttp")).intValue();
        Encoding.sym[231] = (char)((Integer)h.get("parenleftex")).intValue();
        Encoding.sym[232] = (char)((Integer)h.get("parenleftbt")).intValue();
        Encoding.sym[233] = (char)((Integer)h.get("bracketlefttp")).intValue();
        Encoding.sym[234] = (char)((Integer)h.get("bracketleftex")).intValue();
        Encoding.sym[235] = (char)((Integer)h.get("bracketleftbt")).intValue();
        Encoding.sym[236] = (char)((Integer)h.get("bracelefttp")).intValue();
        Encoding.sym[237] = (char)((Integer)h.get("braceleftmid")).intValue();
        Encoding.sym[238] = (char)((Integer)h.get("braceleftbt")).intValue();
        Encoding.sym[239] = (char)((Integer)h.get("braceex")).intValue();
        Encoding.sym[241] = (char)((Integer)h.get("angleright")).intValue();
        Encoding.sym[242] = (char)((Integer)h.get("integral")).intValue();
        Encoding.sym[243] = (char)((Integer)h.get("integraltp")).intValue();
        Encoding.sym[244] = (char)((Integer)h.get("integralex")).intValue();
        Encoding.sym[245] = (char)((Integer)h.get("integralbt")).intValue();
        Encoding.sym[246] = (char)((Integer)h.get("parenrighttp")).intValue();
        Encoding.sym[247] = (char)((Integer)h.get("parenrightex")).intValue();
        Encoding.sym[248] = (char)((Integer)h.get("parenrightbt")).intValue();
        Encoding.sym[249] = (char)((Integer)h.get("bracketrighttp")).intValue();
        Encoding.sym[250] = (char)((Integer)h.get("bracketrightex")).intValue();
        Encoding.sym[251] = (char)((Integer)h.get("bracketrightbt")).intValue();
        Encoding.sym[252] = (char)((Integer)h.get("bracerighttp")).intValue();
        Encoding.sym[253] = (char)((Integer)h.get("bracerightmid")).intValue();
        Encoding.sym[254] = (char)((Integer)h.get("bracerightbt")).intValue();
        Encoding.zap[32] = (char)((Integer)h.get("space")).intValue();
        Encoding.zap[33] = (char)((Integer)h.get("a1")).intValue();
        Encoding.zap[34] = (char)((Integer)h.get("a2")).intValue();
        Encoding.zap[35] = (char)((Integer)h.get("a202")).intValue();
        Encoding.zap[36] = (char)((Integer)h.get("a3")).intValue();
        Encoding.zap[37] = (char)((Integer)h.get("a4")).intValue();
        Encoding.zap[38] = (char)((Integer)h.get("a5")).intValue();
        Encoding.zap[39] = (char)((Integer)h.get("a119")).intValue();
        Encoding.zap[40] = (char)((Integer)h.get("a118")).intValue();
        Encoding.zap[41] = (char)((Integer)h.get("a117")).intValue();
        Encoding.zap[42] = (char)((Integer)h.get("a11")).intValue();
        Encoding.zap[43] = (char)((Integer)h.get("a12")).intValue();
        Encoding.zap[44] = (char)((Integer)h.get("a13")).intValue();
        Encoding.zap[45] = (char)((Integer)h.get("a14")).intValue();
        Encoding.zap[46] = (char)((Integer)h.get("a15")).intValue();
        Encoding.zap[47] = (char)((Integer)h.get("a16")).intValue();
        Encoding.zap[48] = (char)((Integer)h.get("a105")).intValue();
        Encoding.zap[49] = (char)((Integer)h.get("a17")).intValue();
        Encoding.zap[50] = (char)((Integer)h.get("a18")).intValue();
        Encoding.zap[51] = (char)((Integer)h.get("a19")).intValue();
        Encoding.zap[52] = (char)((Integer)h.get("a20")).intValue();
        Encoding.zap[53] = (char)((Integer)h.get("a21")).intValue();
        Encoding.zap[54] = (char)((Integer)h.get("a22")).intValue();
        Encoding.zap[55] = (char)((Integer)h.get("a23")).intValue();
        Encoding.zap[56] = (char)((Integer)h.get("a24")).intValue();
        Encoding.zap[57] = (char)((Integer)h.get("a25")).intValue();
        Encoding.zap[58] = (char)((Integer)h.get("a26")).intValue();
        Encoding.zap[59] = (char)((Integer)h.get("a27")).intValue();
        Encoding.zap[60] = (char)((Integer)h.get("a28")).intValue();
        Encoding.zap[61] = (char)((Integer)h.get("a6")).intValue();
        Encoding.zap[62] = (char)((Integer)h.get("a7")).intValue();
        Encoding.zap[63] = (char)((Integer)h.get("a8")).intValue();
        Encoding.zap[64] = (char)((Integer)h.get("a9")).intValue();
        Encoding.zap[65] = (char)((Integer)h.get("a10")).intValue();
        Encoding.zap[66] = (char)((Integer)h.get("a29")).intValue();
        Encoding.zap[67] = (char)((Integer)h.get("a30")).intValue();
        Encoding.zap[68] = (char)((Integer)h.get("a31")).intValue();
        Encoding.zap[69] = (char)((Integer)h.get("a32")).intValue();
        Encoding.zap[70] = (char)((Integer)h.get("a33")).intValue();
        Encoding.zap[71] = (char)((Integer)h.get("a34")).intValue();
        Encoding.zap[72] = (char)((Integer)h.get("a35")).intValue();
        Encoding.zap[73] = (char)((Integer)h.get("a36")).intValue();
        Encoding.zap[74] = (char)((Integer)h.get("a37")).intValue();
        Encoding.zap[75] = (char)((Integer)h.get("a38")).intValue();
        Encoding.zap[76] = (char)((Integer)h.get("a39")).intValue();
        Encoding.zap[77] = (char)((Integer)h.get("a40")).intValue();
        Encoding.zap[78] = (char)((Integer)h.get("a41")).intValue();
        Encoding.zap[79] = (char)((Integer)h.get("a42")).intValue();
        Encoding.zap[80] = (char)((Integer)h.get("a43")).intValue();
        Encoding.zap[81] = (char)((Integer)h.get("a44")).intValue();
        Encoding.zap[82] = (char)((Integer)h.get("a45")).intValue();
        Encoding.zap[83] = (char)((Integer)h.get("a46")).intValue();
        Encoding.zap[84] = (char)((Integer)h.get("a47")).intValue();
        Encoding.zap[85] = (char)((Integer)h.get("a48")).intValue();
        Encoding.zap[86] = (char)((Integer)h.get("a49")).intValue();
        Encoding.zap[87] = (char)((Integer)h.get("a50")).intValue();
        Encoding.zap[88] = (char)((Integer)h.get("a51")).intValue();
        Encoding.zap[89] = (char)((Integer)h.get("a52")).intValue();
        Encoding.zap[90] = (char)((Integer)h.get("a53")).intValue();
        Encoding.zap[91] = (char)((Integer)h.get("a54")).intValue();
        Encoding.zap[92] = (char)((Integer)h.get("a55")).intValue();
        Encoding.zap[93] = (char)((Integer)h.get("a56")).intValue();
        Encoding.zap[94] = (char)((Integer)h.get("a57")).intValue();
        Encoding.zap[95] = (char)((Integer)h.get("a58")).intValue();
        Encoding.zap[96] = (char)((Integer)h.get("a59")).intValue();
        Encoding.zap[97] = (char)((Integer)h.get("a60")).intValue();
        Encoding.zap[98] = (char)((Integer)h.get("a61")).intValue();
        Encoding.zap[99] = (char)((Integer)h.get("a62")).intValue();
        Encoding.zap[100] = (char)((Integer)h.get("a63")).intValue();
        Encoding.zap[101] = (char)((Integer)h.get("a64")).intValue();
        Encoding.zap[102] = (char)((Integer)h.get("a65")).intValue();
        Encoding.zap[103] = (char)((Integer)h.get("a66")).intValue();
        Encoding.zap[104] = (char)((Integer)h.get("a67")).intValue();
        Encoding.zap[105] = (char)((Integer)h.get("a68")).intValue();
        Encoding.zap[106] = (char)((Integer)h.get("a69")).intValue();
        Encoding.zap[107] = (char)((Integer)h.get("a70")).intValue();
        Encoding.zap[108] = (char)((Integer)h.get("a71")).intValue();
        Encoding.zap[109] = (char)((Integer)h.get("a72")).intValue();
        Encoding.zap[110] = (char)((Integer)h.get("a73")).intValue();
        Encoding.zap[111] = (char)((Integer)h.get("a74")).intValue();
        Encoding.zap[112] = (char)((Integer)h.get("a203")).intValue();
        Encoding.zap[113] = (char)((Integer)h.get("a75")).intValue();
        Encoding.zap[114] = (char)((Integer)h.get("a204")).intValue();
        Encoding.zap[115] = (char)((Integer)h.get("a76")).intValue();
        Encoding.zap[116] = (char)((Integer)h.get("a77")).intValue();
        Encoding.zap[117] = (char)((Integer)h.get("a78")).intValue();
        Encoding.zap[118] = (char)((Integer)h.get("a79")).intValue();
        Encoding.zap[119] = (char)((Integer)h.get("a81")).intValue();
        Encoding.zap[120] = (char)((Integer)h.get("a82")).intValue();
        Encoding.zap[121] = (char)((Integer)h.get("a83")).intValue();
        Encoding.zap[122] = (char)((Integer)h.get("a84")).intValue();
        Encoding.zap[123] = (char)((Integer)h.get("a97")).intValue();
        Encoding.zap[124] = (char)((Integer)h.get("a98")).intValue();
        Encoding.zap[125] = (char)((Integer)h.get("a99")).intValue();
        Encoding.zap[126] = (char)((Integer)h.get("a100")).intValue();
        Encoding.zap[128] = (char)((Integer)h.get("a89")).intValue();
        Encoding.zap[129] = (char)((Integer)h.get("a90")).intValue();
        Encoding.zap[130] = (char)((Integer)h.get("a93")).intValue();
        Encoding.zap[131] = (char)((Integer)h.get("a94")).intValue();
        Encoding.zap[132] = (char)((Integer)h.get("a91")).intValue();
        Encoding.zap[133] = (char)((Integer)h.get("a92")).intValue();
        Encoding.zap[134] = (char)((Integer)h.get("a205")).intValue();
        Encoding.zap[135] = (char)((Integer)h.get("a85")).intValue();
        Encoding.zap[136] = (char)((Integer)h.get("a206")).intValue();
        Encoding.zap[137] = (char)((Integer)h.get("a86")).intValue();
        Encoding.zap[138] = (char)((Integer)h.get("a87")).intValue();
        Encoding.zap[139] = (char)((Integer)h.get("a88")).intValue();
        Encoding.zap[140] = (char)((Integer)h.get("a95")).intValue();
        Encoding.zap[141] = (char)((Integer)h.get("a96")).intValue();
        Encoding.zap[161] = (char)((Integer)h.get("a101")).intValue();
        Encoding.zap[162] = (char)((Integer)h.get("a102")).intValue();
        Encoding.zap[163] = (char)((Integer)h.get("a103")).intValue();
        Encoding.zap[164] = (char)((Integer)h.get("a104")).intValue();
        Encoding.zap[165] = (char)((Integer)h.get("a106")).intValue();
        Encoding.zap[166] = (char)((Integer)h.get("a107")).intValue();
        Encoding.zap[167] = (char)((Integer)h.get("a108")).intValue();
        Encoding.zap[168] = (char)((Integer)h.get("a112")).intValue();
        Encoding.zap[169] = (char)((Integer)h.get("a111")).intValue();
        Encoding.zap[170] = (char)((Integer)h.get("a110")).intValue();
        Encoding.zap[171] = (char)((Integer)h.get("a109")).intValue();
        Encoding.zap[172] = (char)((Integer)h.get("a120")).intValue();
        Encoding.zap[173] = (char)((Integer)h.get("a121")).intValue();
        Encoding.zap[174] = (char)((Integer)h.get("a122")).intValue();
        Encoding.zap[175] = (char)((Integer)h.get("a123")).intValue();
        Encoding.zap[176] = (char)((Integer)h.get("a124")).intValue();
        Encoding.zap[177] = (char)((Integer)h.get("a125")).intValue();
        Encoding.zap[178] = (char)((Integer)h.get("a126")).intValue();
        Encoding.zap[179] = (char)((Integer)h.get("a127")).intValue();
        Encoding.zap[180] = (char)((Integer)h.get("a128")).intValue();
        Encoding.zap[181] = (char)((Integer)h.get("a129")).intValue();
        Encoding.zap[182] = (char)((Integer)h.get("a130")).intValue();
        Encoding.zap[183] = (char)((Integer)h.get("a131")).intValue();
        Encoding.zap[184] = (char)((Integer)h.get("a132")).intValue();
        Encoding.zap[185] = (char)((Integer)h.get("a133")).intValue();
        Encoding.zap[186] = (char)((Integer)h.get("a134")).intValue();
        Encoding.zap[187] = (char)((Integer)h.get("a135")).intValue();
        Encoding.zap[188] = (char)((Integer)h.get("a136")).intValue();
        Encoding.zap[189] = (char)((Integer)h.get("a137")).intValue();
        Encoding.zap[190] = (char)((Integer)h.get("a138")).intValue();
        Encoding.zap[191] = (char)((Integer)h.get("a139")).intValue();
        Encoding.zap[192] = (char)((Integer)h.get("a140")).intValue();
        Encoding.zap[193] = (char)((Integer)h.get("a141")).intValue();
        Encoding.zap[194] = (char)((Integer)h.get("a142")).intValue();
        Encoding.zap[195] = (char)((Integer)h.get("a143")).intValue();
        Encoding.zap[196] = (char)((Integer)h.get("a144")).intValue();
        Encoding.zap[197] = (char)((Integer)h.get("a145")).intValue();
        Encoding.zap[198] = (char)((Integer)h.get("a146")).intValue();
        Encoding.zap[199] = (char)((Integer)h.get("a147")).intValue();
        Encoding.zap[200] = (char)((Integer)h.get("a148")).intValue();
        Encoding.zap[201] = (char)((Integer)h.get("a149")).intValue();
        Encoding.zap[202] = (char)((Integer)h.get("a150")).intValue();
        Encoding.zap[203] = (char)((Integer)h.get("a151")).intValue();
        Encoding.zap[204] = (char)((Integer)h.get("a152")).intValue();
        Encoding.zap[205] = (char)((Integer)h.get("a153")).intValue();
        Encoding.zap[206] = (char)((Integer)h.get("a154")).intValue();
        Encoding.zap[207] = (char)((Integer)h.get("a155")).intValue();
        Encoding.zap[208] = (char)((Integer)h.get("a156")).intValue();
        Encoding.zap[209] = (char)((Integer)h.get("a157")).intValue();
        Encoding.zap[210] = (char)((Integer)h.get("a158")).intValue();
        Encoding.zap[211] = (char)((Integer)h.get("a159")).intValue();
        Encoding.zap[212] = (char)((Integer)h.get("a160")).intValue();
        Encoding.zap[213] = (char)((Integer)h.get("a161")).intValue();
        Encoding.zap[214] = (char)((Integer)h.get("a163")).intValue();
        Encoding.zap[215] = (char)((Integer)h.get("a164")).intValue();
        Encoding.zap[216] = (char)((Integer)h.get("a196")).intValue();
        Encoding.zap[217] = (char)((Integer)h.get("a165")).intValue();
        Encoding.zap[218] = (char)((Integer)h.get("a192")).intValue();
        Encoding.zap[219] = (char)((Integer)h.get("a166")).intValue();
        Encoding.zap[220] = (char)((Integer)h.get("a167")).intValue();
        Encoding.zap[221] = (char)((Integer)h.get("a168")).intValue();
        Encoding.zap[222] = (char)((Integer)h.get("a169")).intValue();
        Encoding.zap[223] = (char)((Integer)h.get("a170")).intValue();
        Encoding.zap[224] = (char)((Integer)h.get("a171")).intValue();
        Encoding.zap[225] = (char)((Integer)h.get("a172")).intValue();
        Encoding.zap[226] = (char)((Integer)h.get("a173")).intValue();
        Encoding.zap[227] = (char)((Integer)h.get("a162")).intValue();
        Encoding.zap[228] = (char)((Integer)h.get("a174")).intValue();
        Encoding.zap[229] = (char)((Integer)h.get("a175")).intValue();
        Encoding.zap[230] = (char)((Integer)h.get("a176")).intValue();
        Encoding.zap[231] = (char)((Integer)h.get("a177")).intValue();
        Encoding.zap[232] = (char)((Integer)h.get("a178")).intValue();
        Encoding.zap[233] = (char)((Integer)h.get("a179")).intValue();
        Encoding.zap[234] = (char)((Integer)h.get("a193")).intValue();
        Encoding.zap[235] = (char)((Integer)h.get("a180")).intValue();
        Encoding.zap[236] = (char)((Integer)h.get("a199")).intValue();
        Encoding.zap[237] = (char)((Integer)h.get("a181")).intValue();
        Encoding.zap[238] = (char)((Integer)h.get("a200")).intValue();
        Encoding.zap[239] = (char)((Integer)h.get("a182")).intValue();
        Encoding.zap[241] = (char)((Integer)h.get("a201")).intValue();
        Encoding.zap[242] = (char)((Integer)h.get("a183")).intValue();
        Encoding.zap[243] = (char)((Integer)h.get("a184")).intValue();
        Encoding.zap[244] = (char)((Integer)h.get("a197")).intValue();
        Encoding.zap[245] = (char)((Integer)h.get("a185")).intValue();
        Encoding.zap[246] = (char)((Integer)h.get("a194")).intValue();
        Encoding.zap[247] = (char)((Integer)h.get("a198")).intValue();
        Encoding.zap[248] = (char)((Integer)h.get("a186")).intValue();
        Encoding.zap[249] = (char)((Integer)h.get("a195")).intValue();
        Encoding.zap[250] = (char)((Integer)h.get("a187")).intValue();
        Encoding.zap[251] = (char)((Integer)h.get("a188")).intValue();
        Encoding.zap[252] = (char)((Integer)h.get("a189")).intValue();
        Encoding.zap[253] = (char)((Integer)h.get("a190")).intValue();
        Encoding.zap[254] = (char)((Integer)h.get("a191")).intValue();
    }
}

