/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.utils.PaginatedNodeIterator;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVContainer;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ContentListViewer/UICLVContainer.gtmpl", events={@EventConfig(listeners={UICLVContainer.QuickEditActionListener.class})})
public class UICLVFolderMode
extends UICLVContainer {
    private UICLVPresentation clvPresentation;

    public void init() throws Exception {
        PortletPreferences portletPreferences = Utils.getAllPortletPreferences();
        List nodes = null;
        this.messageKey = null;
        try {
            nodes = this.getRenderedContentNodes();
        }
        catch (ItemNotFoundException e) {
            this.messageKey = "UIMessageBoard.msg.folder-not-found";
            return;
        }
        catch (AccessDeniedException e) {
            this.messageKey = "UIMessageBoard.msg.no-permission";
            return;
        }
        catch (Exception e) {
            this.messageKey = "UIMessageBoard.msg.error-nodetype";
            return;
        }
        if (nodes.size() == 0) {
            this.messageKey = "UIMessageBoard.msg.folder-empty";
        }
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        PaginatedNodeIterator paginatedNodeIterator = new PaginatedNodeIterator(nodes, itemsPerPage);
        this.getChildren().clear();
        this.clvPresentation = (UICLVPresentation)this.addChild(UICLVPresentation.class, null, null);
        String templatePath = this.getFormViewTemplatePath();
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        this.clvPresentation.init(templatePath, resourceResolver, (PageList)paginatedNodeIterator);
        this.clvPresentation.setContentColumn(portletPreferences.getValue("header", null));
        this.clvPresentation.setShowLink(Boolean.parseBoolean(portletPreferences.getValue("showLink", null)));
        this.clvPresentation.setShowHeader(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        this.clvPresentation.setShowReadmore(Boolean.parseBoolean(portletPreferences.getValue("showReadmore", null)));
        this.clvPresentation.setHeader(portletPreferences.getValue("header", null));
    }

    public List<Node> getRenderedContentNodes() throws Exception {
        PortletRequestContext portletRequestContext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences preferences = portletRequestContext.getRequest().getPreferences();
        WCMComposer wcmComposer = (WCMComposer)this.getApplicationComponent(WCMComposer.class);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("filter-mode", Utils.getCurrentMode());
        String orderBy = preferences.getValue("orderBy", null);
        String orderType = preferences.getValue("orderType", null);
        if (orderType == null) {
            orderType = "DESC";
        }
        if (orderBy == null) {
            orderBy = "exo:title";
        }
        filters.put("filter-order-by", orderBy);
        filters.put("filter-order-type", orderType);
        if (preferences.getValue("folderPath", null) == null) {
            return new ArrayList<Node>();
        }
        NodeLocation nodeLocation = NodeLocation.getNodeLocationByExpression((String)preferences.getValue("folderPath", null));
        return wcmComposer.getContents(nodeLocation.getRepository(), nodeLocation.getWorkspace(), nodeLocation.getPath(), filters, WCMCoreUtils.getUserSessionProvider());
    }
}

