/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wcm.webui.clv;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.portlet.PortletPreferences;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.wcm.webui.Utils;
import org.exoplatform.wcm.webui.clv.UICLVContainer;
import org.exoplatform.wcm.webui.clv.UICLVPresentation;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.Lifecycle;

@ComponentConfig(lifecycle=Lifecycle.class, template="app:/groovy/ContentListViewer/UICLVContainer.gtmpl", events={@EventConfig(listeners={UICLVContainer.QuickEditActionListener.class})})
public class UICLVManualMode
extends UICLVContainer {
    public void init() throws Exception {
        PortletPreferences portletPreferences = Utils.getAllPortletPreferences();
        String[] listContent = portletPreferences.getValues("contents", null);
        if (listContent == null || listContent.length == 0) {
            this.messageKey = "UIMessageBoard.msg.contents-not-found";
            return;
        }
        int itemsPerPage = Integer.parseInt(portletPreferences.getValue("itemsPerPage", null));
        ArrayList<Node> nodes = new ArrayList<Node>();
        if (listContent != null && listContent.length != 0) {
            for (String itemPath : listContent) {
                try {
                    NodeLocation nodeLocation = NodeLocation.getNodeLocationByExpression((String)itemPath);
                    Node viewNode = Utils.getViewableNodeByComposer((String)nodeLocation.getRepository(), (String)nodeLocation.getWorkspace(), (String)nodeLocation.getPath());
                    if (viewNode == null) continue;
                    nodes.add(viewNode);
                }
                catch (Exception e) {
                    Utils.createPopupMessage((UIContainer)this, (String)"UIMessageBoard.msg.add-node-error", null, (int)0);
                }
            }
        }
        if (nodes.size() == 0) {
            this.messageKey = "UIMessageBoard.msg.contents-not-found";
        }
        this.getChildren().clear();
        ObjectPageList pageList = new ObjectPageList(nodes, itemsPerPage);
        String templatePath = this.getFormViewTemplatePath();
        ResourceResolver resourceResolver = this.getTemplateResourceResolver();
        UICLVPresentation clvPresentation = (UICLVPresentation)this.addChild(UICLVPresentation.class, null, null);
        clvPresentation.init(templatePath, resourceResolver, (PageList)pageList);
        clvPresentation.setContentColumn(portletPreferences.getValue("header", null));
        clvPresentation.setShowLink(Boolean.parseBoolean(portletPreferences.getValue("showLink", null)));
        clvPresentation.setShowHeader(Boolean.parseBoolean(portletPreferences.getValue("showHeader", null)));
        clvPresentation.setShowReadmore(Boolean.parseBoolean(portletPreferences.getValue("showReadmore", null)));
        clvPresentation.setHeader(portletPreferences.getValue("header", null));
    }
}

