/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import java.io.Serializable;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.exoplatform.commons.utils.SecurityHelper;
import org.exoplatform.services.jcr.ext.organization.CommonHandler;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipHandlerImpl;
import org.exoplatform.services.jcr.ext.organization.MembershipTypeImpl;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.CacheHandler;
import org.exoplatform.services.organization.MembershipType;
import org.exoplatform.services.organization.MembershipTypeEventListener;
import org.exoplatform.services.organization.MembershipTypeEventListenerHandler;
import org.exoplatform.services.organization.MembershipTypeHandler;
import org.exoplatform.services.security.PermissionConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MembershipTypeHandlerImpl
extends CommonHandler
implements MembershipTypeHandler,
MembershipTypeEventListenerHandler {
    public static final String JOS_DESCRIPTION = "jos:description";
    public static final String STORAGE_JOS_MEMBERSHIP_TYPES = "jos:membershipTypes";
    protected final JCROrganizationServiceImpl service;
    protected final List<MembershipTypeEventListener> listeners = new ArrayList<MembershipTypeEventListener>();
    protected static Log log = ExoLogger.getLogger((String)"jcr.MembershipTypeHandler");

    MembershipTypeHandlerImpl(JCROrganizationServiceImpl service) {
        this.service = service;
    }

    MembershipType createMembershipType(Session session, MembershipType mt, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.createMembershipType method is started");
        }
        try {
            Node storagePath = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_JOS_MEMBERSHIP_TYPES);
            Node mtNode = storagePath.addNode(mt.getName());
            if (mt instanceof MembershipTypeImpl) {
                ((MembershipTypeImpl)mt).setUUId(mtNode.getUUID());
            }
            if (broadcast) {
                this.preSave(mt, true);
            }
            this.writeObjectToNode(mt, mtNode);
            session.save();
            this.service.getCacheHandler().put((Serializable)((Object)mt.getName()), mt, CacheHandler.CacheType.MEMBERSHIPTYPE);
            if (broadcast) {
                this.postSave(mt, true);
            }
            return this.readObjectFromNode(mtNode);
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not create membership type '" + mt.getName() + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType createMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.createMembershipType(session, mt, broadcast);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    public MembershipType createMembershipTypeInstance() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.createMembershipTypeInstance method is started");
        }
        return new MembershipTypeImpl();
    }

    private MembershipType findMembershipType(Session session, String name) throws Exception {
        MembershipType mt;
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.findMembershipType method is started");
        }
        if ((mt = (MembershipType)this.service.getCacheHandler().get((Serializable)((Object)name), CacheHandler.CacheType.MEMBERSHIPTYPE)) != null) {
            return mt;
        }
        try {
            Node mtNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_JOS_MEMBERSHIP_TYPES + "/" + name);
            mt = this.readObjectFromNode(mtNode);
            this.service.getCacheHandler().put((Serializable)((Object)name), mt, CacheHandler.CacheType.MEMBERSHIPTYPE);
            return mt;
        }
        catch (PathNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership type '" + name + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType findMembershipType(String name) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.findMembershipType(session, name);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    private Collection findMembershipTypes(Session session) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.findMembershipTypes method is started");
        }
        try {
            ArrayList<MembershipType> types = new ArrayList<MembershipType>();
            Node storageNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_JOS_MEMBERSHIP_TYPES);
            NodeIterator nodes = storageNode.getNodes();
            while (nodes.hasNext()) {
                types.add(this.readObjectFromNode(nodes.nextNode()));
            }
            return types;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not find membership types", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection findMembershipTypes() throws Exception {
        Session session = this.service.getStorageSession();
        try {
            Collection collection = this.findMembershipTypes(session);
            return collection;
        }
        finally {
            session.logout();
        }
    }

    private MembershipType removeMembershipType(Session session, String name, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.removeMembershipType method is started");
        }
        try {
            Node mtNode = (Node)session.getItem(this.service.getStoragePath() + "/" + STORAGE_JOS_MEMBERSHIP_TYPES + "/" + name);
            String mStatement = "select * from jos:userMembership where jos:membershipType='" + mtNode.getUUID() + "'";
            Query mQuery = session.getWorkspace().getQueryManager().createQuery(mStatement, "sql");
            QueryResult mRes = mQuery.execute();
            NodeIterator mNodes = mRes.getNodes();
            while (mNodes.hasNext()) {
                Node mNode = mNodes.nextNode();
                ((MembershipHandlerImpl)this.service.getMembershipHandler()).removeMembership(session, mNode.getUUID(), broadcast);
            }
            MembershipType mt = this.readObjectFromNode(mtNode);
            if (broadcast) {
                this.preDelete(mt);
            }
            mtNode.remove();
            session.save();
            this.service.getCacheHandler().remove((Serializable)((Object)name), CacheHandler.CacheType.MEMBERSHIPTYPE);
            this.service.getCacheHandler().remove((Serializable)((Object)("mt=" + name)), CacheHandler.CacheType.MEMBERSHIP);
            if (broadcast) {
                this.postDelete(mt);
            }
            return mt;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not remove membership type '" + name + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType removeMembershipType(String name, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.removeMembershipType(session, name, broadcast);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    private MembershipType saveMembershipType(Session session, MembershipType mt, boolean broadcast) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"MembershipType.saveMembershipType method is started");
        }
        try {
            String mtUUID;
            MembershipTypeImpl mType = (MembershipTypeImpl)mt;
            if (mType.getUUId() != null) {
                mtUUID = mType.getUUId();
            } else {
                mtUUID = ((MembershipTypeImpl)this.findMembershipType(session, mType.getName())).getUUId();
                mType.setUUId(mtUUID);
            }
            Node mtNode = session.getNodeByUUID(mtUUID);
            String srcPath = mtNode.getPath();
            int pos = srcPath.lastIndexOf(47);
            String prevName = srcPath.substring(pos + 1);
            if (!prevName.equals(mType.getName())) {
                String destPath = srcPath.substring(0, pos) + "/" + mType.getName();
                session.move(srcPath, destPath);
                mtNode = (Node)session.getItem(destPath);
            }
            if (broadcast) {
                this.preSave(mType, false);
            }
            this.writeObjectToNode(mType, mtNode);
            session.save();
            if (!prevName.equals(mType.getName())) {
                this.service.getCacheHandler().remove((Serializable)((Object)prevName), CacheHandler.CacheType.MEMBERSHIPTYPE);
                this.service.getCacheHandler().move((Serializable)((Object)("mt=" + prevName)), (Serializable)((Object)("mt=" + mType.getName())), CacheHandler.CacheType.MEMBERSHIP);
            }
            this.service.getCacheHandler().put((Serializable)((Object)mType.getName()), mType, CacheHandler.CacheType.MEMBERSHIPTYPE);
            if (broadcast) {
                this.postSave(mType, false);
            }
            return mType;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not save membership type '" + mt.getName() + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MembershipType saveMembershipType(MembershipType mt, boolean broadcast) throws Exception {
        Session session = this.service.getStorageSession();
        try {
            MembershipType membershipType = this.saveMembershipType(session, mt, broadcast);
            return membershipType;
        }
        finally {
            session.logout();
        }
    }

    private MembershipType readObjectFromNode(Node node) throws Exception {
        try {
            MembershipTypeImpl mt = new MembershipTypeImpl(node.getUUID());
            mt.setName(node.getName());
            mt.setDescription(this.readStringProperty(node, JOS_DESCRIPTION));
            return mt;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not read membership type properties", e);
        }
    }

    private void writeObjectToNode(MembershipType mt, Node node) throws Exception {
        try {
            node.setProperty(JOS_DESCRIPTION, mt.getDescription());
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not write membership type properties", e);
        }
    }

    public void removeMembershipTypeEventListener(MembershipTypeEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.remove(listener);
    }

    public void addMembershipTypeEventListener(MembershipTypeEventListener listener) {
        SecurityHelper.validateSecurityPermission((Permission)PermissionConstants.MANAGE_LISTENERS);
        this.listeners.add(listener);
    }

    private void preSave(MembershipType type, boolean isNew) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.preSave(type, isNew);
        }
    }

    private void postSave(MembershipType type, boolean isNew) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.postSave(type, isNew);
        }
    }

    private void preDelete(MembershipType type) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.preDelete(type);
        }
    }

    private void postDelete(MembershipType type) throws Exception {
        for (MembershipTypeEventListener listener : this.listeners) {
            listener.postDelete(type);
        }
    }

    public List<MembershipTypeEventListener> getMembershipTypeListeners() {
        return Collections.unmodifiableList(this.listeners);
    }
}

