/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.index.persistent.impl;

import com.google.api.client.util.IOUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.jcr.RepositoryException;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.utils.IOUtil;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.container.component.ComponentRequestLifecycle;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.WorkspaceContainerFacade;
import org.exoplatform.services.jcr.ext.index.persistent.JCRIndexingOperationType;
import org.exoplatform.services.jcr.ext.index.persistent.api.JCRIndexingQueueDAO;
import org.exoplatform.services.jcr.ext.index.persistent.api.JCRIndexingService;
import org.exoplatform.services.jcr.ext.index.persistent.api.TransientQueueEntrySet;
import org.exoplatform.services.jcr.ext.index.persistent.entity.JCRIndexQueueEntity;
import org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl$AjcClosure1;
import org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl$AjcClosure11;
import org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl$AjcClosure13;
import org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl$AjcClosure3;
import org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl$AjcClosure5;
import org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl$AjcClosure7;
import org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl$AjcClosure9;
import org.exoplatform.services.jcr.impl.core.query.ChangesFilterListsWrapper;
import org.exoplatform.services.jcr.impl.core.query.IndexRecovery;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.jcr.impl.core.query.lucene.ChangesHolder;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rpc.RPCService;
import org.picocontainer.Startable;

public class JCRIndexingServiceImpl
implements JCRIndexingService,
Startable {
    public static final String LAST_OPERATION_FILE_NAME = "lastOperationID";
    private static final Log LOG;
    private static final String CLUSTER_NODE_NAME_PARAMETER = "cluster.node.name";
    private static final String BATCH_NUMBER_PARAM = "batch.number";
    private static final String QUEUE_PROCESSING_PERIOD_SECONDS_PARAM = "queue.periodicity.seconds";
    private final JCRIndexingQueueDAO indexingQueueDAO;
    private final RepositoryService repositoryService;
    private final EntityManagerService entityManagerService;
    private String repositoryName;
    private String clusterNodeName;
    private ThreadLocal<Boolean> isIndexingLocally = new ThreadLocal();
    private int queueProcessingPeriod = 5;
    private final ConcurrentLinkedQueue<TransientQueueEntrySet> transientQueueToPersist = new ConcurrentLinkedQueue();
    private ScheduledExecutorService filePersisterThread = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService queueProducingJobService = Executors.newSingleThreadScheduledExecutor();
    private ScheduledExecutorService queueConsumingJobService = Executors.newSingleThreadScheduledExecutor();
    private AtomicBoolean indexingOperationIsRunning = new AtomicBoolean();
    private AtomicLong storedLastOperationId = new AtomicLong(0L);
    private AtomicLong localLastOperationId = null;
    private File localLastOperationFile = null;
    private int batchNumber = 100;
    private ExoContainer container;
    private boolean initialized;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    public JCRIndexingServiceImpl(EntityManagerService entityManagerService, RepositoryService repositoryService, JCRIndexingQueueDAO indexingQueueDAO, InitParams params) {
        this.indexingQueueDAO = indexingQueueDAO;
        this.repositoryService = repositoryService;
        this.entityManagerService = entityManagerService;
        if (params.containsKey((Object)BATCH_NUMBER_PARAM)) {
            String batchNumberValue = params.getValueParam(BATCH_NUMBER_PARAM).getValue();
            try {
                this.batchNumber = Integer.parseInt(batchNumberValue);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid parameter {} with value {}. default value will be used", new Object[]{BATCH_NUMBER_PARAM, batchNumberValue, this.batchNumber});
            }
        }
        if (params.containsKey((Object)QUEUE_PROCESSING_PERIOD_SECONDS_PARAM)) {
            String value = params.getValueParam(QUEUE_PROCESSING_PERIOD_SECONDS_PARAM).getValue();
            try {
                this.queueProcessingPeriod = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                LOG.warn("Invalid parameter {} with value {}. default value will be used", new Object[]{QUEUE_PROCESSING_PERIOD_SECONDS_PARAM, value, this.queueProcessingPeriod});
            }
        }
        String string = this.clusterNodeName = params.containsKey((Object)CLUSTER_NODE_NAME_PARAMETER) ? params.getValueParam(CLUSTER_NODE_NAME_PARAMETER).getValue() : null;
        if (StringUtils.isBlank((String)this.clusterNodeName)) {
            throw new IllegalStateException("cluster.node.name parameter is empty");
        }
    }

    @Override
    public synchronized void processIndexingQueue() throws Exception {
        if (!this.initialized || this.isIndexingInCurrentThread()) {
            return;
        }
        this.isIndexingLocally.set(true);
        this.computeCurrentContainer();
        RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
        try {
            this.applyIndexChangesOnJCR();
        }
        finally {
            this.isIndexingLocally.remove();
            RequestLifeCycle.end();
        }
    }

    public void start() {
        if (this.container instanceof PortalContainer) {
            PortalContainer portalContainer = (PortalContainer)this.container;
            PortalContainer.addInitTask((ServletContext)portalContainer.getPortalContext(), (RootContainer.PortalContainerInitTask)new RootContainer.PortalContainerPostInitTask(){

                public void execute(ServletContext context, PortalContainer portalContainer) {
                    JCRIndexingServiceImpl.this.scheduleIndexTasks();
                }
            });
        }
    }

    public void stop() {
        if (!this.queueProducingJobService.isShutdown() && !this.queueProducingJobService.isTerminated()) {
            this.queueProducingJobService.shutdownNow();
        }
        if (!this.queueConsumingJobService.isShutdown() && !this.queueConsumingJobService.isTerminated()) {
            this.queueConsumingJobService.shutdownNow();
        }
        if (!this.filePersisterThread.isShutdown() && !this.filePersisterThread.isTerminated()) {
            this.filePersisterThread.shutdownNow();
        }
    }

    @Override
    public void applyIndexChangesOnQueue(ChangesFilterListsWrapper changes, String workspaceId) {
        this.applyIndexChangesOnQueue(changes.getRemovedNodes(), changes.getAddedNodes(), changes.getParentRemovedNodes(), changes.getParentAddedNodes(), workspaceId);
    }

    @Override
    public void applyIndexChangesOnQueue(Set<String> removedNodes, Set<String> addedNodes, Set<String> parentRemovedNodes, Set<String> parentAddedNodes, String workspaceId) {
        this.transientQueueToPersist.offer(new TransientQueueEntrySet(workspaceId, removedNodes, addedNodes, parentRemovedNodes, parentAddedNodes));
    }

    @Override
    public synchronized void init(QueryHandler handler, QueryHandlerEntry config) {
        if (this.initialized) {
            return;
        }
        LOG.debug((Object)"Initialize JCR QUEUE Indexing Service");
        this.retrieveLocalLastOperationFile();
        if (this.localLastOperationFile == null || !this.localLastOperationFile.exists()) {
            try {
                String indexDirPath = config.getParameter("index-dir").getValue();
                this.retrieveLastOperationIDFromCoordinator(handler, indexDirPath);
            }
            catch (Exception e) {
                LOG.warn((Object)"Unable to retrieve lastOperation file from coordinator", (Throwable)e);
            }
        }
        if (this.localLastOperationFile != null && this.localLastOperationFile.exists()) {
            this.updateQueueSwitchStatusInFile();
        }
        this.initialized = true;
    }

    @ExoTransactional
    public void applyIndexChangesOnJCR(List<JCRIndexQueueEntity> indexingQueueEntities) throws Exception {
        List<JCRIndexQueueEntity> list = indexingQueueEntities;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, list);
        Object[] objectArray = new Object[]{this, list, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JCRIndexingServiceImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public List<JCRIndexQueueEntity> findNextOperations(int offset, int batchNumber) {
        int n = offset;
        int n2 = batchNumber;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)Conversions.intObject((int)n), (Object)Conversions.intObject((int)n2));
        Object[] objectArray = new Object[]{this, Conversions.intObject((int)n), Conversions.intObject((int)n2), joinPoint};
        return (List)ExoTransactionalAspect.aspectOf().around(new JCRIndexingServiceImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void index(String jcrUUID, String workspaceId, boolean parentChange) {
        String string = jcrUUID;
        String string2 = workspaceId;
        boolean bl = parentChange;
        Object[] objectArray = new Object[]{string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, Conversions.booleanObject((boolean)bl), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JCRIndexingServiceImpl$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void reindex(String jcrUUID, String workspaceId, boolean parentChange) {
        String string = jcrUUID;
        String string2 = workspaceId;
        boolean bl = parentChange;
        Object[] objectArray = new Object[]{string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, Conversions.booleanObject((boolean)bl), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JCRIndexingServiceImpl$AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void unindex(String jcrUUID, String workspaceId, boolean parentChange) {
        String string = jcrUUID;
        String string2 = workspaceId;
        boolean bl = parentChange;
        Object[] objectArray = new Object[]{string, string2, Conversions.booleanObject((boolean)bl)};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, string2, Conversions.booleanObject((boolean)bl), joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JCRIndexingServiceImpl$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void unindexAll(String workspaceId) {
        String string = workspaceId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JCRIndexingServiceImpl$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    @ExoTransactional
    public void updateQueueSwitchStatusInFile() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        ExoTransactionalAspect.aspectOf().around(new JCRIndexingServiceImpl$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648));
    }

    public String getLastExecutedOperation() {
        if (this.localLastOperationFile == null || !this.localLastOperationFile.exists()) {
            return null;
        }
        try {
            return IOUtil.getFileContentAsString((File)this.localLastOperationFile);
        }
        catch (IOException e) {
            LOG.error((Object)"An error occurred while retrieving last operation id from file", (Throwable)e);
            return null;
        }
    }

    public int getQueueProcessingPeriod() {
        return this.queueProcessingPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistQueueOperations() {
        this.computeCurrentContainer();
        while (this.transientQueueToPersist.peek() != null) {
            TransientQueueEntrySet queueEntrySet = this.transientQueueToPersist.poll();
            Set<String> addedNodes = queueEntrySet.getAddedNodes();
            Set<String> parentAddedNodes = queueEntrySet.getParentAddedNodes();
            Set<String> removedNodes = queueEntrySet.getRemovedNodes();
            Set<String> parentRemovedNodes = queueEntrySet.getParentRemovedNodes();
            String workspaceId = queueEntrySet.getWorkspace();
            RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("PUSH to queue index: '{}' parent create & '{}' parent remove & '{}' create & '{}' remove", new Object[]{parentAddedNodes.size(), parentRemovedNodes.size(), addedNodes.size(), removedNodes.size()});
                    for (String parentRemovedNode : parentRemovedNodes) {
                        LOG.debug("-  PUSH to queue index: parent delete UUID = {}", new Object[]{parentRemovedNode});
                    }
                    for (String removedNode : removedNodes) {
                        LOG.debug("-  PUSH to queue index: delete UUID = {}", new Object[]{removedNode});
                    }
                    for (String parentAddedNode : parentAddedNodes) {
                        LOG.debug("+  PUSH to queue index: parent create UUID = {}", new Object[]{parentAddedNode});
                    }
                    for (String addedNode : addedNodes) {
                        LOG.debug("+  PUSH to queue index: create UUID = {}", new Object[]{addedNode});
                    }
                }
                for (String removeNodeUUID : parentRemovedNodes) {
                    if (!parentAddedNodes.contains(removeNodeUUID)) {
                        LOG.debug("Delete all previous indexing operations with JCR UUID '{}' since the node was deleted", new Object[]{removeNodeUUID});
                        this.indexingQueueDAO.deleteOperationsByJCRUUID(removeNodeUUID);
                    }
                    this.unindex(removeNodeUUID, workspaceId, true);
                }
                for (String removeNodeUUID : removedNodes) {
                    if (!addedNodes.contains(removeNodeUUID)) {
                        LOG.debug("Delete all previous indexing operations with JCR UUID '{}' since the node was deleted", new Object[]{removeNodeUUID});
                        this.indexingQueueDAO.deleteOperationsByJCRUUID(removeNodeUUID);
                    }
                    this.unindex(removeNodeUUID, workspaceId, false);
                }
                for (String addedNodeUUID : parentAddedNodes) {
                    this.index(addedNodeUUID, workspaceId, true);
                }
                for (String addedNodeUUID : addedNodes) {
                    this.index(addedNodeUUID, workspaceId, false);
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while applying changes", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }
    }

    private void retrieveLastOperationIDFromCoordinator(QueryHandler handler, String indexDirPath) throws Exception {
        IndexRecovery indexRecovery = handler.getContext().getIndexRecovery();
        File indexDirFile = new File(indexDirPath);
        File lastOperationFile = new File(indexDirFile.getParentFile(), LAST_OPERATION_FILE_NAME);
        if (lastOperationFile.exists()) {
            this.localLastOperationFile = lastOperationFile;
            return;
        }
        if (!handler.getContext().isRecoveryFilterUsed() || handler.getContext().getIndexRecovery() == null) {
            return;
        }
        RPCService rpcService = handler.getContext().getRPCService();
        if (rpcService == null || rpcService.isCoordinator()) {
            return;
        }
        LOG.debug((Object)"Retriving last executed queue operation file from coordinator");
        InputStream indexFile = indexRecovery.getIndexFile("../lastOperationID");
        try (FileOutputStream outputStream = new FileOutputStream(lastOperationFile);){
            IOUtils.copy((InputStream)indexFile, (OutputStream)outputStream);
            outputStream.flush();
        }
    }

    private void applyIndexChangesOnJCR() throws Exception {
        int offset = 0;
        int proceededOperations = 0;
        do {
            List<JCRIndexQueueEntity> indexingQueueEntities = this.findNextOperations(offset, this.batchNumber);
            proceededOperations = indexingQueueEntities.size();
            this.applyIndexChangesOnJCR(indexingQueueEntities);
        } while (proceededOperations == this.batchNumber);
    }

    private void updateLastNewOperationId(long id) {
        this.checkStoredLastOperationId();
        this.localLastOperationId.getAndUpdate(value -> id > value ? id : value);
    }

    public void persistLastOperationId() {
        this.retrieveLocalLastOperationFile();
        if (this.localLastOperationFile == null) {
            LOG.error((Object)"JCR Index parent directory wasn't found. Can't save last indexed operation.");
            return;
        }
        this.checkStoredLastOperationId();
        long id = this.localLastOperationId.get();
        if (this.storedLastOperationId.get() >= id) {
            return;
        }
        LOG.debug("Persist last index operation id: {}", new Object[]{id});
        try (FileOutputStream outputStream = new FileOutputStream(this.localLastOperationFile);){
            String fileContent = id + ";" + this.clusterNodeName;
            outputStream.write(fileContent.getBytes());
            outputStream.flush();
            this.storedLastOperationId.set(id);
        }
        catch (Exception e) {
            LOG.error((Object)"Error while writing last operation ID ", (Throwable)e);
        }
    }

    private void checkStoredLastOperationId() {
        if (this.localLastOperationId == null) {
            String lastExecutedOperation = this.getLastExecutedOperation();
            if (StringUtils.isNotBlank((String)lastExecutedOperation)) {
                String[] lastExecutedIdArray = lastExecutedOperation.split(";");
                String lastExecutedIdString = lastExecutedIdArray[0];
                this.localLastOperationId = new AtomicLong(Long.parseLong(lastExecutedIdString));
            } else {
                this.localLastOperationId = new AtomicLong(0L);
            }
            this.storedLastOperationId.set(this.localLastOperationId.get());
        }
    }

    private JCRIndexQueueEntity addToIndexingQueue(String jcrUUID, String workspaceId, JCRIndexingOperationType operationType, boolean parentChange) {
        if (operationType == null) {
            throw new IllegalArgumentException("Operation cannot be null");
        }
        JCRIndexQueueEntity indexingEntity = this.getIndexingEntity(jcrUUID, workspaceId, operationType, parentChange);
        indexingEntity = (JCRIndexQueueEntity)this.indexingQueueDAO.create(indexingEntity);
        return indexingEntity;
    }

    private boolean isIndexingInCurrentThread() {
        return this.isIndexingLocally.get() != null && this.isIndexingLocally.get() != false;
    }

    private JCRIndexQueueEntity getIndexingEntity(String jcrUUID, String workspaceId, JCRIndexingOperationType operationType, boolean parentChange) {
        return new JCRIndexQueueEntity(jcrUUID, workspaceId, operationType, Calendar.getInstance(), parentChange, this.clusterNodeName);
    }

    private void retrieveLocalLastOperationFile() {
        if (this.localLastOperationFile != null) {
            return;
        }
        String workspaceIndexDirName = this.getSystemWorkspaceIndexDirectory();
        if (StringUtils.isBlank((String)workspaceIndexDirName)) {
            return;
        }
        File workspaceIndexFolder = new File(workspaceIndexDirName);
        File rootIndexFolder = workspaceIndexFolder.getParentFile();
        if (!rootIndexFolder.exists()) {
            rootIndexFolder.mkdirs();
        }
        this.localLastOperationFile = new File(rootIndexFolder, LAST_OPERATION_FILE_NAME);
    }

    private String getSystemWorkspaceIndexDirectory() {
        String indexDirName = null;
        try {
            ManageableRepository repository = this.repositoryService.getCurrentRepository();
            String systemWorkspaceName = repository.getConfiguration().getSystemWorkspaceName();
            WorkspaceContainerFacade workspaceContainer = repository.getWorkspaceContainer(systemWorkspaceName);
            WorkspaceEntry workspaceEntry = (WorkspaceEntry)workspaceContainer.getComponent(WorkspaceEntry.class);
            indexDirName = workspaceEntry.getQueryHandler().getParameterValue("index-dir");
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting system workspace configuration");
        }
        return indexDirName;
    }

    private void checkIndexingArguments(String jcrUUID, String workspaceId) {
        this.checkIndexingArgument("workspaceId", workspaceId);
        this.checkIndexingArgument("jcrUUID", jcrUUID);
    }

    private void checkIndexingArgument(String name, String value) {
        if (StringUtils.isBlank((String)value)) {
            throw new IllegalArgumentException(name + " is null");
        }
    }

    private SearchManager getSearchManager(String workspaceId) throws RepositoryException {
        if (StringUtils.isBlank((String)workspaceId)) {
            throw new IllegalArgumentException("Workspace id is null");
        }
        if (!workspaceId.contains(this.getRepositoryName())) {
            throw new IllegalArgumentException("Workspace id '" + workspaceId + "' doesn't match pattern '" + this.getRepositoryName() + "_WORKSPACENAME' ");
        }
        String workspaceName = workspaceId.replace(this.getRepositoryName() + "_", "");
        WorkspaceContainerFacade workspaceContainer = this.repositoryService.getCurrentRepository().getWorkspaceContainer(workspaceName);
        if (workspaceContainer == null) {
            throw new IllegalStateException("Can't find workspace container with name " + workspaceName);
        }
        return (SearchManager)workspaceContainer.getComponent(SearchManager.class);
    }

    private String getRepositoryName() {
        if (this.repositoryName == null) {
            try {
                this.repositoryName = this.repositoryService.getConfig().getDefaultRepositoryName();
            }
            catch (Exception e) {
                throw new IllegalStateException("Can't get current repository name from repository service", e);
            }
        }
        return this.repositoryName;
    }

    private Set<String> getJCRUUIDs(Map<JCRIndexingOperationType, Set<String>> operationsByType, JCRIndexingOperationType operationType) {
        Set<String> nodesUUIDSet;
        Set<String> set = nodesUUIDSet = operationsByType.containsKey((Object)operationType) ? operationsByType.get((Object)operationType) : null;
        if (nodesUUIDSet == null) {
            nodesUUIDSet = Collections.emptySet();
        }
        return nodesUUIDSet;
    }

    private Map<String, Map<Boolean, Map<JCRIndexingOperationType, Set<String>>>> convertEntitiesToMapByWorkspaceByType(List<JCRIndexQueueEntity> indexingQueueEntities) {
        return indexingQueueEntities.stream().collect(Collectors.groupingBy(JCRIndexQueueEntity::getWorkspace, Collectors.groupingBy(JCRIndexQueueEntity::isParentChange, Collectors.groupingBy(JCRIndexQueueEntity::getOperationType, Collectors.mapping(JCRIndexQueueEntity::getJcrUUID, Collectors.toSet())))));
    }

    private Map<String, List<JCRIndexQueueEntity>> convertEntitiesToMapByWorkspace(List<JCRIndexQueueEntity> indexingQueueEntities) {
        return indexingQueueEntities.stream().collect(Collectors.groupingBy(JCRIndexQueueEntity::getWorkspace, Collectors.toList()));
    }

    private void computeCurrentContainer() {
        if (this.container == null) {
            this.container = ExoContainerContext.getCurrentContainerIfPresent();
        }
        if (this.container instanceof RootContainer) {
            this.container = PortalContainer.getInstance();
        }
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
    }

    private void scheduleIndexTasks() {
        this.retrieveLocalLastOperationFile();
        this.checkStoredLastOperationId();
        this.queueConsumingJobService.scheduleAtFixedRate(() -> {
            if (this.indexingOperationIsRunning.get()) {
                LOG.debug((Object)"Previous QUEUE indexing processing task is always executing, skip this execution");
                return;
            }
            this.indexingOperationIsRunning.set(true);
            this.computeCurrentContainer();
            RequestLifeCycle.begin((ComponentRequestLifecycle)this.entityManagerService);
            try {
                LOG.debug((Object)"Running JCR Index from DB QUEUE Task");
                this.processIndexingQueue();
            }
            catch (Exception e) {
                LOG.error((Object)"Error while Running JCR nodes indexing operation", (Throwable)e);
            }
            finally {
                this.indexingOperationIsRunning.set(false);
                RequestLifeCycle.end();
            }
        }, 0L, this.queueProcessingPeriod, TimeUnit.SECONDS);
        this.queueProducingJobService.scheduleAtFixedRate(() -> this.persistQueueOperations(), 0L, this.queueProcessingPeriod, TimeUnit.SECONDS);
        this.filePersisterThread.scheduleAtFixedRate(() -> this.persistLastOperationId(), 0L, 10L, TimeUnit.SECONDS);
    }

    static {
        JCRIndexingServiceImpl.ajc$preClinit();
        LOG = ExoLogger.getLogger(JCRIndexingServiceImpl.class);
    }

    static /* synthetic */ void applyIndexChangesOnJCR_aroundBody0(JCRIndexingServiceImpl ajc$this, List indexingQueueEntities, JoinPoint joinPoint) {
        if (indexingQueueEntities == null || indexingQueueEntities.isEmpty()) {
            return;
        }
        Map<String, List<JCRIndexQueueEntity>> opByWorkspace = ajc$this.convertEntitiesToMapByWorkspace(indexingQueueEntities);
        Map<String, Map<Boolean, Map<JCRIndexingOperationType, Set<String>>>> opByWorkspaceByType = ajc$this.convertEntitiesToMapByWorkspaceByType(indexingQueueEntities);
        for (Map.Entry<String, Map<Boolean, Map<JCRIndexingOperationType, Set<String>>>> operationsByTypeEntry : opByWorkspaceByType.entrySet()) {
            String workspaceId = operationsByTypeEntry.getKey();
            SearchManager searchManager = ajc$this.getSearchManager(workspaceId);
            Map<Boolean, Map<JCRIndexingOperationType, Set<String>>> operationsByType = operationsByTypeEntry.getValue();
            Map<JCRIndexingOperationType, Set<String>> parentOpsByType = operationsByType.containsKey(true) ? operationsByType.get(true) : Collections.emptyMap();
            Map<JCRIndexingOperationType, Set<String>> opsByType = operationsByType.containsKey(false) ? operationsByType.get(false) : Collections.emptyMap();
            Set<String> parentAddedNodes = ajc$this.getJCRUUIDs(parentOpsByType, JCRIndexingOperationType.CREATE);
            Set<String> parentRemovedNodes = ajc$this.getJCRUUIDs(parentOpsByType, JCRIndexingOperationType.DELETE);
            Set<String> addedNodes = ajc$this.getJCRUUIDs(opsByType, JCRIndexingOperationType.CREATE);
            Set<String> removedNodes = ajc$this.getJCRUUIDs(opsByType, JCRIndexingOperationType.DELETE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("APPLY index to JCR: '{}' parent create & '{}' parent remove & '{}' create & '{}' remove", new Object[]{parentAddedNodes.size(), parentRemovedNodes.size(), addedNodes.size(), removedNodes.size()});
                for (String parentRemovedNode : parentRemovedNodes) {
                    LOG.debug("-  APPLY index to JCR: parent delete UUID = {}", new Object[]{parentRemovedNode});
                }
                for (String removedNode : removedNodes) {
                    LOG.debug("-  APPLY index to JCR: delete UUID = {}", new Object[]{removedNode});
                }
                for (String parentAddedNode : parentAddedNodes) {
                    LOG.debug("+  APPLY index to JCR: parent create UUID = {}", new Object[]{parentAddedNode});
                }
                for (String addedNode : addedNodes) {
                    LOG.debug("+  APPLY index to JCR: create UUID = {}", new Object[]{addedNode});
                }
            }
            ChangesHolder parentChanges = searchManager.getChanges(parentRemovedNodes, parentAddedNodes);
            ChangesHolder changes = searchManager.getChanges(removedNodes, addedNodes);
            searchManager.apply(parentChanges);
            searchManager.apply(changes);
            List<JCRIndexQueueEntity> operationsSucceeded = opByWorkspace.get(workspaceId);
            for (JCRIndexQueueEntity jcrIndexQueueEntity : operationsSucceeded) {
                jcrIndexQueueEntity.addNode(ajc$this.clusterNodeName);
                ajc$this.updateLastNewOperationId(jcrIndexQueueEntity.getId());
            }
            ajc$this.indexingQueueDAO.updateAll(operationsSucceeded);
        }
    }

    static /* synthetic */ List findNextOperations_aroundBody2(JCRIndexingServiceImpl ajc$this, int offset, int batchNumber, JoinPoint joinPoint) {
        return ajc$this.indexingQueueDAO.findAllOperationNotExecutedByClusterNode(offset, batchNumber, ajc$this.clusterNodeName);
    }

    static /* synthetic */ void index_aroundBody4(JCRIndexingServiceImpl ajc$this, String jcrUUID, String workspaceId, boolean parentChange, JoinPoint joinPoint) {
        if (ajc$this.isIndexingInCurrentThread()) {
            return;
        }
        ajc$this.checkIndexingArguments(jcrUUID, workspaceId);
        JCRIndexQueueEntity indexQueueEntity = ajc$this.addToIndexingQueue(jcrUUID, workspaceId, JCRIndexingOperationType.CREATE, parentChange);
        ajc$this.updateLastNewOperationId(indexQueueEntity.getId());
    }

    static /* synthetic */ void reindex_aroundBody6(JCRIndexingServiceImpl ajc$this, String jcrUUID, String workspaceId, boolean parentChange, JoinPoint joinPoint) {
        if (ajc$this.isIndexingInCurrentThread()) {
            return;
        }
        ajc$this.checkIndexingArguments(jcrUUID, workspaceId);
        JCRIndexQueueEntity indexQueueEntity = ajc$this.addToIndexingQueue(jcrUUID, workspaceId, JCRIndexingOperationType.UPDATE, parentChange);
        ajc$this.updateLastNewOperationId(indexQueueEntity.getId());
    }

    static /* synthetic */ void unindex_aroundBody8(JCRIndexingServiceImpl ajc$this, String jcrUUID, String workspaceId, boolean parentChange, JoinPoint joinPoint) {
        if (ajc$this.isIndexingInCurrentThread()) {
            return;
        }
        ajc$this.checkIndexingArguments(jcrUUID, workspaceId);
        JCRIndexQueueEntity indexQueueEntity = ajc$this.addToIndexingQueue(jcrUUID, workspaceId, JCRIndexingOperationType.DELETE, parentChange);
        ajc$this.updateLastNewOperationId(indexQueueEntity.getId());
    }

    static /* synthetic */ void unindexAll_aroundBody10(JCRIndexingServiceImpl ajc$this, String workspaceId, JoinPoint joinPoint) {
        if (ajc$this.isIndexingInCurrentThread()) {
            return;
        }
        ajc$this.checkIndexingArgument("workspaceId", workspaceId);
        JCRIndexQueueEntity indexQueueEntity = ajc$this.addToIndexingQueue("-", workspaceId, JCRIndexingOperationType.DELETE_ALL, false);
        ajc$this.updateLastNewOperationId(indexQueueEntity.getId());
    }

    static /* synthetic */ void updateQueueSwitchStatusInFile_aroundBody12(JCRIndexingServiceImpl ajc$this, JoinPoint joinPoint) {
        try {
            String lastExecutedOperation = ajc$this.getLastExecutedOperation();
            if (StringUtils.isBlank((String)lastExecutedOperation)) {
                return;
            }
            String[] lastExecutedIdArray = lastExecutedOperation.split(";");
            String oldClusterNodeName = lastExecutedIdArray[1];
            String lastExecutedIdString = lastExecutedIdArray[0];
            if (!ajc$this.clusterNodeName.equals(oldClusterNodeName) && StringUtils.isNotBlank((String)lastExecutedIdString)) {
                LOG.debug((Object)"Start: Update Queue with last status because the indexes was manually copied");
                int offset = 0;
                int proceededOperations = 0;
                int totalProceededOperations = 0;
                long lastExecutedId = Long.parseLong(lastExecutedIdString);
                Long totalIndexingOperations = ajc$this.indexingQueueDAO.count();
                do {
                    List<JCRIndexQueueEntity> indexingQueueEntities = ajc$this.indexingQueueDAO.findAllOperationExecutedByClusterNode(oldClusterNodeName, ajc$this.clusterNodeName, lastExecutedId, offset, ajc$this.batchNumber);
                    for (JCRIndexQueueEntity jcrIndexQueueEntity : indexingQueueEntities) {
                        jcrIndexQueueEntity.addNode(ajc$this.clusterNodeName);
                    }
                    ajc$this.indexingQueueDAO.updateAll(indexingQueueEntities);
                    proceededOperations = indexingQueueEntities.size();
                    LOG.debug("Retrieved indexes update: {} / {}", new Object[]{totalProceededOperations += proceededOperations, totalIndexingOperations});
                } while (proceededOperations == ajc$this.batchNumber);
                LOG.debug("End: Update Queue with last status because the indexes was manually copied. Total indexes updates: {} / {}", new Object[]{totalProceededOperations, totalIndexingOperations});
                ajc$this.updateLastNewOperationId(lastExecutedId);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't read file JCR queue indexing last operation id", e);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JCRIndexingServiceImpl.java", JCRIndexingServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "applyIndexChangesOnJCR", "org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl", "java.util.List", "indexingQueueEntities", "java.lang.Exception", "void"), 260);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "findNextOperations", "org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl", "int:int", "offset:batchNumber", "", "java.util.List"), 318);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "index", "org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl", "java.lang.String:java.lang.String:boolean", "jcrUUID:workspaceId:parentChange", "", "void"), 323);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "reindex", "org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl", "java.lang.String:java.lang.String:boolean", "jcrUUID:workspaceId:parentChange", "", "void"), 336);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unindex", "org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl", "java.lang.String:java.lang.String:boolean", "jcrUUID:workspaceId:parentChange", "", "void"), 349);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "unindexAll", "org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl", "java.lang.String", "workspaceId", "", "void"), 362);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "updateQueueSwitchStatusInFile", "org.exoplatform.services.jcr.ext.index.persistent.impl.JCRIndexingServiceImpl", "", "", "", "void"), 373);
    }
}

