/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.jndi.enc.java;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import org.objectweb.carol.jndi.enc.java.JavaNameParser;
import org.objectweb.carol.util.configuration.TraceCarol;

public class CompNamingContext
implements Context {
    private Hashtable myEnv = null;
    private Hashtable bindings = new Hashtable();
    private static NameParser myParser = new JavaNameParser();
    private String compId;

    public CompNamingContext(String id, Hashtable env) {
        if (env != null) {
            this.myEnv = (Hashtable)env.clone();
        }
        this.compId = id;
    }

    public CompNamingContext(String id) {
        this(id, new Hashtable());
    }

    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    public Object lookup(String name) throws NamingException {
        CompositeName n;
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            if (TraceCarol.isDebugjndiEncCarol()) {
                TraceCarol.debugjndiEncCarol("empty name");
            }
            return this;
        }
        if (n.size() == 1) {
            Object ret = this.bindings.get(name);
            if (ret == null) {
                if (TraceCarol.isDebugjndiEncCarol()) {
                    TraceCarol.debugjndiEncCarol(" " + name + " not found.");
                }
                throw new NameNotFoundException(name);
            }
            if (ret instanceof LinkRef) {
                InitialContext ictx = new InitialContext();
                RefAddr ra = ((Reference)ret).get(0);
                try {
                    ret = ictx.lookup((String)ra.getContent());
                }
                catch (Exception e) {
                    NamingException ne = new NamingException(e.getMessage());
                    ne.setRootCause(e);
                    TraceCarol.error("unexpected exception " + e.getMessage(), e);
                    throw ne;
                }
            }
            if (ret instanceof Reference) {
                try {
                    Object o = NamingManager.getObjectInstance(ret, n, this, this.myEnv);
                    ret = o;
                }
                catch (NamingException e) {
                    throw e;
                }
                catch (Exception e) {
                    NamingException ne = new NamingException(e.getMessage());
                    ne.setRootCause(e);
                    throw ne;
                }
                if (ret == null) {
                    TraceCarol.error("Can not build an object with the reference " + name);
                    throw new NamingException("Can not build an object with the reference '" + name + "'");
                }
            }
            return ret;
        }
        String suffix = n.getSuffix(1).toString();
        Context subctx = this.lookupCtx(n.get(0));
        return subctx.lookup(suffix);
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    public void bind(String name, Object obj) throws NamingException {
        CompositeName n;
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            TraceCarol.error("CompNamingContext bind empty name ?");
            throw new InvalidNameException("CompNamingContext cannot bind empty name");
        }
        if (n.size() == 1) {
            if (this.bindings.get(name) != null) {
                TraceCarol.error("CompNamingContext: trying to overbind");
                throw new NameAlreadyBoundException("CompNamingContext: Use rebind to bind over a name");
            }
            this.bindings.put(name, obj);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            try {
                subctx = this.lookupCtx(n.get(0));
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(n.get(0));
            }
            subctx.bind(suffix, obj);
        }
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    public void rebind(String name, Object obj) throws NamingException {
        CompositeName n;
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            TraceCarol.error("CompNamingContext rebind empty name ?");
            throw new InvalidNameException("CompNamingContext cannot rebind empty name");
        }
        if (n.size() == 1) {
            this.bindings.put(name, obj);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            try {
                subctx = this.lookupCtx(n.get(0));
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(n.get(0));
            }
            subctx.rebind(suffix, obj);
        }
    }

    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    public void unbind(String name) throws NamingException {
        CompositeName n;
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            TraceCarol.error("CompNamingContext unbind empty name ?");
            throw new InvalidNameException("CompNamingContext cannot unbind empty name");
        }
        if (n.size() == 1) {
            if (this.bindings.get(name) == null) {
                TraceCarol.error("CompNamingContext nothing to unbind");
                throw new NameNotFoundException(name);
            }
            this.bindings.remove(name);
        } else {
            String suffix = n.getSuffix(1).toString();
            Context subctx = this.lookupCtx(n.get(0));
            subctx.unbind(suffix);
        }
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        this.rename(oldName.toString(), newName.toString());
    }

    public void rename(String oldName, String newName) throws NamingException {
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol("CompNamingContext rename " + oldName + " in " + newName);
        }
        Object obj = this.lookup(oldName);
        this.rebind(newName, obj);
        this.unbind(oldName);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if (name.length() == 0) {
            return new ListOfNames(this.bindings);
        }
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            return ((Context)obj).list("");
        }
        TraceCarol.error("CompNamingContext: can only list a Context");
        throw new NotContextException(name);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if (name.length() == 0) {
            return new ListOfBindings(this.bindings);
        }
        Object obj = this.lookup(name);
        if (obj instanceof Context) {
            return ((Context)obj).listBindings("");
        }
        TraceCarol.error("CompNamingContext: can only list a Context");
        throw new NotContextException(name);
    }

    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    public void destroySubcontext(String name) throws NamingException {
        TraceCarol.error("CompNamingContext try to destroySubcontext " + name);
        throw new OperationNotSupportedException("CompNamingContext: destroySubcontext");
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    public Context createSubcontext(String name) throws NamingException {
        CompositeName n;
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        if ((n = new CompositeName(name)).size() < 1) {
            TraceCarol.error("CompNamingContext createSubcontext with empty name ?");
            throw new InvalidNameException("CompNamingContext cannot create empty Subcontext");
        }
        Context ctx = null;
        if (n.size() == 1) {
            ctx = new CompNamingContext(this.compId, this.myEnv);
            this.bindings.put(name, ctx);
        } else {
            Context subctx;
            String suffix = n.getSuffix(1).toString();
            name = n.get(0);
            try {
                subctx = this.lookupCtx(name);
            }
            catch (NameNotFoundException e) {
                subctx = this.createSubcontext(name);
            }
            ctx = subctx.createSubcontext(suffix);
        }
        return ctx;
    }

    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    public Object lookupLink(String name) throws NamingException {
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol(name);
        }
        TraceCarol.error("CompNamingContext lookupLink not implemented yet!");
        return this.lookup(name);
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return myParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return myParser;
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        TraceCarol.error("CompNamingContext composeName not implemented!");
        throw new OperationNotSupportedException("CompNamingContext composeName");
    }

    public String composeName(String name, String prefix) throws NamingException {
        TraceCarol.error("CompNamingContext composeName " + name + " " + prefix);
        throw new OperationNotSupportedException("CompNamingContext composeName");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        TraceCarol.debugjndiEncCarol(propName);
        if (this.myEnv == null) {
            this.myEnv = new Hashtable();
        }
        return this.myEnv.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        TraceCarol.debugjndiEncCarol(propName);
        if (this.myEnv == null) {
            return null;
        }
        return this.myEnv.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        if (TraceCarol.isDebugjndiEncCarol()) {
            TraceCarol.debugjndiEncCarol("");
        }
        if (this.myEnv == null) {
            this.myEnv = new Hashtable();
        }
        return this.myEnv;
    }

    public void close() throws NamingException {
        this.myEnv = null;
    }

    public String getNameInNamespace() {
        return this.compId;
    }

    private Context lookupCtx(String name) throws NamingException {
        Object obj = this.bindings.get(name);
        if (obj == null) {
            throw new NameNotFoundException();
        }
        if (obj instanceof CompNamingContext) {
            return (Context)obj;
        }
        throw new NameAlreadyBoundException(name);
    }

    protected class ListOfBindings
    extends ListOfNames {
        ListOfBindings(Hashtable bindings) {
            super(bindings);
        }

        public Object next() throws NamingException {
            String name = (String)this.getNames().nextElement();
            return new Binding(name, this.getBindings().get(name));
        }
    }

    protected class ListOfNames
    implements NamingEnumeration {
        private Enumeration names;
        private Hashtable bindings;

        ListOfNames(Hashtable bindings) {
            this.bindings = bindings;
            this.names = bindings.keys();
        }

        public boolean hasMore() throws NamingException {
            return this.names.hasMoreElements();
        }

        public Object next() throws NamingException {
            String name = (String)this.names.nextElement();
            String className = this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public void close() {
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException e) {
                throw new NoSuchElementException(e.toString());
            }
        }

        public boolean hasMoreElements() {
            try {
                return this.hasMore();
            }
            catch (NamingException e) {
                return false;
            }
        }

        protected Hashtable getBindings() {
            return this.bindings;
        }

        protected Enumeration getNames() {
            return this.names;
        }
    }
}

