/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.rmi.jrmp.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.RemoteServer;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerCloneException;
import org.objectweb.carol.rmi.jrmp.interceptor.JClientRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.interceptor.JServerRequestInterceptor;
import org.objectweb.carol.rmi.jrmp.server.JLocalObjectStore;
import org.objectweb.carol.rmi.jrmp.server.JUnicastRef;
import org.objectweb.carol.rmi.jrmp.server.JUnicastServerRef;
import org.objectweb.carol.rmi.jrmp.server.JUnicastServerRefSf;
import org.objectweb.carol.rmi.jrmp.server.JUnicastThreadFactory;
import sun.rmi.transport.ObjectTable;

public class JUnicastRemoteObject
extends RemoteServer {
    protected RMIClientSocketFactory csf = null;
    protected RMIServerSocketFactory ssf = null;
    private static JUnicastThreadFactory defaultThreadFactory = null;
    private static boolean localO = new Boolean(System.getProperty("rmi.local.call", "false"));

    protected JUnicastRemoteObject(JServerRequestInterceptor[] sis, JClientRequestInterceptor[] cis) throws RemoteException {
        this(0, sis, cis);
    }

    protected JUnicastRemoteObject(int p, JServerRequestInterceptor[] sis, JClientRequestInterceptor[] cis) throws RemoteException {
        JUnicastRemoteObject.exportObject(this, p, sis, cis);
    }

    protected JUnicastRemoteObject(int p, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, JServerRequestInterceptor[] sis, JClientRequestInterceptor[] cis) throws RemoteException {
        this.csf = csf;
        this.ssf = ssf;
        JUnicastRemoteObject.exportObject(this, p, csf, ssf, sis, cis);
    }

    protected void exportObject(JServerRequestInterceptor[] sis, JClientRequestInterceptor[] cis) throws RemoteException {
        if (this.csf == null && this.ssf == null) {
            JUnicastRemoteObject.exportObject(this, 0, sis, cis);
        } else {
            JUnicastRemoteObject.exportObject(this, 0, this.csf, this.ssf, sis, cis);
        }
    }

    public static RemoteStub exportObject(Remote obj, JServerRequestInterceptor[] sis, JClientRequestInterceptor[] cis) throws RemoteException {
        return (RemoteStub)JUnicastRemoteObject.exportObject(obj, 0, sis, cis);
    }

    public static Remote exportObject(Remote obj, int p, JServerRequestInterceptor[] sis, JClientRequestInterceptor[] cis) throws RemoteException {
        return JUnicastRemoteObject.exportObjectR(obj, new JUnicastServerRef(p, sis, cis));
    }

    public static Remote exportObject(Remote obj, int p, RMIClientSocketFactory csf, RMIServerSocketFactory ssf, JServerRequestInterceptor[] sis, JClientRequestInterceptor[] cis) throws RemoteException {
        return JUnicastRemoteObject.exportObjectR(obj, new JUnicastServerRefSf(p, csf, ssf, sis, cis));
    }

    protected static Remote exportObjectR(Remote obj, JUnicastServerRef serverRef) throws RemoteException {
        int localId = -2;
        if (localO) {
            localId = JLocalObjectStore.storeObject(obj);
        }
        if (obj instanceof JUnicastRemoteObject) {
            ((JUnicastRemoteObject)obj).ref = serverRef;
        }
        Remote rob = serverRef.exportObject(obj, null, localId);
        return rob;
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        if (localO) {
            JUnicastRef remoteref = (JUnicastRef)((RemoteObject)ObjectTable.getStub(obj)).getRef();
            JLocalObjectStore.removeObject(remoteref.getLocalId());
        }
        return ObjectTable.unexportObject(obj, force);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.exportObject(null, null);
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            JUnicastRemoteObject cloned = (JUnicastRemoteObject)super.clone();
            cloned.exportObject(null, null);
            return cloned;
        }
        catch (RemoteException e) {
            throw new ServerCloneException("Clone failed", e);
        }
    }

    public static void setDefaultThreadFactory(JUnicastThreadFactory factory) {
        defaultThreadFactory = factory;
    }

    public static JUnicastThreadFactory getDefaultThreadFactory() {
        return defaultThreadFactory;
    }
}

