/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;
import org.jgroups.util.ConcurrentLinkedBlockingQueue;
import org.jgroups.util.Util;

@Experimental
@Unsupported
@MBean(description="Protocol just above the transport which disseminates multicasts via daisy chaining")
public class DAISYCHAIN
extends Protocol {
    @Property(description="Loop back multicast messages")
    boolean loopback = true;
    @Property
    int forward_queue_size = 10000;
    @Property
    int send_queue_size = 10000;
    protected Address local_addr;
    protected Address next;
    protected int view_size = 0;
    protected Executor default_pool = null;
    protected Executor oob_pool = null;
    protected BlockingQueue<Message> send_queue;
    protected BlockingQueue<Message> forward_queue;
    protected volatile boolean forward = false;
    protected volatile boolean running = true;
    @ManagedAttribute
    public int msgs_forwarded = 0;
    @ManagedAttribute
    public int msgs_sent = 0;

    @ManagedAttribute
    public int getElementsInForwardQueue() {
        return this.forward_queue.size();
    }

    @ManagedAttribute
    public int getElementsInSendQueue() {
        return this.send_queue.size();
    }

    @Override
    public void init() throws Exception {
        this.default_pool = this.getTransport().getDefaultThreadPool();
        this.oob_pool = this.getTransport().getOOBThreadPool();
        this.send_queue = new ConcurrentLinkedBlockingQueue<Message>(this.send_queue_size);
        this.forward_queue = new ConcurrentLinkedBlockingQueue<Message>(this.forward_queue_size);
    }

    @Override
    public void start() throws Exception {
        super.start();
        this.running = true;
    }

    @Override
    public void stop() {
        super.stop();
        this.running = false;
    }

    @Override
    public Object down(final Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                Address dest = msg.getDest();
                if (dest != null && !dest.isMulticastAddress() || this.next == null) break;
                Message copy = msg.copy(true);
                short hdr_ttl = (short)(this.loopback ? this.view_size - 1 : this.view_size);
                DaisyHeader hdr = new DaisyHeader(hdr_ttl);
                copy.setDest(this.next);
                copy.putHeader(this.getId(), hdr);
                try {
                    ++this.msgs_sent;
                    this.send_queue.put(copy);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return null;
                }
                if (this.loopback) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(new StringBuilder("looping back message ").append(msg));
                    }
                    msg.setSrc(this.local_addr);
                    Executor pool = msg.isFlagSet((byte)1) ? this.oob_pool : this.default_pool;
                    pool.execute(new Runnable(){

                        @Override
                        public void run() {
                            DAISYCHAIN.this.up_prot.up(evt);
                        }
                    });
                }
                return this.processQueues();
            }
            case 6: {
                this.handleView((View)evt.getArg());
                break;
            }
            case 15: {
                this.view_size = ((View)evt.getArg()).size();
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                DaisyHeader hdr = (DaisyHeader)msg.getHeader(this.getId());
                if (hdr == null) break;
                short ttl = hdr.getTTL();
                if (this.log.isTraceEnabled()) {
                    this.log.trace(this.local_addr + ": received message from " + msg.getSrc() + " with ttl=" + ttl);
                }
                if ((ttl = (short)(ttl - 1)) > 0) {
                    Message copy = msg.copy(true);
                    copy.setDest(this.next);
                    copy.putHeader(this.getId(), new DaisyHeader(ttl));
                    ++this.msgs_forwarded;
                    if (this.forward_queue.offer(copy)) {
                        this.processQueues();
                    }
                }
                msg.setDest(null);
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object processQueues() {
        int cnt = 0;
        while (this.running && cnt++ < 10000) {
            Object object;
            Message msg;
            block7: {
                Message message = msg = this.forward ? (Message)this.forward_queue.poll() : (Message)this.send_queue.poll();
                if (msg != null) break block7;
                Message message2 = msg = this.forward ? (Message)this.send_queue.poll() : (Message)this.forward_queue.poll();
                if (msg != null) break block7;
                this.forward = !this.forward;
                continue;
            }
            try {
                if (this.log.isTraceEnabled()) {
                    DaisyHeader hdr = (DaisyHeader)msg.getHeader(this.getId());
                    this.log.trace(this.local_addr + ": " + (this.forward ? " forwarding" : " sending") + " message with ttl=" + hdr.getTTL() + " to " + this.next);
                }
                object = this.down_prot.down(new Event(1, msg));
                this.forward = !this.forward;
            }
            catch (Throwable t) {
                Object var3_5;
                try {
                    this.log.error("failed sending message down", t);
                    var3_5 = null;
                    this.forward = !this.forward;
                }
                catch (Throwable throwable) {
                    this.forward = !this.forward;
                    throw throwable;
                }
                return var3_5;
            }
            return object;
        }
        return null;
    }

    protected void handleView(View view) {
        this.view_size = view.size();
        Address tmp = Util.pickNext(view.getMembers(), this.local_addr);
        if (tmp != null && !tmp.equals(this.local_addr)) {
            this.next = tmp;
            if (this.log.isDebugEnabled()) {
                this.log.debug("next=" + this.next);
            }
        }
    }

    public static class DaisyHeader
    extends Header {
        private short ttl;

        public DaisyHeader() {
        }

        public DaisyHeader(short ttl) {
            this.ttl = ttl;
        }

        public short getTTL() {
            return this.ttl;
        }

        public void setTTL(short ttl) {
            this.ttl = ttl;
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public void writeTo(DataOutputStream out) throws IOException {
            out.writeShort(this.ttl);
        }

        @Override
        public void readFrom(DataInputStream in) throws IOException, IllegalAccessException, InstantiationException {
            this.ttl = in.readShort();
        }

        @Override
        public String toString() {
            return "ttl=" + this.ttl;
        }
    }
}

