/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.annotations.Property;
import org.jgroups.annotations.Unsupported;
import org.jgroups.stack.Protocol;

@Unsupported
public class DUPL
extends Protocol {
    @Property(description="Number of copies of each incoming message (0=no copies)")
    protected int incoming_copies = 1;
    @Property(description="Number of copies of each outgoing message (0=no copies)")
    protected int outgoing_copies = 1;
    @Property(description="Whether or not to copy unicast messages")
    protected boolean copy_unicast_msgs = true;
    @Property(description="Whether or not to copy multicast messages")
    protected boolean copy_multicast_msgs = true;

    public DUPL() {
    }

    public DUPL(boolean copy_multicast_msgs, boolean copy_unicast_msgs, int incoming_copies, int outgoing_copies) {
        this.copy_multicast_msgs = copy_multicast_msgs;
        this.copy_unicast_msgs = copy_unicast_msgs;
        this.incoming_copies = incoming_copies;
        this.outgoing_copies = outgoing_copies;
    }

    public int getIncomingCopies() {
        return this.incoming_copies;
    }

    public void setIncomingCopies(int incoming_copies) {
        this.incoming_copies = incoming_copies;
    }

    public int getOutgoingCopies() {
        return this.outgoing_copies;
    }

    public void setOutgoingCopies(int outgoing_copies) {
        this.outgoing_copies = outgoing_copies;
    }

    public boolean isCopyUnicastMsgs() {
        return this.copy_unicast_msgs;
    }

    public void setCopyUnicastMsgs(boolean copy_unicast_msgs) {
        this.copy_unicast_msgs = copy_unicast_msgs;
    }

    public boolean isCopyMulticastMsgs() {
        return this.copy_multicast_msgs;
    }

    public void setCopyMulticastMsgs(boolean copy_multicast_msgs) {
        this.copy_multicast_msgs = copy_multicast_msgs;
    }

    @Override
    public Object down(Event evt) {
        boolean copy;
        boolean bl = copy = (this.copy_multicast_msgs || this.copy_unicast_msgs) && this.outgoing_copies > 0;
        if (!copy) {
            return this.down_prot.down(evt);
        }
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                this.copy(msg, this.outgoing_copies, Direction.DOWN);
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        boolean copy;
        boolean bl = copy = (this.copy_multicast_msgs || this.copy_unicast_msgs) && this.incoming_copies > 0;
        if (!copy) {
            return this.up_prot.up(evt);
        }
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                this.copy(msg, this.incoming_copies, Direction.UP);
            }
        }
        return this.up_prot.up(evt);
    }

    private void copy(Message msg, int num_copies, Direction direction) {
        boolean multicast;
        Address dest = msg.getDest();
        boolean bl = multicast = dest == null || dest.isMulticastAddress();
        if (multicast && this.copy_multicast_msgs || !multicast && this.copy_unicast_msgs) {
            block4: for (int i = 0; i < num_copies; ++i) {
                Message copy = msg.copy(true);
                switch (direction) {
                    case UP: {
                        this.up_prot.up(new Event(1, copy));
                        continue block4;
                    }
                    case DOWN: {
                        this.down_prot.down(new Event(1, copy));
                    }
                }
            }
        }
    }

    private static enum Direction {
        UP,
        DOWN;

    }
}

