/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.NO_MEMORY;

public final class BufferManager {
    private List[] bufferPool;
    private byte[] bufferMax = null;
    private static int MAX;
    private static final int MIN_OFFSET = 5;
    private static final int THRESHOLD = 20;
    private static final int MEM_BUFSIZE = 256;
    private static final int MIN_PREFERRED_BUFS = 10;
    private Reaper reaper;
    private static int time;
    private static BufferManager singleton;
    private static boolean configured;

    public static void configure(Configuration configuration) throws ConfigurationException {
        singleton.singletonConfigure(configuration);
        configured = true;
    }

    private BufferManager() {
    }

    private synchronized void singletonConfigure(Configuration configuration) throws ConfigurationException {
        int n;
        time = configuration.getAttributeAsInteger("jacorb.bufferManagerMaxFlush", 0);
        MAX = configuration.getAttributeAsInteger("jacorb.maxManagedBufSize", 18);
        this.bufferPool = new List[MAX];
        for (n = 0; n < MAX; ++n) {
            this.bufferPool[n] = new ArrayList();
        }
        n = 0;
        int n2 = 256;
        while (n2 > 1) {
            n2 >>= 1;
            ++n;
        }
        for (int i = 0; i < 10; ++i) {
            this.bufferPool[n - 5].add(new byte[256]);
        }
        if (time > 0) {
            this.reaper = new Reaper(time);
            this.reaper.setName("BufferManager MaxCache Reaper");
            this.reaper.setDaemon(true);
            this.reaper.start();
        }
    }

    public static BufferManager getInstance() throws BAD_INV_ORDER {
        if (!configured) {
            throw new BAD_INV_ORDER("Buffer Manager not configured");
        }
        return singleton;
    }

    private static final int log2up(int n) {
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >> n2 != 0) {
            ++n2;
        }
        return n2;
    }

    private static final int log2down(int n) {
        int n2 = 0;
        int n3 = n;
        while (n3 >> n2 != 0) {
            ++n2;
        }
        return n2 - 1;
    }

    public byte[] getPreferredMemoryBuffer() {
        return this.getBuffer(256);
    }

    public synchronized byte[] getBuffer(int n) {
        return this.getBuffer(n, false);
    }

    public synchronized byte[] getBuffer(int n, boolean bl) {
        byte[] byArray;
        int n2 = BufferManager.log2up(n);
        if (n2 >= MAX) {
            try {
                if (!bl || time < 0) {
                    byArray = new byte[n];
                }
                if (this.bufferMax == null || this.bufferMax.length < n) {
                    this.bufferMax = new byte[n * 2];
                }
                byArray = this.bufferMax;
                this.bufferMax = null;
            }
            catch (OutOfMemoryError outOfMemoryError) {
                throw new NO_MEMORY();
            }
        } else {
            List list = this.bufferPool[n2 > 5 ? n2 - 5 : 0];
            byArray = !list.isEmpty() ? (byte[])list.remove(list.size() - 1) : new byte[n2 > 5 ? 1 << n2 : 32];
        }
        return byArray;
    }

    public synchronized void returnBuffer(byte[] byArray) {
        this.returnBuffer(byArray, false);
    }

    synchronized void returnBuffer(byte[] byArray, boolean bl) {
        int n;
        if (byArray != null && (n = BufferManager.log2down(byArray.length)) >= 5) {
            if (n > MAX) {
                if (bl && time >= 0 && (this.bufferMax == null || this.bufferMax.length < byArray.length)) {
                    this.bufferMax = byArray;
                }
                return;
            }
            List list = this.bufferPool[n - 5];
            if (list.size() < 20) {
                list.add(byArray);
            }
        }
    }

    public synchronized void release() {
        int n = MAX;
        while (n > 0) {
            this.bufferPool[--n].clear();
        }
        if (this.reaper != null) {
            this.reaper.done = true;
            this.reaper.wake();
        }
    }

    static /* synthetic */ byte[] access$002(BufferManager bufferManager, byte[] byArray) {
        bufferManager.bufferMax = byArray;
        return byArray;
    }

    static {
        time = 0;
        singleton = new BufferManager();
        configured = false;
    }

    private class Reaper
    extends Thread {
        public boolean done = false;
        private int sleepInterval = 0;

        public Reaper(int n) {
            this.sleepInterval = n * 1000;
        }

        public void run() {
            while (true) {
                try {
                    long l = (long)this.sleepInterval + System.currentTimeMillis();
                    do {
                        Reaper.sleep(this.sleepInterval);
                    } while (System.currentTimeMillis() <= l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.done) break;
                BufferManager.access$002(BufferManager.this, null);
            }
        }

        public synchronized void wake() {
            this.notify();
        }
    }
}

