/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.ByteArrayInputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.iiop.ServerIIOPConnection;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.security.level2.CurrentImpl;
import org.jacorb.security.level2.KeyAndCert;
import org.jacorb.security.level2.ReceivedCredentialsImpl;
import org.jacorb.security.level2.SecAttributeManager;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.omg.Security.AttributeType;
import org.omg.Security.ExtensibleFamily;
import org.omg.Security.SecAttribute;
import org.omg.SecurityLevel2.Current;
import org.omg.SecurityLevel2.ReceivedCredentials;

public class ServerInvocationInterceptor
extends LocalObject
implements ServerRequestInterceptor,
Configurable {
    public static final String DEFAULT_NAME = "ServerInvocationInterceptor";
    private String name = null;
    private CurrentImpl current = null;
    private SecAttributeManager attrib_mgr = null;
    private AttributeType type = null;
    private HashMap sessionCredentials = new HashMap();
    private Logger logger;
    private short serverSupportedOptions = 0;
    private short serverRequiredOptions = 0;

    public ServerInvocationInterceptor(Current current, ORB oRB) throws ConfigurationException {
        this.current = (CurrentImpl)current;
        this.name = DEFAULT_NAME;
        this.attrib_mgr = SecAttributeManager.getInstance();
        this.type = new AttributeType(new ExtensibleFamily(0, 1), 2);
        this.configure(oRB.getConfiguration());
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.security.ssl.interceptor");
        this.serverSupportedOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
        this.serverRequiredOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
    }

    public String name() {
        return this.name;
    }

    public void destroy() {
    }

    public void receive_request(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
    }

    public void receive_request_service_contexts(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        Object[] objectArray;
        CertificateFactory certificateFactory;
        SSLSocket sSLSocket;
        block14: {
            ServerRequest serverRequest = ((ServerRequestInfoImpl)serverRequestInfo).request;
            GIOPConnection gIOPConnection = serverRequest.getConnection();
            if (gIOPConnection == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("target has no connection!");
                }
                return;
            }
            if (!gIOPConnection.isSSL()) {
                return;
            }
            ServerIIOPConnection serverIIOPConnection = (ServerIIOPConnection)gIOPConnection.getTransport();
            sSLSocket = (SSLSocket)serverIIOPConnection.getSocket();
            SSLSession sSLSession = sSLSocket.getSession();
            if (this.sessionCredentials.containsKey(sSLSession)) {
                ReceivedCredentialsImpl receivedCredentialsImpl = (ReceivedCredentialsImpl)this.sessionCredentials.get(sSLSession);
                this.current.set_received_credentials(receivedCredentialsImpl);
                if (this.logger.isDebugEnabled()) {
                    this.logger.info("Reusing SSL session credentials.");
                }
                return;
            }
            certificateFactory = null;
            try {
                certificateFactory = CertificateFactory.getInstance("X.509");
            }
            catch (Exception exception) {
                if (!this.logger.isWarnEnabled()) break block14;
                this.logger.warn(exception.getMessage());
            }
        }
        KeyAndCert keyAndCert = null;
        try {
            objectArray = sSLSocket.getSession().getPeerCertificateChain();
            int n = objectArray.length;
            Certificate[] certificateArray = new X509Certificate[n];
            for (int i = n - 1; 0 <= i; --i) {
                certificateArray[i] = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(objectArray[i].getEncoded()));
            }
            keyAndCert = new KeyAndCert(null, certificateArray);
        }
        catch (Exception exception) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Exception " + exception.getMessage() + " in ServerInvocationInterceptor");
            }
            if ((this.serverRequiredOptions & 0x40) != 0) {
                throw new NO_PERMISSION("Establish trust in client required, but failed");
            }
            return;
        }
        if (keyAndCert.chain == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Client sent no certificate chain!");
            }
            return;
        }
        objectArray = new SecAttribute[]{this.attrib_mgr.createAttribute(keyAndCert, this.type)};
        this.current.set_received_credentials(new ReceivedCredentialsImpl((SecAttribute[])objectArray));
    }

    public void send_reply(ServerRequestInfo serverRequestInfo) {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    public void send_exception(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    public void send_other(ServerRequestInfo serverRequestInfo) throws ForwardRequest {
        this.removeAttribute();
        this.current.remove_received_credentials();
    }

    private void removeAttribute() {
        ReceivedCredentials receivedCredentials = this.current.received_credentials();
        if (receivedCredentials == null) {
            return;
        }
        SecAttribute[] secAttributeArray = receivedCredentials.get_attributes(new AttributeType[]{this.type});
        if (secAttributeArray.length != 0) {
            this.attrib_mgr.removeAttribute(secAttributeArray[0]);
        }
    }
}

