/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.io.InputStream;
import java.net.URL;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.exoplatform.commons.utils.SecurityHelper;

public class PrivilegedSystemHelper {
    public static String getProperty(final String key) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key);
            }
        };
        return SecurityHelper.doPrivilegedAction(action);
    }

    public static Properties getProperties() {
        PrivilegedAction<Properties> action = new PrivilegedAction<Properties>(){

            @Override
            public Properties run() {
                return System.getProperties();
            }
        };
        return SecurityHelper.doPrivilegedAction(action);
    }

    public static void setProperty(final String key, final String value) {
        PrivilegedAction<Void> action = new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.setProperty(key, value);
                return null;
            }
        };
        SecurityHelper.doPrivilegedAction(action);
    }

    public static String getProperty(final String key, final String def) {
        PrivilegedAction<String> action = new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(key, def);
            }
        };
        return SecurityHelper.doPrivilegedAction(action);
    }

    public static URL getResource(final String name) {
        PrivilegedAction<URL> action = new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return Thread.currentThread().getContextClassLoader().getResource(name);
            }
        };
        return SecurityHelper.doPrivilegedAction(action);
    }

    public static InputStream getResourceAsStream(final String name) {
        PrivilegedAction<InputStream> action = new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
            }
        };
        return SecurityHelper.doPrivilegedAction(action);
    }
}

