/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.rest.impl.header;

import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.exoplatform.services.rest.header.AbstractHeaderDelegate;
import org.exoplatform.services.rest.impl.header.AcceptLanguage;
import org.exoplatform.services.rest.impl.header.HeaderHelper;
import org.exoplatform.services.rest.impl.header.HeaderParameterParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceptLanguageHeaderDelegate
extends AbstractHeaderDelegate<AcceptLanguage> {
    @Override
    public Class<AcceptLanguage> support() {
        return AcceptLanguage.class;
    }

    public AcceptLanguage fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException();
        }
        try {
            String primaryTag;
            String tag;
            header = HeaderHelper.removeWhitespaces(header);
            Map<String, String> m = null;
            int p = header.indexOf(59);
            if (p != -1 && p < header.length() - 1) {
                tag = header.substring(0, p);
                m = new HeaderParameterParser().parse(header);
            } else {
                tag = header;
            }
            p = tag.indexOf(45);
            String subTag = null;
            if (p != -1 && p < tag.length() - 1) {
                primaryTag = tag.substring(0, p);
                subTag = tag.substring(p + 1);
            } else {
                primaryTag = tag;
            }
            if (m == null) {
                return new AcceptLanguage(new Locale(primaryTag, subTag != null ? subTag : ""));
            }
            return new AcceptLanguage(new Locale(primaryTag, subTag != null ? subTag : ""), HeaderHelper.parseQualityValue(m.get("q")));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Accept language header malformed");
        }
    }

    public String toString(AcceptLanguage language) {
        throw new UnsupportedOperationException("Accepted language header used only for request.");
    }
}

